/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Jerzy Kaczorowski <kaczoroj@hotmail.com> --- October 2001
 */

/*
 * AdminOptionDlg.cpp --- admin options dialog
 */

#include "stdafx.h"

#ifdef WIN32
#include "wincvs.h"
#include "AdminOptionDlg.h"
#endif /* WIN32 */

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAdminOptionDlg dialog

#ifdef WIN32

CAdminOptionDlg::CAdminOptionDlg(kAdminOptionDlgType type, 
								 CWnd* pParent /*=NULL*/)
	: CDialog(CAdminOptionDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAdminOptionDlg)
	//}}AFX_DATA_INIT
	
	m_optionString = _T("");
	m_type = type;
	m_singeLine = FALSE;
}


void CAdminOptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAdminOptionDlg)
	//}}AFX_DATA_MAP

	DDX_Text(pDX, m_singeLine ? IDC_OPTIONSTRING_SL : IDC_OPTIONSTRING, m_optionString);
	
	if( pDX->m_bSaveAndValidate )
	{
		if( kSetState == m_type && m_optionString.Find(" ") > -1 )
		{
			AfxMessageBox( "State can't contain the spaces.", MB_ICONSTOP );
			pDX->Fail();
		}
	}
}


BEGIN_MESSAGE_MAP(CAdminOptionDlg, CDialog)
	//{{AFX_MSG_MAP(CAdminOptionDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAdminOptionDlg message handlers

BOOL CAdminOptionDlg::OnInitDialog() 
{
	//set the title and description
	switch( m_type )
	{
	case kChangeLog:
		m_title = "Change log message";
		m_optionDescription = "&Log message:";
		break;
	case kSetState:
		m_title = "Set state";
		m_optionDescription = "&State:";
		m_singeLine = TRUE;
		break;
	case kSetDescription:
		m_title = "Set Description";
		m_optionDescription = "&Description";
		break;
	default:
		ASSERT(FALSE); //unknown type
		return FALSE;
	}

	//hide the unneccessary controls and re-position the window if neccessary
	GetDlgItem(m_singeLine ? IDC_OPTIONSTRING : IDC_OPTIONSTRING_SL)->EnableWindow(FALSE);
	GetDlgItem(m_singeLine ? IDC_OPTIONSTRING : IDC_OPTIONSTRING_SL)->ShowWindow(SW_HIDE);
	if( m_singeLine )
	{
		CRect rectSingleLine;
		CRect rectMultiLine;
		GetDlgItem(IDC_OPTIONSTRING_SL)->GetWindowRect(rectSingleLine);
		GetDlgItem(IDC_OPTIONSTRING)->GetWindowRect(rectMultiLine);
		int diff = rectMultiLine.Height() - rectSingleLine.Height();
		
		CRect rect;
		GetWindowRect(rect);
		SetWindowPos(NULL, 0, 0, rect.Width(), rect.Height() - diff, SWP_NOMOVE | SWP_NOZORDER);
		GetDlgItem(IDC_OPTIONDESC)->GetWindowRect(rect);
		GetDlgItem(IDC_OPTIONDESC)->SetWindowPos(NULL, 0, 0, rect.Width(), rect.Height() - diff, SWP_NOMOVE | SWP_NOZORDER);
		GetDlgItem(IDOK)->GetWindowRect(rect);
		ScreenToClient(rect);
		rect.OffsetRect(0, -diff);
		GetDlgItem(IDOK)->MoveWindow(rect);
		GetDlgItem(IDCANCEL)->GetWindowRect(rect);
		ScreenToClient(rect);
		rect.OffsetRect(0, -diff);
		GetDlgItem(IDCANCEL)->MoveWindow(rect);
	}

	//fix the line endings
	m_optionString.Replace("\n", "\r\n");

	CDialog::OnInitDialog();
	
	if( !m_title.IsEmpty() )
	{
		SetWindowText(m_title);
	}

	if( !m_optionDescription.IsEmpty() )
	{
		GetDlgItem(IDC_OPTIONDESC)->SetWindowText(m_optionDescription);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

#endif /* WIN32 */

bool CompatGetAdminOptions(kAdminOptionDlgType type, CPStr& optionString)
{
	bool userHitOK = false;
	
#ifdef WIN32
	CAdminOptionDlg adminOptionDlg(type);
	adminOptionDlg.m_optionString = (const char*)optionString;
	if( adminOptionDlg.DoModal() == IDOK )
	{
		optionString = (const char*)adminOptionDlg.m_optionString;
		userHitOK = true;
	}
#endif /* WIN32 */
#ifdef qMacCvsPP
#endif /* qMacCvsPP */
#if qUnix
#endif // qUnix
	
	return userHitOK;
}
