/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- July 1998
 */

/*
 * TagDlg.h : the cvs tag dialog
 */

#if !defined(AFX_TAGDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
#define AFX_TAGDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "CPStr.h"

bool CompatTagCreate(bool & noRecurs, bool & overwriteExisting,
					 CPStr & tagName, bool & checkUnmod);
bool CompatTagDelete(bool & noRecurs, CPStr & tagName);
bool CompatTagBranch(bool & noRecurs, CPStr & branchName,
					 bool & checkUnmod);
	// get the tag options...

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// CTag_CREATE dialog

class CTag_CREATE : public CPropertyPage
{
	DECLARE_DYNCREATE(CTag_CREATE)

// Construction
public:
	CTag_CREATE::CTag_CREATE(const char * sLastTag, bool noRecurs,
		bool overwriteExist, bool checkUnmod);
	CTag_CREATE();
	~CTag_CREATE();

// Dialog Data
	//{{AFX_DATA(CTag_CREATE)
	enum { IDD = IDD_TAG_CREATE };
	BOOL	m_checkunmod;
	BOOL	m_norecurs;
	BOOL	m_overwrite;
	CString	m_tagname;
	CComboBox m_tag;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CTag_CREATE)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CTag_CREATE)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

/////////////////////////////////////////////////////////////////////////////
// CTag_DELETE dialog

class CTag_DELETE : public CPropertyPage
{
	DECLARE_DYNCREATE(CTag_DELETE)

// Construction
public:
	CTag_DELETE::CTag_DELETE(const char * sLastBranch, bool noRecurs);
	CTag_DELETE();
	~CTag_DELETE();

// Dialog Data
	//{{AFX_DATA(CTag_DELETE)
	enum { IDD = IDD_TAG_DELETE };
	BOOL	m_norecurs;
	CString	m_tagname;
	CComboBox m_tag;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CTag_DELETE)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CTag_DELETE)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

/////////////////////////////////////////////////////////////////////////////
// CTag_BRANCH dialog

class CTag_BRANCH : public CPropertyPage
{
	DECLARE_DYNCREATE(CTag_BRANCH)

// Construction
public:
	CTag_BRANCH::CTag_BRANCH(const char * sLastBranch, bool noRecurs,
		bool checkUnmod);
	CTag_BRANCH();
	~CTag_BRANCH();

// Dialog Data
	//{{AFX_DATA(CTag_BRANCH)
	enum { IDD = IDD_TAG_BRANCH };
	BOOL	m_checkunmod;
	BOOL	m_norecurs;
	CString	m_branchname;
	CComboBox m_branch;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CTag_BRANCH)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CTag_BRANCH)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.
#endif /* WIN32 */

#endif // !defined(AFX_TAGDLG_H__98CCBD22_845B_11D1_8949_444553540000__INCLUDED_)
