/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * CvsCommands.h --- set of CVS commands
 */

#ifndef CVSCOMMANDS_H
#define CVSCOMMANDS_H

class MultiFiles;

void CvsCmdUpdateFolder(const char *dir = 0L, bool queryOnly = false);
void CvsCmdCommitFolder(const char *dir = 0L);
void CvsCmdDiffFolder(const char *dir = 0L);
void CvsCmdAddFolder(const char *dir = 0L);
void CvsCmdLogFolder(const char *dir = 0L);
void CvsCmdStatusFolder(const char *dir = 0L);
void CvsCmdLockFolder(const char *dir = 0L);
void CvsCmdUnlockFolder(const char *dir = 0L);
void CvsCmdTagCreateFolder(const char *dir = 0L);
void CvsCmdTagDeleteFolder(const char *dir = 0L);
void CvsCmdTagBranchFolder(const char *dir = 0L);

void CvsCmdInit(const char *dir = 0L);
void CvsCmdImportModule(const char *dir = 0L);
void CvsCmdCheckoutModule(const char *dir = 0L);
void CvsCmdRtagCreate(void);
void CvsCmdRtagDelete(void);
void CvsCmdRtagBranch(void);

void CvsCmdLogin(void);
void CvsCmdLogout(void);

void CvsCmdUpdateFiles(MultiFiles *mf = 0L, bool queryOnly = false);
void CvsCmdCommitFiles(MultiFiles *mf = 0L);
void CvsCmdDiffFiles(MultiFiles *mf = 0L);
void CvsCmdLogFiles(MultiFiles *mf = 0L, bool outGraph = false, void *defWnd = 0L);
void CvsCmdAddFiles(MultiFiles *mf = 0L);
void CvsCmdAddBinaryFiles(MultiFiles *mf = 0L);
void CvsCmdRemoveFiles(MultiFiles *mf = 0L);
void CvsCmdStatusFiles(MultiFiles *mf = 0L);
void CvsCmdCancelChangesFiles(MultiFiles *mf = 0L);
void CvsCmdLockFiles(MultiFiles *mf = 0L);
void CvsCmdUnlockFiles(MultiFiles *mf = 0L);
void CvsCmdTagCreateFiles(MultiFiles *mf = 0L);
void CvsCmdTagDeleteFiles(MultiFiles *mf = 0L);
void CvsCmdTagBranchFiles(MultiFiles *mf = 0L);

void CvsCmdLine(void);

void CvsCmdEditFiles(MultiFiles *mf = 0L);
void CvsCmdUneditFiles(MultiFiles *mf = 0L);
void CvsCmdWatchOnFiles(MultiFiles *mf = 0L);
void CvsCmdWatchOffFiles(MultiFiles *mf = 0L);
void CvsCmdWatchersFiles(MultiFiles *mf = 0L);
void CvsCmdEditorsFiles(MultiFiles *mf = 0L);

void CvsCmdEditFolder(const char *dir = 0L);
void CvsCmdUneditFolder(const char *dir = 0L);
void CvsCmdWatchOnFolder(const char *dir = 0L);
void CvsCmdWatchOffFolder(const char *dir = 0L);
void CvsCmdReleaseFolder(const char *dir = 0L);
void CvsCmdWatchersFolder(const char *dir = 0L);
void CvsCmdEditorsFolder(const char *dir = 0L);

void CvsCmdMacrosAdmin(const char *macroName);

#endif /* CVSCOMMANDS_H */
