#!/bin/sh

echo "#define DATE      \"`date`\"" >crypto/date.h

CC=gcc
FLAGS='-DTERMIO -O3 -DL_ENDIAN -fomit-frame-pointer -m486 -Wall'
#FLAGS='-DTERMIO -g -DL_ENDIAN -m486 -Wall'
INCLUDE='-Iinclude -Icrypto -Issl'
SHFLAGS='-DPIC -fpic'

CFLAGS="$FLAGS $INCLUDE $SHFLAGS"

echo compiling bignum assember
as -o bn_asm.o crypto/bn/asm/x86-lnx.s
CFLAGS="$CFLAGS -DASM"

echo compiling crypto
$CC -c $CFLAGS -DCFLAGS="\"$FLAGS\"" -o crypto.o crypto/crypto.c

echo building libcrypto.so
ld -shared -o libcrypto.so crypto.o bn_asm.o

echo compiling ssl
$CC -c $CFLAGS -o ssl.o ssl/ssl.c
echo building libssl.so
ld -shared -o libssl.so ssl.o
