/*
 # $Id: misc.c,v 1.4 1997/09/30 13:41:56 fbm Exp fbm $
 # Copyright (C) 1997 Farrell McKay
 # All rights reserved.
 #
 # This file is part of the Fortify distribution, a toolkit for
 # upgrading the cryptographic strength of the Netscape Navigator
 # web browser, authored by Farrell McKay.
 #
 # This toolkit is provided to the recipient under the
 # following terms and conditions:-
 #   1.  This copyright notice must not be removed or modified.
 #   2.  This toolkit may not be reproduced or included in any commercial
 #       media distribution, or commercial publication (for example CD-ROM,
 #       disk, book, magazine, journal) without first obtaining the author's
 #       express permission.
 #   3.  This toolkit, or any component of this toolkit, may not be
 #       commercially resold, redeveloped, rewritten, enhanced or otherwise
 #       used as the basis for commercial venture, without first obtaining
 #       the author's express permission.
 #   4.  Subject to the above conditions being observed (1-3), this toolkit
 #       may be freely reproduced or redistributed.
 #   5.  This software is provided "as-is", without express or implied
 #       warranty.  In no event shall the author be liable for any direct,
 #       indirect or consequential damages however caused.
 #   6.  Subject to the above conditions being observed (1-5),
 #       this toolkit may be used at no cost to the recipient.
 #
 # Farrell McKay			Farrell.McKay@mpx.com.au
 */

#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "misc.h"

void *
_malloc(size_t sz)
{
	void	*p;
	p = malloc(sz);
	if (p == (void *)0) {
		fprintf(stderr, "Not enough memory\n");
		exit(1);
	}
	return p;
}

void *
_realloc(void *s, size_t sz)
{
	void	*p;
	p = s? realloc(s, sz): malloc(sz);
	if (p == (void *)0) {
		fprintf(stderr, "Not enough memory\n");
		exit(1);
	}
	return p;
}

void *
_calloc(size_t n, size_t sz)
{
	void	*p;
	p = calloc(n, sz);
	if (p == (void *)0) {
		fprintf(stderr, "Not enough memory\n");
		exit(1);
	}
	return p;
}

char *
_strdup(const char *s)
{
	char	*p;
	p = strdup(s);
	if (p == (char *)0) {
		fprintf(stderr, "Not enough memory\n");
		exit(1);
	}
	return p;
}

char *
_strndup(const char *s, int n)
{
	char	*p;
	p = (char *) _calloc(n+1, sizeof(char));
	strncpy(p, s, n);
	return p;
}

char *
seg_name(int i)
{
	if (i == SEG_TEXT)
		return "text";
	if (i == SEG_DATA)
		return "data";
	if (i == SEG_RODATA)
		return "rodata";
	return "?unknown?";
}

int
isnumeric(char *s)
{
	while (isdigit(*s))
		s++;
	return (*s == '\0');
}
