/*
 * Copyright (c) 1995, 1996, 1997, 1998, 1999 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 * 
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* Copyright (C) 1999  Carnegie Mellon University
 * Extensions and modifications to Arla code base for Coda by
 * Philip A. Nelson
 */

/* Started with: xfs_node.c,v 1.8 1999/06/16 20:23:39 assar Exp */
/* $Id: coda_node.c,v 1.1 1999/10/19 17:52:07 phil Exp $ */

#include <coda.h>
#include <coda_sys.h>
#include <coda_common.h>
#include <coda_fs.h>
#include <coda_debug.h>
#include <coda_upcalls.h>

/*
 * Create a new coda_node and make a VN_HOLD()!
 *
 * Also prevents creation of duplicates. This happens
 * whenever there are more than one name to a file,
 * "." and ".." are common cases.
 */
struct coda_node *
new_coda_node(struct coda *codap, struct ViceFid *VFid, vtype_t vn_type)
{
  struct coda_node *result;

  CODADEB(CDEBNODE, (CE_NOTE, "new_coda_node %d.%d.%d\n",
		     VFid->Volume,
		     VFid->Vnode,
		     VFid->Unique));

  /* Does not allow duplicates */
  result = coda_node_find(codap, VFid);
  if (result == 0)
    {
      result = coda_alloc(sizeof(*result));
      if (result == 0)
	{
	  cmn_err(CE_PANIC, "new_coda_node: coda_alloc(%d) failed\n",
		  (int)sizeof(*result));
	  panic("new_coda_node: You Loose!");
	}

      /* Init vnode part */
      result->vn.v_vfsmountedhere = 0;
      result->vn.v_op = &coda_vnodeops;
      result->vn.v_filocks = 0;
      DATA_FROM_CNODE(result) = (struct vnode *) 0;
      VN_INIT(&result->vn, codap->vfsp, vn_type, codap->rdev);  /* XX rdev? */

      /* Init the remainder of the coda_node. */
      result->VFid = *VFid;
      result->flags = 0;
      result->ovp = NULL;
      result->ocount = 0;
      result->owrite = 0;
      result->create = 0;
      result->symlink = NULL;
      result->symlen = 0;
      result->device = 0;
      result->inode = 0;

      /* Save reference on list */
      result->next = codap->nodes;
      codap->nodes = result;
      codap->nnodes++;
    }
  else
    {
      /* Node is already cached */
      VN_HOLD(CNODE_TO_VNODE(result));
    }

  /* Init other fields ? */

  return result;
}


void
free_coda_node(struct coda_node *node)
{
  struct coda *codap = CODA_FROM_CNODE(node);
  struct coda_node *t;

  CODADEB(CDEBNODE, (CE_NOTE, "free_coda_node starting\n"));

  /* First remove from chain. */
  if (node == codap->nodes)
    {
      codap->nodes = node->next;
    }
  else
    {
      for (t = codap->nodes; t->next; t = t->next)
	if (t->next == node)
	  {
	    t->next = t->next->next;
	    goto done;
	  }
      printf("CODA PANIC Error: free_coda_node(0x%x) failed?\n", (int) node);
      return;
    }

 done:
  /* XXX Really need to put back dirty data first. */
  if (DATA_FROM_CNODE(node))
    {
      VN_RELE(DATA_FROM_CNODE(node));
    }
  codap->nnodes--;
  coda_free(node, sizeof(*node));

  CODADEB(CDEBNODE, (CE_NOTE, "free_coda_node done\n"));
}

void
free_all_coda_nodes(struct coda *codap)
{
  struct coda_node *t;

  CODADEB(CDEBNODE, (CE_NOTE, "free_all_coda_nodes starting\n"));

#if 0
  coda_dnlc_purge();		/* This is really a bit brutal! */
#endif
  CODADEB(CDEBNODE, (CE_NOTE, "free_all_coda_nodes now removing root\n"));
  if (codap->root)
    {
      VN_RELE(CNODE_TO_VNODE(codap->root));
      codap->root = 0;
    }

  /* There might still be a few nodes out there, invalidate them */
  for (t = codap->nodes; t; t = t->next)
    {
      if (DATA_FROM_CNODE(t))
	{
	  VN_RELE(DATA_FROM_CNODE(t));
	  DATA_FROM_CNODE(t) = (struct vnode *) 0;
	}
    }

  CODADEB(CDEBNODE, (CE_NOTE, "free_all_coda_nodes done\n"));
}

struct coda_node *
coda_node_find(struct coda *codap, ViceFid *VFid)
{
  struct coda_node *t;

  CODADEB(CDEBNODE, (CE_NOTE, "coda_node_find\n"));

  for (t = codap->nodes; t != NULL; t = t->next)
    if ((t->VFid.Volume == VFid->Volume)
	&& (t->VFid.Vnode == VFid->Vnode)
	&& (t->VFid.Unique == VFid->Unique))
      break;
  return t;
}

