/*
 * Copyright (c) 1995, 1996, 1997 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Kungliga Tekniska
 *      Hgskolan and its contributors.
 *
 * 4. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* Copyright (C) 1999  Carnegie Mellon University
 * Extensions and modifications to Arla code base for Coda by
 * Philip A. Nelson
 */

/* Started with: xfs_fs.h,v 1.4 1998/12/22 13:16:55 lha Exp */
/* $Id: coda_fs.h,v 1.2 2000/01/26 00:34:10 phil Exp $ */

#ifndef _CODA_FS_H_
#define _CODA_FS_H_

#include <coda_common.h>
#include <coda_node.h>

/*
 * Filesystem struct.
 */
struct coda {
  u_int 	status;		/* Inited, opened or mounted */
  struct vfs 	*vfsp;
  struct coda_node *root;
  u_int 	nnodes;
  dev_t		rdev;		/* XXX save this for later use? */
  int 		minor;		/* Which device to use for upcall. */

  struct coda_node *nodes;		/* replace with hash table */
};

/* Filesystem status codes. */
#define CODA_MOUNTED	0x1

#define VFS_TO_CODA(v)      ((struct coda *) ((v)->vfs_data))
#define CODA_TO_VFS(x)      ((x)->vfsp)

#define CODA_FROM_VNODE(vp) VFS_TO_CODA((vp)->v_vfsp)
#define CODA_FROM_CNODE(xp) CODA_FROM_VNODE(CNODE_TO_VNODE(xp))

extern struct coda coda[];

extern struct vnodeops coda_vnodeops;

extern struct vnode *coda_ctlvp;

extern int coda_fstype;

void free_all_coda_nodes (struct coda *codap);
void free_coda_node (struct coda_node *);
struct coda_node *coda_node_find (struct coda *, ViceFid *);
struct coda_node *new_coda_node (struct coda *, ViceFid *, vtype_t);

#endif /* _CODA_FS_H */
