/*
 * 
 *             Coda: an Experimental Distributed File System
 *                              Release 3.1
 * 
 *           Copyright (c) 1999 Carnegie Mellon University
 *                          All Rights Reserved
 * 
 * Permission  to  use, copy, modify and distribute this software and its
 * documentation is hereby granted,  provided  that  both  the  copyright
 * notice  and  this  permission  notice  appear  in  all  copies  of the
 * software, derivative works or  modified  versions,  and  any  portions
 * thereof, and that both notices appear in supporting documentation, and
 * that credit is given to Carnegie Mellon University  in  all  documents
 * and publicity pertaining to direct or indirect use of this code or its
 * derivatives.
 * 
 * CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
 * SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
 * FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
 * DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
 * RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
 * ANY DERIVATIVE WORK.
 * 
 * Carnegie  Mellon  encourages  users  of  this  software  to return any
 * improvements or extensions that  they  make,  and  to  grant  Carnegie
 * Mellon the rights to redistribute these changes without encumbrance.
 * 
 */

/* $Id: coda_downcall.c,v 1.1 1999/10/19 17:52:07 phil Exp $ */

#include <coda.h>
#include <coda_sys.h>
#include <coda_common.h>
#include <coda_debug.h>
#include <coda_dev.h>
#include <coda_downcall.h>

int coda_do_downcall (union outputArgs *message, u_int size,
		      struct coda_channel *chan)
{
  CODADEB (CDEBDNC, (CE_NOTE, "coda_do_downcall: opcode=%d\n",
		    message->oh.opcode));

  switch (message->oh.opcode) {
  case CODA_REPLACE:
  case CODA_FLUSH:
  case CODA_PURGEUSER:
  case CODA_ZAPFILE:
  case CODA_ZAPDIR:
  case CODA_PURGEFID:
    return 0;

  default:
    CODADEB (CDEBDNC, (CE_NOTE, "coda_do_downcall: unrecognized opcode\n"));
  }
  return EINVAL;
}

