/*
 * 
 *             Coda: an Experimental Distributed File System
 *                              Release 3.1
 * 
 *           Copyright (c) 1999 Carnegie Mellon University
 *                          All Rights Reserved
 * 
 * Permission  to  use, copy, modify and distribute this software and its
 * documentation is hereby granted,  provided  that  both  the  copyright
 * notice  and  this  permission  notice  appear  in  all  copies  of the
 * software, derivative works or  modified  versions,  and  any  portions
 * thereof, and that both notices appear in supporting documentation, and
 * that credit is given to Carnegie Mellon University  in  all  documents
 * and publicity pertaining to direct or indirect use of this code or its
 * derivatives.
 * 
 * CODA IS AN EXPERIMENTAL SOFTWARE SYSTEM AND IS  KNOWN  TO  HAVE  BUGS,
 * SOME  OF  WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON ALLOWS
 * FREE USE OF THIS SOFTWARE IN ITS "AS IS" CONDITION.   CARNEGIE  MELLON
 * DISCLAIMS  ANY  LIABILITY  OF  ANY  KIND  FOR  ANY  DAMAGES WHATSOEVER
 * RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE  OR  OF
 * ANY DERIVATIVE WORK.
 * 
 * Carnegie  Mellon  encourages  users  of  this  software  to return any
 * improvements or extensions that  they  make,  and  to  grant  Carnegie
 * Mellon the rights to redistribute these changes without encumbrance.
 * 
 */

/* $Id: coda_upcalls.h,v 1.1 1999/10/19 17:52:03 phil Exp $ */

#ifndef _CODA_UPCALL_H_
#define _CODA_UPCALL_H_

/* Routines in coda_upcalls.c */
int coda_venus_root (int minor, ViceFid *VFidp);
int coda_venus_open (int minor, cred_t *cred, int flags, ViceFid *VFidp,
		    dev_t *dev, ino_t *inode);
int coda_venus_open_by_path (int minor, cred_t *cred, int flags,
			    ViceFid *VFidp, char *name);
int coda_venus_getattr (int minor, cred_t *cred, ViceFid *VFidp,
		       struct vattr *vap);
int coda_venus_setattr (int minor, cred_t *cred, ViceFid *VFidp,
		       struct vattr *vap);
int coda_venus_access (int minor, cred_t *cred, ViceFid *VFidp, int mode);
int coda_venus_lookup (int minor, cred_t *cred, ViceFid *inVFidp, char *name,
		      ViceFid *outVFidp, vtype_t *vtypep, int *nocache);
int coda_venus_create (int minor, cred_t *cred, ViceFid *inVFidp, char *name,
		      int mode, struct vattr *va, vcexcl_t exclusive,
		      ViceFid *outVFidp);
int coda_venus_mkdir (int minor, cred_t *cred, ViceFid *inVFidp, char *name,
		     struct vattr *va, ViceFid *outVFidp);
int coda_venus_link (int minor, cred_t *cred, ViceFid *fileVFidp,
		    ViceFid *dirVFidp, char *name);
int coda_venus_symlink (int minor, cred_t *cred, ViceFid *VFidp,
		       char *linkname, struct vattr *tva, char *tname);
int coda_venus_remove (int minor, cred_t *cred, ViceFid *VFidp, char *name);
int coda_venus_rmdir (int minor, cred_t *cred, ViceFid *VFidp, char *name);
int coda_venus_readlink (int minor, cred_t *cred, ViceFid *VFidp,
			struct uio *uiop);
int coda_venus_rename (int minor, cred_t *cred, ViceFid *srcFidp,
		      char *srcname, ViceFid *dstFidp, char *dstname);
int coda_venus_fsync (int minor, cred_t *cred, ViceFid *VFidp);
int coda_venus_close (int minor, cred_t *cred, ViceFid *VFidp, int flag);
int coda_venus_ioctl (int minor, cred_t *cred, ViceFid *VFidp, int cmd,
		     struct PioctlData *ioargp);
     
#endif /* _CODA_UPCALL_H_ */
