//===- TableGen'erated file -------------------------------------*- C++ -*-===//
//
// DAG Instruction Selector for the X86 target
//
// Automatically generated file, do not edit!
//
//===----------------------------------------------------------------------===//

// *** NOTE: This file is #included into the middle of the target
// *** instruction selector class.  These functions are really methods.


// Predicate functions.
inline bool Predicate_alignedload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getAlignment() >= 16;

}
inline bool Predicate_alignednontemporalstore(SDNode *N) const {

  if (StoreSDNode *ST = dyn_cast<StoreSDNode>(N))
    return ST->isNonTemporal() && !ST->isTruncatingStore() &&
           ST->getAddressingMode() == ISD::UNINDEXED &&
           ST->getAlignment() >= 16;
  return false;

}
inline bool Predicate_alignedstore(SDNode *N) const {

  return cast<StoreSDNode>(N)->getAlignment() >= 16;

}
inline bool Predicate_and_su(SDNode *N) const {

  return N->hasOneUse();

}
inline bool Predicate_atomic_cmp_swap_16(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_atomic_cmp_swap_32(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_atomic_cmp_swap_64(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;

}
inline bool Predicate_atomic_cmp_swap_8(SDNode *N) const {

  return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_atomic_load_add_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_add_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_add_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_add_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_and_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_and_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_and_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_and_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_max_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_max_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_max_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_max_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_min_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_min_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_min_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_min_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_nand_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_nand_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_nand_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_nand_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_or_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_or_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_or_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_or_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_sub_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_sub_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_sub_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_sub_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_umax_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_umax_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_umax_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_umax_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_umin_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_umin_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_umin_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_umin_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_load_xor_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_load_xor_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_load_xor_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_load_xor_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_atomic_swap_16(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i16;
  
}
inline bool Predicate_atomic_swap_32(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i32;
  
}
inline bool Predicate_atomic_swap_64(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i64;
  
}
inline bool Predicate_atomic_swap_8(SDNode *N) const {

    return cast<AtomicSDNode>(N)->getMemoryVT() == MVT::i8;
  
}
inline bool Predicate_cvtff(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_FF;
    
}
inline bool Predicate_cvtfs(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_FS;
    
}
inline bool Predicate_cvtfu(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_FU;
    
}
inline bool Predicate_cvtsf(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_SF;
    
}
inline bool Predicate_cvtss(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_SS;
    
}
inline bool Predicate_cvtsu(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_SU;
    
}
inline bool Predicate_cvtuf(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_UF;
    
}
inline bool Predicate_cvtus(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_US;
    
}
inline bool Predicate_cvtuu(SDNode *N) const {

       return cast<CvtRndSatSDNode>(N)->getCvtCode() == ISD::CVT_UU;
    
}
inline bool Predicate_def32(SDNode *N) const {

  return N->getOpcode() != ISD::TRUNCATE &&
         N->getOpcode() != TargetOpcode::EXTRACT_SUBREG &&
         N->getOpcode() != ISD::CopyFromReg &&
         N->getOpcode() != X86ISD::CMOV;

}
inline bool Predicate_dsload(SDNode *N) const {

  if (const Value *Src = cast<LoadSDNode>(N)->getSrcValue())
    if (const PointerType *PT = dyn_cast<PointerType>(Src->getType()))
      if (PT->getAddressSpace() > 255)
        return false;
  return true;

}
inline bool Predicate_extload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::EXTLOAD;

}
inline bool Predicate_extloadf32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_extloadf64(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::f64;

}
inline bool Predicate_extloadi1(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_extloadi16(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_extloadi32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_extloadi8(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_fp32imm0(SDNode *inN) const {
  ConstantFPSDNode *N = cast<ConstantFPSDNode>(inN);

  return N->isExactlyValue(+0.0);

}
inline bool Predicate_fpimm0(SDNode *inN) const {
  ConstantFPSDNode *N = cast<ConstantFPSDNode>(inN);

  return N->isExactlyValue(+0.0);

}
inline bool Predicate_fpimm1(SDNode *inN) const {
  ConstantFPSDNode *N = cast<ConstantFPSDNode>(inN);

  return N->isExactlyValue(+1.0);

}
inline bool Predicate_fpimmneg0(SDNode *inN) const {
  ConstantFPSDNode *N = cast<ConstantFPSDNode>(inN);

  return N->isExactlyValue(-0.0);

}
inline bool Predicate_fpimmneg1(SDNode *inN) const {
  ConstantFPSDNode *N = cast<ConstantFPSDNode>(inN);

  return N->isExactlyValue(-1.0);

}
inline bool Predicate_fsload(SDNode *N) const {

  if (const Value *Src = cast<LoadSDNode>(N)->getSrcValue())
    if (const PointerType *PT = dyn_cast<PointerType>(Src->getType()))
      return PT->getAddressSpace() == 257;
  return false;

}
inline bool Predicate_gsload(SDNode *N) const {

  if (const Value *Src = cast<LoadSDNode>(N)->getSrcValue())
    if (const PointerType *PT = dyn_cast<PointerType>(Src->getType()))
      return PT->getAddressSpace() == 256;
  return false;

}
inline bool Predicate_i64immSExt32(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  // i64immSExt32 predicate - True if the 64-bit immediate fits in a 32-bit
  // sign extended field.
  return (int64_t)N->getZExtValue() == (int32_t)N->getZExtValue();

}
inline bool Predicate_i64immZExt32(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  // i64immZExt32 predicate - True if the 64-bit immediate fits in a 32-bit
  // unsignedsign extended field.
  return (uint64_t)N->getZExtValue() == (uint32_t)N->getZExtValue();

}
inline bool Predicate_immAllOnesV(SDNode *N) const {

  return ISD::isBuildVectorAllOnes(N);

}
inline bool Predicate_immAllOnesV_bc(SDNode *N) const {

  return ISD::isBuildVectorAllOnes(N);

}
inline bool Predicate_immAllZerosV(SDNode *N) const {

  return ISD::isBuildVectorAllZeros(N);

}
inline bool Predicate_immAllZerosV_bc(SDNode *N) const {

  return ISD::isBuildVectorAllZeros(N);

}
inline bool Predicate_immSext8(SDNode *inN) const {
  ConstantSDNode *N = cast<ConstantSDNode>(inN);

  return N->getSExtValue() == (int8_t)N->getSExtValue();

}
inline bool Predicate_istore(SDNode *N) const {

  return !cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_itruncstore(SDNode *N) const {

  return cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_load(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::NON_EXTLOAD;

}
inline bool Predicate_loadi16(SDNode *N) const {

  LoadSDNode *LD = cast<LoadSDNode>(N);
  if (const Value *Src = LD->getSrcValue())
    if (const PointerType *PT = dyn_cast<PointerType>(Src->getType()))
      if (PT->getAddressSpace() > 255)
        return false;
  ISD::LoadExtType ExtType = LD->getExtensionType();
  if (ExtType == ISD::NON_EXTLOAD)
    return true;
  if (ExtType == ISD::EXTLOAD)
    return LD->getAlignment() >= 2 && !LD->isVolatile();
  return false;

}
inline bool Predicate_loadi16_anyext(SDNode *N) const {

  LoadSDNode *LD = cast<LoadSDNode>(N);
  if (const Value *Src = LD->getSrcValue())
    if (const PointerType *PT = dyn_cast<PointerType>(Src->getType()))
      if (PT->getAddressSpace() > 255)
        return false;
  ISD::LoadExtType ExtType = LD->getExtensionType();
  if (ExtType == ISD::EXTLOAD)
    return LD->getAlignment() >= 2 && !LD->isVolatile();
  return false;

}
inline bool Predicate_loadi32(SDNode *N) const {

  LoadSDNode *LD = cast<LoadSDNode>(N);
  if (const Value *Src = LD->getSrcValue())
    if (const PointerType *PT = dyn_cast<PointerType>(Src->getType()))
      if (PT->getAddressSpace() > 255)
        return false;
  ISD::LoadExtType ExtType = LD->getExtensionType();
  if (ExtType == ISD::NON_EXTLOAD)
    return true;
  if (ExtType == ISD::EXTLOAD)
    return LD->getAlignment() >= 4 && !LD->isVolatile();
  return false;

}
inline bool Predicate_memop(SDNode *N) const {

  return    Subtarget->hasVectorUAMem()
         || cast<LoadSDNode>(N)->getAlignment() >= 16;

}
inline bool Predicate_memop64(SDNode *N) const {

  return cast<LoadSDNode>(N)->getAlignment() >= 8;

}
inline bool Predicate_mmx_pshufw(SDNode *N) const {

  return X86::isPSHUFDMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_mmx_unpckh(SDNode *N) const {

  return X86::isUNPCKHMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_mmx_unpckh_undef(SDNode *N) const {

  return X86::isUNPCKH_v_undef_Mask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_mmx_unpckl(SDNode *N) const {

  return X86::isUNPCKLMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_mmx_unpckl_undef(SDNode *N) const {

  return X86::isUNPCKL_v_undef_Mask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_movddup(SDNode *N) const {

  return X86::isMOVDDUPMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_movhlps(SDNode *N) const {

  return X86::isMOVHLPSMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_movhlps_undef(SDNode *N) const {

  return X86::isMOVHLPS_v_undef_Mask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_movl(SDNode *N) const {

  return X86::isMOVLMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_movlhps(SDNode *N) const {

  return X86::isMOVLHPSMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_movlp(SDNode *N) const {

  return X86::isMOVLPMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_movshdup(SDNode *N) const {

  return X86::isMOVSHDUPMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_movsldup(SDNode *N) const {

  return X86::isMOVSLDUPMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_nontemporalstore(SDNode *N) const {

  if (StoreSDNode *ST = dyn_cast<StoreSDNode>(N))
    return ST->isNonTemporal();
  return false;

}
inline bool Predicate_or_is_add(SDNode *N) const {

  if (ConstantSDNode *CN = dyn_cast<ConstantSDNode>(N->getOperand(1)))
    return CurDAG->MaskedValueIsZero(N->getOperand(0), CN->getAPIntValue());
  else {
    unsigned BitWidth = N->getValueType(0).getScalarType().getSizeInBits();
    APInt Mask = APInt::getAllOnesValue(BitWidth);
    APInt KnownZero0, KnownOne0;
    CurDAG->ComputeMaskedBits(N->getOperand(0), Mask, KnownZero0, KnownOne0, 0);
    APInt KnownZero1, KnownOne1;
    CurDAG->ComputeMaskedBits(N->getOperand(1), Mask, KnownZero1, KnownOne1, 0);
    return (~KnownZero0 & ~KnownZero1) == 0;
  }

}
inline bool Predicate_palign(SDNode *N) const {

  return X86::isPALIGNRMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_post_store(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::POST_INC || AM == ISD::POST_DEC;

}
inline bool Predicate_post_truncst(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::POST_INC || AM == ISD::POST_DEC;

}
inline bool Predicate_post_truncstf32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_post_truncsti1(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_post_truncsti16(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_post_truncsti32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_post_truncsti8(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_pre_store(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::PRE_INC || AM == ISD::PRE_DEC;

}
inline bool Predicate_pre_truncst(SDNode *N) const {

  ISD::MemIndexedMode AM = cast<StoreSDNode>(N)->getAddressingMode();
  return AM == ISD::PRE_INC || AM == ISD::PRE_DEC;

}
inline bool Predicate_pre_truncstf32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_pre_truncsti1(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_pre_truncsti16(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_pre_truncsti32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_pre_truncsti8(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_pshufd(SDNode *N) const {

  return X86::isPSHUFDMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_pshufhw(SDNode *N) const {

  return X86::isPSHUFHWMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_pshuflw(SDNode *N) const {

  return X86::isPSHUFLWMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_sextload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::SEXTLOAD;

}
inline bool Predicate_sextloadi1(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_sextloadi16(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_sextloadi32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_sextloadi8(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_shld(SDNode *N) const {

  assert(N->getOpcode() == ISD::OR);
  return N->getOperand(0).getOpcode() == ISD::SHL &&
         N->getOperand(1).getOpcode() == ISD::SRL &&
         isa<ConstantSDNode>(N->getOperand(0).getOperand(1)) &&
         isa<ConstantSDNode>(N->getOperand(1).getOperand(1)) &&
         N->getOperand(0).getConstantOperandVal(1) ==
         N->getValueSizeInBits(0) - N->getOperand(1).getConstantOperandVal(1);

}
inline bool Predicate_shrd(SDNode *N) const {

  assert(N->getOpcode() == ISD::OR);
  return N->getOperand(0).getOpcode() == ISD::SRL &&
         N->getOperand(1).getOpcode() == ISD::SHL &&
         isa<ConstantSDNode>(N->getOperand(0).getOperand(1)) &&
         isa<ConstantSDNode>(N->getOperand(1).getOperand(1)) &&
         N->getOperand(0).getConstantOperandVal(1) ==
         N->getValueSizeInBits(0) - N->getOperand(1).getConstantOperandVal(1);

}
inline bool Predicate_shufp(SDNode *N) const {

  return X86::isSHUFPMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_splat_lo(SDNode *N) const {

  ShuffleVectorSDNode *SVOp = cast<ShuffleVectorSDNode>(N);
  return SVOp->isSplat() && SVOp->getSplatIndex() == 0;

}
inline bool Predicate_srl_su(SDNode *N) const {

  return N->hasOneUse();

}
inline bool Predicate_store(SDNode *N) const {

  return !cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_trunc_su(SDNode *N) const {

  return N->hasOneUse();

}
inline bool Predicate_truncstore(SDNode *N) const {

  return cast<StoreSDNode>(N)->isTruncatingStore();

}
inline bool Predicate_truncstoref32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f32;

}
inline bool Predicate_truncstoref64(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::f64;

}
inline bool Predicate_truncstorei16(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_truncstorei32(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_truncstorei8(SDNode *N) const {

  return cast<StoreSDNode>(N)->getMemoryVT() == MVT::i8;

}
inline bool Predicate_unalignednontemporalstore(SDNode *N) const {

  if (StoreSDNode *ST = dyn_cast<StoreSDNode>(N))
    return ST->isNonTemporal() &&
           ST->getAlignment() < 16;
  return false;

}
inline bool Predicate_unindexedload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getAddressingMode() == ISD::UNINDEXED;

}
inline bool Predicate_unindexedstore(SDNode *N) const {

  return cast<StoreSDNode>(N)->getAddressingMode() == ISD::UNINDEXED;

}
inline bool Predicate_unpckh(SDNode *N) const {

  return X86::isUNPCKHMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_unpckh_undef(SDNode *N) const {

  return X86::isUNPCKH_v_undef_Mask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_unpckl(SDNode *N) const {

  return X86::isUNPCKLMask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_unpckl_undef(SDNode *N) const {

  return X86::isUNPCKL_v_undef_Mask(cast<ShuffleVectorSDNode>(N));

}
inline bool Predicate_vtFP(SDNode *inN) const {
  VTSDNode *N = cast<VTSDNode>(inN);
 return N->getVT().isFloatingPoint(); 
}
inline bool Predicate_vtInt(SDNode *inN) const {
  VTSDNode *N = cast<VTSDNode>(inN);
 return N->getVT().isInteger(); 
}
inline bool Predicate_zextload(SDNode *N) const {

  return cast<LoadSDNode>(N)->getExtensionType() == ISD::ZEXTLOAD;

}
inline bool Predicate_zextloadi1(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i1;

}
inline bool Predicate_zextloadi16(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i16;

}
inline bool Predicate_zextloadi32(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i32;

}
inline bool Predicate_zextloadi8(SDNode *N) const {

  return cast<LoadSDNode>(N)->getMemoryVT() == MVT::i8;

}


// The main instruction selector code.
SDNode *SelectCode(SDNode *N) {
  // Opcodes are emitted as 2 bytes, TARGET_OPCODE handles this.
  #define TARGET_OPCODE(X) X & 255, unsigned(X) >> 8
  static const unsigned char MatcherTable[] = {
          OPC_SwitchOpcode , 117|128,6|128,1,  ISD::STORE,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_Scope, 43|128,1, 
              OPC_RecordChild1,
              OPC_Scope, 49, 
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_RecordChild2,
                OPC_CheckPredicate, 0,
                OPC_Scope, 20, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVNTPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                20, 
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVNTDQmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              41, 
                OPC_CheckChild1Type, MVT::v2f64,
                OPC_RecordChild2,
                OPC_CheckPredicate, 0,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_Scope, 12, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVNTDQ_64mr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                12, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVNTPDmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              25, 
                OPC_CheckChild1Type, MVT::i32,
                OPC_RecordChild2,
                OPC_CheckPredicate, 1,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVNTImr), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 3, 4, 5, 6, 7, 1, 
              25, 
                OPC_CheckChild1Type, MVT::i64,
                OPC_RecordChild2,
                OPC_CheckPredicate, 1,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVNTI_64mr), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 3, 4, 5, 6, 7, 1, 
              23, 
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVNTDQmr), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 1, 3, 4, 5, 6, 7, 
              0, 
            104|128,124, 
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 68|128,20,  ISD::OR,
                OPC_Scope, 46|128,19, 
                  OPC_MoveChild, 0,
                  OPC_SwitchOpcode , 118|128,7,  ISD::SRL,
                    OPC_Scope, 44|128,1, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_Scope, 79, 
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_RecordChild0,
                        OPC_RecordChild0,
                        OPC_CheckChild0Type, MVT::i32,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SHL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::SUB,
                        OPC_MoveChild, 0,
                        OPC_CheckInteger, 32, 
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitCopyToReg, 4, X86::ECX,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD32mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 5, 
                      79, 
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_RecordChild0,
                        OPC_RecordChild0,
                        OPC_CheckChild0Type, MVT::i16,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SHL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::SUB,
                        OPC_MoveChild, 0,
                        OPC_CheckInteger, 16, 
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitCopyToReg, 4, X86::CX,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD16mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 5, 
                      0, 
                    39|128,1, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::TRUNCATE,
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::SUB,
                      OPC_MoveChild, 0,
                      OPC_Scope, 76, 
                        OPC_CheckInteger, 32, 
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SHL,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_MoveChild, 0,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 5,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/5,
                        OPC_EmitMergeInputChains, 2, 0, 4, 
                        OPC_EmitCopyToReg, 3, X86::ECX,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD32mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 1, 
                      76, 
                        OPC_CheckInteger, 16, 
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SHL,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_MoveChild, 0,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 5,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/5,
                        OPC_EmitMergeInputChains, 2, 0, 4, 
                        OPC_EmitCopyToReg, 3, X86::CX,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD16mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 1, 
                      0, 
                    16|128,1, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_Scope, 65, 
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckChild1Type, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SHL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SUB,
                        OPC_MoveChild, 0,
                        OPC_CheckInteger, 32, 
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitCopyToReg, 4, X86::CL,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD32mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 5, 
                      65, 
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckChild1Type, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SHL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SUB,
                        OPC_MoveChild, 0,
                        OPC_CheckInteger, 16, 
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitCopyToReg, 4, X86::CL,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD16mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 5, 
                      0, 
                    15|128,1, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::SUB,
                      OPC_MoveChild, 0,
                      OPC_Scope, 66, 
                        OPC_CheckInteger, 32, 
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SHL,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 5,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/5,
                        OPC_EmitMergeInputChains, 2, 0, 4, 
                        OPC_EmitCopyToReg, 3, X86::CL,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD32mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 1, 
                      66, 
                        OPC_CheckInteger, 16, 
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SHL,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 5,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/5,
                        OPC_EmitMergeInputChains, 2, 0, 4, 
                        OPC_EmitCopyToReg, 3, X86::CL,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD16mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 1, 
                      0, 
                    72|128,1, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_Scope, 61, 
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SHL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 7,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD32mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 4, 10, 
                      61, 
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SHL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 7,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD16mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 4, 10, 
                      63, 
                        OPC_CheckPredicate, 8,
                        OPC_CheckPredicate, 9,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SHL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 7,
                        OPC_CheckType, MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD64mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 4, 10, 
                      0, 
                    46|128,1, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_CheckType, MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::SHL,
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_Scope, 48, 
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 10,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                        OPC_EmitMergeInputChains, 2, 0, 2, 
                        OPC_EmitConvertToTarget, 4,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD32mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 1, 10, 
                      48, 
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 10,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                        OPC_EmitMergeInputChains, 2, 0, 2, 
                        OPC_EmitConvertToTarget, 4,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD16mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 1, 10, 
                      50, 
                        OPC_CheckPredicate, 8,
                        OPC_CheckPredicate, 9,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 10,
                        OPC_CheckType, MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                        OPC_EmitMergeInputChains, 2, 0, 2, 
                        OPC_EmitConvertToTarget, 4,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD64mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 1, 10, 
                      0, 
                    0, 
                  118|128,7,  ISD::SHL,
                    OPC_Scope, 44|128,1, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_Scope, 79, 
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_RecordChild0,
                        OPC_RecordChild0,
                        OPC_CheckChild0Type, MVT::i32,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SRL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::SUB,
                        OPC_MoveChild, 0,
                        OPC_CheckInteger, 32, 
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitCopyToReg, 4, X86::ECX,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD32mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 5, 
                      79, 
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_RecordChild0,
                        OPC_RecordChild0,
                        OPC_CheckChild0Type, MVT::i16,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SRL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::SUB,
                        OPC_MoveChild, 0,
                        OPC_CheckInteger, 16, 
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitCopyToReg, 4, X86::CX,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD16mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 5, 
                      0, 
                    39|128,1, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::TRUNCATE,
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::SUB,
                      OPC_MoveChild, 0,
                      OPC_Scope, 76, 
                        OPC_CheckInteger, 32, 
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SRL,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_MoveChild, 0,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 5,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/5,
                        OPC_EmitMergeInputChains, 2, 0, 4, 
                        OPC_EmitCopyToReg, 3, X86::ECX,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD32mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 1, 
                      76, 
                        OPC_CheckInteger, 16, 
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SRL,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::TRUNCATE,
                        OPC_MoveChild, 0,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 5,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/5,
                        OPC_EmitMergeInputChains, 2, 0, 4, 
                        OPC_EmitCopyToReg, 3, X86::CX,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD16mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 1, 
                      0, 
                    16|128,1, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_Scope, 65, 
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckChild1Type, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SRL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SUB,
                        OPC_MoveChild, 0,
                        OPC_CheckInteger, 32, 
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitCopyToReg, 4, X86::CL,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD32mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 5, 
                      65, 
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckChild1Type, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SRL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SUB,
                        OPC_MoveChild, 0,
                        OPC_CheckInteger, 16, 
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitCopyToReg, 4, X86::CL,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD16mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 5, 
                      0, 
                    15|128,1, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::SUB,
                      OPC_MoveChild, 0,
                      OPC_Scope, 66, 
                        OPC_CheckInteger, 32, 
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SRL,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 5,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/5,
                        OPC_EmitMergeInputChains, 2, 0, 4, 
                        OPC_EmitCopyToReg, 3, X86::CL,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD32mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 1, 
                      66, 
                        OPC_CheckInteger, 16, 
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_RecordChild1,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SRL,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 5,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/5,
                        OPC_EmitMergeInputChains, 2, 0, 4, 
                        OPC_EmitCopyToReg, 3, X86::CL,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD16mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                            0, 6, 6, 7, 8, 9, 10, 1, 
                      0, 
                    72|128,1, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_Scope, 61, 
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SRL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 10,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD32mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 4, 10, 
                      61, 
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SRL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 10,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD16mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 4, 10, 
                      63, 
                        OPC_CheckPredicate, 8,
                        OPC_CheckPredicate, 9,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::SRL,
                        OPC_RecordChild0,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 10,
                        OPC_CheckType, MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD64mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 4, 10, 
                      0, 
                    46|128,1, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_CheckType, MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::SRL,
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_Scope, 48, 
                        OPC_CheckPredicate, 3,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 7,
                        OPC_CheckType, MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                        OPC_EmitMergeInputChains, 2, 0, 2, 
                        OPC_EmitConvertToTarget, 4,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD32mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 1, 10, 
                      48, 
                        OPC_CheckPredicate, 6,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 7,
                        OPC_CheckType, MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                        OPC_EmitMergeInputChains, 2, 0, 2, 
                        OPC_EmitConvertToTarget, 4,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD16mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 1, 10, 
                      50, 
                        OPC_CheckPredicate, 8,
                        OPC_CheckPredicate, 9,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 7,
                        OPC_CheckType, MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                        OPC_EmitMergeInputChains, 2, 0, 2, 
                        OPC_EmitConvertToTarget, 4,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD64mri8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 7, 5, 6, 7, 8, 9, 1, 10, 
                      0, 
                    0, 
                  53|128,3,  ISD::LOAD,
                    OPC_RecordMemRef,
                    OPC_RecordNode,
                    OPC_CheckFoldableChainNode,
                    OPC_RecordChild1,
                    OPC_CheckPredicate, 2,
                    OPC_Scope, 75|128,1, 
                      OPC_CheckPredicate, 8,
                      OPC_Scope, 113, 
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_CheckPredicate, 11,
                        OPC_MoveParent,
                        OPC_SwitchType , 32,  MVT::i16,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 2,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                          OPC_EmitMergeInputChains, 2, 0, 1, 
                          OPC_EmitConvertToTarget, 3,
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::OR16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                              1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                        32,  MVT::i32,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 2,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                          OPC_EmitMergeInputChains, 2, 0, 1, 
                          OPC_EmitConvertToTarget, 3,
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::OR32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                              1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                        32,  MVT::i64,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 2,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                          OPC_EmitMergeInputChains, 2, 0, 1, 
                          OPC_EmitConvertToTarget, 3,
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::OR64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                              1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                        0, 
                      84, 
                        OPC_CheckPredicate, 9,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::Constant,
                        OPC_Scope, 37, 
                          OPC_CheckPredicate, 12,
                          OPC_MoveParent,
                          OPC_CheckType, MVT::i64,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 2,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                          OPC_EmitMergeInputChains, 2, 0, 1, 
                          OPC_EmitConvertToTarget, 3,
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::OR64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                              1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                        35, 
                          OPC_MoveParent,
                          OPC_CheckType, MVT::i8,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 2,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                          OPC_EmitMergeInputChains, 2, 0, 1, 
                          OPC_EmitConvertToTarget, 3,
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::OR8mi), 0|OPFL_Chain|OPFL_MemRefs,
                              1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                        0, 
                      0, 
                    43, 
                      OPC_CheckPredicate, 6,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i16,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::OR16mi), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    43, 
                      OPC_CheckPredicate, 3,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i32,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::OR32mi), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    6|128,1, 
                      OPC_CheckPredicate, 8,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_SwitchType , 30,  MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::OR8mr), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                      30,  MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::OR16mr), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                      30,  MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::OR32mr), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                      30,  MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::OR64mr), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                      0, 
                    0, 
                  0, 
                16|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_MoveParent,
                  OPC_SwitchType , 30,  MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  0, 
                0, 
              61|128,5,  ISD::SHL,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_Scope, 46, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 31, 
                  OPC_RecordChild0,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL8mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                44, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 31, 
                  OPC_RecordChild0,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL16mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                44, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 31, 
                  OPC_RecordChild0,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL32mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                83, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckType, MVT::i8,
                  OPC_Scope, 37, 
                    OPC_CheckAndImm, 63, 
                    OPC_RecordChild0,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitCopyToReg, 3, X86::CL,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL64mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                        0, 5, 4, 5, 6, 7, 8, 
                  33, 
                    OPC_CheckInteger, 1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL8m1), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 3, 4, 5, 6, 7, 
                  0, 
                40, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL16m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                40, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL32m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                87, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_Scope, 37, 
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 1, 
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL64m1), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 3, 4, 5, 6, 7, 
                  41, 
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL8mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 9, 
                  0, 
                44, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL16mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 4, 5, 6, 7, 8, 9, 
                44, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL32mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 4, 5, 6, 7, 8, 9, 
                85, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_Scope, 40, 
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL64mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 9, 
                  35, 
                    OPC_CheckChild1Type, MVT::i8,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitCopyToReg, 3, X86::CL,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL8mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                        0, 5, 4, 5, 6, 7, 8, 
                  0, 
                39, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL16mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                39, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL32mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                41, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHL64mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                0, 
              61|128,5,  ISD::SRL,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_Scope, 46, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 31, 
                  OPC_RecordChild0,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR8mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                44, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 31, 
                  OPC_RecordChild0,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR16mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                44, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 31, 
                  OPC_RecordChild0,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR32mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                83, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckType, MVT::i8,
                  OPC_Scope, 37, 
                    OPC_CheckAndImm, 63, 
                    OPC_RecordChild0,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitCopyToReg, 3, X86::CL,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR64mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                        0, 5, 4, 5, 6, 7, 8, 
                  33, 
                    OPC_CheckInteger, 1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR8m1), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 3, 4, 5, 6, 7, 
                  0, 
                40, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR16m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                40, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR32m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                87, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_Scope, 37, 
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 1, 
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR64m1), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 3, 4, 5, 6, 7, 
                  41, 
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR8mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 9, 
                  0, 
                44, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR16mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 4, 5, 6, 7, 8, 9, 
                44, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR32mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 4, 5, 6, 7, 8, 9, 
                85, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_Scope, 40, 
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR64mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 9, 
                  35, 
                    OPC_CheckChild1Type, MVT::i8,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitCopyToReg, 3, X86::CL,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR8mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                        0, 5, 4, 5, 6, 7, 8, 
                  0, 
                39, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR16mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                39, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR32mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                41, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHR64mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                0, 
              61|128,5,  ISD::SRA,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_Scope, 46, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 31, 
                  OPC_RecordChild0,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR8mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                44, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 31, 
                  OPC_RecordChild0,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR16mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                44, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckAndImm, 31, 
                  OPC_RecordChild0,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR32mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                83, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckType, MVT::i8,
                  OPC_Scope, 37, 
                    OPC_CheckAndImm, 63, 
                    OPC_RecordChild0,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitCopyToReg, 3, X86::CL,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR64mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                        0, 5, 4, 5, 6, 7, 8, 
                  33, 
                    OPC_CheckInteger, 1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR8m1), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 3, 4, 5, 6, 7, 
                  0, 
                40, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR16m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                40, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR32m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                87, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_Scope, 37, 
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 1, 
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR64m1), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 3, 4, 5, 6, 7, 
                  41, 
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR8mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 9, 
                  0, 
                44, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR16mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 4, 5, 6, 7, 8, 9, 
                44, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR32mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 4, 5, 6, 7, 8, 9, 
                85, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_Scope, 40, 
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR64mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 9, 
                  35, 
                    OPC_CheckChild1Type, MVT::i8,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitCopyToReg, 3, X86::CL,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR8mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                        0, 5, 4, 5, 6, 7, 8, 
                  0, 
                39, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR16mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                39, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR32mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                41, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SAR64mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                0, 
              95|128,4,  ISD::SUB,
                OPC_MoveChild, 0,
                OPC_Scope, 31|128,1, 
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 36, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::NEG8m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  34, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::NEG16m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  34, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::NEG32m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  36, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::NEG64m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  0, 
                56|128,3, 
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 76|128,1, 
                    OPC_CheckPredicate, 8,
                    OPC_Scope, 26|128,1, 
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_Scope, 107, 
                        OPC_CheckPredicate, 11,
                        OPC_MoveParent,
                        OPC_SwitchType , 32,  MVT::i16,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 2,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                          OPC_EmitMergeInputChains, 2, 0, 1, 
                          OPC_EmitConvertToTarget, 3,
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                              1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                        32,  MVT::i32,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 2,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                          OPC_EmitMergeInputChains, 2, 0, 1, 
                          OPC_EmitConvertToTarget, 3,
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                              1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                        32,  MVT::i64,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 2,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                          OPC_EmitMergeInputChains, 2, 0, 1, 
                          OPC_EmitConvertToTarget, 3,
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                              1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                        0, 
                      37, 
                        OPC_CheckPredicate, 12,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      0, 
                    43, 
                      OPC_CheckPredicate, 9,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB8mi), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    0, 
                  43, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB16mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  43, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  6|128,1, 
                    OPC_CheckPredicate, 8,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_SwitchType , 30,  MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB8mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i16,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB16mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i32,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB32mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB64mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    0, 
                  0, 
                0, 
              17|128,6,  ISD::XOR,
                OPC_Scope, 123|128,4, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 49, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::NOT8m), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 3, 4, 5, 6, 7, 
                  47, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::NOT16m), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 3, 4, 5, 6, 7, 
                  47, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::NOT32m), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 3, 4, 5, 6, 7, 
                  123|128,1, 
                    OPC_CheckPredicate, 8,
                    OPC_Scope, 47, 
                      OPC_CheckPredicate, 9,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::NOT64m), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 5, 3, 4, 5, 6, 7, 
                    113, 
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_CheckPredicate, 11,
                      OPC_MoveParent,
                      OPC_SwitchType , 32,  MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      32,  MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      32,  MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      0, 
                    84, 
                      OPC_CheckPredicate, 9,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_Scope, 37, 
                        OPC_CheckPredicate, 12,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      35, 
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR8mi), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      0, 
                    0, 
                  43, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR16mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  43, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  6|128,1, 
                    OPC_CheckPredicate, 8,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_SwitchType , 30,  MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR8mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i16,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR16mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i32,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR32mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR64mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    0, 
                  0, 
                16|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_MoveParent,
                  OPC_SwitchType , 30,  MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  0, 
                0, 
              80|128,10,  ISD::ADD,
                OPC_Scope, 58|128,9, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 41, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::INC8m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  41, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::INC16m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  41, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::INC32m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  50, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC8m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  50, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC16m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  50, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC32m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  88, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_Scope, 34, 
                      OPC_CheckInteger, 1, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::INC64m), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                    43, 
                      OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC64m), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                    0, 
                  41, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 3,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::INC64_16m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  41, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 3,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::INC64_32m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  50, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 3,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC64_16m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  50, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 3,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC64_32m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  52, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0|128,1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitInteger, MVT::i16, 0|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 8, 
                  52, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0|128,1, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitInteger, MVT::i32, 0|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 8, 
                  56|128,2, 
                    OPC_CheckPredicate, 8,
                    OPC_Scope, 107, 
                      OPC_CheckPredicate, 9,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_Scope, 47, 
                        OPC_CheckInteger, 0|128,1, 
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitInteger, MVT::i64, 0|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,127|128,1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 6, 3, 4, 5, 6, 7, 8, 
                      51, 
                        OPC_CheckInteger, 0|128,0|128,0|128,0|128,0|128,1, 
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitInteger, MVT::i64, 0|128,0|128,0|128,0|128,120|128,127|128,127|128,127|128,127|128,1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                            0, 6, 3, 4, 5, 6, 7, 8, 
                      0, 
                    26|128,1, 
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_Scope, 107, 
                        OPC_CheckPredicate, 11,
                        OPC_MoveParent,
                        OPC_SwitchType , 32,  MVT::i16,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 2,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                          OPC_EmitMergeInputChains, 2, 0, 1, 
                          OPC_EmitConvertToTarget, 3,
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                              1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                        32,  MVT::i32,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 2,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                          OPC_EmitMergeInputChains, 2, 0, 1, 
                          OPC_EmitConvertToTarget, 3,
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                              1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                        32,  MVT::i64,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 2,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                          OPC_EmitMergeInputChains, 2, 0, 1, 
                          OPC_EmitConvertToTarget, 3,
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                              1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                        0, 
                      37, 
                        OPC_CheckPredicate, 12,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      0, 
                    43, 
                      OPC_CheckPredicate, 9,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD8mi), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    0, 
                  43, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD16mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  43, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  6|128,1, 
                    OPC_CheckPredicate, 8,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_SwitchType , 30,  MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD8mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i16,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD16mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i32,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD32mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD64mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    0, 
                  0, 
                16|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_MoveParent,
                  OPC_SwitchType , 30,  MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  0, 
                0, 
              11|128,4,  ISD::ROTL,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_Scope, 42, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL8m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                40, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL16m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                40, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL32m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                87, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_Scope, 37, 
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 1, 
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL64m1), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 3, 4, 5, 6, 7, 
                  41, 
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL8mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 9, 
                  0, 
                44, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL16mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 4, 5, 6, 7, 8, 9, 
                44, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL32mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 4, 5, 6, 7, 8, 9, 
                85, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_Scope, 40, 
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL64mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 9, 
                  35, 
                    OPC_CheckChild1Type, MVT::i8,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitCopyToReg, 3, X86::CL,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL8mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                        0, 5, 4, 5, 6, 7, 8, 
                  0, 
                39, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL16mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                39, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL32mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                41, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROL64mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                0, 
              11|128,4,  ISD::ROTR,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_Scope, 42, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR8m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                40, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR16m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                40, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 1, 
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR32m1), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                87, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_Scope, 37, 
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 1, 
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR64m1), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 5, 3, 4, 5, 6, 7, 
                  41, 
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR8mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 9, 
                  0, 
                44, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR16mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 4, 5, 6, 7, 8, 9, 
                44, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR32mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 4, 5, 6, 7, 8, 9, 
                85, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_Scope, 40, 
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR64mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 9, 
                  35, 
                    OPC_CheckChild1Type, MVT::i8,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitCopyToReg, 3, X86::CL,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR8mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                        0, 5, 4, 5, 6, 7, 8, 
                  0, 
                39, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR16mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                39, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR32mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                41, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckChild1Type, MVT::i8,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 3, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ROR64mCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 4, 5, 6, 7, 8, 
                0, 
              79|128,4,  ISD::AND,
                OPC_Scope, 57|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 75|128,1, 
                    OPC_CheckPredicate, 8,
                    OPC_Scope, 113, 
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_CheckPredicate, 11,
                      OPC_MoveParent,
                      OPC_SwitchType , 32,  MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      32,  MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      32,  MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      0, 
                    84, 
                      OPC_CheckPredicate, 9,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_Scope, 37, 
                        OPC_CheckPredicate, 12,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      35, 
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i8,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 2,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 2, 0, 1, 
                        OPC_EmitConvertToTarget, 3,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::AND8mi), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                      0, 
                    0, 
                  43, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  43, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  6|128,1, 
                    OPC_CheckPredicate, 8,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_SwitchType , 30,  MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::AND8mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i16,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i32,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    30,  MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64mr), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                    0, 
                  0, 
                16|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_MoveParent,
                  OPC_SwitchType , 30,  MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  30,  MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  0, 
                0, 
              112|128,4,  ISD::ADDE,
                OPC_RecordNode,
                OPC_CaptureFlagInput,
                OPC_Scope, 80|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 86|128,1, 
                    OPC_CheckPredicate, 8,
                    OPC_Scope, 34|128,1, 
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_Scope, 113, 
                        OPC_CheckPredicate, 11,
                        OPC_MoveParent,
                        OPC_SwitchType , 34,  MVT::i16,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 3,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                          OPC_EmitMergeInputChains, 2, 0, 2, 
                          OPC_EmitConvertToTarget, 4,
                          OPC_MarkFlagResults, 1, 1, 
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC16mi8), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                              0, 6, 5, 6, 7, 8, 9, 10, 
                        34,  MVT::i32,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 3,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                          OPC_EmitMergeInputChains, 2, 0, 2, 
                          OPC_EmitConvertToTarget, 4,
                          OPC_MarkFlagResults, 1, 1, 
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC32mi8), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                              0, 6, 5, 6, 7, 8, 9, 10, 
                        34,  MVT::i64,
                          OPC_MoveParent,
                          OPC_MoveChild, 2,
                          OPC_CheckSame, 3,
                          OPC_MoveParent,
                          OPC_CheckPredicate, 4,
                          OPC_CheckPredicate, 5,
                          OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                          OPC_EmitMergeInputChains, 2, 0, 2, 
                          OPC_EmitConvertToTarget, 4,
                          OPC_MarkFlagResults, 1, 1, 
                          OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC64mi8), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                              0, 6, 5, 6, 7, 8, 9, 10, 
                        0, 
                      39, 
                        OPC_CheckPredicate, 12,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                        OPC_EmitMergeInputChains, 2, 0, 2, 
                        OPC_EmitConvertToTarget, 4,
                        OPC_MarkFlagResults, 1, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC64mi32), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                            0, 6, 5, 6, 7, 8, 9, 10, 
                      0, 
                    45, 
                      OPC_CheckPredicate, 9,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 3,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                      OPC_EmitMergeInputChains, 2, 0, 2, 
                      OPC_EmitConvertToTarget, 4,
                      OPC_MarkFlagResults, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC8mi), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                          0, 6, 5, 6, 7, 8, 9, 10, 
                    0, 
                  45, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_EmitConvertToTarget, 4,
                    OPC_MarkFlagResults, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC16mi), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                        0, 6, 5, 6, 7, 8, 9, 10, 
                  45, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_EmitConvertToTarget, 4,
                    OPC_MarkFlagResults, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC32mi), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                        0, 6, 5, 6, 7, 8, 9, 10, 
                  14|128,1, 
                    OPC_CheckPredicate, 8,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_SwitchType , 32,  MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 3,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                      OPC_EmitMergeInputChains, 2, 0, 2, 
                      OPC_MarkFlagResults, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC8mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                          0, 6, 5, 6, 7, 8, 9, 4, 
                    32,  MVT::i16,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 3,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                      OPC_EmitMergeInputChains, 2, 0, 2, 
                      OPC_MarkFlagResults, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC16mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                          0, 6, 5, 6, 7, 8, 9, 4, 
                    32,  MVT::i32,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 3,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                      OPC_EmitMergeInputChains, 2, 0, 2, 
                      OPC_MarkFlagResults, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC32mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                          0, 6, 5, 6, 7, 8, 9, 4, 
                    32,  MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 3,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                      OPC_EmitMergeInputChains, 2, 0, 2, 
                      OPC_MarkFlagResults, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC64mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                          0, 6, 5, 6, 7, 8, 9, 4, 
                    0, 
                  0, 
                24|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_MoveParent,
                  OPC_SwitchType , 32,  MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 4,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/4,
                    OPC_EmitMergeInputChains, 2, 0, 3, 
                    OPC_MarkFlagResults, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC8mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                        0, 6, 5, 6, 7, 8, 9, 2, 
                  32,  MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 4,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/4,
                    OPC_EmitMergeInputChains, 2, 0, 3, 
                    OPC_MarkFlagResults, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC16mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                        0, 6, 5, 6, 7, 8, 9, 2, 
                  32,  MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 4,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/4,
                    OPC_EmitMergeInputChains, 2, 0, 3, 
                    OPC_MarkFlagResults, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC32mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                        0, 6, 5, 6, 7, 8, 9, 2, 
                  32,  MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 4,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/4,
                    OPC_EmitMergeInputChains, 2, 0, 3, 
                    OPC_MarkFlagResults, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADC64mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                        0, 6, 5, 6, 7, 8, 9, 2, 
                  0, 
                0, 
              82|128,3,  ISD::SUBE,
                OPC_RecordNode,
                OPC_CaptureFlagInput,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_Scope, 86|128,1, 
                  OPC_CheckPredicate, 8,
                  OPC_Scope, 34|128,1, 
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_Scope, 113, 
                      OPC_CheckPredicate, 11,
                      OPC_MoveParent,
                      OPC_SwitchType , 34,  MVT::i16,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                        OPC_EmitMergeInputChains, 2, 0, 2, 
                        OPC_EmitConvertToTarget, 4,
                        OPC_MarkFlagResults, 1, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SBB16mi8), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                            0, 6, 5, 6, 7, 8, 9, 10, 
                      34,  MVT::i32,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                        OPC_EmitMergeInputChains, 2, 0, 2, 
                        OPC_EmitConvertToTarget, 4,
                        OPC_MarkFlagResults, 1, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SBB32mi8), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                            0, 6, 5, 6, 7, 8, 9, 10, 
                      34,  MVT::i64,
                        OPC_MoveParent,
                        OPC_MoveChild, 2,
                        OPC_CheckSame, 3,
                        OPC_MoveParent,
                        OPC_CheckPredicate, 4,
                        OPC_CheckPredicate, 5,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                        OPC_EmitMergeInputChains, 2, 0, 2, 
                        OPC_EmitConvertToTarget, 4,
                        OPC_MarkFlagResults, 1, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::SBB64mi8), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                            0, 6, 5, 6, 7, 8, 9, 10, 
                      0, 
                    39, 
                      OPC_CheckPredicate, 12,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 3,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                      OPC_EmitMergeInputChains, 2, 0, 2, 
                      OPC_EmitConvertToTarget, 4,
                      OPC_MarkFlagResults, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::SBB64mi32), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                          0, 6, 5, 6, 7, 8, 9, 10, 
                    0, 
                  45, 
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_EmitConvertToTarget, 4,
                    OPC_MarkFlagResults, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SBB8mi), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                        0, 6, 5, 6, 7, 8, 9, 10, 
                  0, 
                45, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 3,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                  OPC_EmitMergeInputChains, 2, 0, 2, 
                  OPC_EmitConvertToTarget, 4,
                  OPC_MarkFlagResults, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SBB16mi), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                      0, 6, 5, 6, 7, 8, 9, 10, 
                45, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 3,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                  OPC_EmitMergeInputChains, 2, 0, 2, 
                  OPC_EmitConvertToTarget, 4,
                  OPC_MarkFlagResults, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SBB32mi), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                      0, 6, 5, 6, 7, 8, 9, 10, 
                14|128,1, 
                  OPC_CheckPredicate, 8,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_SwitchType , 32,  MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MarkFlagResults, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SBB8mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                        0, 6, 5, 6, 7, 8, 9, 4, 
                  32,  MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MarkFlagResults, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SBB16mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                        0, 6, 5, 6, 7, 8, 9, 4, 
                  32,  MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MarkFlagResults, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SBB32mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                        0, 6, 5, 6, 7, 8, 9, 4, 
                  32,  MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MarkFlagResults, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SBB64mr), 0|OPFL_Chain|OPFL_FlagInput|OPFL_FlagOutput|OPFL_MemRefs,
                        0, 6, 5, 6, 7, 8, 9, 4, 
                  0, 
                0, 
              124|128,4,  X86ISD::ADD,
                OPC_Scope, 85|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 45, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckPredicate, 11,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  45, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckPredicate, 11,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  124, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_Scope, 37, 
                      OPC_CheckPredicate, 11,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    37, 
                      OPC_CheckPredicate, 12,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    35, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD8mi), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    0, 
                  43, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD16mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  43, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  38, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  36, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  36, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  38, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  0, 
                33|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 37, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  35, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  35, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  37, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  0, 
                0, 
              85|128,3,  X86ISD::SUB,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_Scope, 45, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckPredicate, 11,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                45, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckPredicate, 11,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                124, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_Scope, 37, 
                    OPC_CheckPredicate, 11,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  37, 
                    OPC_CheckPredicate, 12,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  35, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB8mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  0, 
                43, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB16mi), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                43, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 3,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB32mi), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                38, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB8mr), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                36, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB16mr), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                36, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB32mr), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                38, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SUB64mr), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                0, 
              124|128,4,  X86ISD::OR,
                OPC_Scope, 85|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 45, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckPredicate, 11,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  45, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckPredicate, 11,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  124, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_Scope, 37, 
                      OPC_CheckPredicate, 11,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::OR64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    37, 
                      OPC_CheckPredicate, 12,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::OR64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    35, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::OR8mi), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    0, 
                  43, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR16mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  43, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  38, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  36, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  36, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  38, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  0, 
                33|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 37, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  35, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  35, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  37, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::OR64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  0, 
                0, 
              124|128,4,  X86ISD::XOR,
                OPC_Scope, 85|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 45, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckPredicate, 11,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  45, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckPredicate, 11,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  124, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_Scope, 37, 
                      OPC_CheckPredicate, 11,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    37, 
                      OPC_CheckPredicate, 12,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    35, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR8mi), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    0, 
                  43, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR16mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  43, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  38, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  36, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  36, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  38, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  0, 
                33|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 37, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  35, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  35, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  37, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::XOR64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  0, 
                0, 
              124|128,4,  X86ISD::AND,
                OPC_Scope, 85|128,3, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 45, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckPredicate, 11,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  45, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_CheckPredicate, 11,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  124, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_Scope, 37, 
                      OPC_CheckPredicate, 11,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    37, 
                      OPC_CheckPredicate, 12,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    35, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 2,
                      OPC_CheckSame, 2,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 2, 0, 1, 
                      OPC_EmitConvertToTarget, 3,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::AND8mi), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                    0, 
                  43, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  43, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_EmitConvertToTarget, 3,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 9, 
                  38, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  36, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  36, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  38, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 3, 
                  0, 
                33|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 37, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND8mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  35, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  35, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  37, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 3,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                    OPC_EmitMergeInputChains, 2, 0, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64mr), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 4, 5, 6, 7, 8, 1, 
                  0, 
                0, 
              37|128,1,  ISD::VECTOR_SHUFFLE,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 50,  ISD::BIT_CONVERT,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 13,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 4, 5, 6, 7, 8, 3, 
                107,  ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 13,
                  OPC_SwitchType , 29,  MVT::v4f32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 3, 
                  29,  MVT::v2f64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPDmr), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 3, 
                  29,  MVT::v2i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPDmr), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 4, 5, 6, 7, 8, 3, 
                  0, 
                0, 
              27|128,2,  X86ISD::SHLD,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_Scope, 46, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 4,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD32mri8), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 7, 5, 6, 7, 8, 9, 3, 10, 
                46, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 4,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD16mri8), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 7, 5, 6, 7, 8, 9, 3, 10, 
                48, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 4,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD64mri8), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 7, 5, 6, 7, 8, 9, 3, 10, 
                41, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::i8,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 4, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD32mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 6, 5, 6, 7, 8, 9, 3, 
                41, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::i8,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 4, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD16mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 6, 5, 6, 7, 8, 9, 3, 
                43, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::i8,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 4, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHLD64mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 6, 5, 6, 7, 8, 9, 3, 
                0, 
              27|128,2,  X86ISD::SHRD,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_Scope, 46, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 4,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD32mri8), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 7, 5, 6, 7, 8, 9, 3, 10, 
                46, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 4,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD16mri8), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 7, 5, 6, 7, 8, 9, 3, 10, 
                48, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_MoveChild, 2,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitConvertToTarget, 4,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD64mri8), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 7, 5, 6, 7, 8, 9, 3, 10, 
                41, 
                  OPC_CheckPredicate, 3,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::i8,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 4, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD32mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 6, 5, 6, 7, 8, 9, 3, 
                41, 
                  OPC_CheckPredicate, 6,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::i8,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 4, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD16mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 6, 5, 6, 7, 8, 9, 3, 
                43, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_RecordChild2,
                  OPC_CheckChild2Type, MVT::i8,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_EmitCopyToReg, 4, X86::CL,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHRD64mrCL), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 6, 5, 6, 7, 8, 9, 3, 
                0, 
              116|128,1,  X86ISD::INC,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_SwitchType , 36,  MVT::i8,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::INC8m), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                76,  MVT::i16,
                  OPC_Scope, 36, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::INC16m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  36, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 3,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::INC64_16m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  0, 
                76,  MVT::i32,
                  OPC_Scope, 36, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::INC32m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  36, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 3,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::INC64_32m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  0, 
                36,  MVT::i64,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::INC64m), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                0, 
              116|128,1,  X86ISD::DEC,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_SwitchType , 36,  MVT::i8,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC8m), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                76,  MVT::i16,
                  OPC_Scope, 36, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC16m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  36, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 3,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC64_16m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  0, 
                76,  MVT::i32,
                  OPC_Scope, 36, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 2,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC32m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  36, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 2,
                    OPC_CheckSame, 2,
                    OPC_MoveParent,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 3,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 2, 0, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC64_32m), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                  0, 
                36,  MVT::i64,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 2,
                  OPC_CheckSame, 2,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::DEC64m), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 3, 4, 5, 6, 7, 
                0, 
              83|128,3,  ISD::EXTRACT_VECTOR_ELT,
                OPC_Scope, 60|128,1, 
                  OPC_MoveChild, 0,
                  OPC_SwitchOpcode , 99,  ISD::VECTOR_SHUFFLE,
                    OPC_Scope, 51, 
                      OPC_MoveChild, 0,
                      OPC_CheckOpcode, ISD::BIT_CONVERT,
                      OPC_RecordChild0,
                      OPC_CheckChild0Type, MVT::v4f32,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::UNDEF,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 14,
                      OPC_CheckType, MVT::v2f64,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckInteger, 0, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::f64,
                      OPC_MoveParent,
                      OPC_RecordChild2,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckPatternPredicate, 0,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVHPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 6, 3, 4, 5, 6, 7, 1, 
                    44, 
                      OPC_RecordChild0,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::UNDEF,
                      OPC_MoveParent,
                      OPC_CheckPredicate, 14,
                      OPC_CheckType, MVT::v2f64,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckInteger, 0, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::f64,
                      OPC_MoveParent,
                      OPC_RecordChild2,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckPatternPredicate, 1,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVHPDmr), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 6, 3, 4, 5, 6, 7, 1, 
                    0, 
                  81,  ISD::BIT_CONVERT,
                    OPC_RecordChild0,
                    OPC_CheckChild0Type, MVT::v4f32,
                    OPC_SwitchType , 34,  MVT::v2f64,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckInteger, 0, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::f64,
                      OPC_MoveParent,
                      OPC_RecordChild2,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckPatternPredicate, 0,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 6, 3, 4, 5, 6, 7, 1, 
                    38,  MVT::v4i32,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i32,
                      OPC_MoveParent,
                      OPC_RecordChild2,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckPatternPredicate, 4,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitConvertToTarget, 2,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::EXTRACTPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 7, 4, 5, 6, 7, 8, 1, 9, 
                    0, 
                  0, 
                17|128,2, 
                  OPC_RecordChild0,
                  OPC_Scope, 69, 
                    OPC_CheckChild0Type, MVT::v2f64,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::f64,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_Scope, 20, 
                      OPC_CheckPatternPredicate, 1,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPDmr), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 6, 3, 4, 5, 6, 7, 1, 
                    30, 
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitInteger, MVT::i32, 2, 
                      OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                          1, MVT::f64, 2, 1, 8, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSDmr), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 6, 3, 4, 5, 6, 7, 9, 
                    0, 
                  76, 
                    OPC_CheckChild0Type, MVT::v2i64,
                    OPC_Scope, 33, 
                      OPC_MoveChild, 1,
                      OPC_CheckInteger, 0, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_RecordChild2,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckPatternPredicate, 1,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVPQI2QImr), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 6, 3, 4, 5, 6, 7, 1, 
                    37, 
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_RecordChild2,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckPatternPredicate, 4,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitConvertToTarget, 2,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::PEXTRQmr), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 7, 4, 5, 6, 7, 8, 1, 9, 
                    0, 
                  76, 
                    OPC_CheckChild0Type, MVT::v4i32,
                    OPC_Scope, 33, 
                      OPC_MoveChild, 1,
                      OPC_CheckInteger, 0, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i32,
                      OPC_MoveParent,
                      OPC_RecordChild2,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckPatternPredicate, 1,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVPDI2DImr), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 6, 3, 4, 5, 6, 7, 1, 
                    37, 
                      OPC_RecordChild1,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::Constant,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i32,
                      OPC_MoveParent,
                      OPC_RecordChild2,
                      OPC_CheckPredicate, 4,
                      OPC_CheckPredicate, 5,
                      OPC_CheckPatternPredicate, 4,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitConvertToTarget, 2,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::PEXTRDmr), 0|OPFL_Chain|OPFL_MemRefs,
                          0, 7, 4, 5, 6, 7, 8, 1, 9, 
                    0, 
                  45, 
                    OPC_CheckChild0Type, MVT::v4f32,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::f32,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 1, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::f32, 2, 1, 8, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSSmr), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 9, 
                  0, 
                0, 
              57|128,1,  ISD::TRUNCATE,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SRL,
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 8, 
                OPC_CheckType, MVT::i8,
                OPC_MoveParent,
                OPC_CheckPredicate, 15,
                OPC_SwitchType , 53,  MVT::i64,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 16,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, X86::GR64_ABCDRegClassID,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                      1, MVT::i64, 2, 1, 8, 
                  OPC_EmitInteger, MVT::i32, 2, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i8, 2, 9, 10, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV8mr_NOREX), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 11, 
                55,  MVT::i32,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 16,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckPatternPredicate, 3,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, X86::GR32_ABCDRegClassID,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                      1, MVT::i32, 2, 1, 8, 
                  OPC_EmitInteger, MVT::i32, 2, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i8, 2, 9, 10, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV8mr_NOREX), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 11, 
                55,  MVT::i16,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 16,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckPatternPredicate, 3,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, X86::GR16_ABCDRegClassID,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                      1, MVT::i16, 2, 1, 8, 
                  OPC_EmitInteger, MVT::i32, 2, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i8, 2, 9, 10, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV8mr_NOREX), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 11, 
                0, 
              54,  ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::EXTRACT_VECTOR_ELT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v4f32,
                OPC_CheckType, MVT::v4i32,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_CheckType, MVT::f32,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::EXTRACTPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 7, 4, 5, 6, 7, 8, 1, 9, 
              116|128,3,  X86ISD::SETCC,
                OPC_MoveChild, 0,
                OPC_Scope, 30, 
                  OPC_CheckInteger, 4, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETEm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 9, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETNEm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 7, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETLm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 6, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETGEm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 8, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETLEm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 5, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETGm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 2, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETBm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 1, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETAEm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 3, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETBEm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETAm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 15, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETSm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 12, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETNSm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 14, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETPm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 11, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETNPm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 13, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETOm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                30, 
                  OPC_CheckInteger, 10, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitCopyToReg, 1, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SETNOm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                      0, 5, 3, 4, 5, 6, 7, 
                0, 
              116|128,1,  X86ISD::Wrapper,
                OPC_RecordChild0,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 57,  ISD::TargetGlobalAddress,
                  OPC_MoveParent,
                  OPC_SwitchType , 24,  MVT::i32,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 1, 
                  26,  MVT::i64,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 1, 
                  0, 
                57,  ISD::TargetExternalSymbol,
                  OPC_MoveParent,
                  OPC_SwitchType , 24,  MVT::i32,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 1, 
                  26,  MVT::i64,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 1, 
                  0, 
                57,  ISD::TargetBlockAddress,
                  OPC_MoveParent,
                  OPC_SwitchType , 24,  MVT::i32,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 1, 
                  26,  MVT::i64,
                    OPC_MoveParent,
                    OPC_RecordChild2,
                    OPC_CheckPredicate, 4,
                    OPC_CheckPredicate, 5,
                    OPC_CheckPatternPredicate, 5,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 1, 
                  0, 
                29,  ISD::TargetConstantPool,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                29,  ISD::TargetJumpTable,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_RecordChild2,
                  OPC_CheckPredicate, 4,
                  OPC_CheckPredicate, 5,
                  OPC_CheckPatternPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              0, 
            21|128,1, 
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_SwitchType , 28,  MVT::i64,
                OPC_CheckPredicate, 12,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 3, 4, 5, 6, 7, 8, 
              26,  MVT::i8,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV8mi), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 3, 4, 5, 6, 7, 8, 
              26,  MVT::i16,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV16mi), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 3, 4, 5, 6, 7, 8, 
              54,  MVT::i32,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_Scope, 22, 
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV32mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 8, 
                24, 
                  OPC_CheckPredicate, 17,
                  OPC_CheckPredicate, 18,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV16mi), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 8, 
                0, 
              0, 
            35, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::f64,
              OPC_CheckType, MVT::i64,
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckPredicate, 4,
              OPC_CheckPredicate, 5,
              OPC_CheckPatternPredicate, 1,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSDto64mr), 0|OPFL_Chain|OPFL_MemRefs,
                  0, 6, 3, 4, 5, 6, 7, 1, 
            35, 
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_CheckType, MVT::i64,
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckPredicate, 4,
              OPC_CheckPredicate, 17,
              OPC_CheckPredicate, 18,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV16mi), 0|OPFL_Chain|OPFL_MemRefs,
                  0, 6, 3, 4, 5, 6, 7, 8, 
            35, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::f32,
              OPC_CheckType, MVT::i32,
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_CheckPredicate, 4,
              OPC_CheckPredicate, 5,
              OPC_CheckPatternPredicate, 1,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSS2DImr), 0|OPFL_Chain|OPFL_MemRefs,
                  0, 6, 3, 4, 5, 6, 7, 1, 
            85|128,6, 
              OPC_RecordChild1,
              OPC_Scope, 51, 
                OPC_CheckChild1Type, MVT::f32,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_Scope, 20, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ST_Fp32m), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                20, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              79, 
                OPC_CheckChild1Type, MVT::f64,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_Scope, 24, 
                  OPC_CheckPredicate, 17,
                  OPC_CheckPredicate, 19,
                  OPC_CheckPatternPredicate, 7,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ST_Fp64m32), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                46, 
                  OPC_CheckPredicate, 5,
                  OPC_Scope, 20, 
                    OPC_CheckPatternPredicate, 7,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ST_Fp64m), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 1, 
                  20, 
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSDmr), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 1, 
                  0, 
                0, 
              75, 
                OPC_CheckChild1Type, MVT::f80,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_Scope, 46, 
                  OPC_CheckPredicate, 17,
                  OPC_Scope, 20, 
                    OPC_CheckPredicate, 19,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ST_Fp80m32), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 1, 
                  20, 
                    OPC_CheckPredicate, 20,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ST_Fp80m64), 0|OPFL_Chain|OPFL_MemRefs,
                        0, 6, 3, 4, 5, 6, 7, 1, 
                  0, 
                20, 
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ST_FpP80m), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              25, 
                OPC_CheckChild1Type, MVT::i8,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV8mr), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 3, 4, 5, 6, 7, 1, 
              25, 
                OPC_CheckChild1Type, MVT::i16,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV16mr), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 3, 4, 5, 6, 7, 1, 
              63, 
                OPC_CheckChild1Type, MVT::i32,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_Scope, 20, 
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV32mr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                34, 
                  OPC_CheckPredicate, 17,
                  OPC_CheckPredicate, 18,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 3, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i16, 2, 1, 8, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV16mr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 9, 
                0, 
              63, 
                OPC_CheckChild1Type, MVT::i64,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_Scope, 20, 
                  OPC_CheckPredicate, 5,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV64mr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                34, 
                  OPC_CheckPredicate, 17,
                  OPC_CheckPredicate, 18,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 3, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i16, 2, 1, 8, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV16mr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 9, 
                0, 
              53, 
                OPC_CheckChild1Type, MVT::v4f32,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_Scope, 22, 
                  OPC_CheckPredicate, 21,
                  OPC_CheckPatternPredicate, 0,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVAPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                20, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVUPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              53, 
                OPC_CheckChild1Type, MVT::v2f64,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_Scope, 22, 
                  OPC_CheckPredicate, 21,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVAPDmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                20, 
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVUPDmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              49, 
                OPC_CheckChild1Type, MVT::v2i64,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_Scope, 20, 
                  OPC_CheckPredicate, 21,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVAPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                18, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVUPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              49, 
                OPC_CheckChild1Type, MVT::v4i32,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_Scope, 20, 
                  OPC_CheckPredicate, 21,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVAPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                18, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVUPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              49, 
                OPC_CheckChild1Type, MVT::v8i16,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_Scope, 20, 
                  OPC_CheckPredicate, 21,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVAPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                18, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVUPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              49, 
                OPC_CheckChild1Type, MVT::v16i8,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_Scope, 20, 
                  OPC_CheckPredicate, 21,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVAPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                18, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVUPSmr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              49, 
                OPC_CheckChild1Type, MVT::v1i64,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_Scope, 20, 
                  OPC_CheckPatternPredicate, 8,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ64mr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                18, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ64mr), 0|OPFL_Chain|OPFL_MemRefs,
                      0, 6, 3, 4, 5, 6, 7, 1, 
                0, 
              25, 
                OPC_CheckChild1Type, MVT::v8i8,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ64mr), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 3, 4, 5, 6, 7, 1, 
              25, 
                OPC_CheckChild1Type, MVT::v4i16,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ64mr), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 3, 4, 5, 6, 7, 1, 
              25, 
                OPC_CheckChild1Type, MVT::v2i32,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ64mr), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 3, 4, 5, 6, 7, 1, 
              25, 
                OPC_CheckChild1Type, MVT::v2f32,
                OPC_RecordChild2,
                OPC_CheckPredicate, 4,
                OPC_CheckPredicate, 5,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ64mr), 0|OPFL_Chain|OPFL_MemRefs,
                    0, 6, 3, 4, 5, 6, 7, 1, 
              0, 
            0, 
          7|128,24,  ISD::VECTOR_SHUFFLE,
            OPC_Scope, 82, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::f64,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2f64,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_Scope, 23, 
                OPC_CheckPredicate, 13,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
              23, 
                OPC_CheckPredicate, 22,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVHPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
              0, 
            77, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 23,
              OPC_CheckType, MVT::v2i64,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::UNDEF,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_Scope, 22, 
                OPC_CheckPredicate, 24,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSHDUPrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
              22, 
                OPC_CheckPredicate, 25,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSLDUPrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
              0, 
            48|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 70,  ISD::SCALAR_TO_VECTOR,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::f64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2f64,
                OPC_Scope, 23, 
                  OPC_CheckPredicate, 13,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
                23, 
                  OPC_CheckPredicate, 22,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVHPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
                0, 
              97,  ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPredicate, 13,
                OPC_SwitchType , 19,  MVT::v4f32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
                19,  MVT::v2f64,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
                19,  MVT::v4i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
                19,  MVT::v2i64,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                0, 
              0, 
            56, 
              OPC_RecordNode,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 23,
              OPC_CheckType, MVT::v2i64,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::UNDEF,
              OPC_MoveParent,
              OPC_CheckPredicate, 26,
              OPC_CheckType, MVT::v4i32,
              OPC_CheckPatternPredicate, 1,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 1, 
              OPC_EmitNodeXForm, 0, 0,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFDmi), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::v4i32, 6, 3, 4, 5, 6, 7, 8, 
            86, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 23,
              OPC_SwitchType , 31,  MVT::v2f64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::UNDEF,
                OPC_MoveParent,
                OPC_CheckPredicate, 27,
                OPC_CheckType, MVT::v4f32,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVDDUPrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 5, 2, 3, 4, 5, 6, 
              31,  MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::UNDEF,
                OPC_MoveParent,
                OPC_CheckPredicate, 27,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVDDUPrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
              0, 
            122, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 23,
              OPC_MoveParent,
              OPC_SwitchType , 50,  MVT::v4f32,
                OPC_Scope, 23, 
                  OPC_CheckPredicate, 14,
                  OPC_CheckPatternPredicate, 0,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKHPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
                23, 
                  OPC_CheckPredicate, 28,
                  OPC_CheckPatternPredicate, 0,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKLPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
                0, 
              50,  MVT::v2f64,
                OPC_Scope, 23, 
                  OPC_CheckPredicate, 14,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKHPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
                23, 
                  OPC_CheckPredicate, 28,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKLPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
                0, 
              0, 
            126, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 54,  ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::i64,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::UNDEF,
                OPC_MoveParent,
                OPC_CheckPredicate, 27,
                OPC_CheckType, MVT::v2f64,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVDDUPrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 5, 2, 3, 4, 5, 6, 
              64,  ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::UNDEF,
                OPC_MoveParent,
                OPC_CheckPredicate, 27,
                OPC_SwitchType , 20,  MVT::v2f64,
                  OPC_CheckPatternPredicate, 9,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVDDUPrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2f64, 5, 2, 3, 4, 5, 6, 
                20,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 9,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVDDUPrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                0, 
              0, 
            86, 
              OPC_RecordNode,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 23,
              OPC_CheckType, MVT::v2i64,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::UNDEF,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_Scope, 26, 
                OPC_CheckPredicate, 29,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitNodeXForm, 1, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFHWmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 3, 4, 5, 6, 7, 8, 
              26, 
                OPC_CheckPredicate, 30,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitNodeXForm, 2, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFLWmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 3, 4, 5, 6, 7, 8, 
              0, 
            51, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::f64,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::UNDEF,
              OPC_MoveParent,
              OPC_CheckPredicate, 27,
              OPC_CheckType, MVT::v2f64,
              OPC_CheckPatternPredicate, 9,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVDDUPrm), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::v2f64, 5, 2, 3, 4, 5, 6, 
            95, 
              OPC_RecordNode,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_SwitchType , 37,  MVT::v4f32,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::UNDEF,
                OPC_MoveParent,
                OPC_CheckPredicate, 26,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitNodeXForm, 0, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFDmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 3, 4, 5, 6, 7, 8, 
              35,  MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::UNDEF,
                OPC_MoveParent,
                OPC_CheckPredicate, 31,
                OPC_CheckType, MVT::v4i16,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitNodeXForm, 3, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSHUFWmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 3, 4, 5, 6, 7, 8, 
              0, 
            45|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 23,
              OPC_CheckType, MVT::v2i64,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_Scope, 73, 
                OPC_CheckPredicate, 28,
                OPC_SwitchType , 21,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
                21,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
                21,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
                0, 
              73, 
                OPC_CheckPredicate, 14,
                OPC_SwitchType , 21,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
                21,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
                21,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
                0, 
              0, 
            70, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 23,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::UNDEF,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4f32,
              OPC_Scope, 22, 
                OPC_CheckPredicate, 24,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSHDUPrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 5, 2, 3, 4, 5, 6, 
              22, 
                OPC_CheckPredicate, 25,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSLDUPrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 5, 2, 3, 4, 5, 6, 
              0, 
            53, 
              OPC_RecordNode,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 23,
              OPC_CheckType, MVT::v2i64,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckPredicate, 32,
              OPC_CheckType, MVT::v4i32,
              OPC_CheckPatternPredicate, 1,
              OPC_CheckComplexPat, /*CP*/0, /*#*/3,
              OPC_EmitMergeInputChains, 1, 2, 
              OPC_EmitNodeXForm, 0, 0,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::SHUFPSrmi), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::v4i32, 7, 1, 4, 5, 6, 7, 8, 9, 
            12|128,2, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_SwitchOpcode , 73|128,1,  ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 34|128,1,  ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckType, MVT::v1i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_Scope, 73, 
                    OPC_CheckPredicate, 33,
                    OPC_SwitchType , 21,  MVT::v8i8,
                      OPC_CheckPatternPredicate, 8,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKHBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
                    21,  MVT::v4i16,
                      OPC_CheckPatternPredicate, 8,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKHWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
                    21,  MVT::v2i32,
                      OPC_CheckPatternPredicate, 8,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKHDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
                    0, 
                  73, 
                    OPC_CheckPredicate, 34,
                    OPC_SwitchType , 21,  MVT::v8i8,
                      OPC_CheckPatternPredicate, 8,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKLBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
                    21,  MVT::v4i16,
                      OPC_CheckPatternPredicate, 8,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKLWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
                    21,  MVT::v2i32,
                      OPC_CheckPatternPredicate, 8,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKLDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
                    0, 
                  0, 
                30,  X86ISD::VZEXT_LOAD,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPredicate, 22,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVHPSrm), 0|OPFL_Chain,
                      1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
                0, 
              57,  ISD::UNDEF,
                OPC_MoveParent,
                OPC_Scope, 26, 
                  OPC_CheckPredicate, 27,
                  OPC_SwitchType , 9,  MVT::v4f32,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLHPSrr), 0,
                        1, MVT::v4f32, 2, 0, 0, 
                  9,  MVT::v2i64,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLHPSrr), 0,
                        1, MVT::v2i64, 2, 0, 0, 
                  0, 
                26, 
                  OPC_CheckPredicate, 35,
                  OPC_SwitchType , 9,  MVT::v4f32,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVHLPSrr), 0,
                        1, MVT::v4f32, 2, 0, 0, 
                  9,  MVT::v4i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVHLPSrr), 0,
                        1, MVT::v4i32, 2, 0, 0, 
                  0, 
                0, 
              0, 
            75, 
              OPC_RecordNode,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 23,
              OPC_MoveParent,
              OPC_CheckPredicate, 32,
              OPC_SwitchType , 25,  MVT::v4f32,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                OPC_EmitMergeInputChains, 1, 2, 
                OPC_EmitNodeXForm, 0, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SHUFPSrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 7, 1, 4, 5, 6, 7, 8, 9, 
              25,  MVT::v2f64,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                OPC_EmitMergeInputChains, 1, 2, 
                OPC_EmitNodeXForm, 0, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SHUFPDrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 7, 1, 4, 5, 6, 7, 8, 9, 
              0, 
            7|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 67, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_Scope, 23, 
                  OPC_CheckPredicate, 28,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLQDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                23, 
                  OPC_CheckPredicate, 14,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHQDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                0, 
              63, 
                OPC_RecordChild1,
                OPC_SwitchType , 30,  MVT::v4f32,
                  OPC_Scope, 13, 
                    OPC_CheckPredicate, 22,
                    OPC_CheckPatternPredicate, 0,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLHPSrr), 0,
                        1, MVT::v4f32, 2, 0, 1, 
                  13, 
                    OPC_CheckPredicate, 36,
                    OPC_CheckPatternPredicate, 0,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVHLPSrr), 0,
                        1, MVT::v4f32, 2, 0, 1, 
                  0, 
                26,  MVT::v4i32,
                  OPC_Scope, 11, 
                    OPC_CheckPredicate, 22,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVLHPSrr), 0,
                        1, MVT::v4i32, 2, 0, 1, 
                  11, 
                    OPC_CheckPredicate, 36,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVHLPSrr), 0,
                        1, MVT::v4i32, 2, 0, 1, 
                  0, 
                0, 
              0, 
            22, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_CheckPredicate, 37,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckPredicate, 38,
              OPC_CheckType, MVT::v2f64,
              OPC_CheckPatternPredicate, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZPQILo2PQIrr), 0,
                  1, MVT::v2f64, 1, 0, 
            36, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::UNDEF,
              OPC_MoveParent,
              OPC_CheckType, MVT::v4i32,
              OPC_Scope, 12, 
                OPC_CheckPredicate, 24,
                OPC_CheckPatternPredicate, 9,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSHDUPrr), 0,
                    1, MVT::v4i32, 1, 0, 
              12, 
                OPC_CheckPredicate, 25,
                OPC_CheckPatternPredicate, 9,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSLDUPrr), 0,
                    1, MVT::v4i32, 1, 0, 
              0, 
            83, 
              OPC_RecordNode,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::UNDEF,
              OPC_MoveParent,
              OPC_Scope, 36, 
                OPC_CheckPredicate, 39,
                OPC_SwitchType , 14,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 10,
                  OPC_EmitNodeXForm, 0, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFDri), 0,
                      1, MVT::v4i32, 2, 1, 2, 
                14,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 10,
                  OPC_EmitNodeXForm, 0, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFDri), 0,
                      1, MVT::v4f32, 2, 1, 2, 
                0, 
              36, 
                OPC_CheckPredicate, 40,
                OPC_SwitchType , 14,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 10,
                  OPC_EmitNodeXForm, 0, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFDri), 0,
                      1, MVT::v4i32, 2, 1, 2, 
                14,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 10,
                  OPC_EmitNodeXForm, 0, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFDri), 0,
                      1, MVT::v4f32, 2, 1, 2, 
                0, 
              0, 
            91|128,3, 
              OPC_RecordChild0,
              OPC_Scope, 27|128,1, 
                OPC_RecordChild1,
                OPC_Scope, 96, 
                  OPC_CheckPredicate, 38,
                  OPC_SwitchType , 21,  MVT::v4f32,
                    OPC_EmitInteger, MVT::i32, 1, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::f32, 2, 1, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSSrr), 0,
                        1, MVT::v4f32, 2, 0, 3, 
                  21,  MVT::v2f64,
                    OPC_EmitInteger, MVT::i32, 2, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::f64, 2, 1, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSDrr), 0,
                        1, MVT::v2f64, 2, 0, 3, 
                  21,  MVT::v4i32,
                    OPC_EmitInteger, MVT::i32, 1, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::f32, 2, 1, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSSrr), 0,
                        1, MVT::v4i32, 2, 0, 3, 
                  21,  MVT::v2i64,
                    OPC_EmitInteger, MVT::i32, 2, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::f64, 2, 1, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSDrr), 0,
                        1, MVT::v2i64, 2, 0, 3, 
                  0, 
                54, 
                  OPC_CheckPredicate, 13,
                  OPC_SwitchType , 23,  MVT::v4f32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 2, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::f64, 2, 1, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSDrr), 0,
                        1, MVT::v4f32, 2, 0, 3, 
                  23,  MVT::v4i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitInteger, MVT::i32, 2, 
                    OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                        1, MVT::f64, 2, 1, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSDrr), 0,
                        1, MVT::v4i32, 2, 0, 3, 
                  0, 
                0, 
              117|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::UNDEF,
                OPC_MoveParent,
                OPC_Scope, 15, 
                  OPC_CheckPredicate, 41,
                  OPC_CheckType, MVT::v2f64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKLPDrr), 0,
                      1, MVT::v2f64, 2, 0, 0, 
                15, 
                  OPC_CheckPredicate, 14,
                  OPC_CheckType, MVT::v2f64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKHPDrr), 0,
                      1, MVT::v2f64, 2, 0, 0, 
                15, 
                  OPC_CheckPredicate, 41,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLQDQrr), 0,
                      1, MVT::v2i64, 2, 0, 0, 
                15, 
                  OPC_CheckPredicate, 14,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHQDQrr), 0,
                      1, MVT::v2i64, 2, 0, 0, 
                48, 
                  OPC_CheckPredicate, 39,
                  OPC_SwitchType , 9,  MVT::v4f32,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKLPSrr), 0,
                        1, MVT::v4f32, 2, 0, 0, 
                  9,  MVT::v16i8,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLBWrr), 0,
                        1, MVT::v16i8, 2, 0, 0, 
                  9,  MVT::v8i16,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLWDrr), 0,
                        1, MVT::v8i16, 2, 0, 0, 
                  9,  MVT::v4i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLDQrr), 0,
                        1, MVT::v4i32, 2, 0, 0, 
                  0, 
                48, 
                  OPC_CheckPredicate, 40,
                  OPC_SwitchType , 9,  MVT::v4f32,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKHPSrr), 0,
                        1, MVT::v4f32, 2, 0, 0, 
                  9,  MVT::v16i8,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHBWrr), 0,
                        1, MVT::v16i8, 2, 0, 0, 
                  9,  MVT::v8i16,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHWDrr), 0,
                        1, MVT::v8i16, 2, 0, 0, 
                  9,  MVT::v4i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHDQrr), 0,
                        1, MVT::v4i32, 2, 0, 0, 
                  0, 
                37, 
                  OPC_CheckPredicate, 42,
                  OPC_SwitchType , 9,  MVT::v8i8,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKLBWrr), 0,
                        1, MVT::v8i8, 2, 0, 0, 
                  9,  MVT::v4i16,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKLWDrr), 0,
                        1, MVT::v4i16, 2, 0, 0, 
                  9,  MVT::v2i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKLDQrr), 0,
                        1, MVT::v2i32, 2, 0, 0, 
                  0, 
                37, 
                  OPC_CheckPredicate, 43,
                  OPC_SwitchType , 9,  MVT::v8i8,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKHBWrr), 0,
                        1, MVT::v8i8, 2, 0, 0, 
                  9,  MVT::v4i16,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKHWDrr), 0,
                        1, MVT::v4i16, 2, 0, 0, 
                  9,  MVT::v2i32,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKHDQrr), 0,
                        1, MVT::v2i32, 2, 0, 0, 
                  0, 
                0, 
              67, 
                OPC_RecordChild1,
                OPC_SwitchType , 30,  MVT::v4f32,
                  OPC_Scope, 13, 
                    OPC_CheckPredicate, 14,
                    OPC_CheckPatternPredicate, 0,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKHPSrr), 0,
                        1, MVT::v4f32, 2, 0, 1, 
                  13, 
                    OPC_CheckPredicate, 28,
                    OPC_CheckPatternPredicate, 0,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKLPSrr), 0,
                        1, MVT::v4f32, 2, 0, 1, 
                  0, 
                30,  MVT::v2f64,
                  OPC_Scope, 13, 
                    OPC_CheckPredicate, 14,
                    OPC_CheckPatternPredicate, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKHPDrr), 0,
                        1, MVT::v2f64, 2, 0, 1, 
                  13, 
                    OPC_CheckPredicate, 28,
                    OPC_CheckPatternPredicate, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::UNPCKLPDrr), 0,
                        1, MVT::v2f64, 2, 0, 1, 
                  0, 
                0, 
              0, 
            36, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BUILD_VECTOR,
              OPC_CheckPredicate, 44,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v8i8,
              OPC_CheckType, MVT::i64,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_CheckPredicate, 38,
              OPC_CheckType, MVT::v2i64,
              OPC_CheckPatternPredicate, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ2DQrr), 0,
                  1, MVT::v2i64, 1, 0, 
            120, 
              OPC_RecordNode,
              OPC_RecordChild0,
              OPC_Scope, 41, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::UNDEF,
                OPC_MoveParent,
                OPC_CheckPredicate, 26,
                OPC_SwitchType , 14,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 1,
                  OPC_EmitNodeXForm, 0, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFDri), 0,
                      1, MVT::v4i32, 2, 1, 2, 
                14,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 1,
                  OPC_EmitNodeXForm, 0, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFDri), 0,
                      1, MVT::v4f32, 2, 1, 2, 
                0, 
              73, 
                OPC_RecordChild1,
                OPC_CheckPredicate, 45,
                OPC_SwitchType , 15,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 11,
                  OPC_EmitNodeXForm, 4, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PALIGNR128rr), 0,
                      1, MVT::v4i32, 3, 2, 1, 3, 
                15,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 11,
                  OPC_EmitNodeXForm, 4, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PALIGNR128rr), 0,
                      1, MVT::v4f32, 3, 2, 1, 3, 
                15,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 11,
                  OPC_EmitNodeXForm, 4, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PALIGNR128rr), 0,
                      1, MVT::v8i16, 3, 2, 1, 3, 
                15,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 11,
                  OPC_EmitNodeXForm, 4, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PALIGNR128rr), 0,
                      1, MVT::v16i8, 3, 2, 1, 3, 
                0, 
              0, 
            46, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
              OPC_RecordChild0,
              OPC_Scope, 18, 
                OPC_CheckChild0Type, MVT::f32,
                OPC_MoveParent,
                OPC_CheckPredicate, 38,
                OPC_CheckType, MVT::v16i8,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSSrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              18, 
                OPC_CheckChild0Type, MVT::f64,
                OPC_MoveParent,
                OPC_CheckPredicate, 38,
                OPC_CheckType, MVT::v16i8,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSDrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            45, 
              OPC_RecordNode,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::UNDEF,
              OPC_MoveParent,
              OPC_CheckType, MVT::v8i16,
              OPC_Scope, 16, 
                OPC_CheckPredicate, 29,
                OPC_CheckPatternPredicate, 1,
                OPC_EmitNodeXForm, 1, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFHWri), 0,
                    1, MVT::v8i16, 2, 1, 2, 
              16, 
                OPC_CheckPredicate, 30,
                OPC_CheckPatternPredicate, 1,
                OPC_EmitNodeXForm, 2, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFLWri), 0,
                    1, MVT::v8i16, 2, 1, 2, 
              0, 
            52, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::UNDEF,
              OPC_MoveParent,
              OPC_SwitchType , 28,  MVT::v4f32,
                OPC_Scope, 12, 
                  OPC_CheckPredicate, 24,
                  OPC_CheckPatternPredicate, 9,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSHDUPrr), 0,
                      1, MVT::v4f32, 1, 0, 
                12, 
                  OPC_CheckPredicate, 25,
                  OPC_CheckPatternPredicate, 9,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSLDUPrr), 0,
                      1, MVT::v4f32, 1, 0, 
                0, 
              12,  MVT::v2f64,
                OPC_CheckPredicate, 27,
                OPC_CheckPatternPredicate, 9,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVDDUPrr), 0,
                    1, MVT::v2f64, 1, 0, 
              0, 
            125, 
              OPC_RecordNode,
              OPC_RecordChild0,
              OPC_Scope, 80, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::UNDEF,
                OPC_MoveParent,
                OPC_Scope, 53, 
                  OPC_CheckPredicate, 26,
                  OPC_SwitchType , 13,  MVT::v4f32,
                    OPC_EmitNodeXForm, 0, 0,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHUFPSrri), 0,
                        1, MVT::v4f32, 3, 1, 1, 2, 
                  15,  MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitNodeXForm, 0, 0,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHUFPDrri), 0,
                        1, MVT::v2i64, 3, 1, 1, 2, 
                  15,  MVT::v2f64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_EmitNodeXForm, 0, 0,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::SHUFPDrri), 0,
                        1, MVT::v2f64, 3, 1, 1, 2, 
                  0, 
                18, 
                  OPC_CheckPredicate, 31,
                  OPC_CheckType, MVT::v4i16,
                  OPC_CheckPatternPredicate, 8,
                  OPC_EmitNodeXForm, 3, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSHUFWri), 0,
                      1, MVT::v4i16, 2, 1, 2, 
                0, 
              39, 
                OPC_RecordChild1,
                OPC_CheckPredicate, 32,
                OPC_SwitchType , 15,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 0,
                  OPC_EmitNodeXForm, 0, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHUFPSrri), 0,
                      1, MVT::v4f32, 3, 1, 2, 3, 
                15,  MVT::v2f64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_EmitNodeXForm, 0, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHUFPDrri), 0,
                      1, MVT::v2f64, 3, 1, 2, 3, 
                0, 
              0, 
            118, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 56, 
                OPC_CheckPredicate, 28,
                OPC_SwitchType , 11,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLBWrr), 0,
                      1, MVT::v16i8, 2, 0, 1, 
                11,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLWDrr), 0,
                      1, MVT::v8i16, 2, 0, 1, 
                11,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLDQrr), 0,
                      1, MVT::v4i32, 2, 0, 1, 
                11,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKLQDQrr), 0,
                      1, MVT::v2i64, 2, 0, 1, 
                0, 
              56, 
                OPC_CheckPredicate, 14,
                OPC_SwitchType , 11,  MVT::v16i8,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHBWrr), 0,
                      1, MVT::v16i8, 2, 0, 1, 
                11,  MVT::v8i16,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHWDrr), 0,
                      1, MVT::v8i16, 2, 0, 1, 
                11,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHDQrr), 0,
                      1, MVT::v4i32, 2, 0, 1, 
                11,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PUNPCKHQDQrr), 0,
                      1, MVT::v2i64, 2, 0, 1, 
                0, 
              0, 
            62, 
              OPC_RecordNode,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 38, 
                OPC_CheckPredicate, 32,
                OPC_SwitchType , 15,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 1,
                  OPC_EmitNodeXForm, 0, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHUFPSrri), 0,
                      1, MVT::v4i32, 3, 1, 2, 3, 
                15,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_EmitNodeXForm, 0, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::SHUFPDrri), 0,
                      1, MVT::v2i64, 3, 1, 2, 3, 
                0, 
              17, 
                OPC_CheckPredicate, 13,
                OPC_CheckType, MVT::v4f32,
                OPC_EmitNodeXForm, 0, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SHUFPSrri), 0,
                    1, MVT::v4f32, 3, 2, 1, 3, 
              0, 
            92, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_CheckPredicate, 33,
                OPC_SwitchType , 11,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 8,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKHBWrr), 0,
                      1, MVT::v8i8, 2, 0, 1, 
                11,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 8,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKHWDrr), 0,
                      1, MVT::v4i16, 2, 0, 1, 
                11,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 8,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKHDQrr), 0,
                      1, MVT::v2i32, 2, 0, 1, 
                0, 
              43, 
                OPC_CheckPredicate, 34,
                OPC_SwitchType , 11,  MVT::v8i8,
                  OPC_CheckPatternPredicate, 8,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKLBWrr), 0,
                      1, MVT::v8i8, 2, 0, 1, 
                11,  MVT::v4i16,
                  OPC_CheckPatternPredicate, 8,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKLWDrr), 0,
                      1, MVT::v4i16, 2, 0, 1, 
                11,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 8,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKLDQrr), 0,
                      1, MVT::v2i32, 2, 0, 1, 
                0, 
              0, 
            0, 
          83|128,5,  X86ISD::VZEXT_MOVL,
            OPC_Scope, 101|128,4, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 30|128,2,  ISD::SCALAR_TO_VECTOR,
                OPC_Scope, 60|128,1, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 28, 
                    OPC_CheckPredicate, 3,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v4i32,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZDI2PDIrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                  30, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZQI2PQIrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                  28, 
                    OPC_CheckPredicate, 3,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i32,
                    OPC_CheckPatternPredicate, 8,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVZDI2PDIrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i32, 5, 2, 3, 4, 5, 6, 
                  86, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_SwitchType , 38,  MVT::f32,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v4f32,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitInteger, MVT::i32, 0, 
                      OPC_EmitNode, TARGET_OPCODE(X86::MOVSSrm), 0|OPFL_Chain,
                          1, MVT::f32, 5, 2, 3, 4, 5, 6, 
                      OPC_EmitInteger, MVT::i32, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::SUBREG_TO_REG), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v4f32, 3, 7, 8, 9, 
                    38,  MVT::f64,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v2f64,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitInteger, MVT::i64, 0, 
                      OPC_EmitNode, TARGET_OPCODE(X86::MOVSDrm), 0|OPFL_Chain,
                          1, MVT::f64, 5, 2, 3, 4, 5, 6, 
                      OPC_EmitInteger, MVT::i32, 2, 
                      OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::SUBREG_TO_REG), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v2f64, 3, 7, 8, 9, 
                    0, 
                  0, 
                93, 
                  OPC_RecordChild0,
                  OPC_Scope, 29, 
                    OPC_CheckChild0Type, MVT::i32,
                    OPC_MoveParent,
                    OPC_SwitchType , 10,  MVT::v4i32,
                      OPC_CheckPatternPredicate, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZDI2PDIrr), 0,
                          1, MVT::v4i32, 1, 0, 
                    10,  MVT::v2i32,
                      OPC_CheckPatternPredicate, 8,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVZDI2PDIrr), 0,
                          1, MVT::v2i32, 1, 0, 
                    0, 
                  15, 
                    OPC_CheckChild0Type, MVT::i64,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZQI2PQIrr), 0,
                        1, MVT::v2i64, 1, 0, 
                  21, 
                    OPC_CheckChild0Type, MVT::f64,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2f64,
                    OPC_EmitNode, TARGET_OPCODE(X86::V_SET0), 0,
                        1, MVT::v2f64, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSDrr), 0,
                        1, MVT::v2f64, 2, 1, 0, 
                  21, 
                    OPC_CheckChild0Type, MVT::f32,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v4f32,
                    OPC_EmitNode, TARGET_OPCODE(X86::V_SET0), 0,
                        1, MVT::v4f32, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSSrr), 0,
                        1, MVT::v4f32, 2, 1, 0, 
                  0, 
                0, 
              40|128,1,  ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_SwitchType , 80,  MVT::v4f32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_SwitchType , 18,  MVT::v4i32,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZDI2PDIrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                  18,  MVT::v2i64,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZQI2PQIrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                  34,  MVT::v2f64,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i64, 0, 
                    OPC_EmitNode, TARGET_OPCODE(X86::MOVSDrm), 0|OPFL_Chain,
                        1, MVT::f64, 5, 2, 3, 4, 5, 6, 
                    OPC_EmitInteger, MVT::i32, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::SUBREG_TO_REG), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2f64, 3, 7, 8, 9, 
                  0, 
                22,  MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZDI2PDIrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                22,  MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZPQILo2PQIrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                22,  MVT::v1i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVZDI2PDIrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i32, 5, 2, 3, 4, 5, 6, 
                0, 
              18|128,1,  ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_SwitchType , 18,  MVT::v4i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZDI2PDIrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                42,  MVT::v2i64,
                  OPC_Scope, 18, 
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZQI2PQIrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                  20, 
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZPQILo2PQIrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                  0, 
                34,  MVT::v4f32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i32, 0, 
                  OPC_EmitNode, TARGET_OPCODE(X86::MOVSSrm), 0|OPFL_Chain,
                      1, MVT::f32, 5, 2, 3, 4, 5, 6, 
                  OPC_EmitInteger, MVT::i32, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::SUBREG_TO_REG), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4f32, 3, 7, 8, 9, 
                34,  MVT::v2f64,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitInteger, MVT::i64, 0, 
                  OPC_EmitNode, TARGET_OPCODE(X86::MOVSDrm), 0|OPFL_Chain,
                      1, MVT::f64, 5, 2, 3, 4, 5, 6, 
                  OPC_EmitInteger, MVT::i32, 2, 
                  OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::SUBREG_TO_REG), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2f64, 3, 7, 8, 9, 
                0, 
              0, 
            105, 
              OPC_RecordChild0,
              OPC_SwitchType , 10,  MVT::v2i64,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZPQILo2PQIrr), 0,
                    1, MVT::v2i64, 1, 0, 
              16,  MVT::v2i32,
                OPC_EmitNode, TARGET_OPCODE(X86::MMX_V_SET0), 0,
                    1, MVT::v8i8, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PUNPCKLDQrr), 0,
                    1, MVT::v2i32, 2, 0, 1, 
              28,  MVT::v4f32,
                OPC_EmitNode, TARGET_OPCODE(X86::V_SET0), 0,
                    1, MVT::v4f32, 0, 
                OPC_EmitInteger, MVT::i32, 1, 
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::f32, 2, 0, 2, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSSrr), 0,
                    1, MVT::v4f32, 2, 1, 3, 
              28,  MVT::v4i32,
                OPC_EmitNode, TARGET_OPCODE(X86::V_SET0), 0,
                    1, MVT::v4i32, 0, 
                OPC_EmitInteger, MVT::i32, 1, 
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::f32, 2, 0, 2, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSSrr), 0,
                    1, MVT::v4i32, 2, 1, 3, 
              10,  MVT::v2f64,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZPQILo2PQIrr), 0,
                    1, MVT::v2f64, 1, 0, 
              0, 
            0, 
          108|128,2,  ISD::SCALAR_TO_VECTOR,
            OPC_Scope, 120|128,1, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 50|128,1,  ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_Scope, 84, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_SwitchType , 37,  MVT::f32,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v4f32,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i32, 0, 
                    OPC_EmitNode, TARGET_OPCODE(X86::MOVSSrm), 0|OPFL_Chain,
                        1, MVT::f32, 5, 2, 3, 4, 5, 6, 
                    OPC_EmitInteger, MVT::i32, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::SUBREG_TO_REG), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v4f32, 3, 7, 8, 9, 
                  37,  MVT::f64,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2f64,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitInteger, MVT::i64, 0, 
                    OPC_EmitNode, TARGET_OPCODE(X86::MOVSDrm), 0|OPFL_Chain,
                        1, MVT::f64, 5, 2, 3, 4, 5, 6, 
                    OPC_EmitInteger, MVT::i32, 2, 
                    OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::SUBREG_TO_REG), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2f64, 3, 7, 8, 9, 
                  0, 
                27, 
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVDI2PDIrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                29, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVQI2PQIrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                27, 
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i32,
                  OPC_CheckPatternPredicate, 8,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVD64rm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i32, 5, 2, 3, 4, 5, 6, 
                0, 
              61,  ISD::BIT_CONVERT,
                OPC_RecordChild0,
                OPC_CheckType, MVT::i64,
                OPC_Scope, 13, 
                  OPC_CheckChild0Type, MVT::v8i8,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ2DQrr), 0,
                      1, MVT::v2i64, 1, 0, 
                13, 
                  OPC_CheckChild0Type, MVT::v4i16,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ2DQrr), 0,
                      1, MVT::v2i64, 1, 0, 
                13, 
                  OPC_CheckChild0Type, MVT::v2i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ2DQrr), 0,
                      1, MVT::v2i64, 1, 0, 
                13, 
                  OPC_CheckChild0Type, MVT::v1i64,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ2DQrr), 0,
                      1, MVT::v2i64, 1, 0, 
                0, 
              0, 
            111, 
              OPC_RecordChild0,
              OPC_Scope, 28, 
                OPC_CheckChild0Type, MVT::i64,
                OPC_SwitchType , 10,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV64toPQIrr), 0,
                      1, MVT::v2i64, 1, 0, 
                10,  MVT::v1i64,
                  OPC_CheckPatternPredicate, 8,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVD64rrv164), 0,
                      1, MVT::v1i64, 1, 0, 
                0, 
              28, 
                OPC_CheckChild0Type, MVT::i32,
                OPC_SwitchType , 10,  MVT::v4i32,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVDI2PDIrr), 0,
                      1, MVT::v4i32, 1, 0, 
                10,  MVT::v2i32,
                  OPC_CheckPatternPredicate, 8,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVD64rr), 0,
                      1, MVT::v2i32, 1, 0, 
                0, 
              24, 
                OPC_CheckChild0Type, MVT::f32,
                OPC_CheckType, MVT::v4f32,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::IMPLICIT_DEF), 0,
                    1, MVT::v4f32, 0, 
                OPC_EmitInteger, MVT::i32, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                    1, MVT::v4f32, 3, 1, 0, 2, 
              24, 
                OPC_CheckChild0Type, MVT::f64,
                OPC_CheckType, MVT::v2f64,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::IMPLICIT_DEF), 0,
                    1, MVT::v2f64, 0, 
                OPC_EmitInteger, MVT::i32, 2, 
                OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::INSERT_SUBREG), 0,
                    1, MVT::v2f64, 3, 1, 0, 2, 
              0, 
            0, 
          90|128,11,  ISD::LOAD,
            OPC_RecordMemRef,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_CheckPredicate, 2,
            OPC_Scope, 62|128,1, 
              OPC_CheckPredicate, 8,
              OPC_Scope, 24, 
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::f64,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::f64, 5, 2, 3, 4, 5, 6, 
              22, 
                OPC_CheckPredicate, 46,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::GS_MOV32rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              22, 
                OPC_CheckPredicate, 47,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::FS_MOV32rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              22, 
                OPC_CheckPredicate, 46,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV64GSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              22, 
                OPC_CheckPredicate, 47,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV64FSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              68, 
                OPC_CheckPredicate, 9,
                OPC_SwitchType , 20,  MVT::f32,
                  OPC_CheckPatternPredicate, 6,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::LD_Fp32m), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::f32, 5, 2, 3, 4, 5, 6, 
                20,  MVT::f64,
                  OPC_CheckPatternPredicate, 7,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::LD_Fp64m), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::f64, 5, 2, 3, 4, 5, 6, 
                18,  MVT::f80,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::LD_Fp80m), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::f80, 5, 2, 3, 4, 5, 6, 
                0, 
              0, 
            74, 
              OPC_CheckPredicate, 48,
              OPC_SwitchType , 22,  MVT::f64,
                OPC_CheckPredicate, 49,
                OPC_CheckPatternPredicate, 7,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::LD_Fp32m64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::f64, 5, 2, 3, 4, 5, 6, 
              44,  MVT::f80,
                OPC_Scope, 20, 
                  OPC_CheckPredicate, 50,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::LD_Fp64m80), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::f80, 5, 2, 3, 4, 5, 6, 
                20, 
                  OPC_CheckPredicate, 49,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::LD_Fp32m80), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::f80, 5, 2, 3, 4, 5, 6, 
                0, 
              0, 
            24, 
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i8,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV8rm), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i8, 5, 2, 3, 4, 5, 6, 
            22, 
              OPC_CheckPredicate, 6,
              OPC_CheckType, MVT::i16,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV16rm), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i16, 5, 2, 3, 4, 5, 6, 
            22, 
              OPC_CheckPredicate, 3,
              OPC_CheckType, MVT::i32,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV32rm), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i32, 5, 2, 3, 4, 5, 6, 
            72, 
              OPC_CheckPredicate, 51,
              OPC_Scope, 44, 
                OPC_CheckPredicate, 52,
                OPC_SwitchType , 18,  MVT::i16,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSX16rm8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i16, 5, 2, 3, 4, 5, 6, 
                18,  MVT::i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSX32rm8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              22, 
                OPC_CheckPredicate, 53,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSX32rm16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              0, 
            9|128,1, 
              OPC_CheckPredicate, 54,
              OPC_Scope, 44, 
                OPC_CheckPredicate, 55,
                OPC_SwitchType , 18,  MVT::i16,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX16rm8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i16, 5, 2, 3, 4, 5, 6, 
                18,  MVT::i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rm8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              22, 
                OPC_CheckPredicate, 56,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rm16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              64, 
                OPC_CheckPredicate, 57,
                OPC_SwitchType , 18,  MVT::i8,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV8rm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i8, 5, 2, 3, 4, 5, 6, 
                18,  MVT::i16,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX16rm8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i16, 5, 2, 3, 4, 5, 6, 
                18,  MVT::i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rm8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              0, 
            9|128,1, 
              OPC_CheckPredicate, 48,
              OPC_Scope, 64, 
                OPC_CheckPredicate, 58,
                OPC_SwitchType , 18,  MVT::i8,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV8rm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i8, 5, 2, 3, 4, 5, 6, 
                18,  MVT::i16,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX16rm8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i16, 5, 2, 3, 4, 5, 6, 
                18,  MVT::i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rm8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              44, 
                OPC_CheckPredicate, 59,
                OPC_SwitchType , 18,  MVT::i16,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX16rm8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i16, 5, 2, 3, 4, 5, 6, 
                18,  MVT::i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rm8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                0, 
              22, 
                OPC_CheckPredicate, 60,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rm16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              0, 
            24, 
              OPC_CheckPredicate, 51,
              OPC_CheckPredicate, 53,
              OPC_CheckType, MVT::i32,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSX32rm16), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i32, 5, 2, 3, 4, 5, 6, 
            24, 
              OPC_CheckPredicate, 54,
              OPC_CheckPredicate, 56,
              OPC_CheckType, MVT::i32,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rm16), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i32, 5, 2, 3, 4, 5, 6, 
            24, 
              OPC_CheckPredicate, 48,
              OPC_CheckPredicate, 60,
              OPC_CheckType, MVT::i32,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rm16), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i32, 5, 2, 3, 4, 5, 6, 
            22, 
              OPC_CheckPredicate, 8,
              OPC_CheckType, MVT::i64,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOV64rm), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 5, 2, 3, 4, 5, 6, 
            69, 
              OPC_CheckPredicate, 51,
              OPC_CheckType, MVT::i64,
              OPC_Scope, 20, 
                OPC_CheckPredicate, 52,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSX64rm8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              20, 
                OPC_CheckPredicate, 53,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSX64rm16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              20, 
                OPC_CheckPredicate, 61,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSX64rm32), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              0, 
            90, 
              OPC_CheckPredicate, 54,
              OPC_CheckType, MVT::i64,
              OPC_Scope, 20, 
                OPC_CheckPredicate, 55,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rm8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              20, 
                OPC_CheckPredicate, 56,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rm16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              20, 
                OPC_CheckPredicate, 62,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rm32), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              20, 
                OPC_CheckPredicate, 57,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rm8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              0, 
            69, 
              OPC_CheckPredicate, 48,
              OPC_CheckType, MVT::i64,
              OPC_Scope, 20, 
                OPC_CheckPredicate, 58,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rm8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              20, 
                OPC_CheckPredicate, 59,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rm8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              20, 
                OPC_CheckPredicate, 60,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rm16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              0, 
            24, 
              OPC_CheckPredicate, 51,
              OPC_CheckPredicate, 53,
              OPC_CheckType, MVT::i64,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSX64rm16), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 5, 2, 3, 4, 5, 6, 
            24, 
              OPC_CheckPredicate, 54,
              OPC_CheckPredicate, 56,
              OPC_CheckType, MVT::i64,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rm16), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 5, 2, 3, 4, 5, 6, 
            24, 
              OPC_CheckPredicate, 48,
              OPC_CheckPredicate, 60,
              OPC_CheckType, MVT::i64,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rm16), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i64, 5, 2, 3, 4, 5, 6, 
            101, 
              OPC_CheckPredicate, 8,
              OPC_Scope, 24, 
                OPC_CheckPredicate, 9,
                OPC_CheckType, MVT::f32,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVSSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::f32, 5, 2, 3, 4, 5, 6, 
              48, 
                OPC_CheckPredicate, 63,
                OPC_SwitchType , 20,  MVT::f32,
                  OPC_CheckPatternPredicate, 0,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::FsMOVAPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::f32, 5, 2, 3, 4, 5, 6, 
                20,  MVT::v4f32,
                  OPC_CheckPatternPredicate, 0,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVAPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4f32, 5, 2, 3, 4, 5, 6, 
                0, 
              22, 
                OPC_CheckType, MVT::v4f32,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVUPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 5, 2, 3, 4, 5, 6, 
              0, 
            26, 
              OPC_CheckPredicate, 48,
              OPC_CheckPredicate, 49,
              OPC_CheckType, MVT::f64,
              OPC_CheckPatternPredicate, 12,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::CVTSS2SDrm), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::f64, 5, 2, 3, 4, 5, 6, 
            61|128,1, 
              OPC_CheckPredicate, 8,
              OPC_Scope, 48, 
                OPC_CheckPredicate, 63,
                OPC_SwitchType , 20,  MVT::f64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::FsMOVAPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::f64, 5, 2, 3, 4, 5, 6, 
                20,  MVT::v2f64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVAPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2f64, 5, 2, 3, 4, 5, 6, 
                0, 
              22, 
                OPC_CheckType, MVT::v2f64,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVUPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 5, 2, 3, 4, 5, 6, 
              44, 
                OPC_CheckType, MVT::v4i32,
                OPC_Scope, 20, 
                  OPC_CheckPredicate, 63,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVAPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                18, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVUPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                0, 
              44, 
                OPC_CheckType, MVT::v2i64,
                OPC_Scope, 20, 
                  OPC_CheckPredicate, 63,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVAPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                18, 
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVUPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                0, 
              22, 
                OPC_CheckType, MVT::v1i64,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ64rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v1i64, 5, 2, 3, 4, 5, 6, 
              0, 
            77, 
              OPC_CheckPredicate, 48,
              OPC_SwitchType , 36,  MVT::i64,
                OPC_CheckPredicate, 64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitInteger, MVT::i64, 0, 
                OPC_EmitNode, TARGET_OPCODE(X86::MOV32rm), 0|OPFL_Chain,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
                OPC_EmitInteger, MVT::i32, 4, 
                OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::SUBREG_TO_REG), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 3, 7, 8, 9, 
              33,  MVT::f64,
                OPC_CheckPredicate, 49,
                OPC_CheckPatternPredicate, 13,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitNode, TARGET_OPCODE(X86::MOVSSrm), 0|OPFL_Chain,
                    1, MVT::f32, 5, 2, 3, 4, 5, 6, 
                OPC_EmitNode, TARGET_OPCODE(X86::CVTSS2SDrr), 0|OPFL_MemRefs,
                    1, MVT::f64, 1, 7, 
                OPC_CompleteMatch, 1, 8, 

              0, 
            0, 
          60,  X86ISD::VZEXT_LOAD,
            OPC_RecordNode,
            OPC_RecordChild1,
            OPC_SwitchType , 18,  MVT::v2i64,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZQI2PQIrm), 0|OPFL_Chain,
                  1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
            34,  MVT::v2f64,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_EmitInteger, MVT::i64, 0, 
              OPC_EmitNode, TARGET_OPCODE(X86::MOVSDrm), 0|OPFL_Chain,
                  1, MVT::f64, 5, 2, 3, 4, 5, 6, 
              OPC_EmitInteger, MVT::i32, 2, 
              OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::SUBREG_TO_REG), 0|OPFL_Chain,
                  1, MVT::v2f64, 3, 7, 8, 9, 
            0, 
          9|128,9|128,1,  ISD::INTRINSIC_WO_CHAIN,
            OPC_MoveChild, 0,
            OPC_Scope, 20|128,1, 
              OPC_CheckInteger, 126|128,4, 
              OPC_MoveParent,
              OPC_Scope, 0|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 46,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v8i16, 5, 2, 3, 4, 5, 6, 
                41,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v8i16, 5, 2, 3, 4, 5, 6, 
                27,  X86ISD::VZEXT_LOAD,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXBWrm), 0|OPFL_Chain,
                      1, MVT::v8i16, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXBWrr), 0,
                    1, MVT::v8i16, 1, 0, 
              0, 
            20|128,1, 
              OPC_CheckInteger, 0|128,5, 
              OPC_MoveParent,
              OPC_Scope, 0|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 46,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                41,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                27,  X86ISD::VZEXT_LOAD,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXWDrm), 0|OPFL_Chain,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXWDrr), 0,
                    1, MVT::v4i32, 1, 0, 
              0, 
            20|128,1, 
              OPC_CheckInteger, 127|128,4, 
              OPC_MoveParent,
              OPC_Scope, 0|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 46,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                41,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                27,  X86ISD::VZEXT_LOAD,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXDQrm), 0|OPFL_Chain,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXDQrr), 0,
                    1, MVT::v2i64, 1, 0, 
              0, 
            20|128,1, 
              OPC_CheckInteger, 4|128,5, 
              OPC_MoveParent,
              OPC_Scope, 0|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 46,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v8i16, 5, 2, 3, 4, 5, 6, 
                41,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v8i16, 5, 2, 3, 4, 5, 6, 
                27,  X86ISD::VZEXT_LOAD,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXBWrm), 0|OPFL_Chain,
                      1, MVT::v8i16, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXBWrr), 0,
                    1, MVT::v8i16, 1, 0, 
              0, 
            20|128,1, 
              OPC_CheckInteger, 6|128,5, 
              OPC_MoveParent,
              OPC_Scope, 0|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 46,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                41,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                27,  X86ISD::VZEXT_LOAD,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXWDrm), 0|OPFL_Chain,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXWDrr), 0,
                    1, MVT::v4i32, 1, 0, 
              0, 
            20|128,1, 
              OPC_CheckInteger, 5|128,5, 
              OPC_MoveParent,
              OPC_Scope, 0|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 46,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                41,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                27,  X86ISD::VZEXT_LOAD,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v2i64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXDQrm), 0|OPFL_Chain,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXDQrr), 0,
                    1, MVT::v2i64, 1, 0, 
              0, 
            114, 
              OPC_CheckInteger, 124|128,4, 
              OPC_MoveParent,
              OPC_Scope, 95, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 44,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXBDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                39,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXBDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXBDrr), 0,
                    1, MVT::v4i32, 1, 0, 
              0, 
            114, 
              OPC_CheckInteger, 1|128,5, 
              OPC_MoveParent,
              OPC_Scope, 95, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 44,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXWQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                39,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXWQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXWQrr), 0,
                    1, MVT::v2i64, 1, 0, 
              0, 
            114, 
              OPC_CheckInteger, 2|128,5, 
              OPC_MoveParent,
              OPC_Scope, 95, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 44,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXBDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                39,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXBDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXBDrr), 0,
                    1, MVT::v4i32, 1, 0, 
              0, 
            114, 
              OPC_CheckInteger, 7|128,5, 
              OPC_MoveParent,
              OPC_Scope, 95, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 44,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXWQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                39,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXWQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXWQrr), 0,
                    1, MVT::v2i64, 1, 0, 
              0, 
            114, 
              OPC_CheckInteger, 125|128,4, 
              OPC_MoveParent,
              OPC_Scope, 95, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 44,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXBQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                39,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 65,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXBQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVSXBQrr), 0,
                    1, MVT::v2i64, 1, 0, 
              0, 
            114, 
              OPC_CheckInteger, 3|128,5, 
              OPC_MoveParent,
              OPC_Scope, 95, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 44,  X86ISD::VZEXT_MOVL,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXBQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                39,  ISD::SCALAR_TO_VECTOR,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 65,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckPatternPredicate, 4,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXBQrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
                0, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVZXBQrr), 0,
                    1, MVT::v2i64, 1, 0, 
              0, 
            82, 
              OPC_CheckInteger, 99|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 52, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::BLENDPSrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 7, 0, 4, 5, 6, 7, 8, 9, 
              21, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::BLENDPSrri), 0,
                    1, MVT::v4f32, 3, 0, 1, 3, 
              0, 
            82, 
              OPC_CheckInteger, 98|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 52, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::BLENDPDrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 7, 0, 4, 5, 6, 7, 8, 9, 
              21, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::BLENDPDrri), 0,
                    1, MVT::v2f64, 3, 0, 1, 3, 
              0, 
            82, 
              OPC_CheckInteger, 110|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 52, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PBLENDWrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 7, 0, 4, 5, 6, 7, 8, 9, 
              21, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PBLENDWrri), 0,
                    1, MVT::v8i16, 3, 0, 1, 3, 
              0, 
            9|128,1, 
              OPC_CheckInteger, 103|128,4, 
              OPC_MoveParent,
              OPC_Scope, 53, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::DPPSrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 7, 0, 4, 5, 6, 7, 8, 9, 
              53, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::DPPSrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 7, 2, 4, 5, 6, 7, 8, 9, 
              22, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::DPPSrri), 0,
                    1, MVT::v4f32, 3, 0, 1, 3, 
              0, 
            9|128,1, 
              OPC_CheckInteger, 102|128,4, 
              OPC_MoveParent,
              OPC_Scope, 53, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::DPPDrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 7, 0, 4, 5, 6, 7, 8, 9, 
              53, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::DPPDrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 7, 2, 4, 5, 6, 7, 8, 9, 
              22, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::DPPDrri), 0,
                    1, MVT::v2f64, 3, 0, 1, 3, 
              0, 
            9|128,1, 
              OPC_CheckInteger, 107|128,4, 
              OPC_MoveParent,
              OPC_Scope, 53, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MPSADBWrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 7, 0, 4, 5, 6, 7, 8, 9, 
              53, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MPSADBWrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 7, 2, 4, 5, 6, 7, 8, 9, 
              22, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MPSADBWrri), 0,
                    1, MVT::v16i8, 3, 0, 1, 3, 
              0, 
            73, 
              OPC_CheckInteger, 38|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CMPSSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 7, 0, 4, 5, 6, 7, 8, 9, 
              21, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CMPSSrr), 0,
                    1, MVT::v4f32, 3, 0, 1, 3, 
              0, 
            75, 
              OPC_CheckInteger, 37|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 45, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMPPSrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 7, 0, 4, 5, 6, 7, 8, 9, 
              21, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMPPSrri), 0,
                    1, MVT::v4f32, 3, 0, 1, 3, 
              0, 
            73, 
              OPC_CheckInteger, 118|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CMPSDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 7, 0, 4, 5, 6, 7, 8, 9, 
              21, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CMPSDrr), 0,
                    1, MVT::v2f64, 3, 0, 1, 3, 
              0, 
            61, 
              OPC_CheckInteger, 126|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTDQ2PSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTDQ2PSrr), 0,
                    1, MVT::v4f32, 1, 0, 
              0, 
            61, 
              OPC_CheckInteger, 125|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTDQ2PDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTDQ2PDrr), 0,
                    1, MVT::v2f64, 1, 0, 
              0, 
            75, 
              OPC_CheckInteger, 117|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 45, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMPPDrmi), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 7, 0, 4, 5, 6, 7, 8, 9, 
              21, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMPPDrri), 0,
                    1, MVT::v2f64, 3, 0, 1, 3, 
              0, 
            110, 
              OPC_CheckInteger, 31|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDSBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 32|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDSWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 33|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDUSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDUSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDUSBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 34|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDUSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDUSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PADDUSWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 73|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSUBSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSUBSBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 74|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSUBSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSUBSWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 75|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSUBUSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSUBUSBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 76|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSUBUSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSUBUSWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 50|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHUWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHUWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHUWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 49|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 51|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULUDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULUDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULUDQrr), 0,
                    1, MVT::v2i64, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 43|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMADDWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMADDWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMADDWDrr), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 35|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PAVGBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PAVGBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PAVGBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 36|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PAVGWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PAVGWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PAVGWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 47|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINUBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINUBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINUBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 46|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINSWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 45|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXUBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXUBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXUBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 44|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXSWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 52|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSADBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSADBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSADBWrr), 0,
                    1, MVT::v2i64, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 57|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSLLWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSLLWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 53|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSLLDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSLLDrr), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 56|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSLLQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSLLQrr), 0,
                    1, MVT::v2i64, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 69|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRLWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRLWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 65|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRLDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRLDrr), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 68|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRLQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRLQrr), 0,
                    1, MVT::v2i64, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 62|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRAWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRAWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 61|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRADrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRADrr), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 37|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPEQBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPEQBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 39|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPEQWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPEQWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 38|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPEQDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPEQDrr), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 40|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPGTBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPGTBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 42|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPGTWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPGTWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 41|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPGTDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPGTDrr), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 29|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PACKSSWBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PACKSSWBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 28|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PACKSSDWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PACKSSDWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 30|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v2i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PACKUSWBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PACKUSWBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            61, 
              OPC_CheckInteger, 83|128,5, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSBrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSBrr64), 0,
                    1, MVT::v8i8, 1, 0, 
              0, 
            61, 
              OPC_CheckInteger, 84|128,5, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSBrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSBrr128), 0,
                    1, MVT::v16i8, 1, 0, 
              0, 
            61, 
              OPC_CheckInteger, 87|128,5, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v4i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSWrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSWrr64), 0,
                    1, MVT::v4i16, 1, 0, 
              0, 
            61, 
              OPC_CheckInteger, 88|128,5, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSWrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSWrr128), 0,
                    1, MVT::v8i16, 1, 0, 
              0, 
            61, 
              OPC_CheckInteger, 85|128,5, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v2i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSDrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSDrr64), 0,
                    1, MVT::v2i32, 1, 0, 
              0, 
            61, 
              OPC_CheckInteger, 86|128,5, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v4i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSDrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PABSDrr128), 0,
                    1, MVT::v4i32, 1, 0, 
              0, 
            64, 
              OPC_CheckInteger, 95|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v4i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDWrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDWrr64), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 96|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDWrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDWrr128), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 91|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v2i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDDrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDDrr64), 0,
                    1, MVT::v2i32, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 92|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v4i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDDrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDDrr128), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 93|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v4i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDSWrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDSWrr64), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 94|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDSWrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHADDSWrr128), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 101|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v4i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBWrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBWrr64), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 102|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBWrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBWrr128), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 97|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v2i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBDrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBDrr64), 0,
                    1, MVT::v2i32, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 98|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v4i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBDrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBDrr128), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 99|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v4i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBSWrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBSWrr64), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 100|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBSWrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHSUBSWrr128), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 103|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMADDUBSWrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMADDUBSWrr64), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 104|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMADDUBSWrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMADDUBSWrr128), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 105|128,5, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v4i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHRSWrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v4i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHRSWrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHRSWrr64), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 106|128,5, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHRSWrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHRSWrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULHRSWrr128), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 107|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFBrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFBrr64), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 108|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFBrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSHUFBrr128), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 109|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNBrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNBrr64), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 110|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNBrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNBrr128), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 113|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v4i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNWrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNWrr64), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 114|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNWrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNWrr128), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 111|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v2i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNDrm64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNDrr64), 0,
                    1, MVT::v2i32, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 112|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v4i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNDrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 11,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PSIGNDrr128), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            81, 
              OPC_CheckInteger, 89|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 48, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_EmitNodeXForm, 5, 9,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PALIGNR64rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v1i64, 7, 0, 4, 5, 6, 7, 8, 10, 
              24, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 5, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PALIGNR64rr), 0,
                    1, MVT::v1i64, 3, 0, 1, 4, 
              0, 
            81, 
              OPC_CheckInteger, 90|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 48, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_EmitNodeXForm, 5, 9,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PALIGNR128rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 7, 0, 4, 5, 6, 7, 8, 10, 
              24, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 11,
                OPC_EmitConvertToTarget, 2,
                OPC_EmitNodeXForm, 5, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PALIGNR128rr), 0,
                    1, MVT::v2i64, 3, 0, 1, 4, 
              0, 
            72, 
              OPC_CheckInteger, 14|128,5, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ROUNDPSm_Int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 3, 4, 5, 6, 7, 8, 
              20, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ROUNDPSr_Int), 0,
                    1, MVT::v4f32, 2, 0, 2, 
              0, 
            72, 
              OPC_CheckInteger, 13|128,5, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ROUNDPDm_Int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 6, 3, 4, 5, 6, 7, 8, 
              20, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitConvertToTarget, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ROUNDPDr_Int), 0,
                    1, MVT::v2f64, 2, 0, 2, 
              0, 
            61, 
              OPC_CheckInteger, 115|128,4, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 66,
                OPC_CheckType, MVT::v8i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHMINPOSUWrm128), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PHMINPOSUWrr128), 0,
                    1, MVT::v8i16, 1, 0, 
              0, 
            110, 
              OPC_CheckInteger, 111|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPEQQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPEQQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPEQQrr), 0,
                    1, MVT::v2i64, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 108|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PACKUSDWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PACKUSDWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 120|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINSBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 121|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINSDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINSDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINSDrr), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 122|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINUDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINUDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINUDrr), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 123|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINUWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINUWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMINUWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 116|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXSBrr), 0,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 117|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXSDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXSDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXSDrr), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 118|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXUDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXUDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXUDrr), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 119|128,4, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXUWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXUWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMAXUWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              0, 
            110, 
              OPC_CheckInteger, 8|128,5, 
              OPC_MoveParent,
              OPC_Scope, 44, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
              44, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULDQrr), 0,
                    1, MVT::v2i64, 2, 0, 1, 
              0, 
            72, 
              OPC_CheckInteger, 100|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 47, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::XMM0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::BLENDVPDrm0), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::v2f64, 6, 0, 4, 5, 6, 7, 8, 
              16, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitCopyToReg, 2, X86::XMM0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::BLENDVPDrr0), 0|OPFL_FlagInput,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            72, 
              OPC_CheckInteger, 101|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 47, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::XMM0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::BLENDVPSrm0), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 4, 5, 6, 7, 8, 
              16, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitCopyToReg, 2, X86::XMM0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::BLENDVPSrr0), 0|OPFL_FlagInput,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            72, 
              OPC_CheckInteger, 109|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 47, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::XMM0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PBLENDVBrm0), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::v16i8, 6, 0, 4, 5, 6, 7, 8, 
              16, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_CheckPatternPredicate, 4,
                OPC_EmitCopyToReg, 2, X86::XMM0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PBLENDVBrr0), 0|OPFL_FlagInput,
                    1, MVT::v16i8, 2, 0, 1, 
              0, 
            64, 
              OPC_CheckInteger, 28|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPGTQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 14,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPGTQrr), 0,
                    1, MVT::v2i64, 2, 0, 1, 
              0, 
            75, 
              OPC_CheckInteger, 29|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 44, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRIrm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 4, 5, 6, 7, 8, 9, 
              22, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRIrr), 0,
                    2, MVT::i32, MVT::i32, 3, 0, 1, 3, 
              0, 
            75, 
              OPC_CheckInteger, 30|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 44, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRIArm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 4, 5, 6, 7, 8, 9, 
              22, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRIArr), 0,
                    2, MVT::i32, MVT::i32, 3, 0, 1, 3, 
              0, 
            75, 
              OPC_CheckInteger, 31|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 44, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRICrm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 4, 5, 6, 7, 8, 9, 
              22, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRICrr), 0,
                    2, MVT::i32, MVT::i32, 3, 0, 1, 3, 
              0, 
            75, 
              OPC_CheckInteger, 32|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 44, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRIOrm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 4, 5, 6, 7, 8, 9, 
              22, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRIOrr), 0,
                    2, MVT::i32, MVT::i32, 3, 0, 1, 3, 
              0, 
            75, 
              OPC_CheckInteger, 33|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 44, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRISrm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 4, 5, 6, 7, 8, 9, 
              22, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRISrr), 0,
                    2, MVT::i32, MVT::i32, 3, 0, 1, 3, 
              0, 
            75, 
              OPC_CheckInteger, 34|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 44, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRIZrm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 4, 5, 6, 7, 8, 9, 
              22, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRIZrr), 0,
                    2, MVT::i32, MVT::i32, 3, 0, 1, 3, 
              0, 
            90, 
              OPC_CheckInteger, 21|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_Scope, 51, 
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                OPC_EmitMergeInputChains, 1, 2, 
                OPC_EmitConvertToTarget, 5,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 4, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRIrm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 6, 7, 8, 9, 10, 11, 
              29, 
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 4,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 3, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRIrr), 0|OPFL_FlagInput,
                    2, MVT::i32, MVT::i32, 3, 0, 2, 5, 
              0, 
            90, 
              OPC_CheckInteger, 22|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_Scope, 51, 
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                OPC_EmitMergeInputChains, 1, 2, 
                OPC_EmitConvertToTarget, 5,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 4, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRIArm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 6, 7, 8, 9, 10, 11, 
              29, 
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 4,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 3, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRIArr), 0|OPFL_FlagInput,
                    2, MVT::i32, MVT::i32, 3, 0, 2, 5, 
              0, 
            90, 
              OPC_CheckInteger, 23|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_Scope, 51, 
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                OPC_EmitMergeInputChains, 1, 2, 
                OPC_EmitConvertToTarget, 5,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 4, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRICrm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 6, 7, 8, 9, 10, 11, 
              29, 
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 4,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 3, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRICrr), 0|OPFL_FlagInput,
                    2, MVT::i32, MVT::i32, 3, 0, 2, 5, 
              0, 
            90, 
              OPC_CheckInteger, 24|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_Scope, 51, 
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                OPC_EmitMergeInputChains, 1, 2, 
                OPC_EmitConvertToTarget, 5,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 4, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRIOrm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 6, 7, 8, 9, 10, 11, 
              29, 
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 4,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 3, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRIOrr), 0|OPFL_FlagInput,
                    2, MVT::i32, MVT::i32, 3, 0, 2, 5, 
              0, 
            90, 
              OPC_CheckInteger, 25|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_Scope, 51, 
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                OPC_EmitMergeInputChains, 1, 2, 
                OPC_EmitConvertToTarget, 5,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 4, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRISrm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 6, 7, 8, 9, 10, 11, 
              29, 
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 4,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 3, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRISrr), 0|OPFL_FlagInput,
                    2, MVT::i32, MVT::i32, 3, 0, 2, 5, 
              0, 
            90, 
              OPC_CheckInteger, 26|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_Scope, 51, 
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                OPC_EmitMergeInputChains, 1, 2, 
                OPC_EmitConvertToTarget, 5,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 4, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRIZrm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 7, 0, 6, 7, 8, 9, 10, 11, 
              29, 
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 4,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 3, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRIZrr), 0|OPFL_FlagInput,
                    2, MVT::i32, MVT::i32, 3, 0, 2, 5, 
              0, 
            106, 
              OPC_CheckInteger, 73|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDSBrr), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 74|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDSWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 75|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDUSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDUSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDUSBrr), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 76|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDUSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDUSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PADDUSWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 111|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSUBSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSUBSBrr), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 112|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSUBSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSUBSWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 113|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSUBUSBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSUBUSBrr), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 114|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSUBUSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSUBUSWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 91|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULHWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULHWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULHWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 92|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULHUWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULHUWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULHUWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 93|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULUDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULUDQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULUDQrr), 0,
                    1, MVT::v2i32, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 85|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMADDWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMADDWDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMADDWDrr), 0,
                    1, MVT::v2i32, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 77|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PAVGBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PAVGBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PAVGBrr), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 78|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PAVGWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PAVGWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PAVGWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 89|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMINUBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMINUBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMINUBrr), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 88|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMINSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMINSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMINSWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 87|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMAXUBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMAXUBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMAXUBrr), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 86|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMAXSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMAXSWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMAXSWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            106, 
              OPC_CheckInteger, 94|128,3, 
              OPC_MoveParent,
              OPC_Scope, 42, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSADBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              42, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSADBWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSADBWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 107|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRLWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRLWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 105|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRLDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRLDrr), 0,
                    1, MVT::v2i32, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 106|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRLQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v1i64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRLQrr), 0,
                    1, MVT::v1i64, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 97|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSLLWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSLLWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 95|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSLLDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSLLDrr), 0,
                    1, MVT::v2i32, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 96|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSLLQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v1i64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSLLQrr), 0,
                    1, MVT::v1i64, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 102|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRAWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRAWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 101|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRADrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRADrr), 0,
                    1, MVT::v2i32, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 79|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPEQBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPEQBrr), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 81|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPEQWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPEQWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 80|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPEQDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPEQDrr), 0,
                    1, MVT::v2i32, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 82|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPGTBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPGTBrr), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 84|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPGTWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPGTWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 83|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPGTDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PCMPGTDrr), 0,
                    1, MVT::v2i32, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 71|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PACKSSWBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PACKSSWBrr), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 70|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PACKSSDWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PACKSSDWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            62, 
              OPC_CheckInteger, 72|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 41, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckType, MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PACKUSWBrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i8, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PACKUSWBrr), 0,
                    1, MVT::v8i8, 2, 0, 1, 
              0, 
            73, 
              OPC_CheckInteger, 35|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 43, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitConvertToTarget, 3,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRM128MEM), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v16i8, 7, 0, 4, 5, 6, 7, 8, 9, 
              21, 
                OPC_RecordChild2,
                OPC_RecordChild3,
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPISTRM128REG), 0,
                    1, MVT::v16i8, 3, 0, 1, 3, 
              0, 
            88, 
              OPC_CheckInteger, 27|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_Scope, 50, 
                OPC_MoveChild, 3,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/3,
                OPC_EmitMergeInputChains, 1, 2, 
                OPC_EmitConvertToTarget, 5,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 4, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRM128MEM), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::v16i8, 7, 0, 6, 7, 8, 9, 10, 11, 
              28, 
                OPC_RecordChild3,
                OPC_RecordChild4,
                OPC_RecordChild5,
                OPC_MoveChild, 5,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_EmitConvertToTarget, 4,
                OPC_EmitCopyToReg, 1, X86::EAX,
                OPC_EmitCopyToReg, 3, X86::EDX,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PCMPESTRM128REG), 0|OPFL_FlagInput,
                    1, MVT::v16i8, 3, 0, 2, 5, 
              0, 
            52, 
              OPC_CheckInteger, 4|128,4, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSD2SI64rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSD2SI64rr), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            52, 
              OPC_CheckInteger, 12|128,4, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTSD2SI64rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTSD2SI64rr), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            57, 
              OPC_CheckInteger, 7|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSI2SD64rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSI2SD64rr), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            57, 
              OPC_CheckInteger, 50|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSI2SS64rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSI2SS64rr), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            52, 
              OPC_CheckInteger, 52|128,5, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSS2SI64rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSS2SI64rr), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            52, 
              OPC_CheckInteger, 56|128,5, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTSS2SI64rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTSS2SI64rr), 0,
                    1, MVT::i64, 1, 0, 
              0, 
            52, 
              OPC_CheckInteger, 51|128,5, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSS2SIrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSS2SIrr), 0,
                    1, MVT::i32, 1, 0, 
              0, 
            52, 
              OPC_CheckInteger, 48|128,5, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPS2PIrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPS2PIrr), 0,
                    1, MVT::v2i32, 1, 0, 
              0, 
            52, 
              OPC_CheckInteger, 54|128,5, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTPS2PIrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTPS2PIrr), 0,
                    1, MVT::v2i32, 1, 0, 
              0, 
            55, 
              OPC_CheckInteger, 47|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 34, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPI2PSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPI2PSrr), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            52, 
              OPC_CheckInteger, 55|128,5, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTSS2SIrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTSS2SIrr), 0,
                    1, MVT::i32, 1, 0, 
              0, 
            55, 
              OPC_CheckInteger, 49|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 34, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSI2SSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSI2SSrr), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            57, 
              OPC_CheckInteger, 60|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MAXPSrm_Int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MAXPSrr_Int), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            57, 
              OPC_CheckInteger, 62|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MINPSrm_Int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MINPSrr_Int), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            54, 
              OPC_CheckInteger, 72|128,5, 
              OPC_MoveParent,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SQRTPSm_Int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SQRTPSr_Int), 0,
                    1, MVT::v4f32, 1, 0, 
              0, 
            54, 
              OPC_CheckInteger, 69|128,5, 
              OPC_MoveParent,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::RSQRTPSm_Int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::RSQRTPSr_Int), 0,
                    1, MVT::v4f32, 1, 0, 
              0, 
            54, 
              OPC_CheckInteger, 67|128,5, 
              OPC_MoveParent,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::RCPPSm_Int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::RCPPSr_Int), 0,
                    1, MVT::v4f32, 1, 0, 
              0, 
            52, 
              OPC_CheckInteger, 3|128,4, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSD2SIrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSD2SIrr), 0,
                    1, MVT::i32, 1, 0, 
              0, 
            54, 
              OPC_CheckInteger, 45|128,5, 
              OPC_MoveParent,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPD2PIrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPD2PIrr), 0,
                    1, MVT::v2i32, 1, 0, 
              0, 
            54, 
              OPC_CheckInteger, 53|128,5, 
              OPC_MoveParent,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTPD2PIrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTPD2PIrr), 0,
                    1, MVT::v2i32, 1, 0, 
              0, 
            52, 
              OPC_CheckInteger, 46|128,5, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPI2PDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPI2PDrr), 0,
                    1, MVT::v2f64, 1, 0, 
              0, 
            52, 
              OPC_CheckInteger, 11|128,4, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTSD2SIrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTSD2SIrr), 0,
                    1, MVT::i32, 1, 0, 
              0, 
            57, 
              OPC_CheckInteger, 18|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MAXPDrm_Int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MAXPDrr_Int), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            57, 
              OPC_CheckInteger, 21|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MINPDrm_Int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MINPDrr_Int), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            54, 
              OPC_CheckInteger, 1|128,4, 
              OPC_MoveParent,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPS2DQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPS2DQrr), 0,
                    1, MVT::v4i32, 1, 0, 
              0, 
            54, 
              OPC_CheckInteger, 10|128,4, 
              OPC_MoveParent,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTPS2DQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTPS2DQrr), 0,
                    1, MVT::v4i32, 1, 0, 
              0, 
            54, 
              OPC_CheckInteger, 127|128,3, 
              OPC_MoveParent,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPD2DQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPD2DQrr), 0,
                    1, MVT::v4i32, 1, 0, 
              0, 
            54, 
              OPC_CheckInteger, 9|128,4, 
              OPC_MoveParent,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTPD2DQrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTTPD2DQrr), 0,
                    1, MVT::v4i32, 1, 0, 
              0, 
            52, 
              OPC_CheckInteger, 2|128,4, 
              OPC_MoveParent,
              OPC_Scope, 33, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPS2PDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPS2PDrr), 0,
                    1, MVT::v2f64, 1, 0, 
              0, 
            54, 
              OPC_CheckInteger, 0|128,4, 
              OPC_MoveParent,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPD2PSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTPD2PSrr), 0,
                    1, MVT::v4f32, 1, 0, 
              0, 
            55, 
              OPC_CheckInteger, 6|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 34, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSI2SDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSI2SDrr), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            55, 
              OPC_CheckInteger, 5|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 34, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSD2SSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSD2SSrr), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            55, 
              OPC_CheckInteger, 8|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 34, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSS2SDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::Int_CVTSS2SDrr), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            54, 
              OPC_CheckInteger, 77|128,4, 
              OPC_MoveParent,
              OPC_Scope, 35, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SQRTPDm_Int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 5, 2, 3, 4, 5, 6, 
              11, 
                OPC_RecordChild1,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SQRTPDr_Int), 0,
                    1, MVT::v2f64, 1, 0, 
              0, 
            57, 
              OPC_CheckInteger, 90|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ADDSUBPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 9,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ADDSUBPSrr), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            57, 
              OPC_CheckInteger, 89|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ADDSUBPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 9,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ADDSUBPDrr), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            57, 
              OPC_CheckInteger, 92|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::HADDPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 9,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::HADDPSrr), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            57, 
              OPC_CheckInteger, 91|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::HADDPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 9,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::HADDPDrr), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            57, 
              OPC_CheckInteger, 94|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::HSUBPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4f32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 9,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::HSUBPSrr), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            57, 
              OPC_CheckInteger, 93|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 36, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 9,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::HSUBPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2f64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 9,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::HSUBPDrr), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            96, 
              OPC_CheckInteger, 9|128,5, 
              OPC_MoveParent,
              OPC_Scope, 37, 
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULLDrm_int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              37, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULLDrm_int), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 2, 3, 4, 5, 6, 7, 
              13, 
                OPC_RecordChild1,
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULLDrr_int), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              0, 
            55, 
              OPC_CheckInteger, 20|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 34, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CRC32m8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 14,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CRC32r8), 0,
                    1, MVT::i32, 2, 0, 1, 
              0, 
            55, 
              OPC_CheckInteger, 17|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 34, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CRC32m16), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 14,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CRC32r16), 0,
                    1, MVT::i32, 2, 0, 1, 
              0, 
            55, 
              OPC_CheckInteger, 18|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 34, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CRC32m32), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 14,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CRC32r32), 0,
                    1, MVT::i32, 2, 0, 1, 
              0, 
            55, 
              OPC_CheckInteger, 19|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_Scope, 34, 
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 14,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CRC64m64), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 3, 4, 5, 6, 7, 
              12, 
                OPC_RecordChild2,
                OPC_CheckPatternPredicate, 14,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CRC64r64), 0,
                    1, MVT::i64, 2, 0, 1, 
              0, 
            52, 
              OPC_CheckInteger, 16|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MoveChild, 3,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 4,
              OPC_Scope, 22, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 8, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ROUNDSSm_Int), 0|OPFL_Chain,
                    1, MVT::v4f32, 7, 0, 3, 4, 5, 6, 7, 9, 
              12, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ROUNDSSr_Int), 0,
                    1, MVT::v4f32, 3, 0, 1, 3, 
              0, 
            52, 
              OPC_CheckInteger, 15|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MoveChild, 3,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 4,
              OPC_Scope, 22, 
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 8, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ROUNDSDm_Int), 0|OPFL_Chain,
                    1, MVT::v2f64, 7, 0, 3, 4, 5, 6, 7, 9, 
              12, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ROUNDSDr_Int), 0,
                    1, MVT::v2f64, 3, 0, 1, 3, 
              0, 
            40, 
              OPC_CheckInteger, 36|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 0,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ADDSSrm_Int), 0|OPFL_Chain,
                    1, MVT::v4f32, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ADDSSrr_Int), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            40, 
              OPC_CheckInteger, 66|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 0,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MULSSrm_Int), 0|OPFL_Chain,
                    1, MVT::v4f32, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MULSSrr_Int), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            40, 
              OPC_CheckInteger, 76|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 0,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SUBSSrm_Int), 0|OPFL_Chain,
                    1, MVT::v4f32, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SUBSSrr_Int), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            40, 
              OPC_CheckInteger, 57|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 0,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::DIVSSrm_Int), 0|OPFL_Chain,
                    1, MVT::v4f32, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::DIVSSrr_Int), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            40, 
              OPC_CheckInteger, 61|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 0,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MAXSSrm_Int), 0|OPFL_Chain,
                    1, MVT::v4f32, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MAXSSrr_Int), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            40, 
              OPC_CheckInteger, 63|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 0,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MINSSrm_Int), 0|OPFL_Chain,
                    1, MVT::v4f32, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MINSSrr_Int), 0,
                    1, MVT::v4f32, 2, 0, 1, 
              0, 
            37, 
              OPC_CheckInteger, 73|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckPatternPredicate, 0,
              OPC_Scope, 18, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                OPC_EmitMergeInputChains, 1, 6, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SQRTSSm_Int), 0|OPFL_Chain,
                    1, MVT::v4f32, 5, 1, 2, 3, 4, 5, 
              8, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SQRTSSr_Int), 0,
                    1, MVT::v4f32, 1, 0, 
              0, 
            37, 
              OPC_CheckInteger, 70|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckPatternPredicate, 0,
              OPC_Scope, 18, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                OPC_EmitMergeInputChains, 1, 6, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::RSQRTSSm_Int), 0|OPFL_Chain,
                    1, MVT::v4f32, 5, 1, 2, 3, 4, 5, 
              8, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::RSQRTSSr_Int), 0,
                    1, MVT::v4f32, 1, 0, 
              0, 
            37, 
              OPC_CheckInteger, 68|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckPatternPredicate, 0,
              OPC_Scope, 18, 
                OPC_CheckComplexPat, /*CP*/1, /*#*/0,
                OPC_EmitMergeInputChains, 1, 6, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::RCPSSm_Int), 0|OPFL_Chain,
                    1, MVT::v4f32, 5, 1, 2, 3, 4, 5, 
              8, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::RCPSSr_Int), 0,
                    1, MVT::v4f32, 1, 0, 
              0, 
            40, 
              OPC_CheckInteger, 115|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 1,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ADDSDrm_Int), 0|OPFL_Chain,
                    1, MVT::v2f64, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ADDSDrr_Int), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            40, 
              OPC_CheckInteger, 27|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 1,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MULSDrm_Int), 0|OPFL_Chain,
                    1, MVT::v2f64, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MULSDrr_Int), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            40, 
              OPC_CheckInteger, 82|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 1,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SUBSDrm_Int), 0|OPFL_Chain,
                    1, MVT::v2f64, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SUBSDrr_Int), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            40, 
              OPC_CheckInteger, 13|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 1,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::DIVSDrm_Int), 0|OPFL_Chain,
                    1, MVT::v2f64, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::DIVSDrr_Int), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            40, 
              OPC_CheckInteger, 19|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 1,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MAXSDrm_Int), 0|OPFL_Chain,
                    1, MVT::v2f64, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MAXSDrr_Int), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            40, 
              OPC_CheckInteger, 22|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_CheckPatternPredicate, 1,
              OPC_Scope, 19, 
                OPC_CheckComplexPat, /*CP*/2, /*#*/1,
                OPC_EmitMergeInputChains, 1, 7, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MINSDrm_Int), 0|OPFL_Chain,
                    1, MVT::v2f64, 6, 0, 2, 3, 4, 5, 6, 
              9, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MINSDrr_Int), 0,
                    1, MVT::v2f64, 2, 0, 1, 
              0, 
            37, 
              OPC_CheckInteger, 78|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckPatternPredicate, 1,
              OPC_Scope, 18, 
                OPC_CheckComplexPat, /*CP*/2, /*#*/0,
                OPC_EmitMergeInputChains, 1, 6, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SQRTSDm_Int), 0|OPFL_Chain,
                    1, MVT::v2f64, 5, 1, 2, 3, 4, 5, 
              8, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::SQRTSDr_Int), 0,
                    1, MVT::v2f64, 1, 0, 
              0, 
            24, 
              OPC_CheckInteger, 60|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSLLWri), 0,
                  1, MVT::v8i16, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 58|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSLLDri), 0,
                  1, MVT::v4i32, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 59|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSLLQri), 0,
                  1, MVT::v2i64, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 72|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRLWri), 0,
                  1, MVT::v8i16, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 70|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRLDri), 0,
                  1, MVT::v4i32, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 71|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRLQri), 0,
                  1, MVT::v2i64, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 64|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRAWri), 0,
                  1, MVT::v8i16, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 63|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRADri), 0,
                  1, MVT::v4i32, 2, 0, 2, 
            27, 
              OPC_CheckInteger, 54|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 5, 2,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSLLDQri), 0,
                  1, MVT::v2i64, 2, 0, 3, 
            27, 
              OPC_CheckInteger, 66|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_EmitNodeXForm, 5, 2,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRLDQri), 0,
                  1, MVT::v2i64, 2, 0, 3, 
            24, 
              OPC_CheckInteger, 55|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSLLDQri), 0,
                  1, MVT::v2i64, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 67|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 1,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PSRLDQri), 0,
                  1, MVT::v2i64, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 105|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_RecordChild3,
              OPC_MoveChild, 3,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_EmitConvertToTarget, 2,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::INSERTPSrr), 0,
                  1, MVT::v4f32, 3, 0, 1, 3, 
            24, 
              OPC_CheckInteger, 110|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 8,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRLWri), 0,
                  1, MVT::v4i16, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 108|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 8,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRLDri), 0,
                  1, MVT::v2i32, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 109|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 8,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRLQri), 0,
                  1, MVT::v1i64, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 100|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 8,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSLLWri), 0,
                  1, MVT::v4i16, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 98|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 8,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSLLDri), 0,
                  1, MVT::v2i32, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 99|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 8,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSLLQri), 0,
                  1, MVT::v1i64, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 104|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 8,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRAWri), 0,
                  1, MVT::v4i16, 2, 0, 2, 
            24, 
              OPC_CheckInteger, 103|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 8,
              OPC_EmitConvertToTarget, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PSRADri), 0,
                  1, MVT::v2i32, 2, 0, 2, 
            15, 
              OPC_CheckInteger, 64|128,5, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckPatternPredicate, 0,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVMSKPSrr), 0,
                  1, MVT::i32, 1, 0, 
            15, 
              OPC_CheckInteger, 23|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckPatternPredicate, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVMSKPDrr), 0,
                  1, MVT::i32, 1, 0, 
            15, 
              OPC_CheckInteger, 48|128,4, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckPatternPredicate, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PMOVMSKBrr), 0,
                  1, MVT::i32, 1, 0, 
            15, 
              OPC_CheckInteger, 90|128,3, 
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckPatternPredicate, 8,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMOVMSKBrr), 0,
                  1, MVT::i32, 1, 0, 
            0, 
          65|128,32,  ISD::AND,
            OPC_Scope, 118|128,14, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 33|128,7,  ISD::XOR,
                OPC_Scope, 45|128,1, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::BIT_CONVERT,
                  OPC_Scope, 57, 
                    OPC_RecordChild0,
                    OPC_CheckChild0Type, MVT::v4f32,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_CheckType, MVT::v4i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::LOAD,
                    OPC_RecordMemRef,
                    OPC_RecordNode,
                    OPC_CheckFoldableChainNode,
                    OPC_RecordChild1,
                    OPC_CheckPredicate, 2,
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 23,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 0,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                  57, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_CheckType, MVT::v4i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_RecordChild0,
                    OPC_CheckChild0Type, MVT::v4f32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::LOAD,
                    OPC_RecordMemRef,
                    OPC_RecordNode,
                    OPC_CheckFoldableChainNode,
                    OPC_RecordChild1,
                    OPC_CheckPredicate, 2,
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 23,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 0,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                  50, 
                    OPC_RecordChild0,
                    OPC_CheckChild0Type, MVT::v2f64,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::LOAD,
                    OPC_RecordMemRef,
                    OPC_RecordNode,
                    OPC_CheckFoldableChainNode,
                    OPC_RecordChild1,
                    OPC_CheckPredicate, 2,
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 23,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                  0, 
                12|128,2, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::BIT_CONVERT,
                  OPC_MoveChild, 0,
                  OPC_SwitchOpcode , 44|128,1,  ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_SwitchType , 41,  MVT::v4i32,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_CheckPredicate, 8,
                      OPC_CheckPredicate, 23,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v2i64,
                      OPC_CheckPatternPredicate, 1,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                    41,  MVT::v8i16,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_CheckPredicate, 8,
                      OPC_CheckPredicate, 23,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v2i64,
                      OPC_CheckPatternPredicate, 1,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                    41,  MVT::v16i8,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_CheckPredicate, 8,
                      OPC_CheckPredicate, 23,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v2i64,
                      OPC_CheckPatternPredicate, 1,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                    37,  MVT::v2i32,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_CheckPredicate, 8,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v1i64,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v1i64, 6, 0, 3, 4, 5, 6, 7, 
                    0, 
                  82,  ISD::BIT_CONVERT,
                    OPC_CheckPredicate, 68,
                    OPC_SwitchType , 37,  MVT::v4i16,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_CheckPredicate, 8,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v1i64,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v1i64, 6, 0, 3, 4, 5, 6, 7, 
                    37,  MVT::v8i8,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::LOAD,
                      OPC_RecordMemRef,
                      OPC_RecordNode,
                      OPC_CheckFoldableChainNode,
                      OPC_RecordChild1,
                      OPC_CheckPredicate, 2,
                      OPC_CheckPredicate, 8,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v1i64,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                      OPC_EmitMergeInputChains, 1, 1, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v1i64, 6, 0, 3, 4, 5, 6, 7, 
                    0, 
                  0, 
                72|128,2, 
                  OPC_MoveChild, 0,
                  OPC_SwitchOpcode , 50,  ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_RecordChild0,
                    OPC_CheckChild0Type, MVT::v2f64,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::LOAD,
                    OPC_RecordMemRef,
                    OPC_RecordNode,
                    OPC_CheckFoldableChainNode,
                    OPC_RecordChild1,
                    OPC_CheckPredicate, 2,
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 23,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                  13|128,2,  ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_SwitchOpcode , 48|128,1,  ISD::BUILD_VECTOR,
                      OPC_CheckPredicate, 67,
                      OPC_SwitchType , 42,  MVT::v4i32,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 8,
                        OPC_CheckPredicate, 23,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i64,
                        OPC_CheckPatternPredicate, 1,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 1, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                      42,  MVT::v8i16,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 8,
                        OPC_CheckPredicate, 23,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i64,
                        OPC_CheckPatternPredicate, 1,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 1, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                      42,  MVT::v16i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 8,
                        OPC_CheckPredicate, 23,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i64,
                        OPC_CheckPatternPredicate, 1,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 1, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                      38,  MVT::v2i32,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 8,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v1i64,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 1, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::v1i64, 6, 0, 3, 4, 5, 6, 7, 
                      0, 
                    84,  ISD::BIT_CONVERT,
                      OPC_CheckPredicate, 68,
                      OPC_SwitchType , 38,  MVT::v4i16,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 8,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v1i64,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 1, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::v1i64, 6, 0, 3, 4, 5, 6, 7, 
                      38,  MVT::v8i8,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_RecordChild1,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::LOAD,
                        OPC_RecordMemRef,
                        OPC_RecordNode,
                        OPC_CheckFoldableChainNode,
                        OPC_RecordChild1,
                        OPC_CheckPredicate, 2,
                        OPC_CheckPredicate, 8,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v1i64,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                        OPC_EmitMergeInputChains, 1, 1, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::v1i64, 6, 0, 3, 4, 5, 6, 7, 
                      0, 
                    0, 
                  0, 
                75, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::BUILD_VECTOR,
                  OPC_CheckPredicate, 67,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_Scope, 26, 
                    OPC_CheckPredicate, 23,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                  24, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v1i64,
                    OPC_CheckPatternPredicate, 8,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v1i64, 6, 0, 3, 4, 5, 6, 7, 
                  0, 
                75, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::BUILD_VECTOR,
                  OPC_CheckPredicate, 67,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_Scope, 26, 
                    OPC_CheckPredicate, 23,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                  24, 
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v1i64,
                    OPC_CheckPatternPredicate, 8,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v1i64, 6, 0, 3, 4, 5, 6, 7, 
                  0, 
                0, 
              114|128,6,  ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_Scope, 34|128,3, 
                  OPC_CheckPredicate, 23,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::XOR,
                  OPC_Scope, 39|128,1, 
                    OPC_MoveChild, 0,
                    OPC_SwitchOpcode , 124,  ISD::BIT_CONVERT,
                      OPC_Scope, 42, 
                        OPC_RecordChild0,
                        OPC_CheckChild0Type, MVT::v4f32,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::BUILD_VECTOR,
                        OPC_CheckPredicate, 67,
                        OPC_CheckType, MVT::v4i32,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i64,
                        OPC_CheckPatternPredicate, 0,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                        OPC_EmitMergeInputChains, 1, 0, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                      42, 
                        OPC_MoveChild, 0,
                        OPC_CheckOpcode, ISD::BUILD_VECTOR,
                        OPC_CheckPredicate, 67,
                        OPC_CheckType, MVT::v4i32,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::BIT_CONVERT,
                        OPC_RecordChild0,
                        OPC_CheckChild0Type, MVT::v4f32,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i64,
                        OPC_CheckPatternPredicate, 0,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                        OPC_EmitMergeInputChains, 1, 0, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                      35, 
                        OPC_RecordChild0,
                        OPC_CheckChild0Type, MVT::v2f64,
                        OPC_MoveParent,
                        OPC_MoveChild, 1,
                        OPC_CheckOpcode, ISD::BUILD_VECTOR,
                        OPC_CheckPredicate, 67,
                        OPC_MoveParent,
                        OPC_MoveParent,
                        OPC_CheckType, MVT::v2i64,
                        OPC_CheckPatternPredicate, 1,
                        OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                        OPC_EmitMergeInputChains, 1, 0, 
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                            1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                      0, 
                    35,  ISD::BUILD_VECTOR,
                      OPC_CheckPredicate, 67,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckOpcode, ISD::BIT_CONVERT,
                      OPC_RecordChild0,
                      OPC_CheckChild0Type, MVT::v2f64,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::v2i64,
                      OPC_CheckPatternPredicate, 1,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                    0, 
                  39, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_CheckType, MVT::v4i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                  39, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_CheckType, MVT::v4i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                  39, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_CheckType, MVT::v8i16,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                  39, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_CheckType, MVT::v8i16,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                  39, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_CheckType, MVT::v16i8,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                  39, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_CheckType, MVT::v16i8,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                  0, 
                107|128,1, 
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::XOR,
                  OPC_Scope, 37, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_CheckType, MVT::v2i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v1i64,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v1i64, 6, 2, 3, 4, 5, 6, 7, 
                  37, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_CheckType, MVT::v2i32,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v1i64,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v1i64, 6, 2, 3, 4, 5, 6, 7, 
                  37, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_CheckPredicate, 68,
                    OPC_CheckType, MVT::v4i16,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v1i64,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v1i64, 6, 2, 3, 4, 5, 6, 7, 
                  37, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_CheckPredicate, 68,
                    OPC_CheckType, MVT::v4i16,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v1i64,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v1i64, 6, 2, 3, 4, 5, 6, 7, 
                  37, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_CheckPredicate, 68,
                    OPC_CheckType, MVT::v8i8,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v1i64,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v1i64, 6, 2, 3, 4, 5, 6, 7, 
                  37, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_CheckPredicate, 68,
                    OPC_CheckType, MVT::v8i8,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v1i64,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v1i64, 6, 2, 3, 4, 5, 6, 7, 
                  0, 
                75, 
                  OPC_CheckPredicate, 23,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::XOR,
                  OPC_Scope, 32, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                  32, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                  0, 
                73, 
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::XOR,
                  OPC_Scope, 32, 
                    OPC_RecordChild0,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v1i64,
                    OPC_CheckPatternPredicate, 8,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v1i64, 6, 2, 3, 4, 5, 6, 7, 
                  32, 
                    OPC_MoveChild, 0,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v1i64,
                    OPC_CheckPatternPredicate, 8,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v1i64, 6, 2, 3, 4, 5, 6, 7, 
                  0, 
                64, 
                  OPC_CheckPredicate, 23,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::BIT_CONVERT,
                  OPC_RecordChild0,
                  OPC_Scope, 26, 
                    OPC_CheckChild0Type, MVT::v4f32,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 0,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                  26, 
                    OPC_CheckChild0Type, MVT::v2f64,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                  0, 
                0, 
              87,  ISD::BIT_CONVERT,
                OPC_RecordChild0,
                OPC_Scope, 41, 
                  OPC_CheckChild0Type, MVT::v4f32,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 23,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 0,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                41, 
                  OPC_CheckChild0Type, MVT::v2f64,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 23,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDPDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                0, 
              0, 
            46|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_Scope, 27, 
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_CheckType, MVT::i8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::AND8rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i8, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              25, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i16, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              25, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              80, 
                OPC_CheckPredicate, 8,
                OPC_Scope, 23, 
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64rm), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i64, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
                26, 
                  OPC_CheckPredicate, 23,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 6, 0, 3, 4, 5, 6, 7, 
                24, 
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v1i64,
                  OPC_CheckPatternPredicate, 8,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v1i64, 6, 0, 3, 4, 5, 6, 7, 
                0, 
              0, 
            51|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_Scope, 28, 
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::AND8rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i8, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
              26, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i16, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
              26, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
              83, 
                OPC_CheckPredicate, 8,
                OPC_Scope, 24, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::i64,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64rm), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i64, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
                27, 
                  OPC_CheckPredicate, 23,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v2i64, 6, 2, 3, 4, 5, 6, 7, 
                25, 
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v1i64,
                  OPC_CheckPatternPredicate, 8,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDrm), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::v1i64, 6, 2, 3, 4, 5, 6, 7, 
                0, 
              0, 
            16|128,1, 
              OPC_CheckAndImm, 127|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::SRL,
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckInteger, 8, 
              OPC_CheckType, MVT::i8,
              OPC_MoveParent,
              OPC_CheckPredicate, 15,
              OPC_MoveParent,
              OPC_SwitchType , 72,  MVT::i32,
                OPC_Scope, 34, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, X86::GR32_ABCDRegClassID,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                      1, MVT::i32, 2, 0, 1, 
                  OPC_EmitInteger, MVT::i32, 2, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i8, 2, 2, 3, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rr8), 0,
                      1, MVT::i32, 1, 4, 
                34, 
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, X86::GR32_ABCDRegClassID,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                      1, MVT::i32, 2, 0, 1, 
                  OPC_EmitInteger, MVT::i32, 2, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i8, 2, 2, 3, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32_NOREXrr8), 0,
                      1, MVT::i32, 1, 4, 
                0, 
              48,  MVT::i64,
                OPC_EmitInteger, MVT::i64, 0, 
                OPC_EmitInteger, MVT::i32, X86::GR64_ABCDRegClassID,
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                    1, MVT::i64, 2, 0, 2, 
                OPC_EmitInteger, MVT::i32, 2, 
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::i8, 2, 3, 4, 
                OPC_EmitNode, TARGET_OPCODE(X86::MOVZX32_NOREXrr8), 0,
                    1, MVT::i32, 1, 5, 
                OPC_EmitInteger, MVT::i32, 4, 
                OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::SUBREG_TO_REG), 0,
                    1, MVT::i64, 3, 1, 6, 7, 
              0, 
            73|128,2, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 126|128,1,  ISD::XOR,
                OPC_Scope, 74, 
                  OPC_MoveChild, 0,
                  OPC_SwitchOpcode , 33,  ISD::BIT_CONVERT,
                    OPC_RecordChild0,
                    OPC_CheckChild0Type, MVT::v2f64,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_RecordChild0,
                    OPC_CheckChild0Type, MVT::v2f64,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPDrr), 0,
                        1, MVT::v2i64, 2, 0, 1, 
                  33,  ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_RecordChild0,
                    OPC_CheckChild0Type, MVT::v2f64,
                    OPC_MoveParent,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::BIT_CONVERT,
                    OPC_RecordChild0,
                    OPC_CheckChild0Type, MVT::v2f64,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::v2i64,
                    OPC_CheckPatternPredicate, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPDrr), 0,
                        1, MVT::v2i64, 2, 0, 1, 
                  0, 
                16|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::BIT_CONVERT,
                  OPC_MoveChild, 0,
                  OPC_SwitchOpcode , 93,  ISD::BUILD_VECTOR,
                    OPC_CheckPredicate, 67,
                    OPC_SwitchType , 32,  MVT::v4i32,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_CheckType, MVT::v2i64,
                      OPC_Scope, 11, 
                        OPC_CheckPatternPredicate, 0,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPSrr), 0,
                            1, MVT::v2i64, 2, 0, 1, 
                      11, 
                        OPC_CheckPatternPredicate, 1,
                        OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                            1, MVT::v2i64, 2, 0, 1, 
                      0, 
                    17,  MVT::v8i16,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_CheckType, MVT::v2i64,
                      OPC_CheckPatternPredicate, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                          1, MVT::v2i64, 2, 0, 1, 
                    17,  MVT::v16i8,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_CheckType, MVT::v2i64,
                      OPC_CheckPatternPredicate, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                          1, MVT::v2i64, 2, 0, 1, 
                    15,  MVT::v2i32,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_CheckType, MVT::v1i64,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                          1, MVT::v1i64, 2, 0, 1, 
                    0, 
                  38,  ISD::BIT_CONVERT,
                    OPC_CheckPredicate, 68,
                    OPC_SwitchType , 15,  MVT::v4i16,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_CheckType, MVT::v1i64,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                          1, MVT::v1i64, 2, 0, 1, 
                    15,  MVT::v8i8,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_MoveParent,
                      OPC_RecordChild1,
                      OPC_CheckType, MVT::v1i64,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                          1, MVT::v1i64, 2, 0, 1, 
                    0, 
                  0, 
                30, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::BIT_CONVERT,
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::BUILD_VECTOR,
                  OPC_CheckPredicate, 67,
                  OPC_CheckType, MVT::v4i32,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPSrr), 0,
                      1, MVT::v2i64, 2, 0, 1, 
                0, 
              66,  ISD::BIT_CONVERT,
                OPC_RecordChild0,
                OPC_CheckChild0Type, MVT::v2f64,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::XOR,
                OPC_MoveChild, 0,
                OPC_SwitchOpcode , 25,  ISD::BIT_CONVERT,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2f64,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::BUILD_VECTOR,
                  OPC_CheckPredicate, 67,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPDrr), 0,
                      1, MVT::v2i64, 2, 1, 0, 
                25,  ISD::BUILD_VECTOR,
                  OPC_CheckPredicate, 67,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::BIT_CONVERT,
                  OPC_RecordChild0,
                  OPC_CheckChild0Type, MVT::v2f64,
                  OPC_MoveParent,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPDrr), 0,
                      1, MVT::v2i64, 2, 1, 0, 
                0, 
              0, 
            67, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 29, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_CheckType, MVT::v4i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPSrr), 0,
                    1, MVT::v2i64, 2, 1, 0, 
              29, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_CheckType, MVT::v4i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_CheckPatternPredicate, 0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDNPSrr), 0,
                    1, MVT::v2i64, 2, 1, 0, 
              0, 
            34, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BUILD_VECTOR,
              OPC_CheckPredicate, 67,
              OPC_CheckType, MVT::v4i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::v2i64,
              OPC_CheckPatternPredicate, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                  1, MVT::v2i64, 2, 0, 1, 
            67, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 29, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_CheckType, MVT::v4i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                    1, MVT::v2i64, 2, 1, 0, 
              29, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_CheckType, MVT::v4i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                    1, MVT::v2i64, 2, 1, 0, 
              0, 
            34, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BUILD_VECTOR,
              OPC_CheckPredicate, 67,
              OPC_CheckType, MVT::v8i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::v2i64,
              OPC_CheckPatternPredicate, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                  1, MVT::v2i64, 2, 0, 1, 
            67, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 29, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_CheckType, MVT::v8i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                    1, MVT::v2i64, 2, 1, 0, 
              29, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_CheckType, MVT::v8i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                    1, MVT::v2i64, 2, 1, 0, 
              0, 
            34, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BUILD_VECTOR,
              OPC_CheckPredicate, 67,
              OPC_CheckType, MVT::v16i8,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::v2i64,
              OPC_CheckPatternPredicate, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                  1, MVT::v2i64, 2, 0, 1, 
            67, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 29, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                    1, MVT::v2i64, 2, 1, 0, 
              29, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_CheckType, MVT::v16i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                    1, MVT::v2i64, 2, 1, 0, 
              0, 
            32, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BUILD_VECTOR,
              OPC_CheckPredicate, 67,
              OPC_CheckType, MVT::v2i32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::v1i64,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                  1, MVT::v1i64, 2, 0, 1, 
            63, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 27, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_CheckType, MVT::v2i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v1i64,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                    1, MVT::v1i64, 2, 1, 0, 
              27, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_CheckType, MVT::v2i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v1i64,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                    1, MVT::v1i64, 2, 1, 0, 
              0, 
            32, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_CheckPredicate, 68,
              OPC_CheckType, MVT::v4i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::v1i64,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                  1, MVT::v1i64, 2, 0, 1, 
            63, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 27, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 68,
                OPC_CheckType, MVT::v4i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v1i64,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                    1, MVT::v1i64, 2, 1, 0, 
              27, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 68,
                OPC_CheckType, MVT::v4i16,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v1i64,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                    1, MVT::v1i64, 2, 1, 0, 
              0, 
            32, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_CheckPredicate, 68,
              OPC_CheckType, MVT::v8i8,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::v1i64,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                  1, MVT::v1i64, 2, 0, 1, 
            63, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 27, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 68,
                OPC_CheckType, MVT::v8i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v1i64,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                    1, MVT::v1i64, 2, 1, 0, 
              27, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BIT_CONVERT,
                OPC_CheckPredicate, 68,
                OPC_CheckType, MVT::v8i8,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v1i64,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                    1, MVT::v1i64, 2, 1, 0, 
              0, 
            69, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 38, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 11,  MVT::v2i64,
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                      1, MVT::v2i64, 2, 0, 1, 
                11,  MVT::v1i64,
                  OPC_CheckPatternPredicate, 8,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                      1, MVT::v1i64, 2, 0, 1, 
                0, 
              23, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v2i64,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                    1, MVT::v2i64, 2, 0, 1, 
              0, 
            53, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 22, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                    1, MVT::v2i64, 2, 1, 0, 
              22, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i64,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDNrr), 0,
                    1, MVT::v2i64, 2, 1, 0, 
              0, 
            27, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::XOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BUILD_VECTOR,
              OPC_CheckPredicate, 67,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckType, MVT::v1i64,
              OPC_CheckPatternPredicate, 8,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                  1, MVT::v1i64, 2, 0, 1, 
            53, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::XOR,
              OPC_Scope, 22, 
                OPC_RecordChild0,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v1i64,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                    1, MVT::v1i64, 2, 1, 0, 
              22, 
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::BUILD_VECTOR,
                OPC_CheckPredicate, 67,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveParent,
                OPC_CheckType, MVT::v1i64,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDNrr), 0,
                    1, MVT::v1i64, 2, 1, 0, 
              0, 
            29, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v2f64,
              OPC_MoveParent,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_RecordChild0,
              OPC_CheckChild0Type, MVT::v2f64,
              OPC_MoveParent,
              OPC_CheckType, MVT::v2i64,
              OPC_CheckPatternPredicate, 1,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDPDrr), 0,
                  1, MVT::v2i64, 2, 0, 1, 
            27, 
              OPC_CheckAndImm, 127|128,127|128,3, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i32,
              OPC_EmitInteger, MVT::i32, 3, 
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::i16, 2, 0, 1, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rr16), 0,
                  1, MVT::i32, 1, 2, 
            29, 
              OPC_CheckAndImm, 127|128,127|128,127|128,127|128,15, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i64,
              OPC_EmitInteger, MVT::i32, 4, 
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::i32, 2, 0, 1, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rr32), 0,
                  1, MVT::i64, 1, 2, 
            27, 
              OPC_CheckAndImm, 127|128,127|128,3, 
              OPC_RecordChild0,
              OPC_CheckType, MVT::i64,
              OPC_EmitInteger, MVT::i32, 3, 
              OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                  1, MVT::i16, 2, 0, 1, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rr16), 0,
                  1, MVT::i64, 1, 2, 
            24|128,1, 
              OPC_CheckAndImm, 127|128,1, 
              OPC_RecordChild0,
              OPC_SwitchType , 20,  MVT::i64,
                OPC_EmitInteger, MVT::i32, 1, 
                OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                    1, MVT::i8, 2, 0, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX64rr8), 0,
                    1, MVT::i64, 1, 2, 
              60,  MVT::i32,
                OPC_Scope, 22, 
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 1, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i8, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rr8), 0,
                      1, MVT::i32, 1, 2, 
                34, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, X86::GR32_ABCDRegClassID,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                      1, MVT::i32, 2, 0, 1, 
                  OPC_EmitInteger, MVT::i32, 1, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i8, 2, 2, 3, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX32rr8), 0,
                      1, MVT::i32, 1, 4, 
                0, 
              60,  MVT::i16,
                OPC_Scope, 22, 
                  OPC_CheckPatternPredicate, 3,
                  OPC_EmitInteger, MVT::i32, 1, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i8, 2, 0, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX16rr8), 0,
                      1, MVT::i16, 1, 2, 
                34, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_EmitInteger, MVT::i32, X86::GR16_ABCDRegClassID,
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::COPY_TO_REGCLASS), 0,
                      1, MVT::i16, 2, 0, 1, 
                  OPC_EmitInteger, MVT::i32, 1, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i8, 2, 2, 3, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVZX16rr8), 0,
                      1, MVT::i16, 1, 4, 
                0, 
              0, 
            11|128,2, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 38|128,1, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 47, 
                  OPC_CheckPredicate, 11,
                  OPC_MoveParent,
                  OPC_SwitchType , 12,  MVT::i16,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16ri8), 0,
                        2, MVT::i16, MVT::i32, 2, 0, 2, 
                  12,  MVT::i32,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32ri8), 0,
                        2, MVT::i32, MVT::i32, 2, 0, 2, 
                  12,  MVT::i64,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64ri8), 0,
                        2, MVT::i64, MVT::i32, 2, 0, 2, 
                  0, 
                17, 
                  OPC_CheckPredicate, 12,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64ri32), 0,
                      2, MVT::i64, MVT::i32, 2, 0, 2, 
                47, 
                  OPC_CheckPredicate, 69,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_EmitInteger, MVT::i64, 0, 
                  OPC_EmitInteger, MVT::i32, 4, 
                  OPC_EmitNode, TARGET_OPCODE(TargetOpcode::EXTRACT_SUBREG), 0,
                      1, MVT::i32, 2, 0, 3, 
                  OPC_EmitConvertToTarget, 1,
                  OPC_EmitNodeXForm, 6, 5,
                  OPC_EmitNode, TARGET_OPCODE(X86::AND32ri), 0,
                      1, MVT::i32, 2, 4, 6, 
                  OPC_EmitInteger, MVT::i32, 4, 
                  OPC_MorphNodeTo, TARGET_OPCODE(TargetOpcode::SUBREG_TO_REG), 0,
                      1, MVT::i64, 3, 2, 7, 8, 
                45, 
                  OPC_MoveParent,
                  OPC_SwitchType , 12,  MVT::i8,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND8ri), 0,
                        2, MVT::i8, MVT::i32, 2, 0, 2, 
                  12,  MVT::i16,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16ri), 0,
                        2, MVT::i16, MVT::i32, 2, 0, 2, 
                  12,  MVT::i32,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32ri), 0,
                        2, MVT::i32, MVT::i32, 2, 0, 2, 
                  0, 
                0, 
              12, 
                OPC_CheckType, MVT::i8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::AND8rr), 0,
                    2, MVT::i8, MVT::i32, 2, 0, 1, 
              12, 
                OPC_CheckType, MVT::i16,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::AND16rr), 0,
                    2, MVT::i16, MVT::i32, 2, 0, 1, 
              12, 
                OPC_CheckType, MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::AND32rr), 0,
                    2, MVT::i32, MVT::i32, 2, 0, 1, 
              12, 
                OPC_CheckType, MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::AND64rr), 0,
                    2, MVT::i64, MVT::i32, 2, 0, 1, 
              28, 
                OPC_CheckType, MVT::v2i64,
                OPC_Scope, 11, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ANDPSrr), 0,
                      1, MVT::v2i64, 2, 0, 1, 
                11, 
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::PANDrr), 0,
                      1, MVT::v2i64, 2, 0, 1, 
                0, 
              13, 
                OPC_CheckType, MVT::v1i64,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PANDrr), 0,
                    1, MVT::v1i64, 2, 0, 1, 
              0, 
            0, 
          42|128,12,  X86ISD::CMP,
            OPC_Scope, 23|128,6, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 76|128,3,  ISD::AND,
                OPC_Scope, 39|128,1, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 76, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_Scope, 32, 
                      OPC_CheckPredicate, 12,
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i64,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckInteger, 0, 
                      OPC_MoveParent,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitConvertToTarget, 2,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                    30, 
                      OPC_MoveParent,
                      OPC_CheckType, MVT::i8,
                      OPC_MoveParent,
                      OPC_MoveChild, 1,
                      OPC_CheckInteger, 0, 
                      OPC_MoveParent,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitConvertToTarget, 2,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST8mi), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                    0, 
                  38, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitConvertToTarget, 2,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST16mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                  38, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitConvertToTarget, 2,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST32mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                  0, 
                13|128,1, 
                  OPC_RecordChild0,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 32, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST8rm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
                  30, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST16rm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
                  30, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST32rm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
                  32, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                    OPC_EmitMergeInputChains, 1, 1, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST64rm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
                  0, 
                16|128,1, 
                  OPC_MoveChild, 0,
                  OPC_CheckOpcode, ISD::LOAD,
                  OPC_RecordMemRef,
                  OPC_RecordNode,
                  OPC_CheckFoldableChainNode,
                  OPC_RecordChild1,
                  OPC_CheckPredicate, 2,
                  OPC_Scope, 33, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST8rm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
                  31, 
                    OPC_CheckPredicate, 6,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST16rm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
                  31, 
                    OPC_CheckPredicate, 3,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST32rm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
                  33, 
                    OPC_CheckPredicate, 8,
                    OPC_CheckPredicate, 9,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_CheckType, MVT::i64,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST64rm), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
                  0, 
                0, 
              65|128,2,  ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_Scope, 34, 
                  OPC_CheckPredicate, 6,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckPredicate, 11,
                  OPC_MoveParent,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                34, 
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckPredicate, 11,
                  OPC_MoveParent,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                96, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_SwitchType , 58,  MVT::i64,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_Scope, 24, 
                      OPC_CheckPredicate, 11,
                      OPC_MoveParent,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitConvertToTarget, 2,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                    24, 
                      OPC_CheckPredicate, 12,
                      OPC_MoveParent,
                      OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                      OPC_EmitMergeInputChains, 1, 0, 
                      OPC_EmitConvertToTarget, 2,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP64mi32), 0|OPFL_Chain|OPFL_MemRefs,
                          1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                    0, 
                  28,  MVT::i8,
                    OPC_MoveParent,
                    OPC_RecordChild1,
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                    OPC_EmitMergeInputChains, 1, 0, 
                    OPC_EmitConvertToTarget, 2,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP8mi), 0|OPFL_Chain|OPFL_MemRefs,
                        1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                  0, 
                32, 
                  OPC_CheckPredicate, 6,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP16mi), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                32, 
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_MoveParent,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP32mi), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                27, 
                  OPC_CheckPredicate, 8,
                  OPC_CheckPredicate, 9,
                  OPC_CheckType, MVT::i8,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP8mr), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 3, 4, 5, 6, 7, 2, 
                25, 
                  OPC_CheckPredicate, 6,
                  OPC_CheckType, MVT::i16,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP16mr), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 3, 4, 5, 6, 7, 2, 
                25, 
                  OPC_CheckPredicate, 3,
                  OPC_CheckType, MVT::i32,
                  OPC_MoveParent,
                  OPC_RecordChild1,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP32mr), 0|OPFL_Chain|OPFL_MemRefs,
                      1, MVT::i32, 6, 3, 4, 5, 6, 7, 2, 
                0, 
              0, 
            110, 
              OPC_RecordChild0,
              OPC_Scope, 36, 
                OPC_CheckChild0Type, MVT::i8,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP8rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              34, 
                OPC_CheckChild0Type, MVT::i16,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP16rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              34, 
                OPC_CheckChild0Type, MVT::i32,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP32rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              0, 
            37, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::i64,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_CheckComplexPat, /*CP*/0, /*#*/1,
              OPC_EmitMergeInputChains, 1, 0, 
              OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP64mr), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::i32, 6, 3, 4, 5, 6, 7, 2, 
            118, 
              OPC_RecordChild0,
              OPC_Scope, 36, 
                OPC_CheckChild0Type, MVT::i64,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP64rm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              38, 
                OPC_CheckChild0Type, MVT::f32,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 0,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::UCOMISSrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              38, 
                OPC_CheckChild0Type, MVT::f64,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::UCOMISDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              0, 
            47|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::AND,
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 92, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 62, 
                  OPC_MoveParent,
                  OPC_CheckPredicate, 70,
                  OPC_SwitchType , 17,  MVT::i8,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST8ri), 0,
                        1, MVT::i32, 2, 0, 2, 
                  17,  MVT::i16,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST16ri), 0,
                        1, MVT::i32, 2, 0, 2, 
                  17,  MVT::i32,
                    OPC_MoveParent,
                    OPC_MoveChild, 1,
                    OPC_CheckInteger, 0, 
                    OPC_MoveParent,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST32ri), 0,
                        1, MVT::i32, 2, 0, 2, 
                  0, 
                22, 
                  OPC_CheckPredicate, 12,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST64ri32), 0,
                      1, MVT::i32, 2, 0, 2, 
                0, 
              55, 
                OPC_CheckPredicate, 70,
                OPC_SwitchType , 15,  MVT::i8,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST8rr), 0,
                      1, MVT::i32, 2, 0, 1, 
                15,  MVT::i16,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST16rr), 0,
                      1, MVT::i32, 2, 0, 1, 
                15,  MVT::i32,
                  OPC_MoveParent,
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST32rr), 0,
                      1, MVT::i32, 2, 0, 1, 
                0, 
              17, 
                OPC_CheckType, MVT::i64,
                OPC_MoveParent,
                OPC_MoveChild, 1,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST64rr), 0,
                    1, MVT::i32, 2, 0, 1, 
              0, 
            80|128,2, 
              OPC_RecordChild0,
              OPC_Scope, 50, 
                OPC_CheckChild0Type, MVT::i8,
                OPC_Scope, 14, 
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST8rr), 0,
                      1, MVT::i32, 2, 0, 0, 
                30, 
                  OPC_RecordChild1,
                  OPC_Scope, 16, 
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_MoveParent,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP8ri), 0,
                        1, MVT::i32, 2, 0, 2, 
                  9, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP8rr), 0,
                        1, MVT::i32, 2, 0, 1, 
                  0, 
                0, 
              68, 
                OPC_CheckChild0Type, MVT::i16,
                OPC_Scope, 14, 
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST16rr), 0,
                      1, MVT::i32, 2, 0, 0, 
                48, 
                  OPC_RecordChild1,
                  OPC_Scope, 34, 
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_Scope, 14, 
                      OPC_CheckPredicate, 11,
                      OPC_MoveParent,
                      OPC_EmitConvertToTarget, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP16ri8), 0,
                          1, MVT::i32, 2, 0, 2, 
                    12, 
                      OPC_MoveParent,
                      OPC_EmitConvertToTarget, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP16ri), 0,
                          1, MVT::i32, 2, 0, 2, 
                    0, 
                  9, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP16rr), 0,
                        1, MVT::i32, 2, 0, 1, 
                  0, 
                0, 
              68, 
                OPC_CheckChild0Type, MVT::i32,
                OPC_Scope, 14, 
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST32rr), 0,
                      1, MVT::i32, 2, 0, 0, 
                48, 
                  OPC_RecordChild1,
                  OPC_Scope, 34, 
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_Scope, 14, 
                      OPC_CheckPredicate, 11,
                      OPC_MoveParent,
                      OPC_EmitConvertToTarget, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP32ri8), 0,
                          1, MVT::i32, 2, 0, 2, 
                    12, 
                      OPC_MoveParent,
                      OPC_EmitConvertToTarget, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP32ri), 0,
                          1, MVT::i32, 2, 0, 2, 
                    0, 
                  9, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP32rr), 0,
                        1, MVT::i32, 2, 0, 1, 
                  0, 
                0, 
              70, 
                OPC_CheckChild0Type, MVT::i64,
                OPC_Scope, 14, 
                  OPC_MoveChild, 1,
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::TEST64rr), 0,
                      1, MVT::i32, 2, 0, 0, 
                50, 
                  OPC_RecordChild1,
                  OPC_Scope, 36, 
                    OPC_MoveChild, 1,
                    OPC_CheckOpcode, ISD::Constant,
                    OPC_Scope, 14, 
                      OPC_CheckPredicate, 11,
                      OPC_MoveParent,
                      OPC_EmitConvertToTarget, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP64ri8), 0,
                          1, MVT::i32, 2, 0, 2, 
                    14, 
                      OPC_CheckPredicate, 12,
                      OPC_MoveParent,
                      OPC_EmitConvertToTarget, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP64ri32), 0,
                          1, MVT::i32, 2, 0, 2, 
                    0, 
                  9, 
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMP64rr), 0,
                        1, MVT::i32, 2, 0, 1, 
                  0, 
                0, 
              29, 
                OPC_CheckChild0Type, MVT::f32,
                OPC_RecordChild1,
                OPC_Scope, 11, 
                  OPC_CheckPatternPredicate, 6,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::UCOM_FpIr32), 0,
                      1, MVT::i32, 2, 0, 1, 
                11, 
                  OPC_CheckPatternPredicate, 0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::UCOMISSrr), 0,
                      1, MVT::i32, 2, 0, 1, 
                0, 
              29, 
                OPC_CheckChild0Type, MVT::f64,
                OPC_RecordChild1,
                OPC_Scope, 11, 
                  OPC_CheckPatternPredicate, 7,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::UCOM_FpIr64), 0,
                      1, MVT::i32, 2, 0, 1, 
                11, 
                  OPC_CheckPatternPredicate, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::UCOMISDrr), 0,
                      1, MVT::i32, 2, 0, 1, 
                0, 
              12, 
                OPC_CheckChild0Type, MVT::f80,
                OPC_RecordChild1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::UCOM_FpIr80), 0,
                    1, MVT::i32, 2, 0, 1, 
              0, 
            0, 
          78,  X86ISD::INSERTPS,
            OPC_RecordChild0,
            OPC_Scope, 52, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 9,
              OPC_CheckType, MVT::f32,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 4,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 1, 
              OPC_EmitConvertToTarget, 3,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::INSERTPSrm), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::v4f32, 7, 0, 4, 5, 6, 7, 8, 9, 
            21, 
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 4,
              OPC_EmitConvertToTarget, 2,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::INSERTPSrr), 0,
                  1, MVT::v4f32, 3, 0, 1, 3, 
            0, 
          76,  X86ISD::MMX_PINSRW,
            OPC_RecordChild0,
            OPC_Scope, 50, 
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::ANY_EXTEND,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 6,
              OPC_CheckType, MVT::i16,
              OPC_MoveParent,
              OPC_MoveParent,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 8,
              OPC_CheckComplexPat, /*CP*/0, /*#*/2,
              OPC_EmitMergeInputChains, 1, 1, 
              OPC_EmitConvertToTarget, 3,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PINSRWrmi), 0|OPFL_Chain|OPFL_MemRefs,
                  1, MVT::v4i16, 7, 0, 4, 5, 6, 7, 8, 9, 
            21, 
              OPC_RecordChild1,
              OPC_RecordChild2,
              OPC_MoveChild, 2,
              OPC_CheckOpcode, ISD::Constant,
              OPC_MoveParent,
              OPC_CheckPatternPredicate, 8,
              OPC_EmitConvertToTarget, 2,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PINSRWrri), 0,
                  1, MVT::v4i16, 3, 0, 1, 3, 
            0, 
          88,  X86ISD::MOVQ2DQ,
            OPC_Scope, 75, 
              OPC_MoveChild, 0,
              OPC_SwitchOpcode , 41,  ISD::BIT_CONVERT,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::SCALAR_TO_VECTOR,
                OPC_MoveChild, 0,
                OPC_CheckOpcode, ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_CheckFoldableChainNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 3,
                OPC_CheckType, MVT::i32,
                OPC_MoveParent,
                OPC_CheckType, MVT::v2i32,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVDI2PDIrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
              26,  ISD::LOAD,
                OPC_RecordMemRef,
                OPC_RecordNode,
                OPC_RecordChild1,
                OPC_CheckPredicate, 2,
                OPC_CheckPredicate, 8,
                OPC_MoveParent,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MOVQI2PQIrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v2i64, 5, 2, 3, 4, 5, 6, 
              0, 
            9, 
              OPC_RecordChild0,
              OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_MOVQ2DQrr), 0,
                  1, MVT::v2i64, 1, 0, 
            0, 
          25|128,35,  X86ISD::CMOV,
            OPC_Scope, 77|128,8, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_Scope, 33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 2, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 2, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 1, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVAE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 1, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVAE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 4, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 4, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 9, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 9, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 3, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 3, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVA16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVA32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 7, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVL16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 7, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVL32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 6, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVGE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 6, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVGE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 8, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVLE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 8, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVLE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 5, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVG16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 5, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVG32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 15, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVS16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 15, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVS32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 12, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNS16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 12, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNS32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 14, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 14, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 11, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 11, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 13, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVO16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 13, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVO32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 10, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNO16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 0, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 10, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNO32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 0, 4, 5, 6, 7, 8, 
              0, 
            108|128,8, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_Scope, 34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 2, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVAE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 2, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVAE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 1, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 1, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 4, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 4, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 9, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 9, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 3, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVA16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 3, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVA32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 7, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVGE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 7, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVGE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 6, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVL16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 6, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVL32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 8, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVG16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 8, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVG32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 5, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVLE16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 5, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVLE32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 14, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 14, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 11, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 11, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 15, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNS16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 15, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNS32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 12, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVS16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 12, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVS32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 13, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNO16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 13, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNO32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 10, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVO16rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i16, 6, 2, 4, 5, 6, 7, 8, 
              34, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 2,
                OPC_CheckInteger, 10, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVO32rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i32, 6, 2, 4, 5, 6, 7, 8, 
              0, 
            100|128,3, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 9,
              OPC_MoveParent,
              OPC_MoveChild, 2,
              OPC_Scope, 28, 
                OPC_CheckInteger, 2, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 1, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVAE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 4, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 9, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 3, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVA64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 7, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVL64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 6, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVGE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 8, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVLE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 5, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVG64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 15, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVS64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 12, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNS64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 14, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 11, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 13, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVO64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 10, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNO64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 0, 4, 5, 6, 7, 8, 
              0, 
            100|128,3, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_CheckPredicate, 9,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveChild, 2,
              OPC_Scope, 28, 
                OPC_CheckInteger, 2, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVAE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 1, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 4, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 9, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 3, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVA64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 0, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 7, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVGE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 6, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVL64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 8, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVG64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 5, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVLE64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 14, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 11, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 15, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNS64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 12, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVS64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 13, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNO64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              28, 
                OPC_CheckInteger, 10, 
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitCopyToReg, 3, X86::EFLAGS,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVO64rm), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    1, MVT::i64, 6, 2, 4, 5, 6, 7, 8, 
              0, 
            12|128,10, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 4|128,9, 
                OPC_MoveChild, 2,
                OPC_Scope, 94, 
                  OPC_CheckInteger, 2, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 14,  MVT::f32,
                    OPC_CheckPatternPredicate, 6,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB_Fp32), 0|OPFL_FlagInput,
                        1, MVT::f32, 2, 0, 1, 
                  14,  MVT::f64,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB_Fp64), 0|OPFL_FlagInput,
                        1, MVT::f64, 2, 0, 1, 
                  12,  MVT::f80,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB_Fp80), 0|OPFL_FlagInput,
                        1, MVT::f80, 2, 0, 1, 
                  12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVB64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                94, 
                  OPC_CheckInteger, 3, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 14,  MVT::f32,
                    OPC_CheckPatternPredicate, 6,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE_Fp32), 0|OPFL_FlagInput,
                        1, MVT::f32, 2, 0, 1, 
                  14,  MVT::f64,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE_Fp64), 0|OPFL_FlagInput,
                        1, MVT::f64, 2, 0, 1, 
                  12,  MVT::f80,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE_Fp80), 0|OPFL_FlagInput,
                        1, MVT::f80, 2, 0, 1, 
                  12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVBE64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                94, 
                  OPC_CheckInteger, 4, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 14,  MVT::f32,
                    OPC_CheckPatternPredicate, 6,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE_Fp32), 0|OPFL_FlagInput,
                        1, MVT::f32, 2, 0, 1, 
                  14,  MVT::f64,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE_Fp64), 0|OPFL_FlagInput,
                        1, MVT::f64, 2, 0, 1, 
                  12,  MVT::f80,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE_Fp80), 0|OPFL_FlagInput,
                        1, MVT::f80, 2, 0, 1, 
                  12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVE64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                94, 
                  OPC_CheckInteger, 14, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 14,  MVT::f32,
                    OPC_CheckPatternPredicate, 6,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP_Fp32), 0|OPFL_FlagInput,
                        1, MVT::f32, 2, 0, 1, 
                  14,  MVT::f64,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP_Fp64), 0|OPFL_FlagInput,
                        1, MVT::f64, 2, 0, 1, 
                  12,  MVT::f80,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP_Fp80), 0|OPFL_FlagInput,
                        1, MVT::f80, 2, 0, 1, 
                  12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVP64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                94, 
                  OPC_CheckInteger, 1, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 14,  MVT::f32,
                    OPC_CheckPatternPredicate, 6,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNB_Fp32), 0|OPFL_FlagInput,
                        1, MVT::f32, 2, 0, 1, 
                  14,  MVT::f64,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNB_Fp64), 0|OPFL_FlagInput,
                        1, MVT::f64, 2, 0, 1, 
                  12,  MVT::f80,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNB_Fp80), 0|OPFL_FlagInput,
                        1, MVT::f80, 2, 0, 1, 
                  12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVAE16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVAE32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVAE64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                94, 
                  OPC_CheckInteger, 0, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 14,  MVT::f32,
                    OPC_CheckPatternPredicate, 6,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNBE_Fp32), 0|OPFL_FlagInput,
                        1, MVT::f32, 2, 0, 1, 
                  14,  MVT::f64,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNBE_Fp64), 0|OPFL_FlagInput,
                        1, MVT::f64, 2, 0, 1, 
                  12,  MVT::f80,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNBE_Fp80), 0|OPFL_FlagInput,
                        1, MVT::f80, 2, 0, 1, 
                  12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVA16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVA32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVA64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                94, 
                  OPC_CheckInteger, 9, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 14,  MVT::f32,
                    OPC_CheckPatternPredicate, 6,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE_Fp32), 0|OPFL_FlagInput,
                        1, MVT::f32, 2, 0, 1, 
                  14,  MVT::f64,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE_Fp64), 0|OPFL_FlagInput,
                        1, MVT::f64, 2, 0, 1, 
                  12,  MVT::f80,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE_Fp80), 0|OPFL_FlagInput,
                        1, MVT::f80, 2, 0, 1, 
                  12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNE64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                94, 
                  OPC_CheckInteger, 11, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 14,  MVT::f32,
                    OPC_CheckPatternPredicate, 6,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP_Fp32), 0|OPFL_FlagInput,
                        1, MVT::f32, 2, 0, 1, 
                  14,  MVT::f64,
                    OPC_CheckPatternPredicate, 7,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP_Fp64), 0|OPFL_FlagInput,
                        1, MVT::f64, 2, 0, 1, 
                  12,  MVT::f80,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP_Fp80), 0|OPFL_FlagInput,
                        1, MVT::f80, 2, 0, 1, 
                  12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNP64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                48, 
                  OPC_CheckInteger, 7, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVL16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVL32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVL64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                48, 
                  OPC_CheckInteger, 6, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVGE16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVGE32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVGE64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                48, 
                  OPC_CheckInteger, 8, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVLE16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVLE32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVLE64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                48, 
                  OPC_CheckInteger, 5, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVG16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVG32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVG64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                48, 
                  OPC_CheckInteger, 15, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVS16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVS32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVS64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                48, 
                  OPC_CheckInteger, 12, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNS16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNS32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNS64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                48, 
                  OPC_CheckInteger, 13, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVO16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVO32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVO64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                48, 
                  OPC_CheckInteger, 10, 
                  OPC_MoveParent,
                  OPC_RecordChild3,
                  OPC_SwitchType , 12,  MVT::i16,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNO16rr), 0|OPFL_FlagInput,
                        1, MVT::i16, 2, 0, 1, 
                  12,  MVT::i32,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNO32rr), 0|OPFL_FlagInput,
                        1, MVT::i32, 2, 0, 1, 
                  12,  MVT::i64,
                    OPC_EmitCopyToReg, 2, X86::EFLAGS,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOVNO64rr), 0|OPFL_FlagInput,
                        1, MVT::i64, 2, 0, 1, 
                  0, 
                0, 
              0|128,1, 
                OPC_RecordChild2,
                OPC_MoveChild, 2,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_RecordChild3,
                OPC_SwitchType , 15,  MVT::i8,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitCopyToReg, 3, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOV_GR8), 0|OPFL_FlagInput,
                      1, MVT::i8, 3, 0, 1, 4, 
                15,  MVT::f32,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitCopyToReg, 3, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOV_FR32), 0|OPFL_FlagInput,
                      1, MVT::f32, 3, 0, 1, 4, 
                15,  MVT::f64,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitCopyToReg, 3, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOV_FR64), 0|OPFL_FlagInput,
                      1, MVT::f64, 3, 0, 1, 4, 
                15,  MVT::v4f32,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitCopyToReg, 3, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOV_V4F32), 0|OPFL_FlagInput,
                      1, MVT::v4f32, 3, 0, 1, 4, 
                15,  MVT::v2f64,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitCopyToReg, 3, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOV_V2F64), 0|OPFL_FlagInput,
                      1, MVT::v2f64, 3, 0, 1, 4, 
                15,  MVT::v2i64,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitCopyToReg, 3, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOV_V2I64), 0|OPFL_FlagInput,
                      1, MVT::v2i64, 3, 0, 1, 4, 
                15,  MVT::v1i64,
                  OPC_EmitConvertToTarget, 2,
                  OPC_EmitCopyToReg, 3, X86::EFLAGS,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::CMOV_V1I64), 0|OPFL_FlagInput,
                      1, MVT::v1i64, 3, 0, 1, 4, 
                0, 
              0, 
            0, 
          88|128,6,  ISD::MUL,
            OPC_Scope, 50|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_MoveParent,
              OPC_RecordChild1,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::Constant,
              OPC_Scope, 77, 
                OPC_CheckPredicate, 11,
                OPC_MoveParent,
                OPC_SwitchType , 22,  MVT::i16,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rmi8), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i16, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                22,  MVT::i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rmi8), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i32, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                22,  MVT::i64,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rmi8), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i64, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                0, 
              27, 
                OPC_CheckPredicate, 12,
                OPC_MoveParent,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rmi32), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i64, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
              51, 
                OPC_MoveParent,
                OPC_SwitchType , 22,  MVT::i16,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rmi), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i16, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                22,  MVT::i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rmi), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i32, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                0, 
              0, 
            75, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_SwitchType , 27,  MVT::v2i64,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULLWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 0, 3, 4, 5, 6, 7, 
              25,  MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4i16,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULLWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 0, 3, 4, 5, 6, 7, 
              0, 
            76, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::BIT_CONVERT,
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_SwitchType , 28,  MVT::v2i64,
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 1,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULLWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v8i16, 6, 2, 3, 4, 5, 6, 7, 
              26,  MVT::v1i64,
                OPC_MoveParent,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i16,
                OPC_CheckPatternPredicate, 8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULLWrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i16, 6, 2, 3, 4, 5, 6, 7, 
              0, 
            12|128,1, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_Scope, 27, 
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_CheckType, MVT::i8,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_EmitCopyToReg, 0, X86::AL,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MUL8m), 0|OPFL_Chain|OPFL_FlagInput|OPFL_MemRefs,
                    2, MVT::i8, MVT::i32, 5, 3, 4, 5, 6, 7, 
              69, 
                OPC_MoveParent,
                OPC_SwitchType , 20,  MVT::i16,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rm), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i16, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
                20,  MVT::i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rm), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i32, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
                20,  MVT::i64,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                  OPC_EmitMergeInputChains, 1, 1, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rm), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i64, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
                0, 
              26, 
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULLDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 0, 3, 4, 5, 6, 7, 
              0, 
            113, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_CheckPredicate, 8,
              OPC_Scope, 70, 
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_SwitchType , 20,  MVT::i16,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rm), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i16, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
                20,  MVT::i32,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rm), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i32, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
                20,  MVT::i64,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rm), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i64, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
                0, 
              27, 
                OPC_CheckPredicate, 23,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 4,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULLDrm), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::v4i32, 6, 2, 3, 4, 5, 6, 7, 
              0, 
            57, 
              OPC_RecordNode,
              OPC_SwitchType , 36,  MVT::i32,
                OPC_Scope, 16, 
                  OPC_CheckPatternPredicate, 2,
                  OPC_CheckComplexPat, /*CP*/3, /*#*/0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::LEA32r), 0,
                      1, MVT::i32, 4, 1, 2, 3, 4, 
                16, 
                  OPC_CheckPatternPredicate, 3,
                  OPC_CheckComplexPat, /*CP*/3, /*#*/0,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::LEA64_32r), 0,
                      1, MVT::i32, 4, 1, 2, 3, 4, 
                0, 
              14,  MVT::i64,
                OPC_CheckComplexPat, /*CP*/4, /*#*/0,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::LEA64r), 0,
                    1, MVT::i64, 4, 1, 2, 3, 4, 
              0, 
            77|128,1, 
              OPC_RecordChild0,
              OPC_RecordChild1,
              OPC_Scope, 104, 
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 47, 
                  OPC_CheckPredicate, 11,
                  OPC_MoveParent,
                  OPC_SwitchType , 12,  MVT::i16,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rri8), 0,
                        2, MVT::i16, MVT::i32, 2, 0, 2, 
                  12,  MVT::i32,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rri8), 0,
                        2, MVT::i32, MVT::i32, 2, 0, 2, 
                  12,  MVT::i64,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rri8), 0,
                        2, MVT::i64, MVT::i32, 2, 0, 2, 
                  0, 
                17, 
                  OPC_CheckPredicate, 12,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rri32), 0,
                      2, MVT::i64, MVT::i32, 2, 0, 2, 
                31, 
                  OPC_MoveParent,
                  OPC_SwitchType , 12,  MVT::i16,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rri), 0,
                        2, MVT::i16, MVT::i32, 2, 0, 2, 
                  12,  MVT::i32,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rri), 0,
                        2, MVT::i32, MVT::i32, 2, 0, 2, 
                  0, 
                0, 
              14, 
                OPC_CheckType, MVT::i8,
                OPC_EmitCopyToReg, 0, X86::AL,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MUL8r), 0|OPFL_FlagInput,
                    2, MVT::i8, MVT::i32, 1, 1, 
              12, 
                OPC_CheckType, MVT::i16,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rr), 0,
                    2, MVT::i16, MVT::i32, 2, 0, 1, 
              12, 
                OPC_CheckType, MVT::i32,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rr), 0,
                    2, MVT::i32, MVT::i32, 2, 0, 1, 
              12, 
                OPC_CheckType, MVT::i64,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rr), 0,
                    2, MVT::i64, MVT::i32, 2, 0, 1, 
              13, 
                OPC_CheckType, MVT::v8i16,
                OPC_CheckPatternPredicate, 1,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULLWrr), 0,
                    1, MVT::v8i16, 2, 0, 1, 
              13, 
                OPC_CheckType, MVT::v4i32,
                OPC_CheckPatternPredicate, 4,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::PMULLDrr), 0,
                    1, MVT::v4i32, 2, 0, 1, 
              13, 
                OPC_CheckType, MVT::v4i16,
                OPC_CheckPatternPredicate, 8,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::MMX_PMULLWrr), 0,
                    1, MVT::v4i16, 2, 0, 1, 
              0, 
            0, 
          100|128,1,  X86ISD::BT,
            OPC_Scope, 116, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_SwitchType , 32,  MVT::i16,
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 11,
                OPC_MoveParent,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::BT16mi8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
              32,  MVT::i32,
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 11,
                OPC_MoveParent,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::BT32mi8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
              34,  MVT::i64,
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 11,
                OPC_MoveParent,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::BT64mi8), 0|OPFL_Chain|OPFL_MemRefs,
                    1, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
              0, 
            108, 
              OPC_RecordChild0,
              OPC_Scope, 34, 
                OPC_CheckChild0Type, MVT::i16,
                OPC_RecordChild1,
                OPC_Scope, 18, 
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckPredicate, 11,
                  OPC_MoveParent,
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::BT16ri8), 0,
                      1, MVT::i32, 2, 0, 2, 
                9, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::BT16rr), 0,
                      1, MVT::i32, 2, 0, 1, 
                0, 
              34, 
                OPC_CheckChild0Type, MVT::i32,
                OPC_RecordChild1,
                OPC_Scope, 18, 
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckPredicate, 11,
                  OPC_MoveParent,
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::BT32ri8), 0,
                      1, MVT::i32, 2, 0, 2, 
                9, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::BT32rr), 0,
                      1, MVT::i32, 2, 0, 1, 
                0, 
              34, 
                OPC_CheckChild0Type, MVT::i64,
                OPC_RecordChild1,
                OPC_Scope, 18, 
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_CheckPredicate, 11,
                  OPC_MoveParent,
                  OPC_EmitConvertToTarget, 1,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::BT64ri8), 0,
                      1, MVT::i32, 2, 0, 2, 
                9, 
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::BT64rr), 0,
                      1, MVT::i32, 2, 0, 1, 
                0, 
              0, 
            0, 
          89|128,4,  X86ISD::SMUL,
            OPC_Scope, 93|128,1, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_Scope, 35, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 11,
                OPC_MoveParent,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rmi8), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i16, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
              35, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_CheckPredicate, 11,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rmi8), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
              68, 
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_Scope, 27, 
                  OPC_CheckPredicate, 11,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rmi8), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i64, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                27, 
                  OPC_CheckPredicate, 12,
                  OPC_MoveParent,
                  OPC_CheckType, MVT::i64,
                  OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                  OPC_EmitMergeInputChains, 1, 0, 
                  OPC_EmitConvertToTarget, 2,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rmi32), 0|OPFL_Chain|OPFL_MemRefs,
                      2, MVT::i64, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
                0, 
              33, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rmi), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i16, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
              33, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_MoveChild, 1,
                OPC_CheckOpcode, ISD::Constant,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_EmitConvertToTarget, 2,
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rmi), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 6, 3, 4, 5, 6, 7, 8, 
              0, 
            93, 
              OPC_RecordChild0,
              OPC_MoveChild, 1,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_Scope, 25, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i16, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              25, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              27, 
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/2,
                OPC_EmitMergeInputChains, 1, 1, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i64, MVT::i32, 6, 0, 3, 4, 5, 6, 7, 
              0, 
            95, 
              OPC_MoveChild, 0,
              OPC_CheckOpcode, ISD::LOAD,
              OPC_RecordMemRef,
              OPC_RecordNode,
              OPC_CheckFoldableChainNode,
              OPC_RecordChild1,
              OPC_CheckPredicate, 2,
              OPC_Scope, 26, 
                OPC_CheckPredicate, 6,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i16,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i16, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
              26, 
                OPC_CheckPredicate, 3,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i32,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i32, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
              28, 
                OPC_CheckPredicate, 8,
                OPC_CheckPredicate, 9,
                OPC_MoveParent,
                OPC_RecordChild1,
                OPC_CheckType, MVT::i64,
                OPC_CheckComplexPat, /*CP*/0, /*#*/1,
                OPC_EmitMergeInputChains, 1, 0, 
                OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rm), 0|OPFL_Chain|OPFL_MemRefs,
                    2, MVT::i64, MVT::i32, 6, 2, 3, 4, 5, 6, 7, 
              0, 
            56|128,1, 
              OPC_RecordChild0,
              OPC_Scope, 31, 
                OPC_MoveChild, 1,
                OPC_CheckInteger, 2, 
                OPC_MoveParent,
                OPC_SwitchType , 10,  MVT::i16,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD16rr), 0,
                      2, MVT::i16, MVT::i32, 2, 0, 0, 
                10,  MVT::i32,
                  OPC_MorphNodeTo, TARGET_OPCODE(X86::ADD32rr), 0,
                      2, MVT::i32, MVT::i32, 2, 0, 0, 
                0, 
              19|128,1, 
                OPC_RecordChild1,
                OPC_Scope, 104, 
                  OPC_MoveChild, 1,
                  OPC_CheckOpcode, ISD::Constant,
                  OPC_Scope, 47, 
                    OPC_CheckPredicate, 11,
                    OPC_MoveParent,
                    OPC_SwitchType , 12,  MVT::i16,
                      OPC_EmitConvertToTarget, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL16rri8), 0,
                          2, MVT::i16, MVT::i32, 2, 0, 2, 
                    12,  MVT::i32,
                      OPC_EmitConvertToTarget, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL32rri8), 0,
                          2, MVT::i32, MVT::i32, 2, 0, 2, 
                    12,  MVT::i64,
                      OPC_EmitConvertToTarget, 1,
                      OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rri8), 0,
                          2, MVT::i64, MVT::i32, 2, 0, 2, 
                    0, 
                  17, 
                    OPC_CheckPredicate, 12,
                    OPC_MoveParent,
                    OPC_CheckType, MVT::i64,
                    OPC_EmitConvertToTarget, 1,
                    OPC_MorphNodeTo, TARGET_OPCODE(X86::IMUL64rri32), 0,
                        2, MVT::i64, MVT::i32, 2, 0, 2, 
                  31, 
                    OPC_MoveParent,
                    OPC_SwitchType , 12,  MVT::i16,
                      OPC_EmitConvertToTarge