/*
  (C) Nelson Murilo - 2002/08/08
  Version 0.5
  C port from chkproc.pl code from Klaus Steding-Jessen <jessen@nic.br>
  and Cristine Hoepers <cristine@nic.br> +little output changes.

  2002/03/02 - Segmentation fault in ps for non ASCII user name, by RainbowHat

  2002/06/13 Updated by Kostya Kortchinsky <kostya.kortchinsky@renater.fr>
  - corrected the program return value ;
  - added a verbose mode displaying information about the hidden process.

  2002/08/08 - Value of MAX_PROCESSES was increased to 99999 (new versions
    of FreeBSD, HP-UX and others), reported by Morohoshi Akihiko, Paul
    and others.

  2002/09/03 - Eliminate (?) false-positives. Original idea from Aaron Sherman.

*/
#if !defined(__linux__) && !defined(__FreeBSD__)
main (){ return 0; }
#else
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>

//#define MAX_PROCESSES 65535

#define MAX_PROCESSES 99999
#define MAX_BUF 1024
#define PS "ps auxwww"

int psproc [MAX_PROCESSES+1];
int dirproc[MAX_PROCESSES+1];

main(int argc, char **argv)
{
   char buf[MAX_BUF], *p, path[MAX_BUF];
   FILE *ps  = popen(PS, "r");
   DIR *proc = opendir("/proc");
   struct dirent *dir;
   int i, j, retps, retdir;
   int verbose = 0;
   long ret=0;

   if (!ps || !proc)
   {
      perror("ps or proc");
      exit (1);
   }

   for (i = 1; i < argc; i++)
   {
      if (!memcmp(argv[i], "-v", 2))
	verbose++;
      else if (!memcmp(argv[i], "-?", 2))
      {
	printf("Usage: %s [-v] [-v]\n", argv[0]);
	return 0;
      }
   }

   fgets(buf, MAX_BUF, ps); /* Skip header */
   if (!isalpha(*buf))
   {
     fprintf(stderr, "OooPS!\n");
     exit(2);
   }
   for (i = 1; i <= MAX_PROCESSES; i++) /* init matrix */
     psproc[i] = dirproc[i] = 0;

   while (fgets(buf, MAX_BUF, ps))
   {
      p = buf;
      while (*p != ' ') /* Skip USER */
          p++;
      while (*p == ' ') /* Skip spaces */
          p++;
      ret = atol(p);
      if ( ret < 0 || ret > MAX_PROCESSES )
      {
         fprintf (stderr, " OooPS, not expected %d value\n");
         exit (2);
      }
      psproc[ret]=1;
   }
   pclose(ps);

   while (dir = readdir(proc))
   {
      if (!strcmp(dir->d_name, ".") || !strcmp(dir->d_name, "..") ||
         !isdigit(*dir->d_name))
         continue;
      dirproc[atol(dir->d_name)]=1;
   }
   closedir(proc);

   /* Brute force */
   strcpy(buf, "/proc/");
   retps = retdir = 0;
   for (i = 1; i <= MAX_PROCESSES; i++)
   {
      snprintf(&buf[6], 6, "%d", i);
      if (!chdir(buf))
      {
         if (!dirproc[i] && kill(dirproc[i], 0))
         {
            retdir++;
            if (verbose)
	       printf ("PID %5d: not in readdir output\n", i);
         }
         if (!psproc[i] && kill(psproc[i], 0))
         {
            retps++;
            if (verbose)
	       printf ("PID %5d: not in ps output\n", i);
	 }
	 if ((!dirproc[i] || !psproc[i]) && (verbose > 1))
	 {
#if defined(__linux__)
	    j = readlink ("./cwd", path, sizeof(path));
	    path[(j < sizeof(path)) ? j : sizeof(path) - 1] = 0;
	    printf ("CWD %5d: %s\n", i, path);
	    j = readlink ("./exe", path, sizeof(path));
	    path[(j < sizeof(path)) ? j : sizeof(path) - 1] = 0;
	    printf ("EXE %5d: %s\n", i, path);
#elif defined(__FreeBSD__)
	    j = readlink ("./file", path, sizeof(path));
	    path[(j < sizeof(path)) ? j : sizeof(path) - 1] = 0;
	    printf ("FILE %5d: %s\n", i, path);
#endif
         }
      }
   }
   if (retdir)
      printf("You have % 5d process hidden for readdir command\n", retdir);
   if (retps)
      printf("You have % 5d process hidden for ps command\n", retps);
   return (retdir+retps);
}
#endif
