/**************************************************************************/
/*                                                                        */
/*                                 OCaml                                  */
/*                                                                        */
/*             Xavier Leroy, projet Cristal, INRIA Rocquencourt           */
/*                                                                        */
/*   Copyright 1996 Institut National de Recherche en Informatique et     */
/*     en Automatique.                                                    */
/*                                                                        */
/*   All rights reserved.  This file is distributed under the terms of    */
/*   the GNU Lesser General Public License version 2.1, with the          */
/*   special exception on linking described in the file LICENSE.          */
/*                                                                        */
/**************************************************************************/

#define CAML_INTERNALS

#include <sys/types.h>
#include <sys/stat.h>
#include <caml/mlvalues.h>
#include <caml/memory.h>
#include <caml/signals.h>
#include <caml/osdeps.h>
#include "caml/unixsupport.h"

CAMLprim value caml_unix_chmod(value path, value vperm)
{
  CAMLparam2(path, vperm);
  char_os * p;
  int ret;
  int perm = Int_val(vperm);
  caml_unix_check_path(path, "chmod");
  p = caml_stat_strdup_to_os(String_val(path));
  caml_enter_blocking_section();
  ret = chmod_os(p, perm);
  caml_leave_blocking_section();
  caml_stat_free(p);
  if (ret == -1) caml_uerror("chmod", path);
  CAMLreturn(Val_unit);
}
