(* $Id: ostream.ml,v 1.6 2000/04/16 12:39:27 garrigue Exp $ *)

open Stream

class ['a] c s = object
  val mutable s = (s : 'a Stream.t)
  method out = s
  method iter : f:('a -> unit) -> unit = iter s
  method next = next s
  method empty = empty s
  method peek =  peek s
  method junk = junk s
  method count = count s
end

let from f = new c (from f)
and of_list l = new c (of_list l)
and of_string s = new c (of_string s)
and of_channel ic = new c (of_channel ic)
