(* $Id: ostack.ml,v 1.5 2000/04/16 12:39:27 garrigue Exp $ *)

exception Empty

class ['a] c () = object
  val mutable s : 'a list = []
  method push x = s <- x :: s
  method pop =
    match s with x::s' -> s <- s'; x
    | [] -> raise Empty
  method top =
    match s with x::_ -> x
    | [] -> raise Empty
  method clear = s <- []
  method length = List.length s
  method iter = List.iter s
  method contents = s
end
