(***********************************************************************)
(*                                                                     *)
(*                           Htmlc                                     *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2003 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(* $Id: version.mli,v 1.6 2010-07-05 07:08:20 weis Exp $ *)

(** {3 Handling versionning of the software} *)

val print_version : unit -> unit;;
 (** Print the current version of the software on [stderr].
   The version number should be "major version" '.' "minor version".
   Intended use of this function is to handle the [-v] command line
   option parsed with the [Arg] standard library module. *)
val print_long_version : unit -> unit;;
 (** Same as above for the long version of the software (in addition to the
   regular version, the long version should state a date [d] and a level [i],
   such that the format string ["+%i (%s)"] can be applied to [i] [d]). *)

val htmlc_version : string;;
val htmlc_long_version : string;;
 (** The value of the current Htmlc versions.
  [htmlc_version] has format ``major version . minor version''.
  [htmlc_long_version] has format ``version+subversion (date)'', reminiscent
  of the versionning scheme of the Caml compiler). *)
