(***********************************************************************)
(*                                                                     *)
(*                           Htmlc                                     *)
(*                                                                     *)
(*                    Pierre Weis, INRIA Rocquencourt                  *)
(*                                                                     *)
(*  Copyright 1997-2007,                                               *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

(* $Id: types.mli,v 1.4 2011-11-30 18:27:28 weis Exp $ *)

(** {3 Definition and operations on the Htmlc environment.} *)

type ident = string;;
(** Variables environment to expand into files. *)

type command_name = string;;
(** The name of an operating system command. *)

type htmlc_definitions =
   | Htmlc_environment of File.file_name
   | Htmlc_bindings of File.file_name
   | Htmlc_definition of ident * string
(** The kind of definitions that could be added to the Htmlc runtime
    environment. *)
;;

type htmlc_mode =
   | Mode_verbatim
   | Mode_source
   | Mode_ssi
   | Mode_non_ssi
(** The pre-processing modes for Htmlc:
    - [Mode_verbatim] means no pre-processing.
    - [Mode_source] means pre-processing using the pre-processors for source
    files.
    - [Mode_ssi] means pre-processing using the pre-processors for file
    inclusion from a SSI directive.
    - [Mode_non_ssi] means pre-processing using the pre-processors for file
    inclusion from a non-SSI directive. *)
;;
