(***********************************************************************)
(*                                                                     *)
(*                           Htmlc                                     *)
(*                                                                     *)
(*                    Pierre Weis, INRIA Rocquencourt                  *)
(*                                                                     *)
(*  Copyright 1997-2007,                                               *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

(* $Id: types.ml,v 1.3 2011-05-01 11:57:36 weis Exp $ *)

(** {3 Definition and operations on the Htmlc environment.} *)

type ident = string;;
(** Variables environment to expand into files. *)

type command_name = string;;
(** The name of an operating system command. *)

type htmlc_definitions =
   | Htmlc_environment of File.file_name
   | Htmlc_bindings of File.file_name
   | Htmlc_definition of ident * string
;;

type htmlc_mode =
   | Mode_verbatim
   | Mode_source
   | Mode_ssi
   | Mode_non_ssi
;;
