#*********************************************************************#
#                                                                     #
#                           HTMLC                                     #
#                                                                     #
#            Pierre Weis, projet Cristal, INRIA Rocquencourt          #
#                                                                     #
# Copyright 2003-2004,                                                #
# Institut National de Recherche en Informatique et en Automatique.   #
# Distributed only by permission.                                     #
#                                                                     #
#*********************************************************************#

#(* \$Id: test100.mk,v 1.1 2008-10-22 06:11:45 weis Exp $ *)

# To debug the compiler
# ledit ocamldebug ../htmlc.byt
# set arguments -I ../../doc_src/Includes/ -env env1.ml -c test0.html
# directory ..
# run

MAKEFILESDIR = ../../config
include $(MAKEFILESDIR)/Makefile

HTMLC=../htmlc
HTMLCFLAGS0=-I ../../doc_src/Includes/ -env env0
HTMLCFLAGS1=-I ../../doc_src/Includes/ -env env1.ml

ENVS=env0 env1.ml env9.ml
SOURCES0=test00.html test0.html test1.html test2.html test3.html \
test5.html test6.html test7.html test8.html test9.html test10.html \
test12.html test13.html
MSOURCES=test4.man
SOURCES1=example-eng.html included-fra.html
SOURCES2=example-fra.html included-eng.html

HSOURCES=$(SOURCES0) #$(SOURCES1) $(SOURCES2)
HTARGETS=$(HSOURCES)(:.html=.htm)
MTARGETS=$(MSOURCES)(:.man=.m)

MLPROGS=catpp prepro

all:: $(MLPROGS) $(HTARGETS) $(MTARGETS)
	for i in $(HSOURCES); do \
	echo $$i; \
	j=`basename $$i .html`.htm; \
	cmp $$j results/$$j || exit 2; \
	done; \
	for i in $(MSOURCES); do \
	echo $$i; \
	j=`basename $$i .man`.m; \
	cmp $$j results/$$j || exit 2; \
	done

$(HTARGETS): $(HSOURCES) $(ENVS) ../../doc_src/Includes/htmlc-version.html
$(MTARGETS): $(MSOURCES) $(ENVS) ../../doc_src/Includes/htmlc-version.html

catpp: catpp.ml
	$(CAMLBYT) -o catpp catpp.ml

prepro: prepro.ml
	$(CAMLBYT) -o prepro prepro.ml

clean::
	$(RM) $(MLPROGS)

test3.htm:
	LE_HTMLC="Htmlc forever!"; export LE_HTMLC; \
	$(HTMLC) $(HTMLCFLAGS1) -c test3.html

clean::
	$(RM) *.htm *.m

.SUFFIXES:
.SUFFIXES: .shtml .html .htm .man .m

.shtml.htm:
	$(HTMLC) $(HTMLCFLAGS0) -s $<

.html.htm:
	$(HTMLC) $(HTMLCFLAGS1) -c $<

.man.m:
	$(HTMLC) $(HTMLCFLAGS1) -f $< -t $@
