(* $Id: prepro.ml,v 1.2 2008-03-12 17:07:41 fclement Exp $ *)

(* A pre-processor to rewrite non htmlc applications to htmlc applications. *)

open Scanf.Scanning;;

let keyword_list = [ "include"; ];;

let keywords = Hashtbl.create 17;;

List.iter (fun kwd -> Hashtbl.add keywords kwd ()) keyword_list
;;

let read_line () =
  (*prerr_endline "Prepro: reading a line";*)
  if Scanf.Scanning.end_of_input Scanf.Scanning.stdib then raise End_of_file
  else begin
    (*prerr_endline "Prepro: stdib is not empty.";*)
    Scanf.bscanf Scanf.Scanning.stdib "%[^\n]\n"
      (fun l ->
       (*prerr_endline (Printf.sprintf "Prepro: line \"%s\" read." l);*)
       l)
  end
;;

let write_line l =
  output_string stdout l;
  (*prerr_endline (Printf.sprintf "Prepro: line content \"%s\" written." l);*)
  output_char stdout '\n';
  (*prerr_endline (Printf.sprintf "Prepro: end of line \"%s\" written." l);*)
  flush stdout;
  (*prerr_endline (Printf.sprintf "Prepro: line \"%s\" was written." l)*)
;;

let preprocess f =

  let marker = read_line () in

  try
    while true do
      let l = read_line () in
      if l = marker then begin write_line l; raise End_of_file end else
      write_line (f l)
    done
  with
  | End_of_file ->
    (*prerr_endline "Prepro: finishing.";*)
    exit 0
;;

let rewrite_includes s =
  if String.length s > 0 then
    Scanf.sscanf s "%0c" (function
    | 'a'..'z' | 'A'..'Z' ->
      Scanf.sscanf s "%[a-zA-Z] %s@!" (fun kwd fname ->
      (*prerr_endline (Printf.sprintf "Prepro: analyzing line \"%s\"." s);*)
      (*prerr_endline (Printf.sprintf "Prepro: keyword \"%s\" found." kwd);*)
      (*prerr_endline (Printf.sprintf "Prepro: argument \"%s\" found." fname);*)
(*      match kwd with
      | "include" -> Printf.sprintf "$(include \"%s\")" fname
      | _ -> s *)
      if not (Hashtbl.mem keywords kwd) then s else
      Printf.sprintf "$(%s \"%s\")" kwd fname
      )
    | _ -> s)
    else s
;;

let () = preprocess rewrite_includes;;
