(*
    The environment file to expand the examples.

    It is in ``Caml'' style and uses simple Caml-like bindings.

    For variables, we use:

    let name = value;;

    For functions, we use:

    let f x =
      "@x"
    ;;

*)

(* A function definition. *)
let f x = "My argument was @(x)";;

let t = "named t";;

(* A function application. *)
let y = "@(f t)";;

let concat x y = "@(x)@(y)";;

let z = @t;;

let u = @(concat "con" "catenation");;

let title t =
"<!--#include virtual=\"doctype\" -->
<HTML>

<HEAD>
<META name=\"GENERATOR\" content=\"Htmlc @htmlc_version\">
<META http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">

<TITLE>
@t
</TITLE>
</HEAD>

<BODY BGCOLOR=\"#FFFFFF\">
<!--#include virtual=\"topofpage-eng.html\"-->"
;;

let expand s = "@(scan_lines @s)";;

let blank n = @(string_make " " n);;

let forty_two = 42;;

let glop_glop = "glop glop";;
let pasglop_pasglop = "pas glop pas glop";;
let pifou_content b = "@(conditional b glop_glop pasglop_pasglop)";;

let a_href url options text = "<a href=\"@(url)\" @(options)>@(text)</a>";;
let link url text = "@(a_href @(url) \"\" @(text))";;
let safe_link url text =
  "@(conditional @(is_empty url) text @(link url text))"
;;

let empty_url = "";;
let nonempty_url = "url";;
