(***********************************************************************)
(*                                                                     *)
(*                           CIME Caml                                 *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2003 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(* $Id: substitute.mli,v 1.6 2008-11-05 10:42:35 weis Exp $ *)

(** {3 Variable substitution in buffers} *)

type ident = string;;
type value = string;;

(** Occurrences of [$ident] (or [$(ident)]) in a string are substituted
   according to an environment that maps the variables to strings. *)

val add_string_substitute :
 (ident, value) Hashtbl.t -> Buffer.t -> string -> unit
(** [add_string_substitute t b s] Add string [s] to buffer [b], after
    substituting all occurrences of variables in [s].

    Variables of the form [$ident], [$(ident)], or [${ident}] are
    substituted according to their associated value in the hash table
    [t].

    Variables of the form [<$ident>] are substituted by their value in
    the user's environment (using the standard [Sys.getenv]
    function). *)
;;

val add_string :
 (ident -> value) -> Buffer.t -> string -> unit
(** Same as above with a general substitution function. *)
;;

val is_quoted_string : string -> bool
(** A predicate to detect string in normal form
    (i.e. character strings enclosed between quote chars, ['\'']). *)
;;

val is_forced_string : string -> bool
(** A predicate to detect backquoted expression
    (i.e. character strings enclosed between backquote chars, ['`']). *)
;;
