(***********************************************************************)
(*                                                                     *)
(*                           Htmlc                                     *)
(*                                                                     *)
(*                    Pierre Weis, INRIA Rocquencourt                  *)
(*                                                                     *)
(*  Copyright 1997-2007,                                               *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

(* $Id: setting.mli,v 1.10 2011-05-01 11:57:36 weis Exp $ *)

(** {3 A module to define and record settings of the compiler} *)

type file_permission = int;;

type setting = {

  mutable marker_char : char;

  mutable debug : bool;
  mutable print_env : bool;
  mutable print_setting : bool;

  mutable set_writable_target : bool;
  mutable target_perms : file_permission option;
  mutable force_output_file_name : bool;

  mutable honor_ssi_directive : bool;
  mutable honor_ssi_include : bool;
  mutable honor_ssi_binding : bool;
  mutable delimit_ssi_include : bool;

  mutable honor_non_ssi_directive : bool;
  mutable honor_non_ssi_include : bool;
  mutable honor_non_ssi_binding : bool;
  mutable delimit_non_ssi_include : bool;
  mutable keep_non_ssi_include : bool;
  mutable keep_non_ssi_binding : bool;

  mutable quote_marker : bool;
  mutable honor_substitution_in_text : bool;

  mutable expand_mode : bool;
  mutable ssi_mode : bool;
  mutable non_ssi_mode : bool;

  mutable honor_line_continuation : bool;

  mutable htmlc_definitions : Types.htmlc_definitions list;
  mutable source_preprocessors : Types.command_name list;
  mutable ssi_preprocessors : Types.command_name list;
  mutable non_ssi_preprocessors : Types.command_name list;

  mutable default_language : Lang.t;
  mutable language : Lang.t;
  mutable supported_languages : Lang.t list;

  mutable search_path : File.dir_name list;

}
;;

val default : setting;;
val print_setting : Format.formatter -> setting -> unit;;
