(***********************************************************************)
(*                                                                     *)
(*                           CIME Caml                                 *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2009 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(* $Id: preprocessor.mli,v 1.5 2012-03-25 01:05:09 weis Exp $ *)

(** {6 Preprocessors} *)

val add_source_preprocessor_command : Types.command_name -> unit;;
val add_ssi_preprocessor_command : Types.command_name -> unit;;
val add_non_ssi_preprocessor_command : Types.command_name -> unit;;

val fold :
  Types.command_name list -> File.file_name ->
  Scanf.Scanning.scanbuf -> Scanf.Scanning.scanbuf
(** [fold prepros fname sb] calls in turn each command in the
    list of preprocessors [prepros] on the given scan buffer [sb].
    The result is collected in an output buffer, then extracted from
    the buffer and turned into a new scan buffer to call the rest of the
    command list.

    The result is a new scan buffer containing the pre-processed file. *)
;;

val call_preprocessors :
  Types.htmlc_mode ->
  File.file_name ->
  Scanf.Scanning.scanbuf -> Scanf.Scanning.scanbuf
;;

val call_source_preprocessors :
  File.file_name ->
  Scanf.Scanning.scanbuf -> Scanf.Scanning.scanbuf
(** [call_source_preprocessors fname sb] returns a new [scanbuf] reading from
    the preprocessed version of scanning buffer [sb].
    Note: presumably, the [sb] argument is reading from file [fname], but
    [call_source_preprocessors] does not requires it. *)
;;

val call_ssi_preprocessors :
  File.file_name ->
  Scanf.Scanning.scanbuf -> Scanf.Scanning.scanbuf
(** [call_ssi_preprocessors fname sb] same as above in ssi mode. *)
;;

val call_non_ssi_preprocessors :
  File.file_name ->
  Scanf.Scanning.scanbuf -> Scanf.Scanning.scanbuf
(** [call_non_ssi_preprocessors fname sb] same as above in non-ssi mode. *)
;;
