(***********************************************************************)
(*                                                                     *)
(*                           Htmlc                                     *)
(*                                                                     *)
(*                    Pierre Weis, INRIA Rocquencourt                  *)
(*                                                                     *)
(*  Copyright 2007 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(* $Id: parser.mli,v 1.17 2012-03-28 13:14:00 weis Exp $ *)

(** {A very basic paring engine for Htmlc source files} *)

type marker = char;;

type binding_mode =
   | Parsing_mode
   | End_of_line_mode
(**
The two predefined ways to read an identifier definition:
    - in [Parsing_mode], the expression that is bound to the identifier
      is parsed normally,
    - in [End_of_line_mode], the expression that is bound to the identifier
      is not parsed: it just spreads to the next end of line character.
*)
;;

type lexeme =
   | Number of float
   | String of string
   | Char of string
   | Bool of string
   | Ident of string
   | Symbol of string
   | Quoted of string
   | Forced of string
   | Let | Rec | Quote
(*   | If | Then | Else*)
   | Eq | SemiSemi
   | Eof
(** The lexemes of this grammar. *)
;;

type error;;

exception Error of error;;

val string_of_exc : exn -> string;;

val skip_caml_comments : Scanf.Scanning.scanbuf -> unit;;
val get_line : Scanf.Scanning.scanbuf -> string;;

val parse_expression : marker -> Scanf.Scanning.scanbuf -> lexeme;;
val parse_expression_to_end_of_line : Scanf.Scanning.scanbuf -> lexeme;;

val parse_ident_list : Scanf.Scanning.scanbuf -> string * string list;;
val parse_expression_list : marker -> Scanf.Scanning.scanbuf -> lexeme * lexeme list;;

val unquote : string -> string;;
val unforce_string : string -> string;;

val string_of_lexeme : marker -> lexeme -> string;;
