(***********************************************************************)
(*                                                                     *)
(*                           Htmlc                                     *)
(*                                                                     *)
(*                    Pierre Weis, INRIA Rocquencourt                  *)
(*                                                                     *)
(*  Copyright 1997-2009,                                               *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

(* $Id: io_domain.mli,v 1.3 2011-05-01 11:57:36 weis Exp $ *)

(** {3 Definition and operations on input/output domains.} *)

type io_domain =
   | Io_string of string
   | Io_file of File.file_name
   | Io_standard
(** The various entities to perform ios onto:
   either an immediate string, a file name, or a standard channel.
   Could add functions as source/target of Ios ??? *)
;;

type t = io_domain
(** A short public alias for I/O domains. *)
;;

val of_filename : File.file_name -> io_domain;;

val name_in : io_domain -> string;;

val name_out : io_domain -> string;;

val permissions : io_domain -> Unix.file_perm;;

val make_read_only : io_domain -> unit;;

val permissions_in : io_domain -> Unix.file_perm;;

val permissions_out : io_domain -> Unix.file_perm;;

val open_in : io_domain -> in_channel;;

val open_out : Unix.file_perm -> io_domain -> out_channel;;

val close_in : io_domain -> in_channel -> unit;;

val close_out : io_domain -> out_channel -> unit;;

val temporary_target :
  File.file_extension -> io_domain -> io_domain -> io_domain
;;

val remove_temporary_target : io_domain -> io_domain -> unit;;

val rename : io_domain -> io_domain -> unit;;

val remove : io_domain -> unit;;

