(***********************************************************************)
(*                                                                     *)
(*                           CIME Caml                                 *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 1997 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(** {3 The main procedure of the [Htmlc] compiler} *)

(* $Id: htmlc.mli,v 1.24 2011-05-01 11:57:36 weis Exp $ *)

exception Error of string * int * exn;;

val string_of_exc : exn -> string;;

val treat_buffer : File.file_name -> Buffer.t ->
  Scanf.Scanning.scanbuf -> unit
;;

val treat_domains : Io_domain.t -> Io_domain.t -> unit
;;

(** Internal use. *)

val add_env_file_name : File.file_name -> unit;;
val add_bindings_file_name : File.file_name -> unit;;
val add_definition_ident : Env.ident -> unit;;
val add_definition_value : string -> unit;;

val bind_htmlc_definitions : unit -> unit;;

val load_env_file_names : File.file_name list -> unit;;
