(***********************************************************************)
(*                                                                     *)
(*                           Htmlc                                     *)
(*                                                                     *)
(*                    Pierre Weis, INRIA Rocquencourt                  *)
(*                                                                     *)
(*  Copyright 2009,                                                    *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

(* $Id: execute.ml,v 1.1 2009-02-19 20:28:11 weis Exp $ *)

(** {3 Operating system level execution} *)

(** {6 Executing a system command and registering its ouput in a buffer} *)

let htmlc_command htmlc_add_string src_name ob command_name =
  let ic = Unix.open_process_in command_name in
  let ib = String.create Configuration.line_buffer_length in
  let status =
    let rec loop () =
      let n = input ic ib 0 Configuration.line_buffer_length in
      if n > 0 then (htmlc_add_string ob (String.sub ib 0 n); loop ())
      else raise End_of_file in
    try loop () with
    | End_of_file ->
      (match Unix.close_process_in ic with
       | Unix.WEXITED n -> n
       | Unix.WSIGNALED _ | Unix.WSTOPPED _ -> 2) in
  if status <> 0 then
    Debug.failwith
      (Printf.sprintf
         "file %s: command %s failed to execute properly."
         src_name command_name)
;;

let command command_name =
  let ob = Buffer.create Configuration.line_buffer_length in
  htmlc_command Buffer.add_string "<abstract>" ob command_name;
  Buffer.contents ob
;;

(** {6 Executing a CGI command and registering its ouput in a buffer} *)
let htmlc_cgi _htmlc_add_string src_name _ob _cgi_name =
  Debug.failwith (Printf.sprintf "file %s: cgi not yet implemented" src_name)
;;

let cgi cgi_name =
  let ob = Buffer.create Configuration.line_buffer_length in
  ignore (htmlc_cgi Buffer.add_string "<abstract>" ob cgi_name);
  Buffer.contents ob
;;
