(***********************************************************************)
(*                                                                     *)
(*                           Htmlc                                     *)
(*                                                                     *)
(*                    Pierre Weis, INRIA Rocquencourt                  *)
(*                                                                     *)
(*  Copyright 1997-2007,                                               *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

(* $Id: debug.mli,v 1.2 2011-05-01 12:02:57 weis Exp $ *)

(** {3 Some simple generic tools for debugging} *)

val get_debug : unit -> bool;;

val set_debug : unit -> unit;;
(** Turn debugging on. *)

val failwith : string -> 'a;;
(** A special [Debug.failwith] function to be able to trace the failure
  strings. *)

val printf : ('a, out_channel, unit) format -> 'a;;
(** [Debug.printf] prints its arguments on [stderr]
    when debugging is on. *)

val message : string -> unit;;
(** [Debug.message] outputs a given message on [stderr]
    when debugging is on. *)

val warning : string -> unit;;
(** [Debug.warning] unconditionally outputs a warning on [stderr]. *)
