(***********************************************************************)
(*                                                                     *)
(*                           Htmlc                                     *)
(*                                                                     *)
(*                    Pierre Weis, INRIA Rocquencourt                  *)
(*                                                                     *)
(*  Copyright 1997-2007,                                               *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

(* $Id: debug.ml,v 1.11 2011-05-15 15:45:19 weis Exp $ *)

(** {3 Some simple generic tools for debugging} *)

let get_debug, set_debug =
  let debug = ref false in
  (fun () -> !debug),
  (fun () -> debug := true)
;;

(** A special [Debug.failwith] function to be able to trace the failure
  strings. *)
let failwith failure_string =
  if get_debug () then prerr_endline failure_string;
  raise (Failure failure_string)
;;

let printf fmt =
  if get_debug ()
  then Printf.fprintf stderr fmt
  else Printf.ifprintf stderr fmt
;;

let warning s =
  Printf.fprintf stderr "%s: warning, %s\n"
    (Filename.basename Sys.executable_name)
    s
;;

let message s =
  if get_debug () then prerr_endline s else ()
;;

(*
 Local Variables:
  compile-command: "make"
  End:
*)
