.\"                                      Hey, EMACS: -*- nroff -*-
.\" First parameter, NAME, should be all caps
.\" Second parameter, SECTION, should be 1-8, maybe w/ subsection
.\" other parameters are allowed: see man(7), man(1)
.TH ADVI SECTION "September 01, 2004"
.\" Please adjust this date whenever revising the manpage.
.\"
.\" Some roff macros, for reference:
.\" .nh        disable hyphenation
.\" .hy        enable hyphenation
.\" .ad l      left justify
.\" .ad b      justify to both left and right margins
.\" .nf        disable filling
.\" .fi        enable filling
.\" .br        insert line break
.\" .sp <n>    insert n+1 empty lines
.\" for manpage-specific macros, see man(7)
.SH NAME
.B htmlc
\-\- an HTML template compiler and generator
.UR http://caml.inria.fr/htmlc/
(http://caml.inria.fr/htmlc/)
.UE
with file inclusion, variable substitution and Server Side Includes
static execution.

.SH VERSION
Htmlc version $htmlc_version
.SH SYNOPSIS
.B htmlc
.RI [ options ] [source file] [target file] ...
.SH DESCRIPTION
The 
.B htmlc
compiler is a HTML page generator. It parses a HTML source template
with compiler directives and produces a regular HTML file.

.P
.B htmlc
supports arbitrary file inclusion (possibly recursive), various
predefined computation operators (e.g. file size, or date of last
modification of files), and more generally the textual output of
arbitrary Unix commands.

.P
.B htmlc
also supports variables expansion into the template files: the
variable bindings can be defined in a shared
.B environment file
or directly written into the template file. System environment
variables expansion is also available.

.P
In brief,
.B htmlc
allows fully static execution of Server Side Include directives. It also
implements a lot of supplementary features that ease the writing and
maintenance of a Web site. The compilation approach used in
.B htmlc
allows a lot of static verification during the generation of the HTML
pages of a Web site. The neat result is that errors in the conception
of pages are detected very early, way
.B before
the Web site is made available to the public. An additional benefit of
the compilation approach is to drastically lighten the HTTP server
load: the server no more needs to parse the pages and expanse the
directives in them again and again for each request.

.P
.B htmlc
also shines as the back end of CGI (Common Gateway Interface) programs
to generate the final HTML answer page of the program.  The programmer
has just to write an HTML template with some
.B htmlc
variables to be filled with the specific part of the answer.
The CGI program then creates a set of bindings for the variables, and calls
.B htmlc
to expand the template to finally return a complete answer where the
variables have been expanded according to the results of the
CGI program computation.

.SH CURRENTLY SUPPORTED FEATURES:

\- File inclusion

\- Verbatim file inclusion (HTML entities are properly expanded)

\- Size and last modification date of files

\- Variable expansion

\- System environment variable expansion

\- Unix command launching with the standard output redirected to the
compiled file

.SH OPTIONS
Options are :
.TP
.B \-I \<dirname\>
Add directory \<dirname\> in front of the list of directories searched
for include files.
.TP
.B \-w
Compiled files should be writable (default is read only).
.TP
.B \-env \<filename\>
Read \<filename\> to define variable bindings for substitution during
compilation.
.TP
.B \-D ident value
Bind \<ident\> to \<value\> for substitution during compilation.
.TP
.B \-lang \<language\>
The language is set to \<language\> during the compilation
(default is to guess the language from the source file-name extension).
.TP
.B \-default\-lang \<language\>
The default language is set to \<language\>.
.TP
.B \-\-languages
List the set of languages that
.B htmlc
currently supports.
.TP
.B \-s \<filename.shtml\>
Set the input file to \<filename.shtml\>,
the output file is set to \<filename.html\>.
.TP
.B \-c \<filename.html\>
Set the input file to \<filename.html\>,
the output file is set to \<filename.htm\>.
.TP
.B \-tpl \<filename\>
Set the input file to \<filename\>,
the output file is set to \<file.html\>, where \<file\>
designates \<filename\> without its extension (if any).
.TP
.B \-o <filename>
Set the output compiled file to \<filename\> ("-"
stands for stdout).
.TP
.B \-t <filename>
Set the output compiled file to \<filename\> ("-"
stands for stdout).
.TP
.B \-to <filename>
Set the output compiled file to \<filename\> ("-"
stands for stdout).
.TP
.B \-i <filename>
Set the input file to \<filename\> ("-"
stands for stdin).
.TP
.B \-f <filename>
Set the input file to \<filename\> ("-"
stands for stdin).
.TP
.B \-from <filename>
Set the input file to \<filename\> ("-"
stands for stdin).
.TP
.B \-v
Print the
.B htmlc
version number.
.TP
.B \-\-version
Print the
.B htmlc
long version number.
.TP
.B \-help
Display this list of options
.TP
.B \-\-help
Display this list of options

.SH COPYRIGHT
This program is distributed under the artistic licence found in the
LICENSE file in the root directory of the distribution.
.SH SEE ALSO
.BR
The
.B htmlc
user's manual (http://caml.inria.fr/htmlc/eng.htm)
(french version at http://caml.inria.fr/htmlc/fra.htm).
.SH AUTHORS
Pierre Weis <Pierre.Weis@inria.fr>
.P
The original version of this manual page was written by Pierre Weis
<Pierre.Weis@inria.fr>, for
.B htmlc
version 1.6.
.P
Institut National de Recherche en Informatique et en Automatique (2004)
