(***********************************************************************)
(*                                                                     *)
(*                           Htmlc                                     *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2003 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(* $Id: version.mli,v 1.2 2004/07/11 21:41:52 weis Exp $ *)

(* Handling versioning of the software. *)

val print_version : unit -> unit;;
 (** Print the current version of the software on [stderr].
   The version number should be suitable for the format string  ["%.2f"].
   Intended use of this function is to handle the [-v] comand line
   option parsed with the [Arg] standard library module. *)
val print_full_version : unit -> unit;;
 (** Same as above for the full version of the software (normally the
   full version should state a date and a subversion, suitable for the
   format string ["%.2f+%i (%s)"]). *)

val htmlc_version : string;;
val htmlc_full_version : string;;

 (** The value of the current Htmlc version ([htmlc_version] has
  format ``version'', [htmlc_full_version] has format
  ``version+subversion (date)'', reminiscent ot the versionning scheme
  of the Caml compiler). *)
