(***********************************************************************)
(*                                                                     *)
(*                           CIME Caml                                 *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 1997 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(* $Id: path.mli,v 1.4 2004/07/11 21:41:52 weis Exp $ *)

exception Empty;;
(* This exception is raised when [pop] is called and the current
   directory path is empty. *)
val current : string list ref;;
val push : string -> unit;;
val pop : unit -> unit;;
(* The path machinery:
   define a current list of directories to search to find files. *)
val open_in : string -> in_channel;;
val open_out : string -> out_channel;;
(* Opening files in the current path. Equivalent to the regular open
   primitives if the file name argument is not implicit. *)
val find : string -> string;;
