(***********************************************************************)
(*                                                                     *)
(*                           CIME Caml                                 *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 1997 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(* $Id: date.mli,v 1.3 2004/04/14 09:46:29 weis Exp $ *)

type file_name = string;;

open Unix;;

(* Getting the time of day. *)

val local_date_of_day : Lang.t -> string;;
 (* Return the current date as a string according to the [lang] argument.
    Assumes the local time zone. *)

val date_of_day : Lang.t -> string;;
 (* Return the current date as a string according to the [lang] argument.
    Assumes Greenwich meridian time zone, also known as UTC. *)

val date_uk_of_day : unit -> string;;
val date_fr_of_day : unit -> string;;
 (* The string representation of the current time of day, respectively
    in english and french. Assumes the local time zone. *)

val date : unit -> string;;
 (* Synomym for [date_of_day Uk]. *)

val local_date : unit -> string;;
 (* Synomym for [local_date_of_day Uk]. *)

val time_of_day : unit -> tm;;
 (* Return the time of day as a Unix time. Assumes Greenwich meridian
    time zone, also known as UTC. *)

val string_of_time : Lang.t -> tm -> string;;
 (* Translate a Unix time to a string according to the [lang]
    argument. *)

val last_modification_time_of_file : file_name -> tm;;
 (* Last modification time of a file.
    Returns [time_of_day ()], if file name is ["-"]. *)
val last_modification_date_of_file : Lang.t -> file_name -> string;;
 (* Assumes Greenwich meridian time zone. *)
