(***********************************************************************)
(*                                                                     *)
(*                           CIME Caml                                 *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 1997 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(* $Id: date.ml,v 1.4 2004/04/14 09:46:29 weis Exp $ *)

type file_name = string;;

open Unix;;
open Lib_date;;
open Lang;;

let time_of_day () = gmtime (time ());;
let local_time_of_day () = localtime (time ());;

let time_of_tm tm =
  Printf.sprintf "%d:%d:%d" tm.Unix.tm_hour tm.Unix.tm_min tm.Unix.tm_sec;;

let string_of_time lang tm =
 let month_day = tm.Unix.tm_mday in
 let month = tm.Unix.tm_mon in
 let week_day = tm.Unix.tm_wday in
 let year = tm.Unix.tm_year in
 format_date lang month_day month week_day year;;

let string_of_tm lang tm =
  Printf.sprintf "%s %s" (string_of_time lang tm) (time_of_tm tm);;

let date_of_day lang = string_of_tm lang (time_of_day ());;
let local_date_of_day lang = string_of_tm lang (local_time_of_day ());;

let date_uk_of_day () = date_of_day Uk;;
let date_fr_of_day () = date_of_day Fr;;

let date = date_uk_of_day;;
let local_date () = local_date_of_day Uk;;

let last_modification_time_of_file s =
 if s = "-" then time_of_day () else
 let st = Unix.stat s in
 let last_mod_time = st.Unix.st_mtime in
 let tm = Unix.gmtime last_mod_time in
 tm;;

let last_modification_date_of_file lang s =
 string_of_time lang (last_modification_time_of_file s);;
