(***********************************************************************)
(*                                                                     *)
(*                           CIME Caml                                 *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2003 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(* $Id: substitute.mli,v 1.1 2003/03/02 18:28:54 weis Exp $ *)


(* Variable substitution in buffers:
   Substitute $ident (or $(ident)) in a string are substituted
   according to an environment that maps the variables to strings. *)

val add_string :
 (string, string) Hashtbl.t -> Buffer.t -> string -> unit;;

(** [add_string_substitute t b s] Add string [s] to buffer [b], after
    substituting all occurrences of variables in [s].

    Variables of the form [$ident], [$(ident)], or [${ident}] are
    substituted according to their associated value in the hash table
    [t].

    Variables of the form [<$ident>] are substituted by their value in
    the user's environment (using the standard [Sys.getenv]
    function). *)
