(***********************************************************************)
(*                                                                     *)
(*                           CIME Caml                                 *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 1997 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(* $Id: path.ml,v 1.3 2003/03/01 16:01:25 weis Exp $ *)

(* The path machinery:
   we define a current list of directories to look up for finding files. *)
exception Empty;;

let current = ref [];;

let push p = current := p :: !current;;
let pop () =
 match !current with
 | [] -> raise Empty
 | _ :: rest -> current := rest;;

(*
val find : (string -> 'a) -> string list -> string -> 'a;;
  [find f path s] applies [f] on any files named [s] in
   the path, and returns the result of the first call that does not
   fail by raising the exception [Sys_error]. For instance,
   [find open_in "foo"] searches the current path for a file
   ["foo"] and returns an input channel to that file. *) 
let find f path s =
 try f s with
 | Sys_error _ as x ->
   let rec do_in = function
   | [] -> raise x
   | p :: pts ->
     try f (Filename.concat p s) with
     | Sys_error _ -> do_in pts in
   do_in path;;

let open_in s =
 if Filename.is_implicit s
 then find Pervasives.open_in !current s
 else open_in s;;

let open_out s =
 if Filename.is_implicit s
 then find Pervasives.open_out !current s
 else open_out s;;

