#!/usr/bin/perl
#
# Linux Source Code CGI Browser 
# Copyright (C) 1995 by Ben Walter <bjw@gnu.ai.mit.edu>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
#	                  C O N F I G U R A T I O N                         #
#############################################################################

@INC = (@INC, '.');

require 'importenv.pl';
require 'navigator.conf';

$source_root = '/users/b/ben/html/linux/linux/'; # Base directory of Linux 

#############################################################################
#                           C G I   P A R S I N G                           #
#############################################################################

$QUERY_STRING =~ s/\.\.//g;
%prefs = $PATH_INFO =~ /\/(\w+)=([^\/]+)/g;
&check_prefs;
$QUERY_STRING =~ s/^include\/asm\//include\/asm-$arch\// if
    $QUERY_STRING =~ /^include\/asm\//;

($this_path) = $QUERY_STRING =~ /(.+)\/\S+$/;
($this_file) = $QUERY_STRING =~ /\/?(\S+)$/;
$source = "$source_root/$QUERY_STRING";
$source =~ s/\/$//;




$NAVIGATOR_CGI_URL .= $PATH_INFO;

sub check_prefs {
    $arch = $prefs{'arch'};
    $arch = $DEFAULT_ARCH if $arch eq "";
    $version = $prefs{'ver'};
    $version = $DEFAULT_VERSION if $version eq "";
    if (! defined($releases{"$version-$arch"} )) {
	print <<_EOF_;
Content-type: text/html

<HEAD>
<TITLE>Sorry, nothing available</TITLE>
</HEAD>
<BODY BACKGROUND="$NAVIGATOR_BASE_URL/bg2.gif">

<CENTER>
<H2><FONT SIZE=+3>L</FONT><FONT SIZE=+2>INUX </FONT><FONT SIZE=+3>S</FONT><FONT SIZE=+2>OURCE </FONT><FONT SIZE=+3>N</FONT><FONT SIZE=+2>AVIGATOR</FONT></H2>
</CENTER>

<FONT SIZE=+1>
Sorry, there is currently no support for <B>$version-$arch</B>.  Please
select another combination from the supported list:
</FONT>

<CENTER>
<TABLE BORDER=2>
<TR><TH>Kernel Version</TH><TH>Architecture</TH></TR>
<P>
_EOF_

    foreach(keys %releases) {
	($v, $a) = split('-');
	print <<_EOF_;
<TR><TD>$v</TD><TD><A HREF="$NAVIGATOR_CGI_URL/arch=$a/ver=$v?"><B>$a</B></A></TD></TR>
_EOF_
}				
	print <<_EOF_;
</TABLE>
</CENTER>

</BODY>
_EOF_
    exit;
    }
}


#############################################################################
#                        A N S I   C   K E Y W O R D S                      #
#############################################################################

%ansi = ('auto',1,	 'break',1,	 'case',1,
	 'char',1,	 'const',1,	 'continue',1,
	 'default',1,	 'do',1,	 'double',1,
	 'else',1,	 'enum',1,	 'extern',1,
	 'float',1,	 'for',1,	 'goto',1,
	 'if',1,	 'int',1,	 'long',1,
	 'register',1,	 'return',1,	 'short',1,
	 'signed',1,	 'sizeof',1,	 'static',1,
	 'struct',1,	 'switch',1,	 'typedef',1,
	 'union',1,	 'unsigned',1,	 'void',1,
	 'volatile',1,	 'while',1);

sub ansi_token {
    local($token) = @_;
    return defined $ansi{$token};
}

#############################################################################
#                        T A G   O P E R A T I O N S                        #
#############################################################################

sub load_tags {
    local($tags_db) = @_;
    dbmopen(%TAGS, $tags_db, 0444);
}

sub lookup_token {
    return $TAGS{$token};
}

sub index_tags {
    local($file) = @_; 
    local(%tags, $what, $where);
    $what = "ctags -xt $file |";
    open(CTAGS,$what);
    while(<CTAGS>) {
	($what, $where) = /^(\S+)\s+(\d+)/;
	$tags{$where} = "<A NAME=$what></A>";
    }
    close(CTAGS);
    return(%tags);
}


#############################################################################
#                                M I S C                                    #
#############################################################################

sub cat {
    local($file) = @_;
    open(FILE, $file);
    print "<PRE>\n";
    while(<FILE>) {
	print;
    }
    print "</PRE>\n";
}

#############################################################################
#                 D I R E C T O R Y    B U I L D I N G                      #
#############################################################################

sub ls {
    local($dir) = @_;
    local(@contents, $url, @formatted);

    opendir(DIR, $source);
    @contents = sort grep(!/^\./, readdir(DIR));
    closedir(DIR);

    ($url) = $dir =~ /^$source_root\/(\S+)$/;
    if ($url ne "") {
	if ($url =~ /\//) {
	    ($up = $url) =~ s/\/[^\/]+$//;
	} else {
	    $up = "";
	}
	push(@contents,
	     "<IMG SRC=$DIRECTORY_ICON align=center> <A HREF=\"$NAVIGATOR_CGI_URL?$up\"><B>..</B></A>");
	$url .= "/";
    }

    $url = "$NAVIGATOR_CGI_URL?$url";

    print <<TABLE;
</PRE>
<CENTER>
<FONT SIZE=+1>
<TABLE BORDER=2>
<TR><TD>
<TABLE BORDER=0 WIDTH=100%>
<TR>
TABLE

    $col = -1;    
    foreach $file (@contents) {
	if ($col == 0 || $col == 1) {
	    print "<TD><PRE>   </PRE></TD>\n";
	}
	if ($col++ == 2) {
	    print "</TR>\n<TR>\n";
	    $col = 0;
	}
	if ($file =~ /<B>..<\/B>/) {
	    print <<TD;
<TD ALIGN=left>
$file
</TD>
TD
	next;
	}
	$path = "$dir/$file";
	if (-d $path) {
	    print <<TD;
<TD ALIGN=left>
<IMG SRC=$DIRECTORY_ICON ALIGN=center><A HREF=\"$url$file\"><B>$file</B></A>
</TD>
TD
	} else {
	    print <<TD;
<TD ALIGN=left>
<IMG SRC=$TEXT_ICON ALIGN=center> <A HREF=\"$url$file\"><B>$file</B></A>
</TD>
TD
	}
    }
    print "</TABLE></TD></TR></TABLE></CENTER>\n";
}

#############################################################################
#                             L E X E R                                     #
#############################################################################


sub print_header {
    print <<EOH;
Content-type: text/html

<HEAD>
<TITLE>$this_file</TITLE>
</HEAD>
<BODY BGCOLOR=#e8e8e8>
<PRE>
<!-- Created by the Linux Source Navigator -->
<FONT SIZE=+1>
EOH
}

sub do_include {
    if (/&lt/) {
	($include) = /&lt(.+)&gt/;
	$url = "$NAVIGATOR_CGI_URL?include/$include";
	$include = "<A HREF=\"$url\">&lt$include&gt</A>";
	s/&lt(.+)&gt/$include/;
    } else {
	($include) = /"(.+)"/;
	$url = "$NAVIGATOR_CGI_URL?$this_path/$include";
	$include = "<A HREF=$url>\"$include\"</A>";
	s/"(.+)"/$include/;
    }
}

sub do_directory {
    local($title);
    ($upper_this_file = $this_file) =~ tr/a-z/A-Z/;
    if ($this_file eq "") {
    print <<HEAD;
</PRE>
<CENTER>
<TITLE>Linux Source Navigator</TITLE>
<H2><FONT SIZE=+3>L</FONT><FONT SIZE=+2>INUX </FONT><FONT SIZE=+3>S</FONT><FONT SIZE=+2>OURCE </FONT><FONT SIZE=+3>N</FONT><FONT SIZE=+2>AVIGATOR</FONT></H2>
</CENTER>
<PRE>
HEAD
    } else {
    print <<HEAD;
</PRE>
<CENTER>
<TITLE>Directory of $this_file</TITLE>
<H2><FONT SIZE=+2>$upper_this_file</FONT></H2>
</CENTER>
<PRE>
HEAD
    }

    &ls($source);
    if (-e "$source/README") {
#	print "\n<HR SIZE=5><P>\n\n";
	&cat("$source/README");
    }
}

sub count {
    local ($s, $c) = @_;
    local ($count);
    while ($s =~ /$c/g) { $count++; };
    return $count;
}

$comment_count = 0;
sub in_comment {
    local($string, $pos) = @_;
    local($s);
    $s = substr($string, 0, $pos);
    $this_comment_count = (&count($s, '\/\*') - &count($s, '\*\/'));
    return 1 if ($comment_count + $this_comment_count) gt 0;
    return 0;
}

$string_count = 0;
sub in_string {
    local($string, $pos) = @_;
    local($s);
    $s = substr($string, 0, $pos);
    $this_string_count = (&count($s, '\"') - &count($s, '\\\"'));
    return ($string_count + $this_string_count) % 2;
}

sub is_literal {
    local($token) = @_;
    return 1 if $token =~ /^\d+$/;
    return 1 if $token =~ /^0x\d+$/;
}
		  

sub do_c {
    &load_tags('./tags');
    %tags = &index_tags($source);
    $line = 0;
    open(SOURCE, $source);

    while(<SOURCE>) {
	$line++;
	s/</\310/g;
	s/>/\311/g;
	s/&/\312/g;
	if (/^#/) {
	    s/\310/&lt;/g;
	    s/\311/&gt;/g;
	    s/\312/&amp;/g;
	    &do_include if /^#include/;
	    chop;
	    print "<FONT COLOR=$PREP_COLOR>$_</FONT>\n";
	    next;
	} 
	$pos = $len = 0;
	foreach $token (/([A-Za-z0-9_]+)/g) {
	    $pos = index($_, $token, $pos);
	    $len = length($token);
	    if (! &in_comment($_, $pos) && ! &in_string($_, $pos)) {
		if (&ansi_token($token)) {
		    $token = "<FONT COLOR=$ANSI_COLOR>$token</FONT>";
		}  elsif (($where = &lookup_token($token)) ne "") {
		    if ($where eq "__static__") {
			$token = "<A HREF=\"#$token\">$token</A>";
		    } else {
			$token = "<A HREF=\"$NAVIGATOR_CGI_URL?$where#$token\"><B>$token</B></A>";
		    }
		} elsif (&is_literal($token)) {
		    $token = "<FONT COLOR=$LITR_COLOR>$token</FONT>";
		} else {
		    # This is yucky
		    $token = "<B>$token</B>" if ($token ne "lt" && $token ne "gt");
		     }
	    substr($_, $pos, $len) = "$token";
	    $len = length($token);
	    $pos += $len;
	    }
	}       
	print $tags{$line} if $tags{$line} ne "";	     
	$comment_count += (&count($_,'\/\*') - &count($_,'\*\/'));
	$string_count += (&count($_, '\"') - &count($_, '\\\"'));
	s/\/\*/<I>\/\*/g;
	s/\*\//\*\/<\/I>/g;    
	s/\310/&lt;/g;
	s/\311/&gt;/g;
	s/\312/&amp;/g;
	print;	 
    }
    dbmclose(%TAGS);
    close(SOURCE);
    print <<_EOF_;
</FONT>
</PRE>
</BODY>
_EOF_
}

###########################################################################

&print_header;
if (-d $source) {
    &do_directory;
    exit;
} elsif ($source =~ /\.[ch]$/) {
    &do_c;
    exit;
} else {			
    &cat($source);
    exit;
}








