#!/usr/bin/perl
#
# Linux Source Code CGI Browser 
# Copyright (C) 1995 by Ben Walter <bjw@gnu.ai.mit.edu>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#############################################################################
#	                  C O N F I G U R A T I O N                         #
#############################################################################

$source_root = '/users/ben/html/linux/linux/'; # Base directory of Linux 
$base_url = 'http://www.ice.k12.il.us/~ben/linux'; # Base URL
$my_url = "$base_url/navigator.cgi"; # CGI URL
$directory_icon = "$base_url/dir.gif";
$text_icon = "$base_url/text.gif";


#############################################################################
#                           C G I   P A R S I N G                           #
#############################################################################

$ARGV[0] =~ s/\.\.//g;
($this_path) = $ARGV[0] =~ /(.+)\/\S+$/;
($this_file) = $ARGV[0] =~ /\/?(\S+)$/;
$source = "$source_root/$ARGV[0]";
$source =~ s/\/$//;


#############################################################################
#                        A N S I   C   K E Y W O R D S                      #
#############################################################################

%ansi = ('auto',1,	 'break',1,	 'case',1,
	 'char',1,	 'const',1,	 'continue',1,
	 'default',1,	 'do',1,	 'double',1,
	 'else',1,	 'enum',1,	 'extern',1,
	 'float',1,	 'for',1,	 'goto',1,
	 'if',1,	 'int',1,	 'long',1,
	 'register',1,	 'return',1,	 'short',1,
	 'signed',1,	 'sizeof',1,	 'static',1,
	 'struct',1,	 'switch',1,	 'typedef',1,
	 'union',1,	 'unsigned',1,	 'void',1,
	 'volatile',1,	 'while',1);

sub ansi_token {
    local($token) = @_;
    return defined $ansi{$token};
}

#############################################################################
#                        T A G   O P E R A T I O N S                        #
#############################################################################

sub load_tags {
    local($tags_db) = @_;
    dbmopen(%TAGS, $tags_db, 0444);
}

sub lookup_token {
    return $TAGS{$token};
}

sub index_tags {
    local($file) = @_; 
    local(%tags, $what, $where);
    $what = "ctags -xt $file |";
    open(CTAGS,$what);
    while(<CTAGS>) {
	($what, $where) = /^(\S+)\s+(\d+)/;
	$tags{$where} = "<A NAME=$what></A>";
    }
    close(CTAGS);
    return(%tags);
}


#############################################################################
#                                M I S C                                    #
#############################################################################

sub cat {
    local($file) = @_;
    open(FILE, $file);
    print "<PRE>\n";
    while(<FILE>) {
	print;
    }
    print "</PRE>\n";
}

#############################################################################
#                 D I R E C T O R Y    B U I L D I N G                      #
#############################################################################

sub ls {
    local($dir) = @_;
    local(@contents, $url, @formatted);

    opendir(DIR, $source);
    @contents = grep(!/^\./, readdir(DIR));
    closedir(DIR);

    ($url) = $dir =~ /^$source_root\/(\S+)$/;
    if ($url ne "") {
	if ($url =~ /\//) {
	    ($up = $url) =~ s/\/[^\/]+$//;
	} else {
	    $up = "";
	}
	push(@contents,
	     "<IMG SRC=$directory_icon ALIGN=center> <A HREF=\"$my_url?$up\"><B>..</B></A>");
	$url .= "/";
    }

    $url = "$my_url?$url";

    print <<TABLE;
</PRE>
<CENTER>
<FONT SIZE=+1>
<TABLE BORDER=2>
<TR><TD>
<TABLE BORDER=0 WIDTH=100%>
<TR>
TABLE

    $col = -1;    
    foreach $file (@contents) {
	if ($col == 0 || $col == 1) {
	    print "<TD><PRE>   </PRE></TD>\n";
	}
	if ($col++ == 2) {
	    print "</TR>\n<TR>\n";
	    $col = 0;
	}
	if ($file =~ /<B>..<\/B>/) {
	    print <<TD;
<TD ALIGN=left>
$file
</TD>
TD
	next;
	}
	$path = "$dir/$file";
	if (-d $path) {
	    print <<TD;
<TD ALIGN=left>
<IMG SRC=$directory_icon ALIGN=center> <A HREF=\"$url$file\"><B>$file</B></A>
</TD>
TD
	} else {
	    print <<TD;
<TD ALIGN=left>
<IMG SRC=$text_icon ALIGN=center> <A HREF=\"$url$file\"><B>$file</B></A>
</TD>
TD
	}
    }
    print "</TABLE></TD></TR></TABLE></CENTER>\n";
}

#############################################################################
#                             L E X E R                                     #
#############################################################################


sub print_header {
    print <<EOH;
Content-type: text/html

<HEAD>
<TITLE>$this_file</TITLE>
</HEAD>
<BODY BACKGROUND="bg2.gif">
<PRE>
<!-- Created by the Linux Source Navigator -->
<FONT SIZE=+1>
EOH
}

sub do_include {
    if (/&lt/) {
	($include) = /&lt(.+)&gt/;
	$url = "$my_url?include/$include";
	$include = "<A HREF=\"$url\">&lt$include&gt</A>";
	s/&lt(.+)&gt/$include/;
    } else {
	($include) = /"(.+)"/;
	$url = "$my_url?$this_path/$include";
	$include = "<A HREF=$url>\"$include\"</A>";
	s/"(.+)"/$include/;
    }
}

sub do_directory {
    local($title);
    ($upper_this_file = $this_file) =~ tr/a-z/A-Z/;
    if ($this_file eq "") {
    print <<HEAD;
</PRE>
<CENTER>
<TITLE>Linux Source Navigator</TITLE>
<H2><FONT SIZE=+3>L</FONT><FONT SIZE=+2>INUX </FONT><FONT SIZE=+3>S</FONT><FONT SIZE=+2>OURCE </FONT><FONT SIZE=+3>N</FONT><FONT SIZE=+2>AVIGATOR</FONT></H2>
</CENTER>
<PRE>
HEAD
    } else {
    print <<HEAD;
</PRE>
<CENTER>
<TITLE>Directory of $this_file</TITLE>
<H2><FONT SIZE=+2>$upper_this_file</FONT></H2>
</CENTER>
<PRE>
HEAD
    }

    &ls($source);
    if (-e "$source/README") {
#	print "\n<HR SIZE=5><P>\n\n";
	&cat("$source/README");
    }
}

sub count {
    local ($s, $c) = @_;
    local ($count);
    while ($s =~ /$c/g) { $count++; };
    return $count;
}

$comment_count = 0;
sub in_comment {
    local($string, $pos) = @_;
    local($s);
    $s = substr($string, 0, $pos);
    $this_comment_count = (&count($s, '\/\*') - &count($s, '\*\/'));
    return 1 if ($comment_count + $this_comment_count) gt 0;
    return 0;
}

$string_count = 0;
sub in_string {
    local($string, $pos) = @_;
    local($s);
    $s = substr($string, 0, $pos);
    $this_string_count = (&count($s, '\"') - &count($s, '\\\"'));
    return ($string_count + $this_string_count) % 2;
}

sub do_c {
    &load_tags('./tags');
    %tags = &index_tags($source);
    $line = 0;
    open(SOURCE, $source);

    while(<SOURCE>) {
	$line++;
	s/</&lt/g;
	s/>/&gt/g;
	if (/^#/) {
	    &do_include if /^#include/;
	    chop;
	    print "<B>$_</B>\n";
	    next;
	} 
	s/\/\*/<I>\/\*/g;
	s/\*\//\*\/<\/I>/g;    
	$pos = $len = 0;
	foreach $token (/([A-Za-z0-9_]+)/g) {
	    $pos = index($_, $token, $pos);
	    $len = length($token);
	    if (&ansi_token($token) && ! &in_comment($_, $pos)
		&& ! &in_string($_, $pos)) {
		$token = "<B>$token</B>";
	    } else {
		$where = &lookup_token($token);
		if ($where ne "" && ! &in_comment($_, $pos)
		    && ! &in_string($_,$pos)) {
		    $token = "<A HREF=\"$my_url?$where#$token\">$token</A>";
		}
	    }
	    substr($_, $pos, $len) = "$token";
	    $len = length($token);
	    $pos += $len;
	}		
	print $tags{$line} if $tags{$line} ne "";	     
	$comment_count += (&count($_,'\/\*') - &count($_,'\*\/'));
	$string_count += (&count($_, '\"') - &count($_, '\\\"'));
	print;
    }
    dbmclose(%TAGS);
    close(SOURCE);
}

###########################################################################

&print_header;
if (-d $source) {
    &do_directory;
    exit;
} elsif ($source =~ /\.[ch]$/) {
    &do_c;
    exit;
} else {			
    &cat($source);
    exit;
}








