#ifndef _ILUIDL_H
#define _ILUIDL_H
/*
 *  iluidl.h
 *
 *  Copyright (C) 1997 Martin von Lwis
 */

enum anytag{TagType,TagProcedure,TagConstant,TagArgument,TagException,
	    TagClass,TagInterface,
            Taglist,TagReal,
            Tagboolean,Tagstring,TagArgDirection,Taglong,Tagchar};

typedef struct tagged_refany_s{
  enum anytag tag;
  refany value;
}*TaggedAny;

Type any_Type(struct tagged_refany_s);
Procedure any_Procedure(struct tagged_refany_s);
Argument any_Argument(struct tagged_refany_s);
Class any_Class(struct tagged_refany_s);
Interface any_Interface(struct tagged_refany_s);

boolean any_boolean(struct tagged_refany_s);
string any_string(struct tagged_refany_s);
ArgDirection any_ArgDirection(struct tagged_refany_s);

list any_list(struct tagged_refany_s);
refany any_refany(struct tagged_refany_s);

TaggedAny new_TaggedAny(enum anytag,refany);

void filter_any_list(list dest,list src,enum anytag);
void dump_any_list(list,string message);

#define YYSTYPE struct tagged_refany_s

#endif
