%{
/*
 *  idlparse.y
 *
 *  Copyright (C) 1997 Martin von Lwis
 */
#include <stdio.h>
#include <assert.h>
#include <iluptype.h>
#include "iluidl.h"
#define ADD_PRIMITIVE_TYPES  \
  ADD_PRIMITIVE_TYPE (integer);\
  ADD_PRIMITIVE_TYPE (cardinal);\
  ADD_PRIMITIVE_TYPE (real);\
  ADD_PRIMITIVE_TYPE (shortinteger);\
  ADD_PRIMITIVE_TYPE (shortcardinal);\
  ADD_PRIMITIVE_TYPE (shortreal);\
  ADD_PRIMITIVE_TYPE (longinteger);\
  ADD_PRIMITIVE_TYPE (longcardinal);\
  ADD_PRIMITIVE_TYPE (longreal);\
  ADD_PRIMITIVE_TYPE (byte);\
  ADD_PRIMITIVE_TYPE (boolean);\
  ADD_PRIMITIVE_TYPE (character);\
  ADD_PRIMITIVE_TYPE (shortcharacter);\
  ADD_PRIMITIVE_TYPE (pickle);

#define ADD_PRIMITIVE_TYPE(x)  static struct tagged_refany_s the_##x##_t;
ADD_PRIMITIVE_TYPES
#undef ADD_PRIMITIVE_TYPE

Argument argument_Create(ArgDirection,Type,string);
Procedure procedure_Create(boolean,Type,string,list,refany,refany);
Type class_Create(string name,list bases);
Type class_insert_body(Type,list items);
Interface interface_Create(string,list);

enum foreach_set_type{
	INTERFACE_OF_TYPE,
	INTERFACE_OF_CONSTANT,
	INTERFACE_OF_EXCEPTION,
	INTERFACE_ON_PROCEDURE,
	OBJECT_ON_PROCEDURE
};
void foreach_set_item(list,refany,enum foreach_set_type);

list the_result=0;

%}
%token ANY_T ATTRIBUTE BOOLEAN_T BOOL_FALSE BOOL_TRUE CASE CHAR_L CHAR_T
%token CONST CONTEXT DEFAULT DOUBLE_T ENUM EXCEPTION FLOAT_L FLOAT_T IDENT IN
%token INOUT INTEGER_L INTERFACE LONG_T LSHIFT MODULE OCTET_T ONEWAY OUT RAISES
%token READONLY RSHIFT SCOPE SEQUENCE SHORT_T STRING_L STRING_T STRUCT SWITCH
%token TYPEDEF UNION UNSIGNED_T VOID_T
%%

specification:	definition_list {the_result=any_list($1);}

definition:	type_dcl ';'	{$$=$1;}
	|	const_dcl ';'	{$$=$1;}
	|	except_dcl ';'	{$$=$1;}
	|	interface ';'	{$$=$1;}
	|	module ';'	{$$=$1;}
	;

module:	MODULE IDENT '{' definition_list '}'
	{	$$.value=interface_Create(any_string($2),any_list($4));
		$$.tag=TagInterface;
	}

definition_list: definition
	{
		$$.value=iluparser_new_list();
		$$.tag=Taglist;
		list_insert($$.value,new_TaggedAny($1.tag,$1.value));
	}
	|	definition_list definition
	{	list_insert(any_list($1),new_TaggedAny($2.tag,$2.value));
		$$=$1;
	}
	;

interface:	interface_dcl 	{$$=$1;}
	| 	forward_dcl	{$$=$1;}

interface_dcl:	interface_header '{' interface_body '}'
	{	class_insert_body(any_Type($1),any_list($3));
		$$=$1;
	}

forward_dcl:	INTERFACE IDENT	{assert(0);}

interface_header:	INTERFACE IDENT
	{	$$.value=class_Create(any_string($2),0);$$.tag=TagType;}
	|	INTERFACE IDENT ':' scoped_name_list
	{	assert(0);}
	;

interface_body:	/* empty */         {$$.tag=Taglist;$$.value=0;}
	|	export_list         {$$=$1;}

	export:	type_dcl ';' {$$=$1;}
	|	const_dcl ';'     {$$=$1;}
	|	except_dcl ';'    {$$=$1;}
	|	attr_dcl ';'      {$$=$1;}
	|	op_dcl ';'        {$$=$1;}

export_list:	export 
	{ 
		$$.value=iluparser_new_list();
		$$.tag=Taglist;
		list_insert($$.value,new_TaggedAny($1.tag,$1.value));
	}
	|	export_list export
	{
		list_insert(any_list($1),new_TaggedAny($2.tag,$2.value));
		$$=$1;
	}

scoped_name:	IDENT			{$$=$1;}
	|	SCOPE IDENT		{assert(0);}
	|	scoped_name SCOPE IDENT {assert(0);}
	;

scoped_name_list:	scoped_name
	| scoped_name_list ',' scoped_name
	;

const_dcl:	CONST const_type IDENT '=' const_expr	{assert(0);}


const_type:	integer_type
	|	char_type
	|	boolean_type
	|	floating_pt_type
	|	string_type
	|	scoped_name

const_expr:	or_expr
or_expr:	xor_expr
	|	or_expr '|' xor_expr
	;
xor_expr:	and_expr
	|	xor_expr '^' and_expr
	;
and_expr:	shift_expr
	|	and_expr '&' shift_expr
shift_expr:	add_expr
	|	shift_expr LSHIFT add_expr
	|	shift_expr RSHIFT add_expr
add_expr:	mult_expr
	|	add_expr '+' mult_expr
	|	add_expr '-' mult_expr
mult_expr:	unary_expr
	|	mult_expr '*' unary_expr
	|	mult_expr '/' unary_expr
	|	mult_expr '%' unary_expr
unary_expr:	unary_operator primary_expr
	|	primary_expr
unary_operator:	'+' | '-' | '~'
primary_expr:	scoped_name
	|	literal
	|	'(' const_expr ')'
literal:	INTEGER_L
	|	STRING_L
	|	CHAR_L
	|	FLOAT_L
	|	boolean_literal

boolean_literal:	BOOL_TRUE | BOOL_FALSE
positive_const_int:	const_expr { /* Check for int, >0 */ }

type_dcl:	TYPEDEF type_declarator	{assert(0);}
	|	struct_type		{assert(0);}
	|	union_type		{assert(0);}
	|	enum_type		{assert(0);}

type_declarator:	type_spec declarators

type_spec:	simple_type_spec       {$$=$1;}
	|	constr_type_spec       {$$=$1;}

simple_type_spec:	base_type_spec {$$=$1;}
	|	template_type_spec     {$$=$1;}
	|	scoped_name            {$$=$1;}

base_type_spec:	floating_pt_type {$$=$1;}
	|	integer_type     {$$=$1;}
	|	char_type        {$$=$1;}
	|	boolean_type     {$$=$1;}
	|	octet_type       {$$=$1;}
	|	any_type         {$$=$1;}

template_type_spec:	sequence_type {assert(0);}
	|	string_type           {assert(0);}

constr_type_spec:	struct_type   {assert(0);}
	|	union_type            {assert(0);}
	|	enum_type             {assert(0);}

declarators:	declarator                 {assert(0);}
	|	declarators ',' declarator {assert(0);}

declarator:	simple_declarator          {$$=$1;}
	|	complex_declarator         {$$=$1;}

simple_declarator:	IDENT              {$$=$1;}
complex_declarator:	array_declarator   {$$=$1;}

floating_pt_type:	FLOAT_T  {$$=the_shortreal_t;}
	| 		DOUBLE_T {$$=the_real_t;}

integer_type:	signed_int  		{$$=$1;}
	| 	unsigned_int		{$$=$1;}
signed_int:	signed_long_int 	{$$=$1;}
	|	signed_short_int	{$$=$1;}
signed_long_int:	LONG_T		{$$=the_integer_t;}
signed_short_int:	SHORT_T		{$$=the_shortinteger_t;}
unsigned_int:	unsigned_long_int 	{$$=$1;}
	|	unsigned_short_int	{$$=$1;}
unsigned_long_int:	UNSIGNED_T LONG_T	{$$=the_cardinal_t;}
unsigned_short_int:	UNSIGNED_T SHORT_T	{$$=the_shortcardinal_t;}
char_type:	CHAR_T		{$$=the_shortcharacter_t;}
boolean_type:	BOOLEAN_T	{$$=the_boolean_t;}
octet_type:	OCTET_T		{$$=the_byte_t;}
any_type:	ANY_T		{$$=the_pickle_t;}

struct_type:	STRUCT IDENT '{' member_list '}'
	{	assert(0);}
member_list:	member
	|	member_list member
member:	type_spec declarators ';'

union_type:	UNION IDENT SWITCH '(' switch_type_spec ')' '{' switch_body '}'

switch_type_spec:	integer_type
	|	char_type
	|	boolean_type
	|	enum_type
	|	scoped_name

switch_body:	case
	|	switch_body case

case:	case_label_list element_spec ';'

case_label_list:	case_label
	|	case_label_list case_label

case_label:	CASE const_expr ':' 
	|	DEFAULT ':'

element_spec:	type_spec declarator

enum_type:	ENUM IDENT '{' enumerator_list '}'	{assert(0);}
enumerator_list: enumerator
	|	enumerator_list ',' enumerator
enumerator:	IDENT

sequence_type:	SEQUENCE '<' simple_type_spec ',' positive_const_int '>'
	{	assert(0);}
	|	SEQUENCE '<' simple_type_spec '>'

string_type:	STRING_T '<' positive_const_int '>'	{assert(0);}
	|	STRING_T

array_declarator:	IDENT fixed_array_size	{assert(0);}
	|	array_declarator fixed_array_size

fixed_array_size:	'[' positive_const_int ']'

attr_dcl:	opt_readonly ATTRIBUTE param_type_spec simple_declarator
	{	assert(0);}
	|	attr_dcl ',' simple_declarator

opt_readonly:	/*empty*/
	|	READONLY

except_dcl:	EXCEPTION IDENT '{' opt_member_list '}' {assert(0);}
opt_member_list:	/*empty*/
	|	member_list

op_dcl: opt_op_attr op_type_spec IDENT parameter_dcls 
	opt_raises_expr opt_context_expr
	{	$$.value=procedure_Create(any_boolean($1),any_Type($2),
		any_string($3),any_list($4),any_refany($5),any_refany($6));
		$$.tag=TagProcedure;
	}

opt_op_attr:	/*empty*/	{$$.value=(refany)FALSE;$$.tag=Tagboolean}
	|	ONEWAY		{$$.value=(refany)TRUE;$$.tag=Tagboolean}

op_type_spec:	param_type_spec	{$$=$1;}
	|	VOID_T		{$$.value=0;$$.tag=TagType;}

parameter_dcls:	'(' param_dcl_list ')'	{ $$=$2;}
	|	'(' ')'			
	{	$$.value==iluparser_new_list();$$.tag=Taglist;}

param_dcl_list: param_dcl		
	{ 	$$.value=iluparser_new_list();$$.tag=Taglist;
		list_insert($$.value,any_Argument($1));}
	|	param_dcl_list ',' param_dcl
		{ list_insert(any_list($1),any_Argument($3));$$=$1;}

param_dcl:	param_attribute param_type_spec simple_declarator
	{	$$.value=argument_Create(any_ArgDirection($1),
			any_Type($2),any_string($3));
		$$.tag=TagArgument;
	}

param_attribute:	IN	{$$.value=(refany)In;$$.tag=TagArgDirection;}
	|		OUT 	{$$.value=(refany)Out;$$.tag=TagArgDirection;}
	|		INOUT	{$$.value=(refany)InOut;$$.tag=TagArgDirection;}

opt_raises_expr:	/*empty*/		{$$.value=0;}
	|	RAISES '(' scoped_name_list ')'	{assert(0);}

opt_context_expr:	/*empty*/			{$$.value=0;}
	|	CONTEXT '(' string_literal_list ')'	{assert(0);}
string_literal_list:	STRING_L
	| 	string_literal_list STRING_L

param_type_spec:	base_type_spec {$$=$1;}
	|	string_type            {$$=$1;}
	|	scoped_name            {$$=$1;}

%%
	/* copied from ilu.bison */
static Name new_Name(void)
{
  Name new = (Name) iluparser_Malloc (sizeof(struct name_s));
  new->base_name = NULL;
  new->langnames = (set) new_list();
  return (new);
}


static TypeDescription new_TypeDescription(void)
{
  TypeDescription new = (TypeDescription) iluparser_Malloc(sizeof(struct ilu_typedes_s));
  new->type = invalid_Type;
  memset((char *) new, 0, sizeof(struct ilu_typedes_s));
  return (new);
}

static Type new_Type(void)
{
  Type new = (Type) iluparser_Malloc (sizeof(struct ilu_type_s));
  new->name = (Name) new_Name();
  new->description = NULL;
  new->supertype = NULL;
  new->refs = new_list();
  new->def = 0;
  new->builtIn = FALSE;
  new->importInterfaceName = NULL;
  new->interface = NULL;
  new->cached_des = NULL;
  new->marked = FALSE;
  new->uid = NULL;
  return (new);
}

static Argument new_Argument(void)
{
  Argument new = (Argument) iluparser_Malloc (sizeof(struct ilu_argument_s));
  new->name = new_Name();
  new->type = NULL;
  new->values = NULL;
  new->def = 0;
  new->sibling = FALSE;
  new->direction = In;
  return (new);
}

static Procedure new_Procedure(void)
{
  Procedure new = (Procedure) iluparser_Malloc (sizeof(struct ilu_proc_s));
  new->name = new_Name();
  new->object = NULL;
  new->arguments = NULL;
  new->returnType = NULL;
  new->returnOptional = FALSE;
  new->functional = FALSE;
  new->asynch = FALSE;
  new->exceptions = NULL;
  new->def = 0;
  new->id = -1;
  new->interface = NULL;
  new->marked = FALSE;
  return (new);
}

static Interface new_Interface (string name)
{
  Interface new = (Interface) iluparser_Malloc (sizeof(struct ilu_interface_s));
  new->name = new_Name();
  name_set_base_name(new->name, name);
  new->types = (set) new_list();
  new->classes = (set) new_list();
  new->imports = NULL;
  new->exceptions = (set) new_list();
  new->constants = (set) new_list();
  new->brand = NULL;
  new->def = 0;
  /*AddPredefinedTypes (new->types, new);FIXME: removed*/
  return (new);
}

static void IdentifyClasses (Type t, list classes)
{
  if (type_kind(t) == object_Type && t->importInterfaceName == NULL)
    list_insert(classes, t);
}

/* end of copy */

TaggedAny new_TaggedAny(enum anytag tag,refany value)
{
	TaggedAny result=iluparser_Malloc(sizeof(struct tagged_refany_s));
	result->tag=tag;
	result->value=value;
	return result;
}

void init_types()
{
	Type v;
#define ADD_PRIMITIVE_TYPE(n)\
	v=the_##n##_t.value= new_Type();\
	the_##n##_t.tag=TagType;\
	{TypeDescription d = new_TypeDescription();\
	 d->type=(n##_Type);\
	 v->description=d;\
	 v->builtIn=TRUE;\
	};\
	v->interface=NULL;\
	v->importInterfaceName=NULL;\
	name_set_base_name(v->name,ilu_strdup(#n));

  ADD_PRIMITIVE_TYPES;
}

Argument argument_Create(ArgDirection direction,Type type,string name)
{
	Argument result=new_Argument();
	name_set_base_name(result->name,name);
	result->type=type;
	result->direction=direction;
}

Procedure procedure_Create(boolean asynch,Type returnType,
	string name,list parameters,refany raises,refany context)
{
	Procedure result=new_Procedure();
	result->asynch=asynch;
	result->returnType=returnType;
	result->returnOptional=FALSE; /* what is this? */
	name_set_base_name(result->name,name);
	result->arguments=parameters;
	/* FIXME: exceptions */
}

Type class_Create(string class, list bases)
{
  Type result=new_Type();
  TypeDescription td = new_TypeDescription();

  assert(bases==0);

  td->type = object_Type;
  td->structuredDes.object = (Class) iluparser_Malloc (sizeof(struct ilu_class_s));
  td->structuredDes.object->brand = NULL;
  td->structuredDes.object->corba_rep_id = NULL;
  td->structuredDes.object->collectible = FALSE;
  /* CORBA interfaces are optional */
  td->structuredDes.object->optional = TRUE; 
  td->structuredDes.object->singleton = NULL;
  /* fixme: with no supertypes, this inherits from ilu.CORBA-Object */
  td->structuredDes.object->superclasses = NULL;
  td->structuredDes.object->authentication = NULL;
  td->structuredDes.object->methods = NULL;
  td->structuredDes.object->doc_string = NULL;

  result->description=td;
  result->interface=NULL;
  name_set_base_name(result->name,ilu_strdup(class));
  /* FIXME */
  result->uid="<UIDs not yet supported>";
  return result;
}

Type class_insert_body(Type result,list locals)
{
  Class c;
  assert(result->description->type==object_Type);
  c=result->description->structuredDes.object;
  /* this should not have been set, yet */
  assert(c->methods==0);
  c->methods=iluparser_new_list();
  filter_any_list(c->methods,locals,TagProcedure);
  foreach_set_item(c->methods,result,OBJECT_ON_PROCEDURE);
  dump_any_list(locals,"Extra item in interface");
  return result;
}

Interface interface_Create(string name,list locals)
{
	Interface result=new_Interface(name);
	result->brand=0;
	filter_any_list(result->types,locals,TagType);
	foreach_set_item(result->types,result,INTERFACE_OF_TYPE);
	list_enumerate(result->types,IdentifyClasses,result->classes);
	filter_any_list(result->exceptions,locals,TagException);
	foreach_set_item(result->exceptions,result,INTERFACE_OF_EXCEPTION);
	/*FIXME: imports*/
	filter_any_list(result->constants,locals,TagConstant);
	foreach_set_item(result->constants,result,INTERFACE_OF_CONSTANT);
	/*FIXME: file and line*/
	dump_any_list(locals,"Extra items in module");
	return result;
}

struct foreach_set_item_s{
	enum foreach_set_type item;
	refany value;
};

static void foreach_set_item_f(refany e,refany r)
{
	struct foreach_set_item_s* rock=r;
	switch(rock->item){
	case INTERFACE_OF_TYPE: {
		Type t=e;
		t->interface=rock->value;
		if(t->description && t->description->type==object_Type)
		   foreach_set_item(
			t->description->structuredDes.object->methods,
			rock->value,
			INTERFACE_ON_PROCEDURE);
		break;
		}
	case INTERFACE_OF_EXCEPTION: 
		((Exception)e)->interface=rock->value;break;
	case INTERFACE_OF_CONSTANT:
		((Constant)e)->interface=rock->value;break;
	case OBJECT_ON_PROCEDURE:
		((Procedure)e)->object=rock->value;break;
	case INTERFACE_ON_PROCEDURE:
		((Procedure)e)->interface=rock->value;break;
	default: fprintf(stderr,"set_interface: unsupported tag %d\n",
		rock->item);
	}
}
	
void foreach_set_item(list l,refany i,enum foreach_set_type t)
{
	struct foreach_set_item_s rock;
	rock.item=t;
	rock.value=i;
	list_enumerate(l,foreach_set_item_f,&rock);
}

/**************** Any functions **************/
#define make_any(type)\
	type any_##type(struct tagged_refany_s s){\
		assert(s.tag==Tag##type);	\
		return (type)s.value;		\
	}

make_any(Type)
make_any(Class)
make_any(boolean)
make_any(list)
make_any(string)
make_any(Argument)
make_any(ArgDirection)
make_any(Interface)

/* Move all items in the tagged list with the right tag 
   to the destination list */

static boolean find_any(refany element,refany rock)
{
	return ((struct tagged_refany_s*)element)->tag==
		((struct tagged_refany_s*)rock)->tag;
}

void filter_any_list(list dest,list src,enum anytag tag)
{
	struct tagged_refany_s search;
	search.tag=tag;
	/* appearantly, this cannot be done with enumerate */
	do{
		struct tagged_refany_s* item;
		item=list_find(src,find_any,&search);
		if(!item)break;
		list_insert(dest,item->value);
		list_remove(src,item);
		iluparser_Free(item);
	}while(1);
}

static void dump_f(refany e,refany m)
{
	struct tagged_refany_s *element=e;
	string msg=m;
	switch(element->tag)
	{
		default:printf("%s:tag %d\n",msg,element->tag);
	}
}

void dump_any_list(list l,string msg)
{
	list_enumerate(l,dump_f,msg);
}

refany any_refany(struct tagged_refany_s s)
{
	return s.value;
}

yyerror(s)
{
	fprintf(stderr,"%s\n",s);
}

void usage(char *s)
{
  fprintf(stderr,"%s [-d]\n",s);
}

#if 0
int main(int argc,char* argv[])
{
  int c;
  extern int yy_flex_debug;
  /* default: debugging is off */
  yy_flex_debug=0;
  while((c=getopt(argc,argv,"bf"))!=EOF)
	switch(c){
	case 'b': yydebug=1;break;
	case 'f': yy_flex_debug=1;break;
	default:usage(argv[0]);exit(1);
	}
  init_types();
  yyparse();
}
#endif

list ParseIDLFile (string filename)
{
  struct parse_s *new;
  int stat;
  list val = NULL;
  extern FILE* yyin;

  extern int yy_flex_debug;
  static int have_types=0;
  /* default: debugging is off */
  yy_flex_debug=0;
  if(!have_types){
    init_types();
    have_types=1;
  }
  if ((yyin = fopen(filename, "r")) == NULL)
    {
      fprintf (stderr, "ParseFile:  Error opening file \"%s\" for read.\n", filename);
      iluparser_Free (filename);
      return (NULL);
    }

  stat = yyparse();

  val=iluparser_new_list();
  filter_any_list(val,the_result,TagInterface);
  dump_any_list(the_result,"Extra toplevel definition");
  return (val);
}
