INTERFACE footypes;

EXCEPTION zapexception : integer;

TYPE enumtypebase = ENUMERATION red, orange, yellow, green, blue, indigo, violet END;
TYPE LatinString = SEQUENCE OF SHORT CHARACTER;
TYPE UnicodeString = SEQUENCE OF CHARACTER;

TYPE fixedrecordtypebase = RECORD
  fixedrecordinteger : integer,
  fixedrecordenum : enumtypebase
END;

TYPE integerarraybase = array of 5, 10 integer;

TYPE unboundedlongseqbase = SEQUENCE OF integer;

TYPE optionalintegerbase = OPTIONAL integer;

TYPE OptionalEnum = OPTIONAL enumtypebase;


(************************************************************)

TYPE enumtype = enumtypebase;
(* TYPE LatinString = LatinStringBase; *)
(* TYPE UnicodeString = UnicodeStringBase; *)

TYPE OptionalLatinStringBase = OPTIONAL LatinString;
TYPE OptionalLatinString = OptionalLatinStringBase;

TYPE OptionalUnicodeStringBase = OPTIONAL UnicodeString;
TYPE OptionalUnicodeString = OptionalUnicodeStringBase;

TYPE integeralias = integer;
TYPE shortcardinalalias = short cardinal;

(* TYPE fixedrecordtype = fixedrecordtypebase; *)
TYPE fixedrecordtypebase2 = RECORD
  fixedrecordinteger : integeralias,
  fixedrecordenum : enumtype
END;
TYPE fixedrecordtype = fixedrecordtypebase2;
TYPE optionalfixedrecordtype = OPTIONAL fixedrecordtype;

(* TMP 8/25: Can't do this because of type-sorting bug
TYPE OptArray = ARRAY OF 2 OptionalOptRec;  (* TMP 8/25 *)
TMP 8/25 *)
TYPE OptArray = ARRAY OF 2 optionalinteger;  (* TMP 8/25 *)
TYPE OptionalOptArray = OPTIONAL OptArray;

TYPE OptRecBase = RECORD
    integer-member : optionalinteger,
	optrec-member : OptionalOptRec,
	integerarray-member : optionalintegerarray,
	baz-member : OptionalBaz,
	latinstring-member : OptionalLatinString,
	unicodestring-member : OptionalUnicodeString,
	optarray-member: OptArray,  (* NEW 8/25 *)
	enum-member: OptionalEnum  (* NEW 8/25 *)
END;
TYPE OptRec = OptRecBase;
TYPE OptionalOptRecBase = OPTIONAL OptRecBase;
TYPE OptionalOptRec = OPTIONAL OptRec;
(*  TMP 7/24  TYPE OptionalOptRec = OptionalOptRecBase; *)

TYPE integerarray = integerarraybase;
TYPE optionalintegerarraybase = OPTIONAL integerarray;
TYPE optionalintegerarray = optionalintegerarraybase;
(* TYPE bararray = bararraybase; *)

(* TMP NOTE: This won't work because of type sorting bug
    see also foo3.isl
TYPE bararray = bararraybase;
*)

TYPE unboundedlongseqbase2 = SEQUENCE OF integeralias;
TYPE unboundedlongseq = unboundedlongseqbase2;

(* TMP NOTE: This won't work because of type sorting bug
    see also foo3.isl
TYPE boundedbarseq = boundedbarseqbase;
*)

TYPE optionalintegerbase2 = OPTIONAL integeralias;
TYPE optionalinteger = optionalintegerbase2;

EXCEPTION islexception : LatinString;
EXCEPTION voidexception; (* NOTE: an IDL exception w/o members maps to something like this. *)

TYPE baz = OBJECT;
TYPE OptionalBaz = OPTIONAL baz;  (* 8/1: NEW *)

TYPE OptRec2 = RECORD

    character-member: CHARACTER,
    short-character-member: SHORT CHARACTER,

	integer-member: INTEGER,
	short-integer-member: SHORT INTEGER,
	long-integer-member: LONG INTEGER,

	cardinal-member: CARDINAL,
	short-cardinal-member: SHORT CARDINAL,
	long-cardinal-member: LONG CARDINAL,

	real-member: REAL,
	short-real-member: SHORT REAL,
	long-real-member: LONG REAL,

	boolean-member: BOOLEAN,
	byte-member: BYTE,
	enumeration-member: enumtype,

    optional-character-member: OptionalCharacter,
    optional-short-character-member: OptionalShortCharacter,

	optional-integer-member: Optional-Integer,
	optional-short-integer-member: OptionalShortInteger,
	optional-long-integer-member: OptionalLongInteger,

	optional-cardinal-member: OptionalCardinal,
	optional-short-cardinal-member: OptionalShortCardinal,
	optional-long-cardinal-member: OptionalLongInteger,

	optional-real-member: OptionalReal,
	optional-short-real-member: OptionalShortReal,
	optional-long-real-member: OptionalLongReal,

	optional-boolean-member: OptionalBoolean,
	optional-byte-member: OptionalByte,
	optional-enumeration-member: OptionalEnumType

END;
TYPE OptionalOptRec2 = OPTIONAL OptRec2;

TYPE OptionalCharacter = OPTIONAL CHARACTER;
TYPE OptionalShortCharacter = OPTIONAL SHORT CHARACTER;

TYPE Optional-Integer = OPTIONAL INTEGER;  (* Use hyphen to distinguish from "optionalinteger", defined above *)
TYPE OptionalShortInteger = OPTIONAL SHORT INTEGER;
TYPE OptionalLongInteger = OPTIONAL LONG INTEGER;

TYPE OptionalCardinal = OPTIONAL CARDINAL;
TYPE OptionalShortCardinal = OPTIONAL SHORT CARDINAL;
TYPE OptionalLongCardinal = OPTIONAL LONG CARDINAL;

TYPE OptionalReal = OPTIONAL REAL;
TYPE OptionalShortReal = OPTIONAL SHORT REAL;
TYPE OptionalLongReal = OPTIONAL LONG REAL;

TYPE OptionalBoolean = OPTIONAL BOOLEAN;
TYPE OptionalByte = OPTIONAL BYTE;
TYPE OptionalEnumType = OPTIONAL enumtype;

TYPE Gurfle = OBJECT
METHODS
    passOptionals (

	    IN character-in: OptionalCharacter,
	    OUT character-out: OptionalCharacter,
	    INOUT character-inout: OptionalCharacter,

	    IN short-character-in: OptionalShortCharacter,
	    OUT short-character-out: OptionalShortCharacter,
	    INOUT short-character-inout: OptionalShortCharacter,

	    IN integer-in: Optional-Integer,
	    OUT integer-out: Optional-Integer,
	    INOUT integer-inout: Optional-Integer,

	    IN short-integer-in: OptionalShortInteger,
	    OUT short-integer-out: OptionalShortInteger,
	    INOUT short-integer-inout: OptionalShortInteger,
		
	    IN long-integer-in: OptionalLongInteger,
	    OUT long-integer-out: OptionalLongInteger,
	    INOUT long-integer-inout: OptionalLongInteger,

	    IN cardinal-in: OptionalCardinal,
	    OUT cardinal-out: OptionalCardinal,
	    INOUT cardinal-inout: OptionalCardinal,

	    IN short-cardinal-in: OptionalShortCardinal,
	    OUT short-cardinal-out: OptionalShortCardinal,
	    INOUT short-cardinal-inout: OptionalShortCardinal,
		
	    IN long-cardinal-in: OptionalLongCardinal,
	    OUT long-cardinal-out: OptionalLongCardinal,
	    INOUT long-cardinal-inout: OptionalLongCardinal,

	    IN real-in: OptionalReal,
	    OUT real-out: OptionalReal,
	    INOUT real-inout: OptionalReal,

	    IN short-real-in: OptionalShortReal,
	    OUT short-real-out: OptionalShortReal,
	    INOUT short-real-inout: OptionalShortReal,
		
	    IN long-real-in: OptionalLongReal,
	    OUT long-real-out: OptionalLongReal,
	    INOUT long-real-inout: OptionalLongReal,

	    IN boolean-in: OptionalBoolean,
	    OUT boolean-out: OptionalBoolean,
	    INOUT boolean-inout: OptionalBoolean,

	    IN byte-in: OptionalByte,
	    OUT byte-out: OptionalByte,
	    INOUT byte-inout: OptionalByte,

	    IN enumeration-in: OptionalEnumType,
	    OUT enumeration-out: OptionalEnumType,
	    INOUT enumeration-inout: OptionalEnumType

		): OptionalOptRec2

END;