INTERFACE foo IMPORTS footypes END;


TYPE variablerecordtypebase = RECORD
  variablerecordstring : footypes.LatinString,
  variablerecordinteger : integer,
  variablerecordobject : bar
END;

TYPE bararray = array of 2, 3 bar;

TYPE optionalbararray = OPTIONAL bararray;

TYPE boundedbarseq = SEQUENCE OF bar LIMIT 3 ;

TYPE variableuniontypebase = short cardinal UNION
	bararm : bar = 0, 1 END,
    integerarm : integer = DEFAULT
	END;


TYPE optionalbarobject = OPTIONAL bar;

TYPE variablerecordtypebase2 = RECORD
  variablerecordstring : footypes.LatinString,
  variablerecordinteger : footypes.integeralias,
  variablerecordobject : baralias
END;

TYPE optionalboundedbarseq = OPTIONAL boundedbarseq;

TYPE variablerecordtype = variablerecordtypebase2;
(* TMP 6/28: Using "variablerecordtype" below tickles the type sorting
   bug, so we use "variablerecordtypebase2" instead.
TYPE optionalvariablerecordtype = OPTIONAL variablerecordtype;
*)
TYPE optionalvariablerecordtype = OPTIONAL variablerecordtypebase2;

TYPE variableuniontypebase2 = footypes.shortcardinalalias UNION
	bararm : baralias = 0, 1 END,
    integerarm : footypes.integeralias = DEFAULT
	END;
TYPE variableuniontype = variableuniontypebase2;

TYPE baralias = bar;

(************************************************************)

TYPE idlexceptionrec = RECORD
    integermember : footypes.integeralias,
	enummember : footypes.enumtype,
	latinstringmember : footypes.LatinString,
	unicodestringmember : footypes.UnicodeString,
	fixedrecordmember : footypes.fixedrecordtype,
	variablerecordmember : variablerecordtype,
	integerarraymember : footypes.integerarray,
	bararraymember : bararray,
	unboundedlongseqmember : footypes.unboundedlongseq,
	boundedbarseqmember : boundedbarseq,
	variableunionmember : variableuniontype,
(*
	optionalbarmember : optionalbar,
*)
(*
	optionalintegermember : optionalinteger,
*)
    barmember : bar
END;

EXCEPTION idlexception : idlexceptionrec;

TYPE bar = OBJECT SUPERTYPES ilu.CORBA-Object, footypes.baz END

  METHODS

	(* out initial strawman function *)
    zap (IN inarg : integer, INOUT inoutarg : byte, OUT outarg : real ) : boolean
		RAISES footypes.zapexception END,

	(* pass objects *)
(*
	passobj (IN inarg : bar, INOUT inoutarg : bar, OUT outarg : bar ) : bar,
*)
	passobj (IN inarg : SIBLING baralias, INOUT inoutarg : SIBLING baralias, OUT outarg : SIBLING baralias ) : baralias,

	(* pass enums *)
	passenum (IN inarg : footypes.enumtype, INOUT inoutarg : footypes.enumtype, OUT outarg : footypes.enumtype ) : footypes.enumtype,

	(* pass latin and unicode strings *)
	passlatinstring (IN inarg : footypes.LatinString, INOUT inoutarg : footypes.LatinString, OUT outarg : footypes.LatinString ) : footypes.LatinString,
	passunicodestring (IN inarg : footypes.UnicodeString, INOUT inoutarg : footypes.UnicodeString, OUT outarg : footypes.UnicodeString ) : footypes.UnicodeString,
	
	(* pass fixed and variable records *)
	passfixedrecord(IN inarg : footypes.fixedrecordtype, INOUT inoutarg : footypes.fixedrecordtype, OUT outarg : footypes.fixedrecordtype ) : footypes.fixedrecordtype,
	passvariablerecord(IN inarg : variablerecordtype, INOUT inoutarg : variablerecordtype, OUT outarg : variablerecordtype ) : variablerecordtype,

	passidlexceptionrec(IN inarg : idlexceptionrec, INOUT inoutarg : idlexceptionrec, OUT outarg : idlexceptionrec ) : idlexceptionrec
		RAISES idlexception, footypes.islexception, footypes.voidexception END,

	(* pass arrays *)
	passfixedarray (IN inarg : footypes.integerarray, INOUT inoutarg : footypes.integerarray, OUT outarg : footypes.integerarray ) : footypes.integerarray,
	passvariablearray (IN inarg : bararray, INOUT inoutarg : bararray, OUT outarg : bararray ) : bararray,

	(* pass sequences *)
	passunboundedsequence (IN inarg : footypes.unboundedlongseq, INOUT inoutarg : footypes.unboundedlongseq, OUT outarg : footypes.unboundedlongseq ) : footypes.unboundedlongseq,
	passboundedsequence (IN inarg : boundedbarseq, INOUT inoutarg : boundedbarseq, OUT outarg : boundedbarseq ) : boundedbarseq,

 	(* pass unions - variable type used, fixed type should be fairly obvious *)
	passvariableunion (IN inarg : variableuniontype, INOUT inoutarg : variableuniontype, OUT outarg : variableuniontype ) : variableuniontype,

 	(* pass optionals  *)
	passoptionals (

	    IN    inarg-int       : footypes.optionalinteger,
		INOUT inoutarg-int    : footypes.optionalinteger,
		OUT   outarg-int      : footypes.optionalinteger,

	    IN    inarg-obj       : SIBLING optionalbarobject,
		INOUT inoutarg-obj    : SIBLING optionalbarobject,
		OUT   outarg-obj      : SIBLING optionalbarobject,
(*
	    IN    inarg-obj       : optionalbarobject,
		INOUT inoutarg-obj    : optionalbarobject,
		OUT   outarg-obj      : optionalbarobject,
*)
	    IN    inarg-frec      : footypes.optionalfixedrecordtype,
		INOUT inoutarg-frec   : footypes.optionalfixedrecordtype,
		OUT   outarg-frec     : footypes.optionalfixedrecordtype,

	    IN    inarg-vrec      : optionalvariablerecordtype,
		INOUT inoutarg-vrec   : optionalvariablerecordtype,
		OUT   outarg-vrec     : optionalvariablerecordtype,

	    IN    inarg-cstring   : footypes.OptionalLatinString,
		INOUT inoutarg-cstring: footypes.OptionalLatinString,
		OUT   outarg-cstring  : footypes.OptionalLatinString,

	    IN    inarg-wstring   : footypes.OptionalUnicodeString,
		INOUT inoutarg-wstring: footypes.OptionalUnicodeString,
		OUT   outarg-wstring  : footypes.OptionalUnicodeString,

	    IN    inarg-barseq    : optionalboundedbarseq,
		INOUT inoutarg-barseq : optionalboundedbarseq,
		OUT   outarg-barseq   : optionalboundedbarseq,

	    IN    inarg-farray    : footypes.optionalintegerarray,
		INOUT inoutarg-farray : footypes.optionalintegerarray,
		OUT   outarg-farray   : footypes.optionalintegerarray,

	    IN    inarg-varray    : optionalbararray,
		INOUT inoutarg-varray : optionalbararray,
		OUT   outarg-varray   : optionalbararray,

		IN    inarg-optrec    : footypes.OptRec,
		INOUT inoutarg-optrec : footypes.OptRec,
		OUT   outarg-optrec   : footypes.OptRec

	) : footypes.optionalinteger

 END;
