///////////////////////////////////////////////////////////////////////
//  foo client side program for corba2 cpp2 c++ ilu 

#include <stdio.h>
#include <iostream.h>
#include <math.h>

#ifdef WIN32
#include <winsock.h>
#else
extern "C" int gethostname(char *name, int namelen);
#endif

#include "foo-cppsurrogate.hpp"


///////////////////////////////////////////////////////////////////////
// Usage string

char g_c_usage[] = 
"Usage:  fooclient [ HOSTNAME [mt]]\n\
\tHOSTNAME - used as part of the id for the server - defaults to this host\n\
\tmt - if present, sets ilu to multithreaded\n";


///////////////////////////////////////////////////////////////////////
// Show a system exception

void show_system_exception( const CORBA(SystemException)& the_exception) {
	cout << "Got SystemException" << endl <<
		"minor = " << the_exception.minor() << ", completed = ";
	switch (the_exception.completed()) {
	case CORBA(COMPLETED_YES): cout << "YES"; break;
	case CORBA(COMPLETED_NO): cout << "NO"; break;
	case CORBA(COMPLETED_MAYBE): cout << "MAYBE"; break;
	default: cout << "??? unknown exception completion !!!";
	}
	cout << endl;
}


///////////////////////////////////////////////////////////////////////
// check out Object <=> String

CORBA(Boolean) doobjectandstring(foo(bar_var)& mybar_var) {

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering doobjectandstring <<<<<<<<<<<<<<<<<<" << endl;
	
	CORBA(Boolean) b_return = ILUCPP_TRUE;
	char* pc_stringified_reference = NULL;
	
	pc_stringified_reference = mybar_var->iluObjectToString();
	if (!pc_stringified_reference) {
		cout << "iluObjectToString failed" << endl;
		return ILUCPP_FALSE;
	}
	else {
		iluObject* p_ilu_object = iluObject::iluStringToObject(pc_stringified_reference);
		iluCppRuntime::iluFree(pc_stringified_reference);
		if (!p_ilu_object) {
			cout << "iluObject::iluStringToObject failed" << endl;
			return ILUCPP_FALSE;
		}
		else {
			foo(bar_ptr) p_bar_object = foo(bar)::_narrow(p_ilu_object);
			if (p_bar_object != ((foo(bar_ptr))mybar_var)) {
				cout << "p_bar_object != ((foo(bar_ptr))mybar_var)" << endl;
				b_return = ILUCPP_FALSE;
			}
			else 
				cout << "Object <=> String succeeded" << endl;
			p_bar_object->_release();
		}
	}
	
	return b_return;
}


///////////////////////////////////////////////////////////////////////
// call the zap method (primitive types)

CORBA(Boolean) dozap(CORBA(Long) inarg, foo(bar_var)& mybar_var, CORBA(Boolean) b_verbose = ILUCPP_TRUE) {

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dozap <<<<<<<<<<<<<<<<<<" << endl;
	
	CORBA(Boolean) bool_return_value;
	CORBA(Octet)  inoutarg = 0xaa;
	CORBA(Double) outarg;
	CORBA(Boolean) b_return = ILUCPP_TRUE;
	
	try {
		bool_return_value = mybar_var->zap(inarg, inoutarg, outarg);
	}
	catch (const footypes(zapexception)& the_exception) {
		cout << "dozap Got foo::zapexception, value is " << the_exception._val << endl;
		if (the_exception._val != inarg)
			return ILUCPP_FALSE;
		return ILUCPP_TRUE;
	}
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "dozap Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	if (outarg != 3.14159) 
		b_return = ILUCPP_FALSE;
	if (inoutarg != (CORBA(Octet)(~ 0xaa)))
		b_return = ILUCPP_FALSE;
	if (bool_return_value != ILUCPP_TRUE) 
		b_return = ILUCPP_FALSE;
	
	if (b_verbose)
		cout << "zap returned " 
		<< ((bool_return_value == ILUCPP_TRUE) ? "True" : "False")
		<< ", inoutarg 0x" 
		<< hex
		<< (unsigned int) inoutarg 
		<< ", outarg " 
		<< outarg 
		<< endl ; 
	
	return b_return;
}


///////////////////////////////////////////////////////////////////////
// exerciseObject tables

CORBA(Boolean) doobjecttableexercise(foo(bar_var)& mybar_var) {

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering doobjecttableexercise <<<<<<<<<<<<<<<<<<" << endl;
	
	CORBA(Boolean) b_return = ILUCPP_TRUE;
	char* pc_stringified_reference;
	iluCString str_encodedContactInfo;
	char* pc_sibling_reference;
	foo(bar_var) mysibling_var;
	foo(bar_ptr) mysibling_ptr;
	iluObject* p_object;

	// form an sbh for a sibling of mybar_var, with instance handle foo_instance_via_table	

	// first get a hold of the contact information for the mybar_var object,
	// bar parsing up it's string binding handle
	pc_stringified_reference = mybar_var->iluObjectToString();
	if (!pc_stringified_reference) {
		cout << "iluObjectToString failed" << endl;
		return ILUCPP_FALSE;
	}

	if (!iluCppRuntime::iluParseSBH(pc_stringified_reference, NULL, NULL, NULL, &str_encodedContactInfo)) {
		cout << "iluParseSBH failed" << endl;
		iluCppRuntime::iluFree(pc_stringified_reference);
		return ILUCPP_FALSE;
	}

	
	// now make up an SBH representing a sibling
	pc_sibling_reference = 
		iluCppRuntime::iluFormSBHUsingContactInfo (mybar_var->iluServerId(), "foo_instance_via_table",
			mybar_var->iluGetClassRecord(), str_encodedContactInfo);

	// can now free the pc_stringified_reference here since str_encodedContactInfo pointed into it
	// anmd we no longer need str_encodedContactInfo
	iluCppRuntime::iluFree(pc_stringified_reference);

	p_object = iluObject::iluStringToObject(pc_sibling_reference);

	mysibling_ptr = (p_object ? foo(bar)::_narrow(p_object) : NULL);

	if (!mysibling_ptr) {
		cout << "Couldn't get sibling from " << pc_sibling_reference << endl;
		iluCppRuntime::iluFree(pc_stringified_reference);
		return ILUCPP_FALSE;
	}

	// let the var manage it
	mysibling_var = mysibling_ptr;

	// try zap on it to see if it really works
	if (dozap(0, mysibling_var, ILUCPP_FALSE))
		cout <<  "Successful zap on sibling " << pc_sibling_reference << endl;
	else {
		cout <<  "Unsuccessful zap on sibling " << pc_sibling_reference << endl;
	b_return = ILUCPP_FALSE;
	}

	iluCppRuntime::iluFree(pc_sibling_reference);

	return b_return;
}


///////////////////////////////////////////////////////////////////////
// try calling the pass_obj method

CORBA(Boolean) dopass_obj (foo(bar_var)& mybar_var) {

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopass_obj <<<<<<<<<<<<<<<<<<" << endl;
	
	foo(bar_ptr) passobj_inarg = mybar_var;
	foo(bar_ptr) passobj_inoutarg = mybar_var;
	foo(bar_ptr) passobj_outarg;
	foo(bar_ptr) passobj_return;
	CORBA(Boolean) b_good = ILUCPP_FALSE;
	
	// dupicate our inout arg since we want to hang onto it
	// refcount should now be two (one for original, one for
	// the duplicate
	foo(bar)::_duplicate(passobj_inoutarg);
	
	// refcount should now be two (one for original, one for
	// the duplicate we just did for the inout)
	cout << "mybar_var->iluGetReferenceCount() = " << mybar_var->iluGetReferenceCount()  
		<< (mybar_var->iluGetReferenceCount() == 2 ? " Good" : " Bad") << endl;
	
	try {
		passobj_return = mybar_var->passobj(passobj_inarg, passobj_inoutarg, passobj_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	cout << "passobj returned " <<
		(((passobj_inarg == passobj_inoutarg) && 
		(passobj_inoutarg == passobj_outarg) &&
		(passobj_outarg == passobj_return)) ? "All Match" : "Don't match!")
		<< endl ; 
	
	// refcount should now be four (one for original, and one each for
	// the inout, out and return values)
	cout << "mybar_var->iluGetReferenceCount() = " << mybar_var->iluGetReferenceCount()
		<< (mybar_var->iluGetReferenceCount() == 4 ? " Good" : " Bad") << endl;
	
	if ((passobj_inarg == passobj_inoutarg) && 
		(passobj_inoutarg == passobj_outarg) &&
		(passobj_outarg == passobj_return) &&
		(mybar_var->iluGetReferenceCount() == 4)) 
		b_good = ILUCPP_TRUE;
	
	passobj_inoutarg->_release();
	passobj_outarg->_release();
	passobj_return->_release();

	return b_good;
}


///////////////////////////////////////////////////////////////////////
// try calling the passenum method

CORBA(Boolean) dopass_enum(foo(bar_var)& mybar_var) {	

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopass_enum <<<<<<<<<<<<<<<<<<" << endl;
	
	footypes(enumtype) passenum_inarg = footypes(red);
	footypes(enumtype) passenum_inoutarg = footypes(orange);
	
	footypes(enumtype) passenum_outarg = footypes(violet); 
	footypes(enumtype) passenum_return = footypes(violet);
	CORBA(Boolean) b_return = ILUCPP_TRUE;

	try {
		passenum_return = mybar_var->passenum(passenum_inarg, passenum_inoutarg, passenum_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	if (passenum_inoutarg != footypes(yellow)) {
		cout << "passenum_inoutarg not yellow " << (int)passenum_inoutarg << endl;
		b_return = ILUCPP_FALSE;
	}
	if (passenum_outarg != footypes(green)) {
		cout << "passenum_outarg not green " << (int)passenum_outarg << endl;
		b_return = ILUCPP_FALSE;
	}
	if (passenum_return != footypes(blue)) {
		cout << "passenum_return not blue " << (int)passenum_return << endl;
		b_return = ILUCPP_FALSE;
	}

	cout << "passenum returned " 
		<< ((passenum_inoutarg == footypes(yellow) &&
		passenum_outarg == footypes(green) &&
		passenum_return == footypes(blue)
		) ? " Good" : " Bad")
		<< endl ; 

	return b_return;
}


///////////////////////////////////////////////////////////////////////
// try calling the passlatinstring method

CORBA(Boolean) dopasslatinstring(foo(bar_var)& mybar_var) {
	
	footypes(LatinString) passstring_inarg = "ToServer_inarg";
	footypes(LatinString) passstring_inoutarg = CORBA(string_dup)("ToServer_inoutarg");
	
	footypes(LatinString) passstring_outarg; 
	footypes(LatinString) passstring_return;
	CORBA(Boolean) b_return = ILUCPP_TRUE;

	try {
		passstring_return = mybar_var->passlatinstring(passstring_inarg, passstring_inoutarg, passstring_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	if (strcmp(passstring_inarg, "ToServer_inarg") != 0) {
		cout << "passstring_inarg disturbed" << endl;
		b_return = ILUCPP_FALSE;
	}
	if (strcmp(passstring_inoutarg, "FromServer_inoutarg") != 0) {
		cout << "passstring_inoutarg wrong" << endl;
		b_return = ILUCPP_FALSE;
	}
	if (strcmp(passstring_outarg, "FromServer_outarg") != 0) {
		cout << "passstring_outarg wrong" << endl;
		b_return = ILUCPP_FALSE;
	}
	if (strcmp(passstring_return, "FromServer_return") != 0) {
		cout << "passstring_return wrong" << endl;
		b_return = ILUCPP_FALSE;
	}

	cout << "passstring returned " 
		<< passstring_inoutarg << ", "
		<< passstring_outarg << ", "
		<< passstring_return << endl ;
	CORBA(string_free)(passstring_inoutarg);
	CORBA(string_free)(passstring_return);

	return b_return;
}


///////////////////////////////////////////////////////////////////////
// try calling the passunicodestring method

CORBA(Boolean) dopassunicodestring(foo(bar_var)& mybar_var) {

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassunicodestring <<<<<<<<<<<<<<<<<<" << endl;
	
	footypes(UnicodeString) passustring_inarg = iluCppRuntime::iluCharStringFromShortCharString("ToServer_inarg");
	footypes(UnicodeString) passustring_inoutarg = iluCppRuntime::iluCharStringFromShortCharString("ToServer_inoutarg");
	footypes(UnicodeString) passustring_outarg; 
	footypes(UnicodeString) passustring_return;
	CORBA(Boolean) b_return = ILUCPP_TRUE;

	try {
		passustring_return = mybar_var->passunicodestring(passustring_inarg, passustring_inoutarg, passustring_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	if (! iluCppRuntime::iluCharStringShortCharStringEqual(passustring_inarg, "ToServer_inarg")) {
		cout << "passustring_inarg disturbed" << endl;
		b_return = ILUCPP_FALSE;
	}
	
	if (! iluCppRuntime::iluCharStringShortCharStringEqual(passustring_inoutarg, "FromServer_inoutarg")) {
		cout << "passustring_inoutarg wrong" << endl;
		b_return = ILUCPP_FALSE;
	}
	
	if (! iluCppRuntime::iluCharStringShortCharStringEqual(passustring_outarg, "FromServer_outarg")) {
		cout << "passustring_outarg wrong" << endl;
		b_return = ILUCPP_FALSE;
	}
	
	if (! iluCppRuntime::iluCharStringShortCharStringEqual(passustring_return, "FromServer_return")) {
		cout << "passustring_return wrong" << endl;
		b_return = ILUCPP_FALSE;
	}
	
	iluCppRuntime::iluFree(passustring_inarg);
	iluCppRuntime::iluFree(passustring_inoutarg);
	iluCppRuntime::iluFree(passustring_return);
	
	cout << "passustring returned " << (b_return ? "Good" : "Bad") << endl;

	return b_return;
}


///////////////////////////////////////////////////////////////////////
// try calling the passfixedrecord method

CORBA(Boolean) dopassfixedrecord(foo(bar_var)& mybar_var) {	

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassfixedrecord <<<<<<<<<<<<<<<<<<" << endl;
	
	footypes(fixedrecordtype) passfixedrecord_inarg;
	footypes(fixedrecordtype) passfixedrecord_inoutarg;
	
	footypes(fixedrecordtype) passfixedrecord_outarg; 
	footypes(fixedrecordtype) passfixedrecord_return;
	CORBA(Boolean) b_return = ILUCPP_TRUE;

	passfixedrecord_inarg.fixedrecordinteger = 12345;
	passfixedrecord_inarg.fixedrecordenum = footypes(orange);

	passfixedrecord_inoutarg.fixedrecordinteger = 67890;
	passfixedrecord_inoutarg.fixedrecordenum = footypes(yellow);

	
	try {
		passfixedrecord_return = mybar_var->passfixedrecord(passfixedrecord_inarg,
			passfixedrecord_inoutarg, passfixedrecord_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	// outarg should be copy of inarg
	if (12345 != passfixedrecord_outarg.fixedrecordinteger) {
		cout << "passfixedrecord_outarg.fixedrecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (footypes(orange) != passfixedrecord_outarg.fixedrecordenum) {
		cout << "passfixedrecord_outarg.fixedrecordenum bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	//  return should be what inout arg was
	if (67890 != passfixedrecord_return.fixedrecordinteger) {
		cout << "passfixedrecord_return.fixedrecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (footypes(yellow) != passfixedrecord_return.fixedrecordenum) {
		cout << "passfixedrecord_return.fixedrecordenum bad " << endl;
		b_return = ILUCPP_FALSE;
	}

	//  inout arg should be one more in each field
	if (67891 != passfixedrecord_inoutarg.fixedrecordinteger) {
		cout << "passfixedrecord_inoutarg.fixedrecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (footypes(green) != passfixedrecord_inoutarg.fixedrecordenum) {
		cout << "passfixedrecord_inoutarg.fixedrecordenum bad " << endl;
		b_return = ILUCPP_FALSE;
	}

	if (b_return)
		cout << "passfixedrecord succeeded" << endl;

	return b_return;
}


///////////////////////////////////////////////////////////////////////
// try calling the passvariablerecord method

CORBA(Boolean) dopassvariablerecord(foo(bar_var)& mybar_var) {	

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassvariablerecord <<<<<<<<<<<<<<<<<<" << endl;
	
	foo(variablerecordtype) passvariablerecord_inarg;
	foo(variablerecordtype) passvariablerecord_inoutarg;
	
	foo(variablerecordtype)* p_passvariablerecord_outarg; 
	foo(variablerecordtype)* p_passvariablerecord_return;
	CORBA(Boolean) b_return = ILUCPP_TRUE;
	char instringvalue[] = "passvariablerecord_inarg";
	char inoutstringvalue[] = "passvariablerecord_inoutarg";
	char* p_instringvalue = new char[strlen(instringvalue) + 1];
	char* p_inoutstringvalue = new char[strlen(inoutstringvalue) + 1];
	strcpy(p_instringvalue, instringvalue);
	strcpy(p_inoutstringvalue, inoutstringvalue);

	passvariablerecord_inarg.variablerecordstring = p_instringvalue;
	passvariablerecord_inarg.variablerecordinteger = 12345;
	passvariablerecord_inarg.variablerecordobject = mybar_var;	

	passvariablerecord_inoutarg.variablerecordstring = p_inoutstringvalue;
	passvariablerecord_inoutarg.variablerecordinteger = 67890;
	passvariablerecord_inoutarg.variablerecordobject = mybar_var;
	
	try {
		p_passvariablerecord_return = mybar_var->passvariablerecord(passvariablerecord_inarg,
			passvariablerecord_inoutarg, p_passvariablerecord_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	// outarg should be copy of inarg
	if (strcmp(p_passvariablerecord_outarg->variablerecordstring, instringvalue) != 0) {
		cout << "p_passvariablerecord_outarg->variablerecordstring bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (12345 != p_passvariablerecord_outarg->variablerecordinteger) {
		cout << "p_passvariablerecord_outarg->variablerecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (mybar_var.iluGetObjectPointer() != (p_passvariablerecord_outarg->variablerecordobject).iluGetObjectPointer()) {
		cout << "p_passvariablerecord_outarg->variablerecordobject bad " << endl;
		b_return = ILUCPP_FALSE;
	}


	//  return should be what inout arg was
	if (strcmp(p_passvariablerecord_return->variablerecordstring, inoutstringvalue) != 0) {
		cout << "p_passvariablerecord_return->variablerecordstring bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (67890 != p_passvariablerecord_return->variablerecordinteger) {
		cout << "p_passvariablerecord_return->variablerecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (mybar_var.iluGetObjectPointer() != (p_passvariablerecord_return->variablerecordobject).iluGetObjectPointer()) {
		cout << "p_passvariablerecord_return->variablerecordobject bad " << endl;
		b_return = ILUCPP_FALSE;
	}


	//  inout arg check
	if (strcmp(passvariablerecord_inoutarg.variablerecordstring, "returned passvariablerecord_inoutarg") != 0) {
		cout << "passvariablerecord_inoutarg.variablerecordstring bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (67891 != passvariablerecord_inoutarg.variablerecordinteger) {
		cout << "passvariablerecord_inoutarg.variablerecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (mybar_var.iluGetObjectPointer() != (passvariablerecord_inoutarg.variablerecordobject).iluGetObjectPointer()) {
		cout << "passvariablerecord_inoutarg.variablerecordobject bad " << endl;
		b_return = ILUCPP_FALSE;
	}

	delete p_passvariablerecord_outarg;
	delete p_passvariablerecord_return;


	if (b_return)
		cout << "passvariablerecord succeeded" << endl;

	return b_return;
}

///////////////////////////////////////////////////////////////////////
// try calling the passidlexceptionrec method

CORBA(Boolean) dopassidlexceptionrec(foo(bar_var)& mybar_var, const char * inlstringvalue = NULL) {

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassidlexceptionrec"
        << " (" << (inlstringvalue == NULL ? "no exception" : inlstringvalue) << ") "
        << "<<<<<<<<<<<<<<<<<<" << endl;
    cout << endl;

    if (inlstringvalue == NULL)
        inlstringvalue = "rec_inarg";

    const CORBA(Boolean) idlexception_expected = strcmp(inlstringvalue, "idlexception") == 0;
    const CORBA(Boolean) islexception_expected = strcmp(inlstringvalue, "islexception") == 0;
    const CORBA(Boolean) voidexception_expected = strcmp(inlstringvalue, "voidexception") == 0;
	
	foo(idlexceptionrec) rec_inarg;
	foo(idlexceptionrec) rec_inoutarg;
	
	foo(idlexceptionrec)* p_rec_outarg; 
	foo(idlexceptionrec)* p_rec_return;
	CORBA(Boolean) b_return = ILUCPP_TRUE;
    int i, j;  // array indices

    foo(variableuniontype) inoutarg_in_variableunionmember_val;
	char inoutlstringvalue[] = "rec_inoutarg";
	char* p_inlstringvalue = new char[strlen(inlstringvalue) + 1];
	char* p_inoutlstringvalue = new char[strlen(inoutlstringvalue) + 1];
	strcpy(p_inlstringvalue, inlstringvalue);
	strcpy(p_inoutlstringvalue, inoutlstringvalue);

	footypes(UnicodeString) inustringvalue = iluCppRuntime::iluCharStringFromShortCharString("ToServer_inarg");
	footypes(UnicodeString) inoutustringvalue = iluCppRuntime::iluCharStringFromShortCharString("ToServer_inoutarg");
    footypes(UnicodeString) p_inustringvalue = iluCppRuntime::iluCharacterStringDuplicate(inustringvalue);
    footypes(UnicodeString) p_inoutustringvalue = iluCppRuntime::iluCharacterStringDuplicate(inoutustringvalue);

    const int inunboundedlongseqlength = 5;
    const int inoutunboundedlongseqlength = 3;
    footypes(unboundedlongseq) inunboundedlongseqvalue(inunboundedlongseqlength);
    footypes(unboundedlongseq) inoutunboundedlongseqvalue(inoutunboundedlongseqlength);
    inunboundedlongseqvalue.length(inunboundedlongseqlength);
    inoutunboundedlongseqvalue.length(inoutunboundedlongseqlength);
    for (i = 0; i < inunboundedlongseqvalue.length(); i++)
        inunboundedlongseqvalue[i] = i;
    for (i = 0; i < inoutunboundedlongseqvalue.length(); i++)
        inoutunboundedlongseqvalue[i] = 2*i;

    const int boundedbarseqlength = 3;
    foo(bar_ptr)* inboundedbarseqdata = foo(boundedbarseq)::allocbuf(boundedbarseqlength);
    // backing buffer for inboundebarseqvalue
    foo(boundedbarseq) inboundedbarseqvalue(boundedbarseqlength, inboundedbarseqdata, ILUCPP_TRUE);
    // ownership of buffer passes to inboundebarseqvalue
    foo(boundedbarseq) inoutboundedbarseqvalue;
    for (i = 0; i < boundedbarseqlength; i++)
        inboundedbarseqvalue[i] = mybar_var;
    inoutboundedbarseqvalue = inboundedbarseqvalue;  // deep copy

	rec_inarg.integermember = 42;	
	rec_inarg.latinstringmember = p_inlstringvalue;
	rec_inarg.unicodestringmember = p_inustringvalue;
	rec_inarg.enummember = footypes(red);
	rec_inarg.fixedrecordmember.fixedrecordinteger = 42;
	rec_inarg.fixedrecordmember.fixedrecordenum = footypes(red);
	rec_inarg.variablerecordmember.variablerecordstring = p_inlstringvalue;
	rec_inarg.variablerecordmember.variablerecordinteger = 42;
	rec_inarg.variablerecordmember.variablerecordobject = mybar_var;
    for (i = 0; i < 5; i++) {
        for (j = 0; j < 10; j++) {
            rec_inarg.integerarraymember[i][j] = i + j;
        };
    };
    for (i = 0; i < 2; i++) {
        for (j = 0; j < 3; j++) {
            rec_inarg.bararraymember[i][j] = mybar_var;
        };
    };
    rec_inarg.unboundedlongseqmember = inunboundedlongseqvalue;
    rec_inarg.boundedbarseqmember = inboundedbarseqvalue;
    // rec_inarg.variableunionmember defaults to integerarm
    rec_inarg.barmember = mybar_var;


	rec_inoutarg.integermember = 84;	
	rec_inoutarg.latinstringmember = p_inoutlstringvalue;
	rec_inoutarg.unicodestringmember = p_inoutustringvalue;
	rec_inoutarg.enummember = footypes(green);
	rec_inoutarg.fixedrecordmember.fixedrecordinteger = 84;
	rec_inoutarg.fixedrecordmember.fixedrecordenum = footypes(green);
	rec_inoutarg.variablerecordmember.variablerecordstring = p_inoutlstringvalue;
	rec_inoutarg.variablerecordmember.variablerecordinteger = 84;
	rec_inoutarg.variablerecordmember.variablerecordobject = mybar_var;
    for (i = 0; i < 5; i++) {
        for (j = 0; j < 10; j++) {
            rec_inoutarg.integerarraymember[i][j] = 2*(i + j);
        };
    };
    for (i = 0; i < 2; i++) {
        for (j = 0; j < 3; j++) {
            rec_inoutarg.bararraymember[i][j] = mybar_var;
        };
    };
    rec_inoutarg.unboundedlongseqmember = inoutunboundedlongseqvalue;
    rec_inoutarg.boundedbarseqmember = inoutboundedbarseqvalue;
    rec_inoutarg.variableunionmember.bararm(mybar_var);
    inoutarg_in_variableunionmember_val = rec_inoutarg.variableunionmember;
    rec_inoutarg.barmember = mybar_var;


    try {
		p_rec_return = mybar_var->passidlexceptionrec(rec_inarg,
			rec_inoutarg, p_rec_outarg);
	}	
	catch (const foo(idlexception)& the_exception) {
        cout << "Got a foo::idlexception" << endl;
        return idlexception_expected;
	}
	catch (const footypes(islexception)& the_exception) {
        cout << "Got a foo::islexception" << endl;
        return islexception_expected;
	}
	catch (const footypes(voidexception)& the_exception) {
        cout << "Got a foo::voidexception" << endl;
        return voidexception_expected;
	}
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}

    if (idlexception_expected || islexception_expected || voidexception_expected) {
        cout << "No exception was caught" << endl;
        return ILUCPP_FALSE;
    };
	
	// outarg should be copy of inarg
	if (42 != p_rec_outarg->integermember) {
		cout << "p_rec_outarg->integermember bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (strcmp(p_rec_outarg->latinstringmember, inlstringvalue) != 0) {
		cout << "p_rec_outarg->latinstringmember bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (! iluCppRuntime::iluCharacterStringEqual(p_rec_outarg->unicodestringmember, p_inustringvalue)) {
		cout << "p_rec_outarg->unicodestringmember wrong" << endl;
		b_return = ILUCPP_FALSE;
	}
    if (footypes(red) != p_rec_outarg->enummember) {
		cout << "p_rec_outarg->enummember wrong" << endl;
		b_return = ILUCPP_FALSE;
    }
	if (42 != p_rec_outarg->fixedrecordmember.fixedrecordinteger) {
		cout << "p_rec_outarg->fixedrecordmember.fixedrecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
    if (footypes(red) != p_rec_outarg->fixedrecordmember.fixedrecordenum) {
		cout << "p_rec_outarg->fixedrecordmember.fixedrecordenum wrong" << endl;
		b_return = ILUCPP_FALSE;
	}
	if (strcmp(p_rec_outarg->variablerecordmember.variablerecordstring, inlstringvalue) != 0) {
		cout << "p_rec_outarg->variablerecordmember.variablerecordstring bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (42 != p_rec_outarg->variablerecordmember.variablerecordinteger) {
		cout << "p_rec_outarg->variablerecordmember.variablerecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
    if (STATIC_CAST(foo(bar_ptr), mybar_var) != STATIC_CAST(foo(bar_ptr), p_rec_outarg->variablerecordmember.variablerecordobject)) {
		cout << "p_rec_outarg->variablerecordmember.variablerecordobject bad " << endl;
		b_return = ILUCPP_FALSE;
	}
    for (i = 0; i < 5; i++) {
        for (j = 0; j < 10; j++) {
            if (p_rec_outarg->integerarraymember[i][j] != (i + j)) {
                cout << "p_rec_outarg->integerarraymember[" << i << ", " << j << "] bad " << endl;
                b_return = ILUCPP_FALSE;
                break;
            };
        };
    };
    for (i = 0; i < 2; i++) {
        for (j = 0; j < 3; j++) {
            if (STATIC_CAST(foo(bar_ptr), p_rec_outarg->bararraymember[i][j]) != STATIC_CAST(foo(bar_ptr), mybar_var)) {
                cout << "p_rec_outarg->bararraymember[" << i << ", " << j << "] bad " << endl;
                b_return = ILUCPP_FALSE;
                break;
            };
        };
    };
    if (p_rec_outarg->unboundedlongseqmember.length() != inunboundedlongseqlength) {
        cout << "p_rec_outarg->unboundedlongseqmember.length() bad" << endl;
        b_return = ILUCPP_FALSE;
    }
    else {
        for (i = 0; i < p_rec_outarg->unboundedlongseqmember.length(); i++) {
            if (p_rec_outarg->unboundedlongseqmember[i] != i) {
                cout << "p_rec_outarg->unboundedlongseqmember[" << i << "] bad " << endl;
                b_return = ILUCPP_FALSE;
                break;
            };
        };
    };
    if (p_rec_outarg->boundedbarseqmember.length() != boundedbarseqlength) {
        cout << "p_rec_outarg->boundedbarseqmember.length() bad" << endl;
        b_return = ILUCPP_FALSE;
    }
    else {
        for (i = 0; i < p_rec_outarg->boundedbarseqmember.length(); i++) {
            if (STATIC_CAST(foo(bar_ptr), p_rec_outarg->boundedbarseqmember[i]) != STATIC_CAST(foo(bar_ptr), mybar_var)) {
                cout << "p_rec_outarg->boundedbarseq[" << i << "] bad " << endl;
                b_return = ILUCPP_FALSE;
                break;
            };
        };
    };
	if (p_rec_outarg->variableunionmember._d() != rec_inarg.variableunionmember._d()) {
		cout << "p_rec_outarg->variableunionmember._d() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		if (p_rec_outarg->variableunionmember.integerarm() != rec_inarg.variableunionmember.integerarm()) {
			cout << "p_passvariableuniontype_outarg->integerarm() bad" << endl;
			b_return = ILUCPP_FALSE;
		}
	}
    if (STATIC_CAST(foo(bar_ptr), p_rec_outarg->barmember) != STATIC_CAST(foo(bar_ptr), mybar_var)) {
        cout << "p_rec_outarg->barmember bad " << endl;
        b_return = ILUCPP_FALSE;
    };

    

	//  return should be what inout arg was
	if (84 != p_rec_return->integermember) {
		cout << "p_rec_return->integermember bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (strcmp(p_rec_return->latinstringmember, inoutlstringvalue) != 0) {
		cout << "p_rec_return->latinstringmember bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (! iluCppRuntime::iluCharacterStringEqual(p_rec_return->unicodestringmember, inoutustringvalue)) {
		cout << "p_rec_return->unicodestringmember wrong" << endl;
		b_return = ILUCPP_FALSE;
	}
    if (footypes(green) != p_rec_return->enummember) {
		cout << "p_rec_return->enummember wrong" << endl;
		b_return = ILUCPP_FALSE;
    }
	if (84 != p_rec_return->fixedrecordmember.fixedrecordinteger) {
		cout << "p_rec_return->fixedrecordmember.fixedrecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
    if (footypes(green) != p_rec_return->fixedrecordmember.fixedrecordenum) {
		cout << "p_rec_return->fixedrecordmember.fixedrecordenum wrong" << endl;
		b_return = ILUCPP_FALSE;
	}
	if (strcmp(p_rec_return->variablerecordmember.variablerecordstring, inoutlstringvalue) != 0) {
		cout << "p_rec_return->variablerecordmember.variablerecordstring bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (84 != p_rec_return->variablerecordmember.variablerecordinteger) {
		cout << "p_rec_return->variablerecordmember.variablerecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (STATIC_CAST(foo(bar_ptr), mybar_var) != STATIC_CAST(foo(bar_ptr), p_rec_return->variablerecordmember.variablerecordobject)) {
		cout << "p_rec_return->variablerecordmember.variablerecordobject bad " << endl;
		b_return = ILUCPP_FALSE;
	}
    for (i = 0; i < 5; i++) {
        for (j = 0; j < 10; j++) {
            if (p_rec_return->integerarraymember[i][j] != 2*(i + j)) {
                cout << "p_rec_return->integerarraymember[" << i << ", " << j << "] bad " << endl;
                b_return = ILUCPP_FALSE;
                goto bad_return_integerarray_element;
            };
        };
        continue;
bad_return_integerarray_element:
        ;
    };
    for (i = 0; i < 2; i++) {
        for (j = 0; j < 3; j++) {
            if (STATIC_CAST(foo(bar_ptr), p_rec_return->bararraymember[i][j]) != STATIC_CAST(foo(bar_ptr), mybar_var)) {
                cout << "p_rec_return->bararraymember[" << i << ", " << j << "] bad " << endl;
                b_return = ILUCPP_FALSE;
                goto bad_return_bararray_element;
            };
        };
        continue;
bad_return_bararray_element:
        ;
    };
    if (p_rec_return->unboundedlongseqmember.length() != inoutunboundedlongseqlength) {
        cout << "p_rec_return->unboundedlongseqmember.length() bad" << endl;
        b_return = ILUCPP_FALSE;
    }
    else {
        for (i = 0; i < p_rec_return->unboundedlongseqmember.length(); i++) {
            if (p_rec_return->unboundedlongseqmember[i] != 2*i) {
                cout << "p_rec_return->unboundedlongseqmember[" << i << "] bad " << endl;
                b_return = ILUCPP_FALSE;
                break;
            };
        };
    };
    if (p_rec_return->boundedbarseqmember.length() != boundedbarseqlength) {
        cout << "p_rec_return->boundedbarseqmember.length() bad" << endl;
        b_return = ILUCPP_FALSE;
    }
    else {
        for (i = 0; i < p_rec_return->boundedbarseqmember.length(); i++) {
            if (STATIC_CAST(foo(bar_ptr), p_rec_return->boundedbarseqmember[i]) != STATIC_CAST(foo(bar_ptr), mybar_var)) {
                cout << "p_rec_return->boundedbarseq[" << i << "] bad " << endl;
                b_return = ILUCPP_FALSE;
                break;
            };
        };
    };
	if (p_rec_return->variableunionmember._d() != inoutarg_in_variableunionmember_val._d()) {
		cout << "p_rec_return->variableunionmember._d() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		if (p_rec_return->variableunionmember.bararm() != inoutarg_in_variableunionmember_val.bararm()) {
			cout << "p_rec_return->bararm() bad" << endl;
			b_return = ILUCPP_FALSE;
		}
	}
    if (STATIC_CAST(foo(bar_ptr), p_rec_return->barmember) != STATIC_CAST(foo(bar_ptr), mybar_var)) {
        cout << "p_rec_return->barmember bad " << endl;
        b_return = ILUCPP_FALSE;
    };
	

	//  inout arg check
	if (85 != rec_inoutarg.integermember) {
		cout << "rec_inoutarg.integermember bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (strcmp(rec_inoutarg.latinstringmember, "returned passidlexceptionrec_inoutarg") != 0) {
		cout << "rec_inoutarg.latinstringmember bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (! iluCppRuntime::iluCharStringShortCharStringEqual(rec_inoutarg.unicodestringmember, "FromServer_inoutarg")) {
		cout << "rec_inoutarg.unicodestringmember wrong" << endl;
		b_return = ILUCPP_FALSE;
	}
    if (footypes(blue) != rec_inoutarg.enummember) {
		cout << "rec_inoutarg.enummember wrong" << endl;
		b_return = ILUCPP_FALSE;
    }
	if (85 != rec_inoutarg.fixedrecordmember.fixedrecordinteger) {
		cout << "rec_inoutarg.fixedrecordmember.fixedrecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
    if (footypes(blue) != rec_inoutarg.fixedrecordmember.fixedrecordenum) {
		cout << "rec_inoutarg.fixedrecordmember.fixedrecordenum wrong" << endl;
		b_return = ILUCPP_FALSE;
	}
	if (strcmp(rec_inoutarg.variablerecordmember.variablerecordstring, "returned passidlexceptionrec_inoutarg") != 0) {
		cout << "rec_inoutarg.variablerecordmember.variablerecordstring bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (85 != rec_inoutarg.variablerecordmember.variablerecordinteger) {
		cout << "rec_inoutarg.variablerecordmember.variablerecordinteger bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	if (STATIC_CAST(foo(bar_ptr), mybar_var) != STATIC_CAST(foo(bar_ptr), rec_inoutarg.variablerecordmember.variablerecordobject)) {
		cout << "rec_inoutarg.variablerecordobject bad " << endl;
		b_return = ILUCPP_FALSE;
	}
    for (i = 0; i < 5; i++) {
        for (j = 0; j < 10; j++) {
            if (rec_inoutarg.integerarraymember[i][j] != 1 + 2*(i + j)) {
                cout << "rec_inoutarg.integerarraymember[" << i << ", " << j << "] bad " << endl;
                b_return = ILUCPP_FALSE;
                goto bad_inoutarg_integerarray_element;
            };
        };
        continue;
bad_inoutarg_integerarray_element:
        ;
    };
    for (i = 0; i < 2; i++) {
        for (j = 0; j < 3; j++) {
            if (STATIC_CAST(foo(bar_ptr), rec_inoutarg.bararraymember[i][j]) != STATIC_CAST(foo(bar_ptr), mybar_var)) {
                cout << "rec_inoutarg.bararraymember[" << i << ", " << j << "] bad " << endl;
                b_return = ILUCPP_FALSE;
                goto bad_inoutarg_bararray_element;
            };
        };
        continue;
bad_inoutarg_bararray_element:
        ;
    };
    for (i = 0; i < rec_inoutarg.unboundedlongseqmember.length(); i++) {
        if (rec_inoutarg.unboundedlongseqmember[i] != (1 + i)) {
            cout << "rec_inoutarg.unboundedlongseqmember[" << i << "] bad " << endl;
            b_return = ILUCPP_FALSE;
            break;
        };
    };
    if (rec_inoutarg.boundedbarseqmember.length() != boundedbarseqlength) {
        cout << "rec_inoutarg.boundedbarseqmember.length() bad" << endl;
        b_return = ILUCPP_FALSE;
    }
    else {
        for (i = 0; i < rec_inoutarg.boundedbarseqmember.length(); i++) {
            if (STATIC_CAST(foo(bar_ptr), rec_inoutarg.boundedbarseqmember[i]) != STATIC_CAST(foo(bar_ptr), mybar_var)) {
                cout << "rec_inoutarg.boundedbarseq[" << i << "] bad " << endl;
                b_return = ILUCPP_FALSE;
                break;
            };
        };
    };
	if (rec_inoutarg.variableunionmember._d() != rec_inarg.variableunionmember._d()) {
		cout << "rec_inoutarg.variableunionmember._d() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		if (rec_inoutarg.variableunionmember.integerarm() != rec_inarg.variableunionmember.integerarm()) {
			cout << "variableunionmember.integerarm() bad" << endl;
			b_return = ILUCPP_FALSE;
		}
	}
    if (STATIC_CAST(foo(bar_ptr), rec_inoutarg.barmember) != STATIC_CAST(foo(bar_ptr), mybar_var)) {
        cout << "rec_inoutarg.barmember bad " << endl;
        b_return = ILUCPP_FALSE;
    };
	
    delete p_rec_outarg;
    delete p_rec_return;
	
	iluCppRuntime::iluFree(p_inustringvalue);
	iluCppRuntime::iluFree(p_inoutustringvalue);
	
	if (b_return)
		cout << "passidlexceptionrec succeeded" << endl;

	return b_return;
}

///////////////////////////////////////////////////////////////////////
// try calling the passfixedarray method

CORBA(Boolean) dopassfixedarray(foo(bar_var)& mybar_var) {

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassfixedarray <<<<<<<<<<<<<<<<<<" << endl;
	
	footypes(integerarray) in_array = {
		{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9},
		{ 10, 11, 12, 13, 14, 15, 16, 17, 18, 19},
		{ 20, 21, 22, 23, 24, 25, 26, 27, 28, 29},
		{ 30, 31, 32, 33, 34, 35, 36, 37, 38, 39},
		{ 40, 41, 42, 43, 44, 45, 46, 47, 48, 49}
	};
	footypes(integerarray) inout_array = {
		{ 10, 11, 12, 13, 14, 15, 16, 17, 18, 19},
		{ 110, 111, 112, 113, 114, 115, 116, 117, 118, 119},
		{ 120, 121, 122, 123, 124, 125, 126, 127, 128, 129},
		{ 130, 131, 132, 133, 134, 135, 136, 137, 138, 139},
		{ 140, 141, 142, 143, 144, 145, 146, 147, 148, 149}
	};

	// use these intermediate slice variables to get around G++ (2.7.2) problem with 
 	// distinguishing between conversion to const T and conversion to T
	footypes(integerarray_slice)* p_inarg_slice = footypes(integerarray_dup)(in_array);
 	footypes(integerarray_slice)* p_inoutarg_slice = footypes(integerarray_dup)(inout_array);
 	footypes(integerarray_slice)* p_outarg_slice = footypes(integerarray_alloc)();
	footypes(integerarray_slice)* p_return_slice;

	footypes(integerarray_var) passfixedarray_inarg_var(p_inarg_slice);
	footypes(integerarray_var) passfixedarray_inoutarg_var(p_inoutarg_slice);
	footypes(integerarray_var) passfixedarray_outarg_var(p_outarg_slice);


#if (defined(__SUNPRO_CC))
	/* apparently the Sunpro C++ compiler (4.1 here) has some strange bug which *actually will copy* an
	   array onto the stack! if we pass the passfixedarray_WHATEVERarg_var as the 
	   argument to the call to mybar_var->passfixedarray, invoking the conversion to 
	   footypes(integerarray)& in the process.  However, if we make an intermediate reference
	   as below, and pass that, we don't have the problem.
	*/
	footypes(integerarray)& r_fixedarray_inarg = passfixedarray_inarg_var;
	footypes(integerarray)& r_fixedarray_inoutarg = passfixedarray_inoutarg_var;
	footypes(integerarray)& r_fixedarray_outarg = passfixedarray_outarg_var;
#endif

	footypes(integerarray_var) passfixedarray_return_var;
	CORBA(Long) index0, index1;
	CORBA(Boolean) b_return = ILUCPP_TRUE;

	try {

#if (defined(__SUNPRO_CC))
		passfixedarray_return_var = mybar_var->passfixedarray(r_fixedarray_inarg,
			r_fixedarray_inoutarg, r_fixedarray_outarg);

#elif (defined (__GNUC__))
		// use these intermediate slice variables to get around G++ (2.7.2) problem with 
 		// distinguishing between conversion to const T and conversion to T
		p_return_slice = mybar_var->passfixedarray(p_inarg_slice,
			p_inoutarg_slice, p_outarg_slice);
		passfixedarray_return_var = p_return_slice;

#else
		passfixedarray_return_var = mybar_var->passfixedarray(passfixedarray_inarg_var,
			passfixedarray_inoutarg_var, passfixedarray_outarg_var);
#endif

	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	// make some refs so we can use []'s
#ifdef __GNUC__
	footypes(integerarray)& inargref =  *((footypes(integerarray)*)p_inarg_slice);
	footypes(integerarray)& outargref = *((footypes(integerarray)*)p_outarg_slice);
	footypes(integerarray)& inoutargref = *((footypes(integerarray)*)p_inoutarg_slice);
	footypes(integerarray)& returnref = *((footypes(integerarray)*)p_return_slice);
#else
	footypes(integerarray)& inargref = passfixedarray_inarg_var;
	footypes(integerarray)& outargref = passfixedarray_outarg_var;
	footypes(integerarray)& inoutargref = passfixedarray_inoutarg_var;
	footypes(integerarray)& returnref = passfixedarray_return_var;
#endif

	// outarg should be copy of inarg
	for (index0 = 0; index0 < 5; index0++) {
		for (index1 = 0; index1 < 10; index1++) {
			if (inargref[index0][index1] != outargref[index0][index1]) {
				cout << "passfixedarray_outarg bad " << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
		if (b_return == ILUCPP_FALSE) break;
	}
	
	//  return should be what inout arg was
	for (index0 = 0; index0 < 5; index0++) {
		for (index1 = 0; index1 < 10; index1++) {
			if (inout_array[index0][index1] != returnref[index0][index1]) {
				cout << "passfixedarray_return bad " << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
		if (b_return == ILUCPP_FALSE) break;
	}

	//  inout arg should be one more in each field
	for (index0 = 0; index0 < 5; index0++) {
		for (index1 = 0; index1 < 10; index1++) {
			if (inout_array[index0][index1] + 1 != inoutargref[index0][index1]) {
				cout << "passfixedarray_inoutarg bad " << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
		if (b_return == ILUCPP_FALSE) break;
	}

	if (b_return)
		cout << "passfixedarray succeeded" << endl;

	return b_return;
}

///////////////////////////////////////////////////////////////////////
// try calling the passvariablearray method

CORBA(Boolean) dopassvariablearray(foo(bar_var)& mybar_var) {

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassvariablearray <<<<<<<<<<<<<<<<<<" << endl;
	
	foo(bararray) in_array = {
		{ mybar_var, mybar_var, mybar_var},
		{ mybar_var, mybar_var, mybar_var}
	};
	foo(bararray) inout_array = {
		{ mybar_var, mybar_var, mybar_var},
		{ mybar_var, mybar_var, mybar_var}
	};

	// cout << "dopassvariablearray - automatics made " << endl;

#ifdef __GNUC__
	// manually increment the refcounts to get around G++ (2.7.2) problem with 
 	// not running the copy constructors during the initialization of the multidimensional
	// automatic foo(bararray)'s
	for (int i_gnubug = 0; i_gnubug < 12; i_gnubug++)
	   mybar_var->iluIncrementReferenceCount();
#endif

	// cout << "dopassvariablearray - about to make slices, mybar_var count = " << mybar_var->iluGetReferenceCount() << endl;

	// use these intermediate slice variables to get around G++ (2.7.2) problem with 
 	// distinguishing between conversion to const T and conversion to T
	foo(bararray_slice)* p_inarg_slice = foo(bararray_dup)(in_array);
 	foo(bararray_slice)* p_inoutarg_slice = foo(bararray_dup)(inout_array);
	foo(bararray_slice)* p_return_slice;


	foo(bararray_var) passvariablearray_inarg_var(p_inarg_slice);
	foo(bararray_var) passvariablearray_inoutarg_var(p_inoutarg_slice);
	foo(bararray_slice)* passvariablearray_outarg_slice;


#ifdef __SUNPRO_CC
	/* apparently the Sunpro C++ compiler (4.1 here) has some strange bug which *actually will copy* an
	   array onto the stack! if we pass the passvariablearray_WHATEVERarg_var as the 
	   argument to the call to mybar_var->passvariablearray, invoking the conversion to 
	   footypes(integerarray)& in the process.  However, if we make an intermediate reference
	   as below, and pass that, we don't have the problem.
	*/
	foo(bararray)& r_variablearray_inarg = passvariablearray_inarg_var;
	foo(bararray)& r_variablearray_inoutarg = passvariablearray_inoutarg_var;
#endif

	foo(bararray_var) passvariablearray_return_var;
	CORBA(Long) index0, index1;
	CORBA(Boolean) b_return = ILUCPP_TRUE;
	
	try {

#if (defined(__SUNPRO_CC))
		passvariablearray_return_var = mybar_var->passvariablearray(r_variablearray_inarg,
			r_variablearray_inoutarg, passvariablearray_outarg_slice);

#elif (defined (__GNUC__))
		// use these intermediate slice variables to get around G++ (2.7.2) problem with 
 		// distinguishing between conversion to const T and conversion to T
		p_return_slice = mybar_var->passvariablearray(p_inarg_slice,
			p_inoutarg_slice, passvariablearray_outarg_slice);
		passvariablearray_return_var = p_return_slice;

#else
		passvariablearray_return_var = mybar_var->passvariablearray(passvariablearray_inarg_var,
			passvariablearray_inoutarg_var, passvariablearray_outarg_slice);
#endif

	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}

	foo(bararray_var) passvariablearray_outarg_var (passvariablearray_outarg_slice);

	// make some refs so we can use []'s
#ifdef __GNUC__
	foo(bararray)& inargref =  *((foo(bararray)*)p_inarg_slice);
	foo(bararray)& outargref = *((foo(bararray)*)passvariablearray_outarg_slice);
	foo(bararray)& inoutargref = *((foo(bararray)*)p_inoutarg_slice);
	foo(bararray)& returnref = *((foo(bararray)*)p_return_slice);
#else
	foo(bararray)& inargref = passvariablearray_inarg_var;
	foo(bararray)& outargref = passvariablearray_outarg_var;
	foo(bararray)& inoutargref = passvariablearray_inoutarg_var;
	foo(bararray)& returnref = passvariablearray_return_var;
#endif
	// outarg should be copy of inarg
	for (index0 = 0; index0 < 2; index0++) {
		for (index1 = 0; index1 < 3; index1++) {
			if ((inargref[index0][index1]).iluGetObjectPointer() != 
				(outargref[index0][index1]).iluGetObjectPointer()) {
				cout << "passvariablearray_outarg bad " << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
		if (b_return == ILUCPP_FALSE) break;
	}
	
	//  return should be what inout arg was
	for (index0 = 0; index0 < 2; index0++) {
		for (index1 = 0; index1 < 3; index1++) {
			if ((returnref[index0][index1]).iluGetObjectPointer() !=
				(inoutargref[index0][index1]).iluGetObjectPointer()){
				cout << "passvariablearray_return bad " << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
		if (b_return == ILUCPP_FALSE) break;
	}

	//  inout arg should  be copy of inarg
	for (index0 = 0; index0 < 2; index0++) {
		for (index1 = 0; index1 < 3; index1++) {
			if ((inargref[index0][index1]).iluGetObjectPointer() != 
				(inoutargref[index0][index1]).iluGetObjectPointer()) {
				cout << "passvariablearray_inoutarg bad " << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
		if (b_return == ILUCPP_FALSE) break;
	}

	if (b_return)
		cout << "passvariablearray succeeded" << endl;

	return b_return;
}


///////////////////////////////////////////////////////////////////////
// try calling the passunboundedsequence method

CORBA(Boolean) dopassunboundedsequence(foo(bar_var)& mybar_var) {	

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassunboundedsequence <<<<<<<<<<<<<<<<<<" << endl;
	
	footypes(unboundedlongseq) passunboundedlongseq_inarg(5);
	footypes(unboundedlongseq) passunboundedlongseq_inoutarg(3);
	
	footypes(unboundedlongseq)* p_passunboundedlongseq_outarg; 
	footypes(unboundedlongseq)* p_passunboundedlongseq_return;
	CORBA(Boolean) b_return = ILUCPP_TRUE;
	iluCardinal index;

	passunboundedlongseq_inarg.length(5);
	for (index = 0; index < 5; index++) 
		passunboundedlongseq_inarg[index] = index;

	passunboundedlongseq_inoutarg.length(3);
	for (index = 0; index < 3; index++) 
		passunboundedlongseq_inoutarg[index] = index + 100;
	
	try {
		p_passunboundedlongseq_return = mybar_var->passunboundedsequence(passunboundedlongseq_inarg,
			passunboundedlongseq_inoutarg, p_passunboundedlongseq_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	// outarg should be a copy of inarg
	if (p_passunboundedlongseq_outarg->length() != passunboundedlongseq_inarg.length()) {
		cout << "p_passunboundedlongseq_outarg->length() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		for (index = 0; index < p_passunboundedlongseq_outarg->length(); index++) {
			if ((*p_passunboundedlongseq_outarg)[index] != passunboundedlongseq_inarg[index]) {
				cout << "(*p_passunboundedlongseq_outarg)[index]() bad" << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
	}

	// return should be what inout arg was
	if (p_passunboundedlongseq_return->length() != 3) {
		cout << "p_passunboundedlongseq_outarg->length() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		for (index = 0; index < p_passunboundedlongseq_return->length(); index++) {
			if ((*p_passunboundedlongseq_return)[index] != (CORBA(Long)(index + 100))) {
				cout << "(*p_passunboundedlongseq_return)[index] bad" << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
	}

	// inout arg should be a copy of inarg
	if (passunboundedlongseq_inoutarg.length() != passunboundedlongseq_inarg.length()) {
		cout << "passunboundedlongseq_inoutarg.length() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		for (index = 0; index < passunboundedlongseq_inoutarg.length(); index++) {
			if (passunboundedlongseq_inoutarg[index] != passunboundedlongseq_inarg[index]) {
				cout << "passunboundedlongseq_inoutarg[index] bad" << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
	}

	delete p_passunboundedlongseq_outarg;
	delete p_passunboundedlongseq_return;

	if (b_return)
		cout << "passunboundedlongseq succeeded" << endl;

	return b_return;
}


///////////////////////////////////////////////////////////////////////
// try calling the passboundedsequence method

CORBA(Boolean) dopassboundedsequence(foo(bar_var)& mybar_var) {	

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassboundedsequence <<<<<<<<<<<<<<<<<<" << endl;
	
	foo(boundedbarseq) passboundedbarseq_inarg;
	foo(boundedbarseq) passboundedbarseq_inoutarg;
	
	foo(boundedbarseq)* p_passboundedbarseq_outarg; 
	foo(boundedbarseq)* p_passboundedbarseq_return;
	CORBA(Boolean) b_return = ILUCPP_TRUE;
	iluCardinal index;

	passboundedbarseq_inarg.length(2);
	for (index = 0; index < 2; index++) 
		passboundedbarseq_inarg[index] = mybar_var;

	passboundedbarseq_inoutarg.length(1);
	for (index = 0; index < 1; index++) 
		passboundedbarseq_inoutarg[index] = mybar_var;
	
	try {
		p_passboundedbarseq_return = mybar_var->passboundedsequence(passboundedbarseq_inarg,
			passboundedbarseq_inoutarg, p_passboundedbarseq_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	// outarg should be a copy of inarg
	if (p_passboundedbarseq_outarg->length() != passboundedbarseq_inarg.length()) {
		cout << "p_passboundedbarseq_outarg->length() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		for (index = 0; index < p_passboundedbarseq_outarg->length(); index++) {
			if (((*p_passboundedbarseq_outarg)[index]).iluGetObjectPointer() != 
				(passboundedbarseq_inarg[index]).iluGetObjectPointer()) {
				cout << "(*p_passboundedbarseq_outarg)[index]() bad" << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
	}

	// return should be what inout arg was
	if (p_passboundedbarseq_return->length() != 1) {
		cout << "p_passboundedbarseq_outarg->length() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		for (index = 0; index < p_passboundedbarseq_return->length(); index++) {
			if (((*p_passboundedbarseq_return)[index]).iluGetObjectPointer() != 
				mybar_var.iluGetObjectPointer()) {
				cout << "(*p_passboundedbarseq_return)[index] bad" << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
	}

	// inout arg should be a copy of inarg
	if (passboundedbarseq_inoutarg.length() != passboundedbarseq_inarg.length()) {
		cout << "passboundedbarseq_inoutarg.length() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		for (index = 0; index < passboundedbarseq_inoutarg.length(); index++) {
			if ((passboundedbarseq_inoutarg[index]).iluGetObjectPointer() != 
				(passboundedbarseq_inarg[index]).iluGetObjectPointer()) {
				cout << "passboundedbarseq_inoutarg[index] bad" << endl;
				b_return = ILUCPP_FALSE;
				break;
			}
		}
	}

	delete p_passboundedbarseq_outarg;
	delete p_passboundedbarseq_return;

	if (b_return)
		cout << "passboundedbarseq succeeded" << endl;

	return b_return;
}


///////////////////////////////////////////////////////////////////////
// try calling the dopassvariableunion method

CORBA(Boolean) dopassvariableunion(foo(bar_var)& mybar_var) {	

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassvariableunion <<<<<<<<<<<<<<<<<<" << endl;
	
	foo(variableuniontype) passvariableuniontype_inarg;
	foo(variableuniontype) passvariableuniontype_inoutarg;
	
	foo(variableuniontype)* p_passvariableuniontype_outarg; 
	foo(variableuniontype)* p_passvariableuniontype_return;
	CORBA(Boolean) b_return = ILUCPP_TRUE;

	passvariableuniontype_inarg.integerarm(2);
	passvariableuniontype_inoutarg.bararm(mybar_var);
	CORBA(UShort) original_inoutarg_discriminator = passvariableuniontype_inoutarg._d();
	
	try {
		p_passvariableuniontype_return = mybar_var->passvariableunion(passvariableuniontype_inarg,
			passvariableuniontype_inoutarg, p_passvariableuniontype_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	// outarg should be a copy of inarg
	if (p_passvariableuniontype_outarg->_d() != passvariableuniontype_inarg._d()) {
		cout << "p_passvariableuniontype_outarg->_d() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		if (p_passvariableuniontype_outarg->integerarm() != passvariableuniontype_inarg.integerarm()) {
			cout << "p_passvariableuniontype_outarg->integerarm() bad" << endl;
			b_return = ILUCPP_FALSE;
		}
	}

	// return should be what inout arg was
	if (p_passvariableuniontype_return->_d() != original_inoutarg_discriminator) {
		cout << "p_passvariableuniontype_return->_d() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		if (p_passvariableuniontype_return->bararm() != 
			mybar_var.iluGetObjectPointer()) {
			cout << "p_passvariableuniontype_return->bararm() bad" << endl;
			b_return = ILUCPP_FALSE;
		}
	}

	// inout arg should be a copy of inarg
	if (passvariableuniontype_inoutarg._d() != passvariableuniontype_inarg._d()) {
		cout << "p_passvariableuniontype_inoutarg._d() bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {		
		if (passvariableuniontype_inoutarg.integerarm() != passvariableuniontype_inarg.integerarm()) {
			cout << "p_passvariableuniontype_inoutarg.integerarm() bad" << endl;
			b_return = ILUCPP_FALSE;
		}
	}

	delete p_passvariableuniontype_outarg;
	delete p_passvariableuniontype_return;

	if (b_return)
		cout << "passvariableuniontype succeeded" << endl;

	return b_return;
}


static
ILUCPP_BOOL
equivalent (footypes(integerarray_slice)* a, footypes(integerarray_slice)* b);

static
ILUCPP_BOOL
equivalent (const footypes(OptArray) a, const footypes(OptArray) b);

static
ILUCPP_BOOL
equivalent (const char* a, const char* b) {
    if (a == b)
        return ILUCPP_TRUE;
    if (a == NULL || b == NULL)
        return ILUCPP_FALSE;
    return (strcmp(a, b) == 0);
}

static
ILUCPP_BOOL
equivalent (const iluCharacter* a, const iluCharacter* b) {
    if (a == b)
        return ILUCPP_TRUE;
    if (a == NULL || b == NULL)
        return ILUCPP_FALSE;
    return iluCppRuntime::iluCharacterStringEqual(a, b);
}

template <class T>
TEMPLATE_STATIC
ILUCPP_BOOL
equivalent (const iluTemplatableObject_var<T>& a, const iluTemplatableObject_var<T>& b) {
    return (a.iluGetObjectPointer() == b.iluGetObjectPointer());
}

static
ILUCPP_BOOL
equivalent (const footypes(fixedrecordtype)* a, const footypes(fixedrecordtype)* b) {
    if (a == b)
        return ILUCPP_TRUE;
    if (a == NULL || b == NULL)
        return ILUCPP_FALSE;
    return (
        a->fixedrecordinteger == b->fixedrecordinteger &&
        a->fixedrecordenum == b->fixedrecordenum
        );
}

static
ILUCPP_BOOL
equivalent (const foo(variablerecordtype)* a, const foo(variablerecordtype)* b) {
    if (a == b)
        return ILUCPP_TRUE;
    if (a == NULL || b == NULL)
        return ILUCPP_FALSE;
    return (
        equivalent(a->variablerecordstring, b->variablerecordstring) &&
        a->variablerecordinteger == b->variablerecordinteger &&
        equivalent(a->variablerecordobject, b->variablerecordobject)
        );
}

template <class T>
TEMPLATE_STATIC
ILUCPP_BOOL
equivalent (const iluTemplatableT_var<T>& a, const iluTemplatableT_var<T>& b) {
    if (a.iluIsNull() != b.iluIsNull())
        return ILUCPP_FALSE;
    else if (a.iluIsNull())
        return ILUCPP_TRUE;
	return (STATIC_CAST(const T&, a) == STATIC_CAST(const T&, b));
}

static
ILUCPP_BOOL
equivalent (const footypes(OptRec)* a, const footypes(OptRec)* b) {
    if (a == b)
        return ILUCPP_TRUE;
    if (a == NULL || b == NULL)
        return ILUCPP_FALSE;
    return (
        equivalent(a->integer_member, b->integer_member) &&
        equivalent(
            (footypes(OptRec)*)(CONST_CAST(footypes(OptRec)*, a)->optrec_member),
            (footypes(OptRec)*)(CONST_CAST(footypes(OptRec)*, b)->optrec_member)
        ) &&
        equivalent(a->integerarray_member, b->integerarray_member) &&
        // TEMP: above casts required because no conversion operator from const iluTemplatableT_var<T> to const T*
        equivalent(a->baz_member, b->baz_member) &&
		equivalent(a->latinstring_member, b->latinstring_member) &&
		equivalent(a->unicodestring_member, b->unicodestring_member) &&
		equivalent(a->optarray_member, b->optarray_member)
    );
}

static
ILUCPP_BOOL
equivalent (const foo(boundedbarseq)* a, const foo(boundedbarseq)* b) {
    if (a == b)
        return ILUCPP_TRUE;
    if (a == NULL || b == NULL)
        return ILUCPP_FALSE;
    if (a->length() != b->length())
        return ILUCPP_FALSE;
    for (CORBA(ULong) i = 0; i < a->length(); i++) {
        if (!equivalent((*a)[i], (*b)[i]))
            return ILUCPP_FALSE;
    };
    return ILUCPP_TRUE;
}

static
ILUCPP_BOOL
equivalent (footypes(integerarray_slice)* a, footypes(integerarray_slice)* b) {
    if (a == b)
        return ILUCPP_TRUE;
    if (a == NULL || b == NULL)
        return ILUCPP_FALSE;
    for (CORBA(ULong) i = 0; i < 5; i++) {
        for (CORBA(ULong) j = 0; j < 10; j++) {
            if (a[i][j] != b[i][j])
                return ILUCPP_FALSE;
        };
    };
    return ILUCPP_TRUE;
}

static
ILUCPP_BOOL
equivalent (foo(bararray_slice)* a, foo(bararray_slice)* b) {
    if (a == b)
        return ILUCPP_TRUE;
    if (a == NULL || b == NULL)
        return ILUCPP_FALSE;
    for (CORBA(ULong) i = 0; i < 2; i++) {
        for (CORBA(ULong) j = 0; j < 3; j++) {
            if (a[i][j] != b[i][j])
                return ILUCPP_FALSE;
        };
    };
    return ILUCPP_TRUE;
}

static
ILUCPP_BOOL
equivalent (const footypes(OptArray) a, const footypes(OptArray) b) {
	// TMP 8/25: NOTE: this probably isn't the best way to pass arrays,
	// but at the moment I can't figure out how else to do it.
    if (a == b)
        return ILUCPP_TRUE;
    if (a == NULL || b == NULL)
        return ILUCPP_FALSE;
    for (CORBA(ULong) i = 0; i < 2; i++) {
        if (*a[i] != *b[i])
			return ILUCPP_FALSE;
    };
    return ILUCPP_TRUE;
}



///////////////////////////////////////////////////////////////////////
// try calling the dopassoptionals method

CORBA(Boolean) dopassoptionals(foo(bar_var)& mybar_var) {	

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassoptionals <<<<<<<<<<<<<<<<<<" << endl;
	
	footypes(optionalinteger) passoptionalinteger_inarg = NULL;
	foo(optionalbarobject) passoptionalbarobject_inoutarg = mybar_var;
	foo(optionalbarobject) passoptionalbarobject_outarg; 
	footypes(optionalinteger) passoptionalinteger_return;

//    footypes(fixedrecordtypebase2) fixedrecord_in = {15, footypes(blue)};
    footypes(fixedrecordtype) fixedrecord_in;
    fixedrecord_in.fixedrecordinteger = 15;
    fixedrecord_in.fixedrecordenum = footypes(blue);

//    footypes(fixedrecordtype) fixedrecord_inout = {20, footypes(red)};
    footypes(fixedrecordtype) fixedrecord_inout;
    fixedrecord_inout.fixedrecordinteger = 20;
    fixedrecord_inout.fixedrecordenum = footypes(red);

//    footypes(fixedrecordtype) fixedrecord_out = {25, footypes(orange)};
    footypes(fixedrecordtype) fixedrecord_out;
    fixedrecord_out.fixedrecordinteger = 25;
    fixedrecord_out.fixedrecordenum = footypes(orange);


    footypes(optionalfixedrecordtype) optionalfixedrecord_inarg = &fixedrecord_in;
    footypes(optionalfixedrecordtype) optionalfixedrecord_inoutarg = &fixedrecord_inout;
    footypes(optionalfixedrecordtype) optionalfixedrecord_outarg = &fixedrecord_out;

    const char * in_string_value = "InString";
    const char * inout_string_value = "InOutString";
    const char * out_string_value = "OutString";


//    foo(variablerecordtype) variablerecord_in = {"In String", 15, mybar_var};
    foo(variablerecordtype) variablerecord_in;
    variablerecord_in.variablerecordstring = CORBA(string_dup)(in_string_value);
    variablerecord_in.variablerecordinteger = 15;
    variablerecord_in.variablerecordobject = mybar_var;

//    foo(variablerecordtype) variablerecord_inout = {"InOut String", 20, mybar_var};
    foo(variablerecordtype) variablerecord_inout;
    variablerecord_inout.variablerecordstring = CORBA(string_dup)(inout_string_value);
    variablerecord_inout.variablerecordinteger = 20;
    variablerecord_inout.variablerecordobject = mybar_var;

//    foo(variablerecordtype) variablerecord_out = {"Out String", 25, mybar_var};
    foo(variablerecordtype) variablerecord_out;

    foo(optionalvariablerecordtype) optionalvariablerecord_inarg = &variablerecord_in;
    foo(optionalvariablerecordtype) optionalvariablerecord_inoutarg = &variablerecord_inout;
    foo(optionalvariablerecordtype) optionalvariablerecord_outarg = &variablerecord_out;

    const char* optionalLatinString_inarg = "In String";
    char* optionalLatinString_inoutarg = CORBA(string_dup)("In Out String");
    char* optionalLatinString_outarg = "Out String";

    const iluCharacter* optionalUnicodeString_inarg = iluCppRuntime::iluCharStringFromShortCharString("In String");
    iluCharacter* optionalUnicodeString_inoutarg = iluCppRuntime::iluCharStringFromShortCharString("In Out String");
    iluCharacter* optionalUnicodeString_outarg = iluCppRuntime::iluCharStringFromShortCharString("Out String");

    foo(boundedbarseq) * optionalboundedbarseq_inarg = new foo(boundedbarseq);
    foo(boundedbarseq) * optionalboundedbarseq_inoutarg = new foo(boundedbarseq);
    foo(boundedbarseq) * optionalboundedbarseq_outarg = new foo(boundedbarseq);
    optionalboundedbarseq_inarg->length(3);
    optionalboundedbarseq_inoutarg->length(2);
    optionalboundedbarseq_outarg->length(1);
    for (CORBA(ULong) i = 0; i < optionalboundedbarseq_inarg->length(); i++)
        (*optionalboundedbarseq_inarg)[i] = mybar_var;
    for (i = 0; i < optionalboundedbarseq_inoutarg->length(); i++)
        (*optionalboundedbarseq_inoutarg)[i] = mybar_var;
    for (i = 0; i < optionalboundedbarseq_outarg->length(); i++)
        (*optionalboundedbarseq_outarg)[i] = mybar_var;

	
	footypes(integerarray) integerarray_in = {
		{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9},
		{ 10, 11, 12, 13, 14, 15, 16, 17, 18, 19},
		{ 20, 21, 22, 23, 24, 25, 26, 27, 28, 29},
		{ 30, 31, 32, 33, 34, 35, 36, 37, 38, 39},
		{ 40, 41, 42, 43, 44, 45, 46, 47, 48, 49}
	};
	footypes(integerarray) integerarray_inout = {
		{ 10, 11, 12, 13, 14, 15, 16, 17, 18, 19},
		{ 110, 111, 112, 113, 114, 115, 116, 117, 118, 119},
		{ 120, 121, 122, 123, 124, 125, 126, 127, 128, 129},
		{ 130, 131, 132, 133, 134, 135, 136, 137, 138, 139},
		{ 140, 141, 142, 143, 144, 145, 146, 147, 148, 149}
	};

	// use these intermediate slice variables to get around G++ (2.7.2) problem with 
 	// distinguishing between conversion to const T and conversion to T
	footypes(integerarray_slice)* integerarray_in_slice = footypes(integerarray_dup)(integerarray_in);
 	footypes(integerarray_slice)* integerarray_inout_slice = footypes(integerarray_dup)(integerarray_inout);
    footypes(integerarray_slice)* integerarray_out_slice = NULL;

    foo(bararray) bararray_in;
    foo(bararray) bararray_inout;
    foo(bararray) bararray_out;

    for (i = 0; i < 2; i++) {
        for (CORBA(ULong) j = 0; j < 3; j++) {
            bararray_in[i][j] = mybar_var;
            bararray_inout[i][j] = mybar_var;
        };
    };


	// use these intermediate slice variables to get around G++ (2.7.2) problem with 
 	// distinguishing between conversion to const T and conversion to T
	foo(bararray_slice)* bararray_in_slice = foo(bararray_dup)(bararray_in);
 	foo(bararray_slice)* bararray_inout_slice = foo(bararray_dup)(bararray_inout);
    foo(bararray_slice)* bararray_out_slice = NULL;

    footypes(OptRec) optrec_inarg;
    footypes(OptRec) optrec_inoutarg;
    footypes(OptRec)* optrec_outarg;

    optrec_inarg.integer_member = new CORBA(Long);
    optrec_inoutarg.integer_member = new CORBA(Long);
    *optrec_inarg.integer_member = 1;
    *optrec_inoutarg.integer_member = 2;

    optrec_inarg.integerarray_member = footypes(integerarray_alloc)();
    optrec_inoutarg.integerarray_member = footypes(integerarray_alloc)();
    for (i = 0; i < 5; i++) {
        for (CORBA(ULong) j = 0; j < 10; j++) {
            optrec_inarg.integerarray_member[i][j] = i*2;
            optrec_inoutarg.integerarray_member[i][j] = i*2 + 2;
        };
    };

    optrec_inarg.baz_member = foo(bar)::_duplicate(mybar_var);
    optrec_inoutarg.baz_member = foo(bar)::_duplicate(mybar_var);

	optrec_inarg.latinstring_member = CORBA(string_dup)(in_string_value);
	optrec_inoutarg.latinstring_member = CORBA(string_dup)(inout_string_value);

	optrec_inarg.unicodestring_member = iluCppRuntime::iluCharStringFromShortCharString(in_string_value);
	optrec_inoutarg.unicodestring_member = iluCppRuntime::iluCharStringFromShortCharString(inout_string_value);

	for (i = 0; i < 2; i++) {
		optrec_inarg.optarray_member[i] = new CORBA(Long);
		*optrec_inarg.optarray_member[i] = i*2;
		optrec_inoutarg.optarray_member[i] = new CORBA(Long);
		*optrec_inoutarg.optarray_member[i] = i*2 + 2;
	};

    footypes(OptionalOptRec) optrec_inarg_optrec_member = new footypes(OptRec);
    *optrec_inarg_optrec_member = optrec_inarg;
    optrec_inarg.optrec_member = optrec_inarg_optrec_member;

    footypes(OptionalOptRec) optrec_inoutarg_optrec_member = new footypes(OptRec);
    *optrec_inoutarg_optrec_member = optrec_inoutarg;
    optrec_inoutarg.optrec_member = optrec_inoutarg_optrec_member;

    // dupicate our inout arg since we want to hang onto it
	// refcount should now be two (one for original, one for
	// the duplicate
	foo(bar)::_duplicate(passoptionalbarobject_inoutarg);

	CORBA(Boolean) b_return = ILUCPP_TRUE;

	try {
		passoptionalinteger_return = mybar_var->passoptionals(

            passoptionalinteger_inarg,
            passoptionalinteger_inarg,
            passoptionalinteger_inarg,

			NULL,
			passoptionalbarobject_inoutarg,
            passoptionalbarobject_outarg,

            optionalfixedrecord_inarg,
            optionalfixedrecord_inoutarg,
            optionalfixedrecord_outarg,

            optionalvariablerecord_inarg,
            optionalvariablerecord_inoutarg,
            optionalvariablerecord_outarg,

            optionalLatinString_inarg,
            optionalLatinString_inoutarg,
            optionalLatinString_outarg,

            optionalUnicodeString_inarg,
            optionalUnicodeString_inoutarg,
            optionalUnicodeString_outarg,

            optionalboundedbarseq_inarg,
            optionalboundedbarseq_inoutarg,
            optionalboundedbarseq_outarg,

            integerarray_in,
            integerarray_inout_slice,
            integerarray_out_slice,

            bararray_in,
            bararray_inout_slice,
            bararray_out_slice,

            optrec_inarg,
            optrec_inoutarg,
            optrec_outarg
        );
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	// object outarg should be mybar_var's object
	if ((! passoptionalbarobject_outarg) || 
		(passoptionalbarobject_outarg != mybar_var.iluGetObjectPointer())) {
		cout << "passoptionalbarobject_outarg bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else 
		passoptionalbarobject_outarg->_release();

    // other outargs should be equal to inargs
    if (!equivalent(optionalfixedrecord_inarg, optionalfixedrecord_outarg)) {
		cout << "optionalfixedrecord_outarg bad" << endl;
		b_return = ILUCPP_FALSE;
	};
    if (!equivalent(optionalvariablerecord_inarg, optionalvariablerecord_outarg)) {
		cout << "optionalvariablerecord_outarg bad" << endl;
		b_return = ILUCPP_FALSE;
	};
    if (!equivalent(optionalLatinString_inarg, optionalLatinString_outarg)) {
		cout << "optionalLatinString_outarg bad" << endl;
		b_return = ILUCPP_FALSE;
	};
    if (!equivalent(optionalUnicodeString_inarg, optionalUnicodeString_outarg)) {
		cout << "optionalUnicodeString_outarg bad" << endl;
		b_return = ILUCPP_FALSE;
	};
    if (!equivalent(optionalboundedbarseq_inarg, optionalboundedbarseq_outarg)) {
		cout << "optionalboundedbarseq_outarg bad" << endl;
		b_return = ILUCPP_FALSE;
	};
    if (!equivalent(integerarray_in, integerarray_out_slice)) {
		cout << "integerarray_out_slice bad" << endl;
		b_return = ILUCPP_FALSE;
	};
    if (!equivalent(bararray_in, bararray_out_slice)) {
		cout << "bararray_out_slice bad" << endl;
		b_return = ILUCPP_FALSE;
	};
    if (!equivalent(&optrec_inarg, optrec_outarg)) {
		cout << "optrec_outarg bad" << endl;
		b_return = ILUCPP_FALSE;
	};

	// return should be 40
	if ((!passoptionalinteger_return) || (*passoptionalinteger_return != 40)) {
		cout << "passoptionalinteger_return bad" << endl;
		b_return = ILUCPP_FALSE;
	}

	// inout arg should be NULL
	if (passoptionalbarobject_inoutarg) {
		cout << "passoptionalbarobject_inoutarg bad" << endl;
		b_return = ILUCPP_FALSE;
	}
    if (optionalfixedrecord_inoutarg != NULL) {
		cout << "optionalfixedrecord_inoutarg bad" << endl;
		b_return = ILUCPP_FALSE;
	}
    if (optionalvariablerecord_inoutarg != NULL) {
		cout << "optionalvariablerecord_inoutarg bad" << endl;
		b_return = ILUCPP_FALSE;
	}
    if (optionalLatinString_inoutarg != NULL) {
		cout << "optionalLatinString_inoutarg bad" << endl;
		b_return = ILUCPP_FALSE;
	}
    if (optionalUnicodeString_inoutarg != NULL) {
		cout << "optionalUnicodeString_inoutarg bad" << endl;
		b_return = ILUCPP_FALSE;
	}
    if (optionalboundedbarseq_inoutarg != NULL) {
		cout << "optionalboundedbarseq_inoutarg bad" << endl;
		b_return = ILUCPP_FALSE;
	}
    if (bararray_inout_slice != NULL) {
		cout << "bararray_inout_slice bad" << endl;
		b_return = ILUCPP_FALSE;
	}
    if ((CORBA(Long)*)optrec_inoutarg.integer_member != NULL) {
		cout << "optrec_inoutarg bad" << endl;
		b_return = ILUCPP_FALSE;
	}

	// undo the dup we did on the inout arg in the beginning
	mybar_var->_release();

    CORBA(Long) what_mybar_var_refcount_should_be = 19;  // TMP 7/16: Until we fix refcounting bug
    for (i = mybar_var->iluGetReferenceCount(); i > what_mybar_var_refcount_should_be; i--)
        mybar_var->_release();

	delete passoptionalinteger_return;

	if (b_return)
		cout << "passoptionals succeeded" << endl;

	return b_return;
}

#ifdef ADD_VARIANT_SUPPORT

///////////////////////////////////////////////////////////////////////
// try calling the passsimpleanys method

/* TMP SRJ
CORBA(Boolean) dopasssimpleanys(foo(bar_var)& mybar_var) {	

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopasssimpleanys <<<<<<<<<<<<<<<<<<" << endl;
	
	CORBA(Any) passsimpleanys_inarg;
	CORBA(Any) passsimpleanys_inoutarg;
	
	CORBA(Any)* p_passsimpleanys_outarg; 
	CORBA(Any)* p_passsimpleanys_return;

	CORBA(Long) l_inarg_any_value = 2;
	CORBA(Boolean) inout_boolean;
	CORBA(Any)::to_boolean inout_to_boolean(inout_boolean);
	CORBA(string) inoutstring = "InOut string in an Any";
	CORBA(string) pc_inout_any_string = new char[strlen(inoutstring) + 1];
	CORBA(string) pc_return_any_string;
	strcpy(pc_inout_any_string, inoutstring);
	CORBA(Any)::from_string a_from_string (pc_inout_any_string, strlen(pc_inout_any_string));
	CORBA(Any)::to_string a_to_string (pc_return_any_string, 0);
	CORBA(Boolean) b_return = CORBA(TRUE);
	CORBA(Double) d_out_double;

	passsimpleanys_inarg <<= l_inarg_any_value;
	passsimpleanys_inoutarg <<= a_from_string;
	
	try {
		p_passsimpleanys_return = mybar_var->passsimpleanys(passsimpleanys_inarg,
			passsimpleanys_inoutarg, p_passsimpleanys_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	// outarg should be square root of inarg
	if (! ((*p_passsimpleanys_outarg) >>= d_out_double)) {
		cout << "p_passsimpleanys_outarg extraction bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	else if ((pow(d_out_double, 2.0) < (l_inarg_any_value - .01)) || 
		(pow(d_out_double, 2.0) > (l_inarg_any_value + .01))) {
			cout << "p_passsimpleanys_outarg extraction value bad " << endl;
		b_return = ILUCPP_FALSE;
	}

	//  return should be what inout arg was
	if (! ((*p_passsimpleanys_return) >>= a_to_string)) {
		cout << "p_passsimpleanys_return extraction bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else if (strcmp(inoutstring, a_to_string.val) != 0) {
			cout << "p_passsimpleanys_return extraction value bad" << endl;
		b_return = ILUCPP_FALSE;
	}

	//  inout arg check
	if (! (passsimpleanys_inoutarg >>= inout_to_boolean)) {
		cout << "passsimpleanys_inoutarg extraction bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else if (! inout_boolean) {
			cout << "passsimpleanys_inoutarg extraction value bad" << endl;
		b_return = ILUCPP_FALSE;
	}

	delete p_passsimpleanys_outarg; 
	delete p_passsimpleanys_return;

	if (b_return)
		cout << "passsimpleanys succeeded" << endl;

	return b_return;
}

///////////////////////////////////////////////////////////////////////
// try calling the passarrayanys method

CORBA(Boolean) dopassarrayanys(foo(bar_var)& mybar_var) {	

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassarrayanys <<<<<<<<<<<<<<<<<<" << endl;
	
	int i_xindex, i_yindex;
	CORBA(Boolean) b_return = CORBA(TRUE);

	CORBA(Any) passarrayanys_inarg;
	CORBA(Any) passarrayanys_inoutarg;
	
	CORBA(Any)* p_passarrayanys_outarg; 
	CORBA(Any)* p_passarrayanys_return;
	foo(bararray_forany)  out_barforany;
	footypes(integerarray_forany)  return_integerforany;
	footypes(integerarray_forany)  inout_integerforany;

	// define an integer array
	footypes(integerarray) in_integerarray = {
		{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9},
		{ 10, 11, 12, 13, 14, 15, 16, 17, 18, 19},
		{ 20, 21, 22, 23, 24, 25, 26, 27, 28, 29},
		{ 30, 31, 32, 33, 34, 35, 36, 37, 38, 39},
		{ 40, 41, 42, 43, 44, 45, 46, 47, 48, 49}
	};

	// make up a bararray
	foo(bararray_slice)*  p_inout_barslice = foo(bararray_alloc)();
	
	for (i_xindex = 0; i_xindex < 2; i_xindex++) {
		for (i_yindex = 0; i_yindex < 3; i_yindex++)
			p_inout_barslice[i_xindex][i_yindex] = mybar_var;
	}

	// make up an integerarray_forany, setting to copy the argument when we insert into an any
	footypes(integerarray_forany) in_integer_forany (in_integerarray);
	// tell the in_integer_forany not to release since the array's actually on the stack
	in_integer_forany.iluSetRelease(ILUCPP_FALSE); 

	// make up an bararray_forany, passing ownership of the argument when we insert into an any
	foo(bararray_forany) inout_bar_forany (p_inout_barslice, CORBA(TRUE)); 

	// insert the foranys into the anys
	passarrayanys_inarg <<= in_integer_forany;
	passarrayanys_inoutarg <<= inout_bar_forany;
	
	try {
		p_passarrayanys_return = mybar_var->passarrayanys(passarrayanys_inarg,
			passarrayanys_inoutarg, p_passarrayanys_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	// outarg should be what inout arg was
	if (! ((*p_passarrayanys_outarg) >>= out_barforany)) {
		cout << "p_passarrayanys_outarg extraction bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	else {
#ifdef __GNUC__
		// get around G++ (2.7.2) problem with 
 		// distinguishing between conversion to const T and conversion to T
		foo(bararray)& the_out_array = *((foo(bararray)*)(out_barforany.iluGetSlice()));
#else
		foo(bararray)& the_out_array = out_barforany;  
#endif
		for (i_xindex = 0; i_xindex < 2; i_xindex++) {
			for (i_yindex = 0; i_yindex < 3; i_yindex++) {
				if (!(the_out_array[i_xindex][i_yindex])->_is_equivalent(mybar_var)) {
					cout << "p_passarrayanys_outarg extraction value bad " << endl;
					b_return = ILUCPP_FALSE;
				}
			}
		}
	}

	//  return should be what inarg was with all the elements doubled
	if (! ((*p_passarrayanys_return) >>= return_integerforany)) {
		cout << "p_passarrayanys_return extraction bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {
#ifdef __GNUC__
		// get around G++ (2.7.2) problem with 
 		// distinguishing between conversion to const T and conversion to T
		footypes(integerarray)& the_return_array = *((footypes(integerarray)*)(return_integerforany.iluGetSlice()));
#else
		footypes(integerarray)& the_return_array = return_integerforany;
#endif
		for (i_xindex = 0; i_xindex < 5; i_xindex++) {
			for (i_yindex = 0; i_yindex < 10; i_yindex++) {
				if (the_return_array[i_xindex][i_yindex] != (2 * in_integerarray[i_xindex][i_yindex])) {
					cout << "p_passarrayanys_return extraction value bad" << endl;
					b_return = ILUCPP_FALSE;
				}
			}
		}
	}

	//  inout should be what inarg was
	if (! (passarrayanys_inoutarg >>= inout_integerforany)) {
		cout << "passarrayanys_inoutarg extraction bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else {
#ifdef __GNUC__
		// get around G++ (2.7.2) problem with 
 		// distinguishing between conversion to const T and conversion to T
		footypes(integerarray)& the_inout_array = *((footypes(integerarray)*)(inout_integerforany.iluGetSlice()));
#else
		footypes(integerarray)& the_inout_array = inout_integerforany;
#endif
		for (i_xindex = 0; i_xindex < 5; i_xindex++) {
			for (i_yindex = 0; i_yindex < 10; i_yindex++) {
				if (the_inout_array[i_xindex][i_yindex] != in_integerarray[i_xindex][i_yindex]) {
					cout << "passarrayanys_inoutarg extraction value bad" << endl;
					b_return = ILUCPP_FALSE;
				}
			}
		}
	}
	
	delete p_passarrayanys_outarg; 
	delete p_passarrayanys_return;

	if (b_return)
		cout << "passarrayanys succeeded" << endl;

	return b_return;
}


///////////////////////////////////////////////////////////////////////
// try calling the passassortedanys method

CORBA(Boolean) dopassassortedanys(foo(bar_var)& mybar_var) {	

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dopassassortedanys <<<<<<<<<<<<<<<<<<" << endl;
	
	CORBA(Boolean) b_return = CORBA(TRUE);
	CORBA(Any) passassortedanys_inarg;
	CORBA(Any) passassortedanys_inoutarg;
	
	CORBA(Any)* p_passassortedanys_outarg; 
	CORBA(Any)* p_passassortedanys_return;

	// set up inarg
	footypes(fixedrecordtype) inarg_any_value;
	inarg_any_value.fixedrecordinteger = 12345;
	inarg_any_value.fixedrecordenum = footypes(orange);
	passassortedanys_inarg <<= inarg_any_value;

	foo(optionalbarobject_forany) inoutarg_sent_value;
	passassortedanys_inoutarg <<= inoutarg_sent_value;  // should send 'bar not present'

	
	try {
		p_passassortedanys_return = mybar_var->passassortedanys(passassortedanys_inarg,
			passassortedanys_inoutarg, p_passassortedanys_outarg);
	}	
	catch (const CORBA(SystemException)& the_exception) {
		show_system_exception (the_exception);		
		return ILUCPP_FALSE;
	}
	catch (...) {
		cout << "Got some sort of exception" << endl;
		return ILUCPP_FALSE;
	}
	
	footypes(fixedrecordtype)* p_inoutarg_received_value;
	//  inout arg check should be copy of inarg
	if (! (passassortedanys_inoutarg >>= p_inoutarg_received_value)) {
		cout << "passassortedanys_inoutarg extraction bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else if (inarg_any_value.fixedrecordinteger != p_inoutarg_received_value->fixedrecordinteger ||
		inarg_any_value.fixedrecordenum != p_inoutarg_received_value->fixedrecordenum) {
			cout << "passassortedanys_inoutarg extraction value bad" << endl;
		b_return = ILUCPP_FALSE;
	}


	// outarg should be an optional bar set up to contain a pointer to the mybar_var's object
	foo(optionalbarobject_forany)* p_outarg_value;
	if (! ((*p_passassortedanys_outarg) >>= p_outarg_value)) {
		cout << "p_passassortedanys_outarg extraction bad " << endl;
		b_return = ILUCPP_FALSE;
	}
	else if (p_outarg_value->m_p_value != mybar_var.iluGetObjectPointer()) {
			cout << "p_passassortedanys_outarg extraction value bad " << endl;
		b_return = ILUCPP_FALSE;
	}

	//  return should be a variable union, set to integer 78
	foo(variableuniontype)* p_return_value;
	if (! ((*p_passassortedanys_return) >>= p_return_value)) {
		cout << "p_passassortedanys_return extraction bad" << endl;
		b_return = ILUCPP_FALSE;
	}
	else if (p_return_value->_d() != 2 || p_return_value->integerarm() != 78) {
			cout << "p_passassortedanys_return extraction value bad" << endl;
		b_return = ILUCPP_FALSE;
	}


	delete p_passassortedanys_outarg; 
	delete p_passassortedanys_return;

	if (b_return)
		cout << "passassortedanys succeeded" << endl;

	return b_return;
}


///////////////////////////////////////////////////////////////////////
// try calling the dotoywithanys method

CORBA(Boolean) dotoywithanys(foo(bar_var)& mybar_var) {	

    cout << endl;
    cout << "<<<<<<<<<<<<<<<<< entering dotoywithanys <<<<<<<<<<<<<<<<<<" << endl;
	
	CORBA(Boolean) b_return = CORBA(TRUE);
	CORBA(Any) anany;
	foo(bar_ptr) p_bar_retriever;
	iluObject* p_iluobject_retriever;

	// dup since we'll be putting into an any
	foo(bar)::_duplicate(mybar_var);

	// put it into the any
	anany <<= (foo(bar_ptr))mybar_var;

	// cause it to be pickled
	anany.iluPickleValue();

	// suck it back out as a bar object
	if (! (anany >>= p_bar_retriever)) {
		cout << "dotoywithanys extraction as foo(bar) failure" << endl;
		return ILUCPP_FALSE;
	}

	// put it back in
	anany.iluPickleValue();

	// suck it back out as an ilu object
	if (! (anany >>= p_iluobject_retriever)) {
		cout << "dotoywithanys extraction as iluObject failure" << endl;
		return ILUCPP_FALSE;
	}

	// put it back in
	anany.iluPickleValue();

	// see if we can suck it back out again as a bar object
	if (! (anany >>= p_bar_retriever)) {
		cout << "dotoywithanys extraction as foo(bar) (after iluObject) failure" << endl;
		return ILUCPP_FALSE;
	}


	if (b_return)
		cout << "dotoywithanys succeeded" << endl;

	return b_return;
}
TMP SRJ */

#endif // ADD_VARIANT_SUPPORT


///////////////////////////////////////////////////////////////////////
// mainsub

int mainsub(int ac, char **av) {
	
	char pc_hostname[1024];			/* holds the name of the host the server is on */
	char pc_serverid[128];			/* holds server id */	
	CORBA(Boolean) b_failure = ILUCPP_FALSE;
	
	// our object
	foo(bar_var) mybar_var; 
	
	if ((ac > 3)) {		/* check for proper command line args */
		cout << g_c_usage << endl;
		return 1;
	}
	
	if (ac > 1)				/* get hostname */
		strcpy (pc_hostname, av[1]);
	else
		gethostname(pc_hostname, sizeof(pc_hostname));
	
	if (ac > 2)	{ 
		// set up the runtime for threaded operation
		iluCppRuntime::iluInitialize(ILUCPP_TRUE);
	}
	else 	{ 
		// set up the runtime for non threaded operation
		iluCppRuntime::iluInitialize(ILUCPP_FALSE);
	}


	/* create server id */
	strcpy(pc_serverid, pc_hostname);
	strcat(pc_serverid, ".parc.xerox.com.fooserver");
	
	cout << "looking up object foo_instance_0 at server " << pc_serverid << endl;
	
	// get an object ptr - note that this object has a refcount of 1
	try {
		mybar_var =  foo(bar)::iluLookup ("foo_instance_0", pc_serverid);
	}
	catch(...) {
		cout << "foo::bar::iluLookup Exception" << endl;
		return -1;
	}


	// run each of the tests

    if ((! doobjectandstring(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "doobjectandstring FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
	if ((! dozap(0, mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dozap (no exception) FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
	if ((! dozap(100, mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dozap (exception) FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
	if ((! doobjecttableexercise(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "doobjecttableexercise FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
	if ((! dopass_obj(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopass_obj FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
	if ((! dopass_enum(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopass_enum FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
	if ((! dopasslatinstring(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopasslatinstring FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
	if ((! dopassunicodestring(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassunicodestring FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
    if ((! dopassfixedrecord(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassfixedrecord FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	} 
	if ((! dopassvariablerecord(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassvariablerecord FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
	if ((! dopassidlexceptionrec(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassidlexceptionrec FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
    if ((! dopassidlexceptionrec(mybar_var, "idlexception")) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassidlexceptionrec FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
    if ((! dopassidlexceptionrec(mybar_var, "islexception")) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassidlexceptionrec FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
    if ((! dopassidlexceptionrec(mybar_var, "voidexception")) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassidlexceptionrec FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
	if ((! dopassfixedarray(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassfixedarray FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}

	if ((! dopassvariablearray(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassvariablearray FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}

	if ((! dopassunboundedsequence(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassunboundedsequence FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}	
	if ((! dopassboundedsequence(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassboundedsequence FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	} 
	if ((! dopassvariableunion(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassvariableunion FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
    if ((! dopassoptionals(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassoptionals FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
	if ((! dopassvariableunion(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassvariableunion FAILED" << endl;
		b_failure = ILUCPP_TRUE;
	}
#ifdef ADD_VARIANT_SUPPORT
/* TMP 7/1 SRJ We don't implement optionals yet
	if ((! dotoywithanys(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dotoywithanys FAILED" << endl;
		b_failure = CORBA(TRUE);
	}
	if ((! dopasssimpleanys(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopasssimpleanys FAILED" << endl;
		b_failure = CORBA(TRUE);
	}
	if ((! dopassarrayanys(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassarrayanys FAILED" << endl;
		b_failure = CORBA(TRUE);
	}
	if ((! dopassassortedanys(mybar_var)) || (mybar_var->iluGetReferenceCount() != 1)) {
		cout << "dopassarrayanys FAILED" << endl;
		b_failure = CORBA(TRUE);
	}
TMP SRJ */
#endif

	if (b_failure) {
		cout << "One or more tests FAILED" << endl;
		return -1;
	}
	else {
		cout << "All tests Succeeded" << endl;
	}
		
	/* try closing the server at this point to verify monitor outgoing connections sees it
	while (1) {
	_sleep(5);
	}
	*/
	return 0;
}


///////////////////////////////////////////////////////////////////////
// main

int main(int ac, char **av) {
	int i_return_value;
	
	i_return_value = mainsub(ac, av);
	
	
	return i_return_value;
}


///////////////////////////////////////////////////////////////////////
//  End of file
///////////////////////////////////////////////////////////////////////

