// Prevent multiple inclusions
#ifndef __foo_cppsurrogate_H_
#define __foo_cppsurrogate_H_

#include "foo-cpp.hpp"

#define foo_surrogate_(name) NAME_INSIDE_SCOPE(foo_surrogate, name)
#define foo_surrogate(name) NAME_OUTSIDE_SCOPE(foo_surrogate, name)

BEGIN_NAMESPACE(foo_surrogate)

  // Surrogate classes

  class foo_surrogate_(bar) : public virtual foo(bar) {

    public:

      // ISL specified methods

      virtual
      CORBA(Boolean)
      zap (
        CORBA(Long) inarg,
        CORBA(Octet)& inoutarg,
        CORBA(Double)& outarg
      ) throw (CORBA(SystemException), foo(zapexception));

      virtual foo(bar_ptr) 
	  passobj (
		  foo(bar_ptr) inarg, 
		  foo(bar_ptr)& inoutarg, 
		  foo(bar_ptr)& outarg
	  ) throw (CORBA(SystemException));

      virtual foo(enumtype) 
	  passenum(
	      foo(enumtype) inarg, 
		  foo(enumtype)& inoutarg, 
		  foo(enumtype)& outarg
		  ) throw (CORBA(SystemException));
	  
	  virtual foo(LatinString) 
	  passlatinstring (
		  foo(const_LatinString) inarg,
		  foo(LatinString)& inoutarg,
		  foo(LatinString)& outarg
		  ) throw (CORBA(SystemException));

	  virtual foo(UnicodeString) 
      passunicodestring (
	      foo(const_UnicodeString) inarg,
		  foo(UnicodeString)& inoutarg,
		  foo(UnicodeString)& outarg
		  ) throw (CORBA(SystemException));
	  
	  virtual foo(fixedrecordtype)	
	  passfixedrecord(
		  const foo(fixedrecordtype)& inarg, 
		  foo(fixedrecordtype)& inoutarg, 
		  foo(fixedrecordtype)& outarg) throw (CORBA(SystemException));
	  
	  virtual foo(variablerecordtype)* 
	  passvariablerecord(
		  const foo(variablerecordtype)& inarg, 
		  foo(variablerecordtype)& inoutarg, 
		  foo(variablerecordtype)*& outarg) throw (CORBA(SystemException));
	  
	  virtual foo(integerarray_slice)* 
	  passfixedarray(
		  const foo(integerarray) inarg, 
		  foo(integerarray) inoutarg, 
		  foo(integerarray) outarg) throw (CORBA(SystemException));
	  
	  virtual foo(bararray_slice)* 
	  passvariablearray(
		  const foo(bararray) inarg, 
		  foo(bararray) inoutarg, 
		  foo(bararray_slice)*& outarg) throw (CORBA(SystemException));
	  
	  virtual foo(unboundedlongseq)* 
	  passunboundedsequence(
		  const foo(unboundedlongseq)& inarg, 
		  foo(unboundedlongseq)& inoutarg, 
		  foo(unboundedlongseq)*& outarg) throw (CORBA(SystemException));
	  
	  virtual foo(boundedbarseq)* 
	  passboundedsequence(
		  const foo(boundedbarseq)& inarg, 
		  foo(boundedbarseq)& inoutarg, 
		  foo(boundedbarseq)*& outarg) throw (CORBA(SystemException));

	  virtual foo(variableuniontype)* 
		  passvariableunion(
		  const foo(variableuniontype)& inarg, 
		  foo(variableuniontype)& inoutarg, 
		  foo(variableuniontype)*& outarg) throw (CORBA(SystemException));

	  virtual foo(optionalinteger) passoptionals(
		  foo(const_optionalinteger) inarg, 
		  foo(optionalbarobject)& inoutarg, 
		  foo(optionalbarobject)& outarg) throw (CORBA(SystemException));

	  virtual CORBA(Any)* passsimpleanys(
			  const CORBA(Any)& inarg, 
			  CORBA(Any)& inoutarg, 
			  CORBA(Any)*& outarg) throw (CORBA(SystemException));

	  virtual CORBA(Any)* passarrayanys(
			  const CORBA(Any)& inarg, 
			  CORBA(Any)& inoutarg, 
			  CORBA(Any)*& outarg) throw (CORBA(SystemException));

	  virtual CORBA(Any)* passassortedanys(
			  const CORBA(Any)& inarg, 
			  CORBA(Any)& inoutarg, 
			  CORBA(Any)*& outarg) throw (CORBA(SystemException));

      // Initialize to use this class of objects

      static
      void
      iluInitialize ();

      // Function used to create a surrogate for a foo_(bar) object

      static
      iluObject*
      create_surrogate (iluKernelObject);

    private:

      // Exception forwarding

      static
      void
      _throw_zap_exception (iluCardinal exception_index, iluSurrogateCall&)
      throw (CORBA(SystemException), foo(zapexception));

      // Set to 1 once initialization has occured

      static int _initialized;

  };

  // Class initializers

  class foo_surrogate_(bar_initializer) {
    public:
      foo_surrogate_(bar_initializer) ();
      int ensure_instantiation ();
	  static foo_surrogate_(bar_initializer) sm_the_surrogate_foo_bar_initializer;
  };

END_NAMESPACE;  // foo_surrogate

#endif // __foo_cppsurrogate_H_
