/* This file was hand written
 *
 * ILU is Copyright 1991-1996 Xerox Corporation, All Rights Reserved.
 * ILU information:  ftp://ftp.parc.xerox.com/pub/ilu/ilu.html.
 */

// Prevent multiple inclusions
#ifndef __foo_H_
#define __foo_H_

// define this variable since these are hand coded stubs and
// variant support if written - this would not normally appear
// in the stubber's output, but is merely here so that the client
// and server driver programs can conditionalize to either these
// hand written stubs or the stubber generated one (that are sans
// variant support currently)
#define CPP_STUBBER_VARIANTS_IMPLEMENTED


// Note corba.hpp includes ilucpp.hpp and ilucpp-templates.hpp
#include <corba.hpp>

// start the module scope
#define foo_(name) NAME_INSIDE_SCOPE(foo, name)
#define foo(name) NAME_OUTSIDE_SCOPE(foo, name)

BEGIN_NAMESPACE(foo)

#define CORBA_(name) NAME_INSIDE_SCOPE(CORBA, name)
#define CORBA(name) NAME_OUTSIDE_SCOPE(CORBA, name)
  class foo_(zapexception);
  #define g_foo_zapexception_index	0


  /////////////////////////////////////////////
  // Forward declarations and typedefs

    class foo_(bar);
    typedef foo_(bar)* foo_(bar_ptr);
    typedef iluTemplatableObject_var<foo_(bar)> foo_(bar_var);

	struct foo_(fixedrecordtype);
    typedef iluTemplatableT_var<foo_(fixedrecordtype)> foo_(fixedrecordtype_var);

 	struct foo_(variablerecordtype);
    typedef iluTemplatableT_var<foo_(variablerecordtype)> foo_(variablerecordtype_var);

	class foo_(integerarray_var);
	typedef CORBA(Long) foo_(integerarray)[5][10];
	typedef CORBA(Long) foo_(integerarray_slice)[10];
	NS_EXTERN foo_(integerarray_slice)* foo_(integerarray_alloc)();
	NS_EXTERN foo_(integerarray_slice)* foo_(integerarray_dup) (const foo_(integerarray_slice)* p_foo_integerarray_slice);
	NS_EXTERN void foo_(integerarray_free)(foo_(integerarray_slice)* p_foo_integerarray_slice);

	class foo_(bararray_var);
	typedef foo_(bar_var) foo_(bararray)[2][3];
	typedef foo_(bar_var) foo_(bararray_slice)[3];
	NS_EXTERN foo_(bararray_slice)* foo_(bararray_alloc)();
	NS_EXTERN foo_(bararray_slice)* foo_(bararray_dup) (const foo_(bararray_slice)* p_foo_bararray_slice);
	NS_EXTERN void foo_(bararray_free)(foo_(bararray_slice)* p_foo_bararray_slice);
	NS_EXTERN void foo_(bararray_iluSurrogateSideCleanup)(foo_(bararray_slice)* p_foo_bararray_slice);
	NS_EXTERN void foo_(const_bararray_iluSurrogateSideCleanup)(const foo_(bararray_slice)* p_foo_bararray_slice);

	class foo_(unboundedlongseq);
	class foo_(unboundedlongseq_var);

	class foo_(boundedbarseq);
	class foo_(boundedbarseq_var);

	class foo_(variableuniontype);
    typedef iluTemplatableT_var<foo_(variableuniontype)> foo_(variableuniontype_var);

	typedef foo_(bar_ptr) foo_(optionalbarobject);

    typedef CORBA(Long)* foo_(optionalinteger);
    typedef const CORBA(Long)* foo_(const_optionalinteger);

    // Declarations for initialization
    NS_EXTERN void foo_(iluInitialize)();
    NS_EXTERN int foo_(g_i_initialized);

    NS_EXTERN iluInitializationFunctionNode* foo_(p_initialization_function_list);

    //////////////////////////////////////////////////////////////////////
	// interface enumerations
	
	enum foo_(enumtype) { foo_(red), foo_(orange), foo_(yellow), foo_(green), foo_(blue), foo_(indigo), foo_(violet) };

#ifdef ADD_VARIANT_SUPPORT

  // declare the typecode instance for enumtype
  NS_EXTERN const CORBA(TypeCode_ptr) foo_(tc_enumtype);

#endif // ADD_VARIANT_SUPPORT


	//////////////////////////////////////////////////////////////////////
	// string typedefs

	typedef iluShortCharacter* foo_(LatinString);
	typedef const iluShortCharacter* foo_(const_LatinString);

	typedef iluCharacter* foo_(UnicodeString) ;
    typedef const iluCharacter* foo_(const_UnicodeString);


	//////////////////////////////////////////////////////////////////////
	// structures

	struct foo_(fixedrecordtype) {
/*	Can leave out - and would then allow aggregate inits 
		foo_(fixedrecordtype)();						// default constructor
		foo_(fixedrecordtype)(const foo_(fixedrecordtype)& r_a_fixedrecordtype); // copy constructor
		~foo_(fixedrecordtype)(); // destructor
		foo_(fixedrecordtype)& operator= (const foo_(fixedrecordtype)& r_a_fixedrecordtype); // assignment operator
*/
		// member vars
		int fixedrecordinteger;
		foo_(enumtype) fixedrecordenum;
	};
		
#ifdef ADD_VARIANT_SUPPORT

  // declare the typecode instance for fixedrecordtype
  NS_EXTERN const CORBA(TypeCode_ptr) foo_(tc_fixedrecordtype);

#endif // ADD_VARIANT_SUPPORT


	struct foo_(variablerecordtype) {
		foo_(variablerecordtype)();						// default constructor
		foo_(variablerecordtype)(const foo_(variablerecordtype)& r_a_variablerecordtype); // copy constructor
		~foo_(variablerecordtype)(); // destructor
		foo_(variablerecordtype)& operator= (const foo_(variablerecordtype)& r_a_variablerecordtype); // assignment operator
		
		// for ilustub use only - should be called before the surrogate side stub returns
		void iluSurrogateSideCleanup() const;

		// member vars
		CORBA(String_var) variablerecordstring;
		int variablerecordinteger;
		foo_(bar_var) variablerecordobject;
	};

#ifdef ADD_VARIANT_SUPPORT

  // declare the typecode instance for variablerecordtype
  NS_EXTERN const CORBA(TypeCode_ptr) foo_(tc_variablerecordtype);

#endif // ADD_VARIANT_SUPPORT

	

    //////////////////////////////////////////////////////////////////////
	// arrays

	class foo_(integerarray_var) : public ilu_var {
		
	public:
		
		// default constructor
		foo_(integerarray_var)() : m_b_release(ILUCPP_TRUE) { 
			m_p_slice = NULL;
		}
		
		// construct from slice
		foo_(integerarray_var)(foo_(integerarray_slice)* p_a_foo_integerarray_slice) : m_b_release(ILUCPP_TRUE) {
			m_p_slice = p_a_foo_integerarray_slice;
		}

		// copy constructor
		foo_(integerarray_var)(const foo_(integerarray_var)& r_a_foo_integerarray) : m_b_release(ILUCPP_TRUE) {
			m_p_slice = foo_(integerarray_dup)(r_a_foo_integerarray.m_p_slice);
		}

		// destructor
		~foo_(integerarray_var)() {
			if (m_b_release)
				foo_(integerarray_free)(m_p_slice);
		}
		
		// assign from slice
		foo_(integerarray_var)& operator=(foo_(integerarray_slice)* p_a_foo_integerarray_slice) {
			if (m_p_slice != p_a_foo_integerarray_slice)
				if (m_b_release)
					foo_(integerarray_free) (m_p_slice);
			m_p_slice = p_a_foo_integerarray_slice;
			return *this;			
		}
		
		// assign from another array_var
		foo_(integerarray_var)& operator=(const foo_(integerarray_var)& r_a_foo_integerarray) {
			if ((&r_a_foo_integerarray != this) && 
				(m_p_slice != r_a_foo_integerarray.m_p_slice)) {
				if (m_b_release)
					foo_(integerarray_free)(m_p_slice);
				m_p_slice = foo_(integerarray_dup)(r_a_foo_integerarray.m_p_slice);
			}
			return (*this);
		}

		/* XXX Note - If we define the [] operators along with the conversion 
		 operators needed to allow passing array_vars as parameters, 
		 and we try something like long temp = my_integerarray_var[2][4]; we get a 
		 error C2666: '[]' : 4 overloads have similar conversions
		 A user workaround is to do something like 
		 integerarray& my_array = my_integerarray_var;
		 long temp = my_integerarray_var[2][4] 

		// element operator - returns the index'th slice
		foo_(integerarray_slice)& operator[](CORBA(ULong) index) {
			return *(m_p_slice + index);
		}

		const foo_(integerarray_slice)& operator[](CORBA(ULong) index) const {
			return *(m_p_slice + index);
		}
		
		*/

		// conversion operations to allow parameter passing per Corba Spec chap 16, Table 16.2
		operator const foo_(integerarray)& () const {	// in parameters
			return *((const foo_(integerarray)*)m_p_slice);
		}

		operator foo_(integerarray)& () const {			// inout and fixed out parameters
/* xxx temp debugging only 
			foo_(integerarray)* p_temp_debugging = (foo_(integerarray)*)m_p_slice;
			 foo_(integerarray)& r_temp_debugging = *(p_temp_debugging);
			return r_temp_debugging;
end xxx temp debugging only */
			return *((foo_(integerarray)*)m_p_slice);
		}
		

		// accessors on the m_b_release member
		void iluSetRelease(ILUCPP_BOOL b_release_on_destruct) const {
			// cast around constness
			ILUCPP_BOOL* p_release = CONST_CAST(ILUCPP_BOOL*, &m_b_release);
			*p_release = b_release_on_destruct;
		}

		ILUCPP_BOOL iluGetRelease() const { return m_b_release; }

	protected:
		foo_(integerarray_slice)* m_p_slice;

		// whether or not a delete should be done when the var destructs
		ILUCPP_BOOL m_b_release;
		
    private:
		foo_(integerarray_var) &operator= (const ilu_var&);
		foo_(integerarray_var) (const ilu_var&);
	};

#ifdef ADD_VARIANT_SUPPORT

	// foo_(integerarray_forany) class to support use of arrays with anys
	class foo_(integerarray_forany) : public ilu_var {
		
	public:
		
		// default constructor
		foo_(integerarray_forany)() : m_p_slice(NULL), m_b_release(ILUCPP_TRUE), m_b_nocopy(ILUCPP_FALSE) {}
		
		// construct from slice
		foo_(integerarray_forany)(foo_(integerarray_slice)* p_a_foo_integerarray_slice, CORBA(Boolean) b_nocopy = ILUCPP_FALSE) 
			:  m_p_slice(p_a_foo_integerarray_slice), m_b_release(ILUCPP_TRUE), m_b_nocopy(b_nocopy) {}

		// copy constructor
		foo_(integerarray_forany)(const foo_(integerarray_forany)& r_a_foo_integerarray) : m_b_release(ILUCPP_TRUE), m_b_nocopy(ILUCPP_FALSE) {
			m_p_slice = foo_(integerarray_dup)(r_a_foo_integerarray.m_p_slice);
		}

		// destructor
		~foo_(integerarray_forany)() {
			if (m_b_release)
				foo_(integerarray_free)(m_p_slice);
		}
		
		// assign from slice
		foo_(integerarray_forany)& operator=(foo_(integerarray_slice)* p_a_foo_integerarray_slice) {
			if (m_p_slice != p_a_foo_integerarray_slice)
				if (m_b_release)
					foo_(integerarray_free) (m_p_slice);
			m_p_slice = p_a_foo_integerarray_slice;
			return *this;			
		}
		
		// assign from another array_var
		foo_(integerarray_forany)& operator=(const foo_(integerarray_forany)& r_a_foo_integerarray) {
			if ((&r_a_foo_integerarray != this) && 
				(m_p_slice != r_a_foo_integerarray.m_p_slice)) {
				if (m_b_release)
					foo_(integerarray_free)(m_p_slice);
				m_p_slice = foo_(integerarray_dup)(r_a_foo_integerarray.m_p_slice);
			}
			return (*this);
		}		

		operator const foo_(integerarray)& () const {	
			return *((const foo_(integerarray)*)m_p_slice);
		}

		operator foo_(integerarray)& () const {	
			return *((foo_(integerarray)*)m_p_slice);
		}

		// accessors on the m_b_release member
		void iluSetRelease(ILUCPP_BOOL b_release_on_destruct) const {
			// cast around constness
			ILUCPP_BOOL* p_release = CONST_CAST(ILUCPP_BOOL*, &m_b_release);
			*p_release = b_release_on_destruct;
		}

		ILUCPP_BOOL iluGetRelease() const { return m_b_release; }

		// accessors on the m_b_nocopy member
		void iluSetNoCopy(ILUCPP_BOOL b_nocopy) const {
			// cast around constness
			ILUCPP_BOOL* p_nocopy = CONST_CAST(ILUCPP_BOOL*, &m_b_nocopy);
			*p_nocopy = b_nocopy;
		}

		// used by ilu when we transfer ownership of the content to the any 
		CORBA(Boolean) iluShouldCopy() const {return (m_b_nocopy ? ILUCPP_FALSE : ILUCPP_TRUE);}
		foo_(integerarray_slice)* iluGetSlice() const {return m_p_slice;}		

	protected:
		foo_(integerarray_slice)* m_p_slice;

		// whether or not a delete should be done when the var destructs
		ILUCPP_BOOL m_b_release;
		
    private:
		foo_(integerarray_forany) &operator= (const ilu_var&);
		foo_(integerarray_forany) (const ilu_var&);

		CORBA(Boolean) m_b_nocopy;
	};


  // declare the typecode instance for foo_integerarray
  NS_EXTERN const CORBA(TypeCode_ptr) foo_(tc_integerarray);


#endif // ADD_VARIANT_SUPPORT

	// insertion, extraction, and sizing functions for foo(integerarray)
	// Note we cant use overloaded operators since arrays map to arrays, and
	// simple typedefs do not distinguish among overloaded functions
	
	NS_EXTERN iluBaseCall& foo_(size_const_integerarray)(iluBaseCall& r_call, const CORBA(Long)a_foo_integerarray[][10]);
	NS_EXTERN iluBaseCall& foo_(size_integerarray)(iluBaseCall& r_call, CORBA(Long)a_foo_integerarray[][10]);
	NS_EXTERN iluBaseCall& foo_(output_const_integerarray)(iluBaseCall& r_call, const CORBA(Long)a_foo_integerarray[][10]);
	NS_EXTERN iluBaseCall& foo_(output_integerarray)(iluBaseCall& r_call, CORBA(Long)a_foo_integerarray[][10]);
	NS_EXTERN iluBaseCall& foo_(input_integerarray)(iluBaseCall& r_call, CORBA(Long)a_foo_integerarray[][10]);


	class foo_(bararray_var) : public ilu_var {
		
	public:
		
		// default constructor
		foo_(bararray_var)() : m_b_release(ILUCPP_TRUE) { 
			m_p_slice = NULL;
		}
		
		// construct from slice
		foo_(bararray_var)(foo_(bararray_slice)* p_a_foo_bararray_slice) : m_b_release(ILUCPP_TRUE) {
			m_p_slice = p_a_foo_bararray_slice;
		}

		// copy constructor
		foo_(bararray_var)(const foo_(bararray_var)& r_a_foo_bararray) : m_b_release(ILUCPP_TRUE) {
			m_p_slice = foo_(bararray_dup)(r_a_foo_bararray.m_p_slice);
		}
		
		// destructor
		~foo_(bararray_var)() {
			if (m_b_release)
				foo_(bararray_free)(m_p_slice);
		}
		
		// assign from slice
		foo_(bararray_var)& operator=(foo_(bararray_slice)* p_a_foo_bararray_slice) {
			if (m_p_slice != p_a_foo_bararray_slice)
				if (m_b_release)
					foo_(bararray_free) (m_p_slice);
			m_p_slice = p_a_foo_bararray_slice;
			return *this;			
		}
		
		// assign from another array_var
		foo_(bararray_var)& operator=(const foo_(bararray_var)& r_a_foo_bararray) {
			if ((&r_a_foo_bararray != this) && 
				(m_p_slice != r_a_foo_bararray.m_p_slice)) {
				if (m_b_release)
					foo_(bararray_free)(m_p_slice);
				m_p_slice = foo_(bararray_dup)(r_a_foo_bararray.m_p_slice);
			}
			return (*this);
		}

		/* XXX Note - If we define the [] operators along with the conversion 
		 operators needed to allow passing array_vars as parameters, 
		 and we try something like long temp = my_bararray_var[2][4]; we get a 
		 error C2666: '[]' : 4 overloads have similar conversions
		 A user workaround is to do something like 
		 bararray& my_array = my_bararray_var;
		 long temp = my_bararray_var[2][4] 

		// element operator - returns the index'th slice
		foo_(bararray_slice)& operator[](CORBA(ULong) index) {
			return *(m_p_slice + index);
		}

		const foo_(bararray_slice)& operator[](CORBA(ULong) index) const {
			return *(m_p_slice + index);
		}
		
		*/

		// conversion operations to allow parameter passing per Corba Spec chap 16, Table 16.2
		operator const foo_(bararray)& () const {	// in parameters
			return *((const foo_(bararray)*)m_p_slice);
		}

		operator foo_(bararray)& () const {			// inout and fixed out parameters	
			return *((foo_(bararray)*)m_p_slice);
		}

		// accessors on the m_b_release member
		void iluSetRelease(ILUCPP_BOOL b_release_on_destruct) const {
			// cast around constness
			ILUCPP_BOOL* p_release = CONST_CAST(ILUCPP_BOOL*, &m_b_release);
			*p_release = b_release_on_destruct;
		}

		ILUCPP_BOOL iluGetRelease() const { return m_b_release; }

	protected:
		foo_(bararray_slice)* m_p_slice;

		// whether or not a delete should be done when the var destructs
		ILUCPP_BOOL m_b_release;
				
    private:
		foo_(bararray_var) &operator= (const ilu_var&);
		foo_(bararray_var) (const ilu_var&);
	};


#ifdef ADD_VARIANT_SUPPORT

	// foo_(bararray_forany) class to support use of arrays with anys
	class foo_(bararray_forany) : public ilu_var {
		
	public:
		
		// default constructor
		foo_(bararray_forany)() :  m_p_slice(NULL), m_b_release(ILUCPP_TRUE), m_b_nocopy(ILUCPP_FALSE) {}
		
		// construct from slice
		foo_(bararray_forany)(foo_(bararray_slice)* p_a_foo_bararray_slice, CORBA(Boolean) b_nocopy = ILUCPP_FALSE) 
			: m_p_slice(p_a_foo_bararray_slice), m_b_release(ILUCPP_TRUE), m_b_nocopy(b_nocopy) {}

		// copy constructor
		foo_(bararray_forany)(const foo_(bararray_forany)& r_a_foo_bararray) : m_b_release(ILUCPP_TRUE), m_b_nocopy(ILUCPP_FALSE) {
			m_p_slice = foo_(bararray_dup)(r_a_foo_bararray.m_p_slice);
		}

		// destructor
		~foo_(bararray_forany)() {
			if (m_b_release)
				foo_(bararray_free)(m_p_slice);
		}
		
		// assign from slice
		foo_(bararray_forany)& operator=(foo_(bararray_slice)* p_a_foo_bararray_slice) {
			if (m_p_slice != p_a_foo_bararray_slice)
				if (m_b_release)
					foo_(bararray_free) (m_p_slice);
			m_p_slice = p_a_foo_bararray_slice;
			return *this;			
		}
		
		// assign from another array_var
		foo_(bararray_forany)& operator=(const foo_(bararray_forany)& r_a_foo_bararray) {
			if ((&r_a_foo_bararray != this) && 
				(m_p_slice != r_a_foo_bararray.m_p_slice)) {
				if (m_b_release)
					foo_(bararray_free)(m_p_slice);
				m_p_slice = foo_(bararray_dup)(r_a_foo_bararray.m_p_slice);
			}
			return (*this);
		}		

		operator const foo_(bararray)& () const {	
			return *((const foo_(bararray)*)m_p_slice);
		}

		operator foo_(bararray)& () const {	
			return *((foo_(bararray)*)m_p_slice);
		}

		// accessors on the m_b_release member
		void iluSetRelease(ILUCPP_BOOL b_release_on_destruct) const {
			// cast around constness
			ILUCPP_BOOL* p_release = CONST_CAST(ILUCPP_BOOL*, &m_b_release);
			*p_release = b_release_on_destruct;
		}

		ILUCPP_BOOL iluGetRelease() const { return m_b_release; }

		// accessors on the m_b_nocopy member
		void iluSetNoCopy(ILUCPP_BOOL b_nocopy) const {
			// cast around constness
			ILUCPP_BOOL* p_nocopy = CONST_CAST(ILUCPP_BOOL*, &m_b_nocopy);
			*p_nocopy = b_nocopy;
		}

		// used by ilu when we transfer ownership of the content to the any 
		CORBA(Boolean) iluShouldCopy() const {return (m_b_nocopy ? ILUCPP_FALSE : ILUCPP_TRUE);}
		foo_(bararray_slice)* iluGetSlice() const {return m_p_slice;}		

	protected:
		foo_(bararray_slice)* m_p_slice;

		// whether or not a delete should be done when the var destructs
		ILUCPP_BOOL m_b_release;
		
    private:
		foo_(bararray_forany) &operator= (const ilu_var&);
		foo_(bararray_forany) (const ilu_var&);

		CORBA(Boolean) m_b_nocopy;
	};

  // declare the typecode instance for foo_bararray
  NS_EXTERN const CORBA(TypeCode_ptr) foo_(tc_bararray);


#endif // ADD_VARIANT_SUPPORT

	
	// insertion, extraction, and sizing functions for foo(bararray)
	// Note we cant use overloaded operators since arrays map to arrays, and
	// simple typedefs do not distinguish among overloaded functions
	
	NS_EXTERN iluBaseCall& foo_(size_const_bararray)(iluBaseCall& r_call, const foo_(bar_var) a_foo_bararray[][3]);
	NS_EXTERN iluBaseCall& foo_(size_bararray)(iluBaseCall& r_call,  foo_(bar_var) a_foo_bararray[][3]);
	NS_EXTERN iluBaseCall& foo_(output_const_bararray)(iluBaseCall& r_call, const foo_(bar_var) a_foo_bararray[][3]);
	NS_EXTERN iluBaseCall& foo_(output_bararray)(iluBaseCall& r_call, foo_(bar_var) a_foo_bararray[][3]);
	NS_EXTERN iluBaseCall& foo_(input_bararray)(iluBaseCall& r_call, foo_(bar_var) a_foo_bararray[][3]);
	
	
	class foo_(unboundedlongseq) {
		
    public:
		
		// constructors & desructor
		foo_(unboundedlongseq) ();
		foo_(unboundedlongseq) (CORBA(ULong) max);
		foo_(unboundedlongseq) (CORBA(ULong) max, CORBA(ULong) length, CORBA(Long)* data, CORBA(Boolean) release = ILUCPP_FALSE);
		foo_(unboundedlongseq) (const foo_(unboundedlongseq)& r_foo_unboundedlongseq);
		~foo_(unboundedlongseq)();
		
		// assignment
		foo_(unboundedlongseq)& operator= (const foo_(unboundedlongseq)& r_foo_unboundedlongseq);
		
		// accessors
		CORBA(ULong) maximum() const;
		CORBA(ULong) length() const;
		void length (CORBA(ULong) len);
		
		// [] operators
		CORBA(Long)& operator [] (CORBA(ULong) index);
		const CORBA(Long)& operator [] (CORBA(ULong) index) const;
		
		// memory management
		static CORBA(Long)* allocbuf(CORBA(ULong) num_elements);
		static void freebuf(CORBA(Long)* p_buf);

	private:
		CORBA(ULong) m_maximum;
		CORBA(ULong) m_length;
		CORBA(Long)* m_buffer;
		CORBA(Boolean) m_release;		
	};

#ifdef ADD_VARIANT_SUPPORT

  // declare the typecode instance for unboundedlongseq
  NS_EXTERN const CORBA(TypeCode_ptr) foo_(tc_unboundedlongseq);

#endif // ADD_VARIANT_SUPPORT


	class foo_(unboundedlongseq_var) : public iluTemplatableT_var<foo_(unboundedlongseq)> {
		
	public:
		
		const  CORBA(Long)& operator[] (CORBA(ULong) index) const {
			return (*m_ptr) [index];
		}
		
		CORBA(Long)& operator[] (CORBA(ULong) index) {
			return (*m_ptr) [index];
		}
	};
	

	class foo_(boundedbarseq) {
		
    public:
		
		// constructors & desructor
		foo_(boundedbarseq) ();
		foo_(boundedbarseq) (CORBA(ULong) length, foo_(bar_ptr)* data, CORBA(Boolean) release = ILUCPP_FALSE);
		foo_(boundedbarseq) (const foo_(boundedbarseq)& r_foo_boundedbarseq);
		~foo_(boundedbarseq)();
		
		// assignment
		foo_(boundedbarseq)& operator= (const foo_(boundedbarseq)& r_foo_boundedbarseq);
		
		// accessors
		CORBA(ULong) maximum() const;
		CORBA(ULong) length() const;
		void length (CORBA(ULong) len);
		
		// [] operators
		foo_(bar_var)& operator [] (CORBA(ULong) index);
		const foo_(bar_var)& operator [] (CORBA(ULong) index) const;
		
		// memory management
		static foo_(bar_ptr)* allocbuf(CORBA(ULong) num_elements);
		static void freebuf(foo_(bar_ptr)* p_buf);

		// for ilustub use only - should be called before the surrogate side stub returns
		void iluSurrogateSideCleanup() const;

	private:
		CORBA(ULong) m_maximum;
		CORBA(ULong) m_length;
		foo_(bar_var)* m_varbuffer;
		foo_(bar_ptr)* m_buffer;
		CORBA(Boolean) m_release;		
	};

#ifdef ADD_VARIANT_SUPPORT

  // declare the typecode instance for boundedbarseq
  NS_EXTERN const CORBA(TypeCode_ptr) foo_(tc_boundedbarseq);

#endif // ADD_VARIANT_SUPPORT

	class foo_(boundedbarseq_var) : public iluTemplatableT_var<foo_(boundedbarseq)> {
		
	public:
		
		const foo_(bar_var)& operator[] (CORBA(ULong) index) const {
			return (*m_ptr) [index];
		}
		
		foo_(bar_var)& operator[] (CORBA(ULong) index) {
			return (*m_ptr) [index];
		}
	};


	class foo_(variableuniontype) {
		
		// insertion, extraction, and sizing operators for foo(variableuniontype)
		
		friend iluBaseCall& operator+=(iluBaseCall& r_call, const foo(variableuniontype)& r_foo_variableuniontype);
		friend iluBaseCall& operator<<(iluBaseCall& r_call, const foo(variableuniontype)& r_foo_variableuniontype);
		friend iluBaseCall& operator>>(iluBaseCall& r_call, foo(variableuniontype)& r_foo_variableuniontype);
		
		
	public:
		
		// constructors & desructor
        foo_(variableuniontype)();
        foo_(variableuniontype)(const foo_(variableuniontype)& r_union_type);
        ~foo_(variableuniontype)();
		
		// assignment
        foo_(variableuniontype)& operator= (const foo_(variableuniontype)& r_union_type);
		
		// accessors
        CORBA(UShort) _d () const;		
        void _d (CORBA(UShort) new_d);
		
        foo_(bar_ptr) bararm () const;		
        void bararm (foo_(bar_ptr) a_bararm);
		
        CORBA(Long) integerarm () const;		
        void integerarm (CORBA(Long) an_integerarm);
		
		// for ilustub use only - should be called before the surrogate side stub returns
		void iluSurrogateSideCleanup() const;
		
	private:
		
		void unset();
		
		union {
            foo_(bar_var)* m_bararm;
            CORBA(Long)    m_integerarm;
        };
		
        CORBA(UShort) m_discriminator;
		CORBA(Boolean)    m_b_beenset;
		
	};
	
#ifdef ADD_VARIANT_SUPPORT

  // declare the typecode instance for variableuniontype
  NS_EXTERN const CORBA(TypeCode_ptr) foo_(tc_variableuniontype);

#endif // ADD_VARIANT_SUPPORT

    //////////////////////////////////////////////////////////////////////
    // For Clients, instances of _surrogate subclasses of this class will function
    // as surrogates - that is, their IDL specified member functions will forward
    // calls to the true object. Servers will subclass from this class, and supply
    // the IDL specified member functions to provide the true object's implementations

  class foo_(bar) : public virtual iluObject {

      public:
        // Constructs a new foo_(bar) using pc_instance_handle as the instance
        // identifier, and puts the object under the specified iluServer.
        // If an_iluserver is NULL, the default server will be used.
        foo_(bar)(char *pc_instance_handle, iluServer& r_an_ilu_server = iluServer::iluGetDefaultServer(),
			 CORBA(Boolean) b_within_object_table = ILUCPP_FALSE) :
          iluObject(foo_(bar)::m_ILUClassRecord, pc_instance_handle, r_an_ilu_server, b_within_object_table) {}

        // CORBA object reference operations
        static foo_(bar_ptr) _duplicate(foo_(bar_ptr) a_ptr);

        static foo_(bar_ptr) _narrow(CORBA(Object_ptr) an_object_ptr) {
          return (foo_(bar_ptr) (an_object_ptr->iluDowncast(m_ILUClassRecord)));
        }

        static foo_(bar_ptr) _narrow(iluObject* an_object_ptr) {
          return (foo_(bar_ptr) (an_object_ptr->iluDowncast(m_ILUClassRecord)));
        }

        static foo_(bar_ptr) _nil();
        foo_(bar_ptr) _this() { return _duplicate((foo_(bar_ptr)) this); }

        // IDL specified methods
          virtual CORBA(Boolean) zap (CORBA(Long) inarg, CORBA(Octet)& inoutarg, CORBA(Double)& outarg) = 0;

          virtual foo_(bar_ptr) passobj (foo_(bar_ptr) inarg, foo_(bar_ptr)& inoutarg, foo_(bar_ptr)& outarg) = 0;

		  virtual foo_(enumtype) passenum (foo_(enumtype) inarg, foo_(enumtype)& inoutarg, foo_(enumtype)& outarg) = 0;

		  virtual foo_(LatinString) passlatinstring (foo_(const_LatinString) inarg, foo_(LatinString)& inoutarg, foo_(LatinString)& outarg) = 0;

		  virtual foo_(UnicodeString) passunicodestring (foo_(const_UnicodeString) inarg, foo_(UnicodeString)& inoutarg, foo_(UnicodeString)& outarg) = 0;

		  virtual foo_(fixedrecordtype)	passfixedrecord(
			  const foo_(fixedrecordtype)& inarg, 
			  foo_(fixedrecordtype)& inoutarg, 
			  foo_(fixedrecordtype)& outarg) = 0;

		  virtual foo_(variablerecordtype)* passvariablerecord(
			  const foo_(variablerecordtype)& inarg, 
			  foo_(variablerecordtype)& inoutarg, 
			  foo_(variablerecordtype)*& outarg) = 0;

		  virtual foo_(integerarray_slice)* passfixedarray(
			  const foo_(integerarray) inarg, 
			  foo_(integerarray) inoutarg, 
			  foo_(integerarray) outarg) = 0;

		  virtual foo_(bararray_slice)* passvariablearray(
			  const foo_(bararray) inarg, 
			  foo_(bararray) inoutarg, 
			  foo_(bararray_slice)*& outarg) = 0;

		  virtual foo_(unboundedlongseq)* passunboundedsequence(
			  const foo_(unboundedlongseq)& inarg, 
			  foo_(unboundedlongseq)& inoutarg, 
			  foo_(unboundedlongseq)*& outarg) = 0;

		  virtual foo_(boundedbarseq)* passboundedsequence(
			  const foo_(boundedbarseq)& inarg, 
			  foo_(boundedbarseq)& inoutarg, 
			  foo_(boundedbarseq)*& outarg) = 0;

		  virtual foo_(variableuniontype)* passvariableunion(
			  const foo_(variableuniontype)& inarg, 
			  foo_(variableuniontype)& inoutarg, 
			  foo_(variableuniontype)*& outarg) = 0;

		  virtual foo_(optionalinteger) passoptionals(
			  foo_(const_optionalinteger) inarg, 
			  foo_(optionalbarobject)& inoutarg, 
			  foo_(optionalbarobject)& outarg) = 0;

		  virtual CORBA(Any)* passsimpleanys(
			  const CORBA(Any)& inarg, 
			  CORBA(Any)& inoutarg, 
			  CORBA(Any)*& outarg) = 0;

		  virtual CORBA(Any)* passarrayanys(
			  const CORBA(Any)& inarg, 
			  CORBA(Any)& inoutarg, 
			  CORBA(Any)*& outarg) = 0;

		  virtual CORBA(Any)* passassortedanys(
			  const CORBA(Any)& inarg, 
			  CORBA(Any)& inoutarg, 
			  CORBA(Any)*& outarg) = 0;

        // initialize to use of this class of objects - called by (Interface)::initialize
        static void iluInitialize();

        // Simple Object Lookup
        static foo_(bar_ptr) iluLookup(char *pc_server_id, char *pc_instance_handle);

        // For ILU C++ runtime - stub use only - returns the m_ILUClassRecord member variable
        static ilu_Class iluGetILUClassRecord() {
          return m_ILUClassRecord;
        }
        // for use in narrowing
        virtual void *iluDowncast(iluClass class_to_cast_down_to);

      protected:

        // Holds the kernel class for this kind of object
        static ilu_Class m_ILUClassRecord;

        foo_(bar)();	// default constructor
        virtual ~foo_(bar)();	 // destructor

      private:
        foo_(bar)(const foo_(bar)&);	// copy constructor
        void operator=(const foo_(bar)&);	// assignment operator

      };

#ifdef ADD_VARIANT_SUPPORT

  // declare the typecode instance for foo_(bar)
  NS_EXTERN const CORBA(TypeCode_ptr) foo_(tc_bar);

#endif // ADD_VARIANT_SUPPORT


  // Exception classes for this interface

  class foo_(zapexception) : public CORBA(UserException){
    public:
      // constructors and destructors
      foo_(zapexception)() { };
      foo_(zapexception)(CORBA(Long) value) : _m_value(value) {};
      foo_(zapexception)(const foo_(zapexception)& a_zapexception);
      ~foo_(zapexception)();

      // assignment operator
      foo_(zapexception)& operator=(const foo_(zapexception)& a_zapexception);

      // Members
      const CORBA(Long)& _value() const { return _m_value; };
      public:
      CORBA(Long) _m_value;
    };


  #ifdef ADD_VARIANT_SUPPORT

  // declare the typecode instance for optionalbarobject
  NS_EXTERN const CORBA(TypeCode_ptr) foo_(tc_optionalbarobject);

  // used to insert and extract foo_(optionalbarobject) s from Anys
  struct foo_(optionalbarobject_forany) {

	  foo_(optionalbarobject_forany)(foo_(bar_ptr) p_value = NULL) : m_p_value(p_value) {}

	  ~foo_(optionalbarobject_forany)() { if (m_p_value) m_p_value->_release(); }

	  foo_(optionalbarobject_forany)& operator= (const foo_(optionalbarobject_forany)& r_a_optionalbarobject_forany) { // assignment operator
		  if (this != &r_a_optionalbarobject_forany) {
			  if (r_a_optionalbarobject_forany.m_p_value)
				m_p_value = foo_(bar)::_duplicate(r_a_optionalbarobject_forany.m_p_value);
			  else m_p_value = NULL;
		  }
		  return *this;
	  }	  

	  foo_(bar_ptr) m_p_value;
  };

#endif // ADD_VARIANT_SUPPORT


#ifdef ADD_VARIANT_SUPPORT

  // declare the typecode instance for optionalinteger
  NS_EXTERN const CORBA(TypeCode_ptr) foo_(tc_optionalinteger);

  // used to insert and extract foo_(optionalinteger) s from Anys
  struct foo_(optionalinteger_forany) {

	  foo_(optionalinteger_forany)(foo_(optionalinteger) p_value = NULL) : m_p_value(p_value) {}

	  ~foo_(optionalinteger_forany)() { delete m_p_value; }

	  foo_(optionalinteger_forany)& operator= (const foo_(optionalinteger_forany)& r_a_optionalinteger_forany) { // assignment operator
		  if (this != &r_a_optionalinteger_forany) {
			  m_p_value = new CORBA(Long);
			  *m_p_value = *(r_a_optionalinteger_forany.m_p_value);
		  }
		  return *this;
	  }	  

	  foo_(optionalinteger) m_p_value;
  };

#endif // ADD_VARIANT_SUPPORT



  // Initialization related


  // foo_(initializer) class is used to create a single instance that puts the 
  // foo(iluInitialize) onto the iluCppInternal::sm_p_initialization_function_list 

  class foo_(initializer) {
    public:
      foo_(initializer) ();
      int ensure_instantiation ();
	  static foo_(initializer) sm_the_foo_initializer;
  };


  // If you're using a C++ compiler which does not initialize all non-local
  // statics before running main() (or you're doing something else which
  // could cause an unusual initialization order), you should use
  // one of the following macros to perform your initialization
  // before calling iluCppRuntime::iluInitialize()


  #define ILU_INIT_foo_CLIENT_ONLY() { \
	foo(initializer)::sm_the_foo_initializer.ensure_instantiation(); \
    foo_surrogate(bar_initializer)::sm_the_surrogate_foo_bar_initializer.ensure_instantiation(); \
    }

  #define ILU_INIT_foo_SERVER_ONLY() { \
	foo(initializer)::sm_the_foo_initializer.ensure_instantiation(); \
    foo_true(bar_initializer)::sm_the_true_foo_bar_initializer.ensure_instantiation(); \
    }

  #define ILU_INIT_foo_CLIENT_SERVER() { \
 	foo(initializer)::sm_the_foo_initializer.ensure_instantiation(); \
   foo_surrogate(bar_initializer)::sm_the_surrogate_foo_bar_initializer.ensure_instantiation(); \
    foo_true(bar_initializer)::sm_the_true_foo_bar_initializer.ensure_instantiation(); \
    }
  END_NAMESPACE;  // foo


  ////////////////////////////////////////////////////////
  // insertion & extraction operators

  // note following three operators are only needed if a foo(bar) is a member of a structured type
  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(bar_var)& r_foo_bar_var);
  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(bar_var)& r_foo_bar_var);
  iluBaseCall& operator>>(iluBaseCall& r_call, foo(bar_var)& r_foo_bar_var);
  
  // insertion, extraction, and sizing operators for foo(fixedrecordtype)
  
  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(fixedrecordtype)& r_foo_fixedrecordtype);
  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(fixedrecordtype)& r_foo_fixedrecordtype);
  iluBaseCall& operator>>(iluBaseCall& r_call, foo(fixedrecordtype)& r_foo_fixedrecordtype);
  
  // insertion, extraction, and sizing operators for foo(variablerecordtype)
  
  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(variablerecordtype)& r_foo_variablerecordtype);
  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(variablerecordtype)& r_foo_variablerecordtype);
  iluBaseCall& operator>>(iluBaseCall& r_call, foo(variablerecordtype)& r_foo_variablerecordtype);

  // insertion, extraction, and sizing operators for foo(unboundedlongseq)
  
  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(unboundedlongseq)& r_foo_unboundedlongseq);
  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(unboundedlongseq)& r_foo_unboundedlongseq);
  iluBaseCall& operator>>(iluBaseCall& r_call, foo(unboundedlongseq)& r_foo_unboundedlongseq);

  // insertion, extraction, and sizing operators for foo(boundedbarseq)
  
  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(boundedbarseq)& r_foo_boundedbarseq);
  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(boundedbarseq)& r_foo_boundedbarseq);
  iluBaseCall& operator>>(iluBaseCall& r_call, foo(boundedbarseq)& r_foo_boundedbarseq);

  // insertion, extraction, and sizing operators for foo(variableuniontype)
  
  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(variableuniontype)& r_foo_variableuniontype);
  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(variableuniontype)& r_foo_variableuniontype);
  iluBaseCall& operator>>(iluBaseCall& r_call, foo(variableuniontype)& r_foo_variableuniontype);


#ifdef ADD_VARIANT_SUPPORT


  // define the typecode class for foo_enumtype
  ILUCPP_DEFINE_STUB_TYPE_CODE_CLASS(foo_enumtype, ilu_enumeration_tk, "ilu:mlI8KGJsFBG2ywCR8x0Wql+mOYX");

  // declare the Any insertion and extraction operators for foo(enumtype)
  void operator<<=(CORBA(Any)& r_any, const foo(enumtype)& r_foo_enumtype);
  CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(enumtype)& r_foo_enumtype);



  // define the typecode class for foo_fixedrecordtype
  ILUCPP_DEFINE_STUB_TYPE_CODE_CLASS(foo_fixedrecordtype, ilu_record_tk, "ilu:fJRvTuuUCyZ+GZX2mytNYfCmECq");

  // declare the Any insertion and extraction operators for foo(fixedrecordtype)
  void operator<<=(CORBA(Any)& r_any, const foo(fixedrecordtype)& r_foo_fixedrecordtype);
  void operator<<=(CORBA(Any)& r_any, foo(fixedrecordtype)* p_foo_fixedrecordtype);
  CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(fixedrecordtype)*& rp_foo_fixedrecordtype);



  // define the typecode class for foo_variablerecordtype
  ILUCPP_DEFINE_STUB_TYPE_CODE_CLASS(foo_variablerecordtype, ilu_record_tk, "ilu:p1p-Xd0SkjKs8cNPeMkSi8G+s-j");

  // declare the Any insertion and extraction operators for foo(variablerecordtype)
  void operator<<=(CORBA(Any)& r_any, const foo(variablerecordtype)& r_foo_variablerecordtype);
  void operator<<=(CORBA(Any)& r_any, foo(variablerecordtype)* p_foo_variablerecordtype);
  CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(variablerecordtype)*& rp_foo_variablerecordtype);



  // define the typecode class for foo_integerarray
  ILUCPP_DEFINE_STUB_TYPE_CODE_CLASS(foo_integerarray, ilu_array_tk, "ilu:f3qA-xRiSkCvrf6KovBV+KsjMh0");

  // declare the Any insertion and extraction operators for foo(integerarray_forany)
  void operator<<=(CORBA(Any)& r_any, const foo(integerarray_forany)& r_integerarray_forany);
  CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(integerarray_forany)& r_integerarray_forany);



  // define the typecode class for foo_bararray
  ILUCPP_DEFINE_STUB_TYPE_CODE_CLASS(foo_bararray, ilu_array_tk, "ilu:dwYXDC7Gf2XOuhGijTt-FPv+OWo");
  
  // declare the Any insertion and extraction operators for foo(bararray_forany)
  void operator<<=(CORBA(Any)& r_any, const foo(bararray_forany)& r_bararray_forany);
  CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(bararray_forany)& r_bararray_forany);



  // define the typecode class for foo_unboundedlongseq
  ILUCPP_DEFINE_STUB_TYPE_CODE_CLASS(foo_unboundedlongseq, ilu_sequence_tk, "ilu:gb+4Sy4d-wQwxncKVc0kDH2CHNY");

  // declare the Any insertion and extraction operators for foo(unboundedlongseq)
  void operator<<=(CORBA(Any)& r_any, const foo(unboundedlongseq)& r_foo_unboundedlongseq);
  void operator<<=(CORBA(Any)& r_any, foo(unboundedlongseq)* p_foo_unboundedlongseq);
  CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(unboundedlongseq)*& rp_foo_unboundedlongseq);



  // define the typecode class for foo_boundedbarseq
  ILUCPP_DEFINE_STUB_TYPE_CODE_CLASS(foo_boundedbarseq, ilu_sequence_tk, "ilu:a-A0iHnQNNRmhhmp3wkeUYwSA84");

  // declare the Any insertion and extraction operators for foo(boundedbarseq)
  void operator<<=(CORBA(Any)& r_any, const foo(boundedbarseq)& r_foo_boundedbarseq);
  void operator<<=(CORBA(Any)& r_any, foo(boundedbarseq)* p_foo_boundedbarseq);
  CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(boundedbarseq)*& rp_foo_boundedbarseq);



  // define the typecode class for foo_variableuniontype
  ILUCPP_DEFINE_STUB_TYPE_CODE_CLASS(foo_variableuniontype, ilu_union_tk, "ilu:jYcmgu8Gvx9g1A-c6Q82yVwdEyS");

  // declare the Any insertion and extraction operators for foo(variableuniontype)
  void operator<<=(CORBA(Any)& r_any, const foo(variableuniontype)& r_foo_variableuniontype);
  void operator<<=(CORBA(Any)& r_any, foo(variableuniontype)* p_foo_variableuniontype);
  CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(variableuniontype)*& rp_foo_variableuniontype);


  // define the typecode class for foo_optionalbarobject
  ILUCPP_DEFINE_STUB_TYPE_CODE_CLASS(foo_optionalbarobject, ilu_optional_tk, "ilu:ayhvbuUI6IYTo8anOBtzxYTFKsU");

  // declare the Any insertion and extraction operators for foo(optionalbarobject_forany)
  void operator<<=(CORBA(Any)& r_any, const foo(optionalbarobject_forany)& r_foo_optionalbarobject_forany);
  void operator<<=(CORBA(Any)& r_any, foo(optionalbarobject_forany)* p_foo_optionalbarobject_forany);
  CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(optionalbarobject_forany)*& rp_foo_optionalbarobject_forany);
 

  
  // define the typecode class for foo_optionalinteger
  ILUCPP_DEFINE_STUB_TYPE_CODE_CLASS(foo_optionalinteger, ilu_optional_tk, "ilu:f6I-vh57myFWF48brBQvjvvaJI5");

  // declare the Any insertion and extraction operators for foo(optionalinteger_forany)
  void operator<<=(CORBA(Any)& r_any, const foo(optionalinteger_forany)& r_foo_optionalinteger_forany);
  void operator<<=(CORBA(Any)& r_any, foo(optionalinteger_forany)* p_foo_optionalinteger_forany);
  CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(optionalinteger_forany)*& rp_foo_optionalinteger_forany);


  // define the typecode class for foo_bar
  ILUCPP_DEFINE_STUB_TYPE_CODE_OBJECT_CLASS(foo_bar, ilu_object_tk, "ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ");

  // declare the Any insertion and extraction operators for foo(bar)
  void operator<<=(CORBA(Any)& r_any, foo(bar)* p_foo_bar);
  CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(bar)*& rp_foo_bar);


#endif // ADD_VARIANT_SUPPORT

  
#endif
