/* This file was hand written
 *
 * ILU is Copyright 1991-1996 Xerox Corporation, All Rights Reserved.
 * ILU information:  ftp://ftp.parc.xerox.com/pub/ilu/ilu.html.
 */

#include "foo-cpp.hpp"

  //////////////////////////////////////////////////////////////////////
  // globals & static members

  // exceptions vector
  static iluException interface_exceptions[] = {
    (iluException) 0,	//foo_(zapexception)exception
  };

  // list of initialization functions to call for the foo interface
  iluInitializationFunctionNode* foo(p_initialization_function_list);
  int foo(g_i_initialized);
  // holds the ilu class record for foo(bar) objects
  iluClass foo(bar)::m_ILUClassRecord;

  //////////////////////////////////////////////////////////////////////
  // foo initialization

  void foo(iluInitialize) () {
	  	  
	  if ( foo_(g_i_initialized) == 0) {  // haven't initialized before
		  
		  // grab global mutex for object type data structures
		  iluMutexer mutex_on_object_type(iluCppInternal::sm_object_type_mutex);
		  
		  // define the exceptions in the foo interface
		  interface_exceptions[g_foo_zapexception_index] = iluCppInternal::iluDefineException("foo", "foo_(zapexception)exception", 
			  "ilu:nf0EIEuSgtCJuWWvPNt9Fz51i8x");
		  
		  // performs object type initialization
		  foo_(bar)::iluInitialize();

		  
#ifdef IIOP_PROTOCOL
		  {
		  ILUCPP_BOOL b_new_registration;
		  iluType  a_type;

		  iluCppInternal::iluRegisterOptionalType("optionalinteger", "foo", NULL, "ilu:f6I-vh57myFWF48brBQvjvvaJI5",
			  "ilu:nf0EIEuSgtCJuWWvPNt9Fz51i8x", // base type 
			  &b_new_registration);

		  iluCppInternal::iluRegisterOptionalType("optionalbarobject", "foo", NULL, "ilu:ayhvbuUI6IYTo8anOBtzxYTFKsU",
			  "ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ", // base type 
			  &b_new_registration);

		  a_type = iluCppInternal::iluRegisterUnionType("variableuniontype", "foo", NULL, "ilu:jYcmgu8Gvx9g1A-c6Q82yVwdEyS",
			  "ilu:mJe++WAwhe7qgsVhq+Ci6auxZZk",	// UID of discriminant type 
			  2,	// number of arms 
			  2,	// default arm (0 for none) 
			  ILUCPP_FALSE,	// invalid discriminant values allowed? (idiot CORBA) 
			  &b_new_registration);

		  if (b_new_registration) {
			  iluConstantValue_s constant_value;
			  iluUnionArm union_arm;
			  
			  union_arm = iluCppInternal::iluRegisterUnionArm (a_type, 0, // which arm 
				  "bararm", // name of arm 
				  "ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ", // arm type 
				  2 // number of values that can select this arm 
				  );

			  constant_value.value.shortcardinal_val = 0;
			  constant_value.kind = ilu_shortcardinal_cvk;
			  iluCppInternal::iluRegisterUnionArmValue (union_arm, 0, // which arm value 
				  &constant_value // actual value 
				  );

			  constant_value.value.shortcardinal_val = 1;
			  constant_value.kind = ilu_shortcardinal_cvk;
			  iluCppInternal::iluRegisterUnionArmValue (union_arm, 1, // which arm value 
				  &constant_value // actual value 
				  );

			  union_arm = iluCppInternal::iluRegisterUnionArm (a_type, 1, // which arm 
				  "integerarm", // name of arm 
				  "ilu:nf0EIEuSgtCJuWWvPNt9Fz51i8x", // arm type 
				  0 // number of values that can select this arm 
				  );

		  }

		  iluCppInternal::iluRegisterSequenceType("boundedbarseq", "foo", NULL, "ilu:a-A0iHnQNNRmhhmp3wkeUYwSA84",
			  "ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ",	// base type of sequence 
			  3,		// limit (0 for no limit) 
			  &b_new_registration);

		  iluCppInternal::iluRegisterSequenceType("unboundedlongseq", "foo", NULL, "ilu:gb+4Sy4d-wQwxncKVc0kDH2CHNY",
			  "ilu:nf0EIEuSgtCJuWWvPNt9Fz51i8x",	// base type of sequence 
			  0,		// limit (0 for no limit) 
			  &b_new_registration);

		  { // array type "foo_bararray" 

			  iluCardinal _foo_bararray_dims[] = { 2, 3 };

			  iluCppInternal::iluRegisterArrayType("bararray", "foo", NULL, "ilu:dwYXDC7Gf2XOuhGijTt-FPv+OWo",
				  "ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ", // base type of array 
				  2,		// number of dimensions 
				  _foo_bararray_dims,	// actual dimensions 
				  &b_new_registration);
		  }

		  { // array type "foo_integerarray" 
			  iluCardinal _foo_integerarray_dims[] = { 5, 10 };

			  iluCppInternal::iluRegisterArrayType("integerarray", "foo", NULL, "ilu:f3qA-xRiSkCvrf6KovBV+KsjMh0",
				  "ilu:nf0EIEuSgtCJuWWvPNt9Fz51i8x", // base type of array 
				  2,		// number of dimensions 
				  _foo_integerarray_dims,	// actual dimensions 
				  &b_new_registration);
		  }

		  a_type = iluCppInternal::iluRegisterRecordType("variablerecordtype", "foo", NULL, "ilu:p1p-Xd0SkjKs8cNPeMkSi8G+s-j",
			  3,	// number of fields in the record 
			  &b_new_registration);

		  if (b_new_registration) {

			  iluCppInternal::iluRegisterRecordField(a_type, 0, // which field 
				  "variablerecordstring", // field name 
				  "ilu:kakRtQhq-+fkRr0MUKKXsAhAwNo" // UID of field type 
				  );

			  iluCppInternal::iluRegisterRecordField(a_type, 1, // which field 
				  "variablerecordinteger", // field name 
				  "ilu:nf0EIEuSgtCJuWWvPNt9Fz51i8x" // UID of field type 
				  );

			  iluCppInternal::iluRegisterRecordField(a_type, 2, // which field 
				  "variablerecordobject", // field name 
				  "ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ" // UID of field type 
				  );

		  }

		  iluCppInternal::iluRegisterObjectType("bar", "foo", NULL, "ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ",
			  foo(bar)::iluGetILUClassRecord(), // object class 
			  &b_new_registration);

		  a_type = iluCppInternal::iluRegisterRecordType("fixedrecordtype", "foo", NULL, "ilu:fJRvTuuUCyZ+GZX2mytNYfCmECq",
			  2,	// number of fields in the record 
			  &b_new_registration);

		  if (b_new_registration) {

			  iluCppInternal::iluRegisterRecordField(a_type, 0, // which field 
				  "fixedrecordinteger", // field name 
				  "ilu:nf0EIEuSgtCJuWWvPNt9Fz51i8x" // UID of field type 
				  );

			  iluCppInternal::iluRegisterRecordField(a_type, 1, // which field 
				  "fixedrecordenum", // field name 
				  "ilu:mlI8KGJsFBG2ywCR8x0Wql+mOYX" // UID of field type 
				  );
		  }

		  iluCppInternal::iluRegisterSequenceType("UnicodeString", "foo", NULL, "ilu:pMGHN1T0dtNq6bo6+8Kn7sKAS97",
			  "ilu:od5xIjO9jSGB5fani+vgOBD9ip3",	// base type of sequence 
			  0,		// limit (0 for no limit) 
			  &b_new_registration);

		  a_type = iluCppInternal::iluRegisterEnumerationType("enumtype", "foo", NULL, "ilu:mlI8KGJsFBG2ywCR8x0Wql+mOYX",
			  7,	// number of elements in the enum 
			  &b_new_registration);

		  if (b_new_registration) {

			  iluCppInternal::iluRegisterEnumerationElement(a_type, 0, // which element 
				  "red", // element name 
				  0	// integer value for element 
				  );

			  iluCppInternal::iluRegisterEnumerationElement(a_type, 1, // which element 
				  "orange", // element name 
				  1	// integer value for element 
				  );

			  iluCppInternal::iluRegisterEnumerationElement(a_type, 2, // which element 
				  "yellow", // element name 
				  2	// integer value for element 
				  );

			  iluCppInternal::iluRegisterEnumerationElement(a_type, 3, // which element 
				  "green", // element name 
				  3	// integer value for element 
				  );

			  iluCppInternal::iluRegisterEnumerationElement(a_type, 4, // which element 
				  "blue", // element name 
				  4	// integer value for element 
				  );

			  iluCppInternal::iluRegisterEnumerationElement(a_type, 5, // which element 
				  "indigo", // element name 
				  5	// integer value for element 
				  );

			  iluCppInternal::iluRegisterEnumerationElement(a_type, 6, // which element 
				  "violet", // element name 
				  6	// integer value for element 
				  );
		  }
	}
#endif // IIOP_PROTOCOL 

	foo_(g_i_initialized) = 1;

	}

	// call all the surrogate and true initialization functions
	iluCppInternal::iluCallInitializationFunctions(&foo_(p_initialization_function_list));

	}


  //////////////////////////////////////////////////////////////////////
  //  foo(bar_var) sizing, input and output operators

  // note following three operators are only needed if a foo(bar) is a member of a structured type

  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(bar_var)& r_foo_bar_var)  {
	  r_call += r_foo_bar_var.iluGetObjectPointer();
	  return r_call;
  }

  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(bar_var)& r_foo_bar_var)  {

	  if (r_foo_bar_var.iluGetWrapper() != NULL) { // must be a true side inout
		  r_foo_bar_var.iluDeleteWrapper();
	  }

	  // make a new wrapper for the object
	  r_foo_bar_var.iluSetWrapper(new iluObjectWrapper(r_foo_bar_var.iluGetObjectPointer(), ILUCPP_FALSE, 
		  (r_foo_bar_var.iluGetObjectPointer() ? NULL : foo(bar)::iluGetILUClassRecord())));

	  // output the object from the wrapper
	  iluObjectWrapper* p_wrapper = r_foo_bar_var.iluGetWrapper();
	  r_call << *p_wrapper;
	  
	  // ensure _var is in control
	  p_wrapper->m_b_do_refcount_decrement = ILUCPP_FALSE;
	  
	  return r_call;
  }

  iluBaseCall& operator>>(iluBaseCall& r_call, foo(bar_var)& r_foo_bar_var)  {
	  
	  foo(bar_var) temp_bar_var;
	  
	  if (r_foo_bar_var.iluGetWrapper() != NULL) { // must be a surrogate side inout
		  r_foo_bar_var.iluDeleteWrapper();

		  // we assign a temporaty var to what the argument var is to handle the
		  // case where the client put a 'true' object with a single refcount
		  // into the inout var, and the server did not modify it.  If we didn't
		  // do this temporary assignment, then we would end up destructing the 
		  // object, and then try reading in a reference to the object that was
		  // was just destroyed.  Note that the destuctor for temp_bar_var will
		  // be invoked when we leave the scope of this function, releasing the
		  // extra count we had to keep the object in existence for this brief period.
		  temp_bar_var = r_foo_bar_var;

		  r_foo_bar_var = NULL; // force a release since the var's in control of the refcount
	  }
	  
	  // make up a new wrapper
	  r_foo_bar_var.iluSetWrapper(new iluObjectWrapper(ILUCPP_FALSE, foo(bar)::iluGetILUClassRecord()));
	  
	  // read the object into a wrapper
	  iluObjectWrapper* p_wrapper = r_foo_bar_var.iluGetWrapper();
	  r_call >> *p_wrapper;
	  
	  // give the _var control of it
	  r_foo_bar_var = (foo(bar_ptr))(p_wrapper->m_pv_iluobject);
	  p_wrapper->m_b_do_refcount_decrement = ILUCPP_FALSE;
	  
	  return r_call;
  }


  //////////////////////////////////////////////////////////////////////
  //  foo(enumtype) variant support

#ifdef ADD_VARIANT_SUPPORT


  // define the four member functions in typecode class for foo_enumtype
  ILUCPP_DEFINE_ILU_TYPE_CODE_ENUM_MEMBERFUNCTIONS(foo_enumtype, foo(enumtype))

  // typecode instance for foo_enumtype
  const CORBA(TypeCode_ptr) foo(tc_enumtype) = new ILUCPP_TYPE_CODE_CLASS_NAME(foo_enumtype);
  
  // define the Any insertion and extraction operators for foo(enumtype)
  ILUCPP_DEFINE_COPYING_INSERTION_OPERATOR(foo(enumtype), foo(tc_enumtype))
  ILUCPP_DEFINE_REF_EXTRACTION_OPERATOR(foo(enumtype), foo(tc_enumtype))
  
  
#endif // ADD_VARIANT_SUPPORT

  
  //////////////////////////////////////////////////////////////////////
  //  foo(fixedrecordtype) members
  
  /* Can leave out - and would then allow aggregate inits 
  // default constructor
  foo(fixedrecordtype)::foo_(fixedrecordtype)() { 
  }
  
  // copy constructor
  foo(fixedrecordtype)::foo_(fixedrecordtype)(const foo(fixedrecordtype)& r_a_fixedrecordtype) {
	  fixedrecordinteger = r_a_fixedrecordtype.fixedrecordinteger;
	  fixedrecordenum = r_a_fixedrecordtype.fixedrecordenum;
  }
  
  // destructor
  foo(fixedrecordtype)::~foo_(fixedrecordtype)() { 
  }
  
  // assignment operator
  foo(fixedrecordtype)& foo(fixedrecordtype)::operator= (const foo(fixedrecordtype)& r_a_fixedrecordtype) {
	  if (this != &r_a_fixedrecordtype) {
		  fixedrecordinteger = r_a_fixedrecordtype.fixedrecordinteger;
		  fixedrecordenum = r_a_fixedrecordtype.fixedrecordenum;
	  }
	  return *this;
  }
*/
    // insertion, extraction, and sizing operators for foo(fixedrecordtype)
  
  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(fixedrecordtype)& r_foo_fixedrecordtype)  {
	  
	  iluEnumWrapper _fixedrecordenum((iluDummyEnum &)r_foo_fixedrecordtype.fixedrecordenum);
	  
	  r_call += iluSizeRecord;
	  r_call += r_foo_fixedrecordtype.fixedrecordinteger;
	  r_call += _fixedrecordenum;
	  r_call << iluEndRecord;
	  return r_call;
  }
  
  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(fixedrecordtype)& r_foo_fixedrecordtype)  {
	  
	  iluEnumWrapper _fixedrecordenum((iluDummyEnum &)r_foo_fixedrecordtype.fixedrecordenum);
	  
	  r_call << iluOutputRecord;
	  r_call << r_foo_fixedrecordtype.fixedrecordinteger;
	  r_call << _fixedrecordenum;
	  r_call << iluEndRecord;
	  return r_call;
  }
  
  iluBaseCall& operator>>(iluBaseCall& r_call, foo(fixedrecordtype)& r_foo_fixedrecordtype)  {
	  
	  iluEnumWrapper _fixedrecordenum((iluDummyEnum &)r_foo_fixedrecordtype.fixedrecordenum);
	  
	  r_call >> iluInputRecord;
	  r_call >> r_foo_fixedrecordtype.fixedrecordinteger;
	  r_call >> _fixedrecordenum;
	  r_call >> iluEndRecord;
	  return r_call;
  }
  
#ifdef ADD_VARIANT_SUPPORT
  
  // define the four member functions in typecode class for foo_fixedrecordtype
  ILUCPP_DEFINE_ILU_TYPE_CODE_MEMBERFUNCTIONS(foo_fixedrecordtype, foo(fixedrecordtype))

  // typecode instance for foo_fixedrecord
  const CORBA(TypeCode_ptr) foo(tc_fixedrecordtype) = new ILUCPP_TYPE_CODE_CLASS_NAME(foo_fixedrecordtype);
  
  // define the Any insertion and extraction operators for foo(fixedrecordtype)
  ILUCPP_DEFINE_COPYING_INSERTION_OPERATOR(foo(fixedrecordtype), foo(tc_fixedrecordtype))
  ILUCPP_DEFINE_NONCOPYING_INSERTION_OPERATOR(foo(fixedrecordtype), foo(tc_fixedrecordtype))
  ILUCPP_DEFINE_EXTRACTION_OPERATOR(foo(fixedrecordtype), foo(tc_fixedrecordtype))
  
  
#endif // ADD_VARIANT_SUPPORT

  
  //////////////////////////////////////////////////////////////////////
  //  foo(variablerecordtype) members
  

  // default constructor
  foo(variablerecordtype)::foo_(variablerecordtype)() { 
  }
  
  // copy constructor
  foo(variablerecordtype)::foo_(variablerecordtype)(const foo(variablerecordtype)& r_a_variablerecordtype) { 
	  variablerecordstring = r_a_variablerecordtype.variablerecordstring;
	  variablerecordinteger = r_a_variablerecordtype.variablerecordinteger;
	  variablerecordobject = r_a_variablerecordtype.variablerecordobject;
  }
  
  // destructor
  foo(variablerecordtype)::~foo_(variablerecordtype)() {
  }
  
  // assignment operator
  foo(variablerecordtype)& foo(variablerecordtype)::operator= (const foo(variablerecordtype)& r_a_variablerecordtype) { 
	  if (this != &r_a_variablerecordtype) {
		  variablerecordstring = r_a_variablerecordtype.variablerecordstring;
		  variablerecordinteger = r_a_variablerecordtype.variablerecordinteger;
		  variablerecordobject = r_a_variablerecordtype.variablerecordobject;
	  }
	  return *this;
  }
  
  // for ilustub use only - should be called before the surrogate side stub returns
  void foo(variablerecordtype)::iluSurrogateSideCleanup() const {
	variablerecordobject.iluDeleteWrapper();
  }

  // insertion, extraction, and sizing operators for foo(variablerecordtype)
  
  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(variablerecordtype)& r_foo_variablerecordtype)  {
	  
	  iluCardinal r_foo_variablerecordtype_variablerecordstring_length = strlen(r_foo_variablerecordtype.variablerecordstring);
	  iluCStringWrapper _r_foo_variablerecordtype_variablerecordstring((r_foo_variablerecordtype.variablerecordstring).iluStringVarReference(), 
		  r_foo_variablerecordtype_variablerecordstring_length);
	  
	  r_call += iluSizeRecord;
	  r_call += _r_foo_variablerecordtype_variablerecordstring;
	  r_call += r_foo_variablerecordtype.variablerecordinteger;
	  r_call += r_foo_variablerecordtype.variablerecordobject;
	  r_call << iluEndRecord;
	  return r_call;
  }
  
  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(variablerecordtype)& r_foo_variablerecordtype)  {
	  
	  iluCardinal r_foo_variablerecordtype_variablerecordstring_length = strlen(r_foo_variablerecordtype.variablerecordstring);
	  iluCStringWrapper _r_foo_variablerecordtype_variablerecordstring((r_foo_variablerecordtype.variablerecordstring).iluStringVarReference(), 
		  r_foo_variablerecordtype_variablerecordstring_length);
	  
	  r_call << iluOutputRecord;
	  r_call << _r_foo_variablerecordtype_variablerecordstring;
	  r_call << r_foo_variablerecordtype.variablerecordinteger;
	  r_call << r_foo_variablerecordtype.variablerecordobject;
	  r_call << iluEndRecord;
	  return r_call;
  }
  
  iluBaseCall& operator>>(iluBaseCall& r_call, foo(variablerecordtype)& r_foo_variablerecordtype)  {
	  
	  iluCardinal r_foo_variablerecordtype_variablerecordstring_length;
	  iluCStringWrapper _r_foo_variablerecordtype_variablerecordstring((r_foo_variablerecordtype.variablerecordstring).iluStringVarReference(), 
		  r_foo_variablerecordtype_variablerecordstring_length);
	  
	  r_call >> iluInputRecord;
	  r_call >> _r_foo_variablerecordtype_variablerecordstring;
	  r_call >> r_foo_variablerecordtype.variablerecordinteger;
	  r_call >> r_foo_variablerecordtype.variablerecordobject;
	  r_call >> iluEndRecord;
	  return r_call;
  }
  
#ifdef ADD_VARIANT_SUPPORT
  
  // define the four member functions in typecode class for foo_variablerecordtype
  ILUCPP_DEFINE_ILU_TYPE_CODE_MEMBERFUNCTIONS(foo_variablerecordtype, foo(variablerecordtype))

  // typecode instance for foo_variablerecord
  const CORBA(TypeCode_ptr) foo(tc_variablerecordtype) = new ILUCPP_TYPE_CODE_CLASS_NAME(foo_variablerecordtype);
  
  // define the Any insertion and extraction operators for foo(variablerecordtype)
  ILUCPP_DEFINE_COPYING_INSERTION_OPERATOR(foo(variablerecordtype), foo(tc_variablerecordtype))
  ILUCPP_DEFINE_NONCOPYING_INSERTION_OPERATOR(foo(variablerecordtype), foo(tc_variablerecordtype))
  ILUCPP_DEFINE_EXTRACTION_OPERATOR(foo(variablerecordtype), foo(tc_variablerecordtype))
  
  
#endif // ADD_VARIANT_SUPPORT

  //////////////////////////////////////////////////////////////////////
  // foo(integerarray_var) array member functions and allocation utility functions

  foo(integerarray_slice)* foo(integerarray_alloc) (){

/* xxx temp debugging only 
	foo(integerarray_slice)* p_slice = (foo(integerarray_slice)*)(new CORBA(Long)[5][10]);
	CORBA(Long)* p_element = (CORBA(Long)*) p_slice;	
	for (CORBA(Long) count = 0; count < 5 * 10; count++)
			  *p_element++ = ~count;
	  return (p_slice);
end xxx temp debugging only */

	  return ((foo(integerarray_slice)*) (new CORBA(Long)[5][10]));
   }


  // duplicate a foo_(integerarray)
  foo(integerarray_slice)* foo(integerarray_dup) (const foo(integerarray_slice)* p_foo_integerarray_slice) {
	  if (!p_foo_integerarray_slice)
		  return NULL;
	  else {
		  foo(integerarray_slice)* p_slice = foo(integerarray_alloc)();
		  CORBA(Long)* p_this_element = (CORBA(Long)*) p_slice;
		  CORBA(Long)* p_that_element = (CORBA(Long)*) p_foo_integerarray_slice;
		  for (CORBA(Long) count = 0; count < 5 * 10; count++)
			  *p_this_element++ = *p_that_element++;
		  return p_slice;
	  }
  }
  

  void foo(integerarray_free)(foo(integerarray_slice)* p_foo_integerarray_slice) {
	  delete [] p_foo_integerarray_slice;
  }
  
  // insertion, extraction, and sizing functions for foo(integerarray)

  iluBaseCall& foo(size_const_integerarray)(iluBaseCall& r_call, const CORBA(Long)a_foo_integerarray[][10]) {
	  
	  r_call.iluSizeArray(5 * 10);
	  
	  for (iluCardinal index0 = 0; index0 < 5; index0++) {
		  for (iluCardinal index1 = 0; index1 < 10; index1++) {
			  r_call += a_foo_integerarray[index0][index1];
		  }
	  }
	  
	  r_call << iluEndArray;
	  return r_call;
  }
  
  iluBaseCall& foo(size_integerarray)(iluBaseCall& r_call, CORBA(Long)a_foo_integerarray[][10]) {
	  
	  r_call.iluSizeArray(5 * 10);
	  
	  for (iluCardinal index0 = 0; index0 < 5; index0++) {
		  for (iluCardinal index1 = 0; index1 < 10; index1++) {
			  r_call += a_foo_integerarray[index0][index1];
		  }
	  }
	  
	  r_call << iluEndArray;
	  return r_call;
  }
  
  iluBaseCall& foo(output_const_integerarray)(iluBaseCall& r_call, const CORBA(Long)a_foo_integerarray[][10]) {
	  
	  r_call.iluOutputArray(5 * 10);
	  
	  for (iluCardinal index0 = 0; index0 < 5; index0++) {
		  for (iluCardinal index1 = 0; index1 < 10; index1++) {
			  r_call << a_foo_integerarray[index0][index1];
		  }
	  }
	  
	  r_call << iluEndArray;
	  return r_call;
  }
  
  iluBaseCall& foo(output_integerarray)(iluBaseCall& r_call, CORBA(Long)a_foo_integerarray[][10]) {
	  
	  r_call.iluOutputArray(5 * 10);
	  
	  for (iluCardinal index0 = 0; index0 < 5; index0++) {
		  for (iluCardinal index1 = 0; index1 < 10; index1++) {
			  r_call << a_foo_integerarray[index0][index1];
		  }
	  }
	  
	  r_call << iluEndArray;
	  return r_call;
  }
  
  
  iluBaseCall& foo(input_integerarray)(iluBaseCall& r_call, CORBA(Long)a_foo_integerarray[][10]) {
      
	  r_call >> iluInputArray;
	  
	  for (iluCardinal index0 = 0; index0 < 5; index0++) {
		  for (iluCardinal index1 = 0; index1 < 10; index1++) {
			  r_call >> a_foo_integerarray[index0][index1];
		  }
	  }
	  
	  r_call << iluEndArray;
	  return r_call;
  }
  
#ifdef ADD_VARIANT_SUPPORT
  
  // define the four member functions in typecode class for foo_integerarray
  ILUCPP_DEFINE_ILU_TYPE_CODE_ARRAY_MEMBERFUNCTIONS(foo_integerarray, foo(integerarray_slice), foo(integerarray_alloc), foo(integerarray_dup), foo(size_integerarray), foo(output_integerarray), foo(input_integerarray))

  // typecode instance for foo_integerarray
  const CORBA(TypeCode_ptr) foo(tc_integerarray) = new ILUCPP_TYPE_CODE_CLASS_NAME(foo_integerarray);
  
  // define the Any insertion and extraction operators for foo_(integerarray_forany)
  ILUCPP_DEFINE_ARRAY_INSERTION_OPERATOR(foo(integerarray_forany), foo(tc_integerarray), foo(integerarray_dup))
  ILUCPP_DEFINE_ARRAY_EXTRACTION_OPERATOR(foo(integerarray_forany), foo(tc_integerarray), foo(integerarray_slice))
  
  
#endif // ADD_VARIANT_SUPPORT

  //////////////////////////////////////////////////////////////////////
  // foo(bararray_var) array member functions and allocation utility functions

  foo(bararray_slice)* foo(bararray_alloc) () {
	  return (foo(bararray_slice)*) new foo(bar_var)[2][3];
  }


  // duplicate a foo_(bararray)
  foo(bararray_slice)* foo(bararray_dup) (const foo(bararray_slice)* p_foo_bararray_slice) {
	  if (!p_foo_bararray_slice)
		  return NULL;
	  else {
		  foo(bararray_slice)* p_slice = foo(bararray_alloc) ();
		  foo(bar_var)* p_this_element = (foo(bar_var)*) p_slice;
		  foo(bar_var)* p_that_element = (foo(bar_var)*) p_foo_bararray_slice;
		  for (CORBA(Long) count = 0; count < 2 * 3; count++)
			  *p_this_element++ = *p_that_element++;
		  return p_slice;
	  }
  }
  

  void foo(bararray_free)(foo(bararray_slice)* p_foo_bararray_slice) {
	  delete [] p_foo_bararray_slice;
  }


  // surrogate side cleanup foo_(bararray)
  void foo(bararray_iluSurrogateSideCleanup) (foo(bararray_slice)* p_foo_bararray_slice) {
	  if (p_foo_bararray_slice) {
		  foo(bar_var)* p_element = (foo(bar_var)*) p_foo_bararray_slice;
		  for (CORBA(Long) count = 0; count < 2 * 3; count++){			  
			  p_element->iluDeleteWrapper();
			  p_element++;
		  }
	  }
  }
  
  void foo(const_bararray_iluSurrogateSideCleanup) (const foo(bararray_slice)* p_foo_bararray_slice) {
	  if (p_foo_bararray_slice) {
		  foo(bar_var)* p_element = (foo(bar_var)*) p_foo_bararray_slice;
		  for (CORBA(Long) count = 0; count < 2 * 3; count++){		  
			  p_element->iluDeleteWrapper();
			  p_element++;
		  }
	  }
  }
  
  
  // insertion, extraction, and sizing functions for foo(bararray)
  
  iluBaseCall& foo(size_const_bararray)(iluBaseCall& r_call, const foo(bar_var) a_foo_bararray[][3]) {
	  
	  r_call.iluSizeArray(2 * 3);
	  
	  for (iluCardinal index0 = 0; index0 < 2; index0++) {
		  for (iluCardinal index1 = 0; index1 < 3; index1++) {
			  
			  r_call += a_foo_bararray[index0][index1];
		  }
	  }
	  
	  r_call << iluEndArray;
	  return r_call;
  }

  iluBaseCall& foo(size_bararray)(iluBaseCall& r_call, foo(bar_var) a_foo_bararray[][3]) {
	  
	  r_call.iluSizeArray(2 * 3);
	  
	  for (iluCardinal index0 = 0; index0 < 2; index0++) {
		  for (iluCardinal index1 = 0; index1 < 3; index1++) {
			  
			  r_call += a_foo_bararray[index0][index1];
		  }
	  }
	  
	  r_call << iluEndArray;
	  return r_call;
  }
  
  
  iluBaseCall& foo(output_const_bararray)(iluBaseCall& r_call, const foo(bar_var) a_foo_bararray[][3]) {
	  
	  r_call.iluOutputArray(2 * 3);
	  
	  for (iluCardinal index0 = 0; index0 < 2; index0++) {
		  for (iluCardinal index1 = 0; index1 < 3; index1++) {
			  
			  r_call << a_foo_bararray[index0][index1];
		  }
	  }
	  
	  r_call << iluEndArray;
	  return r_call;
  }
  
  iluBaseCall& foo(output_bararray)(iluBaseCall& r_call, foo(bar_var) a_foo_bararray[][3]) {
	  
	  r_call.iluOutputArray(2 * 3);
	  
	  for (iluCardinal index0 = 0; index0 < 2; index0++) {
		  for (iluCardinal index1 = 0; index1 < 3; index1++) {
			  
			  r_call << a_foo_bararray[index0][index1];
		  }
	  }
	  
	  r_call << iluEndArray;
	  return r_call;
  }

  iluBaseCall& foo(input_bararray)(iluBaseCall& r_call, foo(bar_var) a_foo_bararray[][3]) {
      
	  r_call >> iluInputArray;
	  
	  for (iluCardinal index0 = 0; index0 < 2; index0++) {
		  for (iluCardinal index1 = 0; index1 < 3; index1++) {
			  
			  r_call >> a_foo_bararray[index0][index1];
		  }
	  }
	  
	  r_call << iluEndArray;
	  return r_call;
  }


#ifdef ADD_VARIANT_SUPPORT
  
  // define the four member functions in typecode class for foo_bararray
  ILUCPP_DEFINE_ILU_TYPE_CODE_ARRAY_MEMBERFUNCTIONS(foo_bararray, foo(bararray_slice), foo(bararray_alloc), foo(bararray_dup), foo(size_bararray), foo(output_bararray), foo(input_bararray))

  // typecode instance for foo_bararray
  const CORBA(TypeCode_ptr) foo(tc_bararray) = new ILUCPP_TYPE_CODE_CLASS_NAME(foo_bararray);
  
  // define the Any insertion and extraction operators for foo_(bararray_forany)
  ILUCPP_DEFINE_ARRAY_INSERTION_OPERATOR(foo(bararray_forany), foo(tc_bararray), foo(bararray_dup))
  ILUCPP_DEFINE_ARRAY_EXTRACTION_OPERATOR(foo(bararray_forany), foo(tc_bararray), foo(bararray_slice))
  
  
#endif // ADD_VARIANT_SUPPORT


  //////////////////////////////////////////////////////////////////////
  // foo(unboundedlongseq) members
  
  // constructors & desructor
  foo(unboundedlongseq)::foo_(unboundedlongseq) () : m_maximum(0),
	  m_length(0),
	  m_buffer(NULL),
	  m_release (ILUCPP_TRUE) {}
  
  foo(unboundedlongseq)::foo_(unboundedlongseq) (CORBA(ULong) max) : m_maximum(max),
	  m_length(0),
	  m_buffer(allocbuf (max)),
	  m_release (ILUCPP_TRUE) {}
  
  foo(unboundedlongseq)::foo_(unboundedlongseq) (CORBA(ULong) max, CORBA(ULong) length, 
	  CORBA(Long)* data, CORBA(Boolean) release)  : m_maximum(max),
	  m_length(length),
	  m_buffer(data),
	  m_release (release) {}
  
  foo(unboundedlongseq)::foo_(unboundedlongseq) (const foo(unboundedlongseq)& r_foo_unboundedlongseq) :
		m_maximum(r_foo_unboundedlongseq.m_maximum), 
			m_length(r_foo_unboundedlongseq.m_length), 
			m_release(ILUCPP_TRUE)
		{
			m_buffer = allocbuf (m_maximum);
			for (CORBA(ULong) index = 0; index < m_length; index++) {
				m_buffer[index] = r_foo_unboundedlongseq.m_buffer[index];
			}
		}  
		
	foo(unboundedlongseq)::~foo_(unboundedlongseq)() {
		if (m_buffer && m_release)
			freebuf (m_buffer);
	}
		
	// assignment
	foo(unboundedlongseq)& foo(unboundedlongseq)::operator= (const foo(unboundedlongseq)& r_foo_unboundedlongseq) {

		if (this == &r_foo_unboundedlongseq) 
			return *this;

		if (m_buffer && m_release)
			freebuf (m_buffer);
		
        m_maximum = r_foo_unboundedlongseq.m_maximum;
        m_buffer = allocbuf (m_maximum);
        m_release = ILUCPP_TRUE;
		m_length = r_foo_unboundedlongseq.m_length;
		for (CORBA(ULong) index = 0; index < m_length; index++) {
			m_buffer[index] = r_foo_unboundedlongseq.m_buffer[index];
		}
		return *this;
	}
	
  
  // accessors
  CORBA(ULong) foo(unboundedlongseq)::maximum() const {
	return m_maximum;
  }
  
  CORBA(ULong) foo(unboundedlongseq)::length() const {
	 return m_length;
  }
  
  void foo(unboundedlongseq)::length (CORBA(ULong) len) {
	  if (len <= m_maximum)
		  m_length = len;
      else {
		  CORBA(Long)* p_oldbuf = m_buffer;
		  CORBA(ULong) oldlen = m_length;
		  CORBA(Boolean) b_oldrelease = m_release;
		  m_release = ILUCPP_TRUE;
		  m_length = len;
		  m_maximum = len;
		  m_buffer = allocbuf(m_length);
		  for (CORBA(ULong) index = 0; index < oldlen; index++) {
			  m_buffer[index] = p_oldbuf[index];
		  }
		  if (b_oldrelease)
			  freebuf(p_oldbuf);
	  } 
  }
  
  
  // [] operators
  CORBA(Long)& foo(unboundedlongseq)::operator [] (CORBA(ULong) index) {
	  if (index >= m_length) {
		  // really undefined by CORBA as to what to do, but better safe than sorry!
		  CORBA(UNKNOWN) an_exception(0, CORBA(COMPLETED_NO));
		  throw (an_exception);
	  }
      return m_buffer [index];
  }
  
  const CORBA(Long)& foo(unboundedlongseq)::operator [] (CORBA(ULong) index) const {
	  if (index >= m_length) {
		  // really undefined by CORBA as to what to do, but better safe than sorry!
		  CORBA(UNKNOWN) an_exception(0, CORBA(COMPLETED_NO));
		  throw (an_exception);
	  }
      return m_buffer [index];
  }
  
  
  // memory management
  CORBA(Long)* foo(unboundedlongseq)::allocbuf(CORBA(ULong) num_elements) {
      return (num_elements > 0 ? (new CORBA(Long)[num_elements]) : NULL);
  }
  
  void foo(unboundedlongseq)::freebuf(CORBA(Long)* p_buf) {
	  delete [] p_buf;
  }
  
  // insertion, extraction, and sizing operators for foo(unboundedlongseq)
  
  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(unboundedlongseq)& r_foo_unboundedlongseq){
	  iluCardinal card_length = r_foo_unboundedlongseq.length();
	  iluSequenceWrapper _r_foo_unboundedlongseq(card_length);
	  r_call += _r_foo_unboundedlongseq;
	  for (CORBA(ULong) index = 0; index < r_foo_unboundedlongseq.length(); index++) {
		  r_call += r_foo_unboundedlongseq[index];
	  }
	  r_call += iluEndSequence;
	  return r_call;
  }

  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(unboundedlongseq)& r_foo_unboundedlongseq) {
	  iluCardinal card_length = r_foo_unboundedlongseq.length();
	  iluSequenceWrapper _r_foo_unboundedlongseq(card_length);
	  r_call << _r_foo_unboundedlongseq;
	  for (CORBA(ULong) index = 0; index < r_foo_unboundedlongseq.length(); index++) {
		  r_call << r_foo_unboundedlongseq[index];
	  }
	  r_call << iluEndSequence;
	  return r_call;
  }

  iluBaseCall& operator>>(iluBaseCall& r_call, foo(unboundedlongseq)& r_foo_unboundedlongseq) {
	  iluCardinal card_length;
	  iluSequenceWrapper _r_foo_unboundedlongseq(card_length);
	  r_call >> _r_foo_unboundedlongseq;
	  r_foo_unboundedlongseq.length(card_length);
	  for (CORBA(ULong) index = 0; index < r_foo_unboundedlongseq.length(); index++) {
		  r_call >> r_foo_unboundedlongseq[index];
	  }
	  r_call >> iluEndSequence;
 	  return r_call;
 }
  
#ifdef ADD_VARIANT_SUPPORT
  
  // define the four member functions in typecode class for foo_unboundedlongseq
  ILUCPP_DEFINE_ILU_TYPE_CODE_MEMBERFUNCTIONS(foo_unboundedlongseq, foo(unboundedlongseq))

  // typecode instance for foo_fixedrecord
  const CORBA(TypeCode_ptr) foo(tc_unboundedlongseq) = new ILUCPP_TYPE_CODE_CLASS_NAME(foo_unboundedlongseq);
  
  // define the Any insertion and extraction operators for foo(unboundedlongseq)
  ILUCPP_DEFINE_COPYING_INSERTION_OPERATOR(foo(unboundedlongseq), foo(tc_unboundedlongseq))
  ILUCPP_DEFINE_NONCOPYING_INSERTION_OPERATOR(foo(unboundedlongseq), foo(tc_unboundedlongseq))
  ILUCPP_DEFINE_EXTRACTION_OPERATOR(foo(unboundedlongseq), foo(tc_unboundedlongseq))
  
  
#endif // ADD_VARIANT_SUPPORT


  //////////////////////////////////////////////////////////////////////
  // foo(boundedbarseq) members
  
  // constructors & desructor
  foo(boundedbarseq)::foo_(boundedbarseq) () : m_maximum(3),
	  m_length(0),
	  m_release (ILUCPP_TRUE) {
	  m_buffer = allocbuf (m_maximum);
	  m_varbuffer = new foo(bar_var)[3];
  }
  
  foo(boundedbarseq)::foo_(boundedbarseq) (CORBA(ULong) length, 
	  foo_(bar_ptr)* data, CORBA(Boolean) release)  : m_maximum(3),
	  m_length(length),
	  m_buffer(data),
	  m_release (release) {
	  
	  if (m_length > 3) {
		  // really undefined by CORBA as to what to do, but better safe than sorry!
		  CORBA(UNKNOWN) an_exception(0, CORBA(COMPLETED_NO));
		  throw (an_exception);
	  }
	  
	  m_varbuffer = new foo(bar_var)[3];
	  for (CORBA(ULong) index = 0; index < 3; index++) {
		  (m_varbuffer[index]).iluSetRelease(m_release);
		  m_varbuffer[index] = data[index];
	  }	  
  }
  
  foo(boundedbarseq)::foo_(boundedbarseq) (const foo(boundedbarseq)& r_foo_boundedbarseq)   :
                        m_maximum(r_foo_boundedbarseq.m_maximum), 
			m_length(r_foo_boundedbarseq.m_length), 
			m_release(ILUCPP_TRUE) 

		{
			m_buffer = allocbuf (m_maximum);
			m_varbuffer = new foo(bar_var)[3];

#ifdef __GNUC__
			// workaround to GNU 2.7.2 internal compiler error
			// note, this GNU workaround approach should work every where else, so
			// we may just want to do this for the general case.
			foo(bar_ptr) p_buffer_ptr;
	                foo(bar_var)* p_buffer_var;
			for (CORBA(ULong) index = 0; index < m_length; index++) {
				p_buffer_ptr = r_foo_boundedbarseq.m_buffer[index];
				m_buffer[index] = p_buffer_ptr;
				p_buffer_var =  &(m_varbuffer[index]);
				(*(p_buffer_var)) = foo(bar)::_duplicate((foo(bar_ptr))r_foo_boundedbarseq.m_varbuffer[index]);
			} 

#else
			for (CORBA(ULong) index = 0; index < m_length; index++) {
				 m_buffer[index] = r_foo_boundedbarseq.m_buffer[index];
			         m_varbuffer[index] = r_foo_boundedbarseq.m_varbuffer[index];
			} 
#endif
		}  

		
	foo(boundedbarseq)::~foo_(boundedbarseq)() {
		if (m_buffer && m_release)
			freebuf (m_buffer);
		delete [] m_varbuffer;
	}
		
	// assignment
	foo(boundedbarseq)& foo(boundedbarseq)::operator= (const foo(boundedbarseq)& r_foo_boundedbarseq) {

		if (this == &r_foo_boundedbarseq) 
			return *this;

		if (m_buffer && m_release)
			freebuf (m_buffer);
		delete [] m_varbuffer;
		
        m_maximum = r_foo_boundedbarseq.m_maximum;
        m_buffer = allocbuf (m_maximum);
        m_varbuffer = new foo(bar_var)[3];
		m_release = ILUCPP_TRUE;
		m_length = r_foo_boundedbarseq.m_length;
#ifdef __GNUC__
		// workaround to GNU 2.7.2 internal compiler error
		// note, this GNU workaround approach should work every where else, so
		// we may just want to do this for the general case.
		foo(bar_ptr) p_buffer_ptr;
	        foo(bar_var)* p_buffer_var;
		for (CORBA(ULong) index = 0; index < m_length; index++) {
			p_buffer_ptr = r_foo_boundedbarseq.m_buffer[index];
		     	m_buffer[index] = p_buffer_ptr;
			p_buffer_var =  &(m_varbuffer[index]);
			(*(p_buffer_var)) = foo(bar)::_duplicate((foo(bar_ptr))r_foo_boundedbarseq.m_varbuffer[index]);
		} 

#else
		for (CORBA(ULong) index = 0; index < m_length; index++) {
			m_buffer[index] = r_foo_boundedbarseq.m_buffer[index];
			m_varbuffer[index] = r_foo_boundedbarseq.m_varbuffer[index];
		} 
#endif
		return *this;
	}
	
  
  // accessors
  CORBA(ULong) foo(boundedbarseq)::maximum() const {
	return m_maximum;
  }
  
  CORBA(ULong) foo(boundedbarseq)::length() const {
	 return m_length;
  }
  
  void foo(boundedbarseq)::length (CORBA(ULong) len) {
	  if (len > m_maximum) {
		  // really undefined by CORBA as to what to do, but better safe than sorry!
		  CORBA(UNKNOWN) an_exception(0, CORBA(COMPLETED_NO));
		  throw (an_exception);
	  }
	  else {
		  if (len < m_length && m_release) {
			  for (CORBA(ULong) index = len; index < m_length; index++) {
				  m_varbuffer[index] = NULL;
			  }
		  }
		  m_length = len;
	  }
  }
  
  
  // [] operators
  foo(bar_var)& foo(boundedbarseq)::operator [] (CORBA(ULong) index) {
	  if (index >= m_length) {
		  // really undefined by CORBA as to what to do, but better safe than sorry!
		  CORBA(UNKNOWN) an_exception(0, CORBA(COMPLETED_NO));
		  throw (an_exception);
	  }
      return m_varbuffer [index];
  }
  
  const foo(bar_var)& foo(boundedbarseq)::operator [] (CORBA(ULong) index) const {
	  if (index >= m_length) {
		  // really undefined by CORBA as to what to do, but better safe than sorry!
		  CORBA(UNKNOWN) an_exception(0, CORBA(COMPLETED_NO));
		  throw (an_exception);
	  }
      return m_varbuffer [index];
  }
  
  
  // memory management
  foo(bar_ptr)* foo(boundedbarseq)::allocbuf(CORBA(ULong) num_elements) {
	  if (num_elements > 0) {
		  foo(bar_ptr)* p_new_buffer = new foo(bar_ptr)[num_elements];
		  for (CORBA(ULong) ul_index = 0; ul_index < num_elements; ul_index++)
				p_new_buffer[ul_index] = NULL;
		  return p_new_buffer;
	  }
	  else return NULL;
  }
  


  void foo(boundedbarseq)::freebuf(foo(bar_ptr)* p_buf) {
	  delete [] p_buf;
  }
  
  // for ilustub use only - should be called before the surrogate side stub returns
  void foo(boundedbarseq)::iluSurrogateSideCleanup() const {
	  for (CORBA(ULong) index = 0; index < m_length; index++) {
		  (m_varbuffer[index]).iluDeleteWrapper();
	  }
  }

  
  // insertion, extraction, and sizing operators for foo(boundedbarseq)
  
  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(boundedbarseq)& r_foo_boundedbarseq){
	  iluCardinal card_length = r_foo_boundedbarseq.length();
	  iluSequenceWrapper _r_foo_boundedbarseq(card_length);
	  r_call += _r_foo_boundedbarseq;
	  for (CORBA(ULong) index = 0; index < r_foo_boundedbarseq.length(); index++) {
		  r_call += r_foo_boundedbarseq[index];
	  }
	  r_call += iluEndSequence;
	  return r_call;
  }

  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(boundedbarseq)& r_foo_boundedbarseq) {
	  iluCardinal card_length = r_foo_boundedbarseq.length();
	  iluSequenceWrapper _r_foo_boundedbarseq(card_length);
	  r_call << _r_foo_boundedbarseq;
	  for (CORBA(ULong) index = 0; index < r_foo_boundedbarseq.length(); index++) {
		  r_call << r_foo_boundedbarseq[index];
	  }
	  r_call << iluEndSequence;
	  return r_call;
  }

  iluBaseCall& operator>>(iluBaseCall& r_call, foo(boundedbarseq)& r_foo_boundedbarseq) {
	  iluCardinal card_length;
	  iluSequenceWrapper _r_foo_boundedbarseq(card_length);
	  r_call >> _r_foo_boundedbarseq;
	  r_foo_boundedbarseq.length(card_length);
	  for (CORBA(ULong) index = 0; index < r_foo_boundedbarseq.length(); index++) {
		  r_call >> r_foo_boundedbarseq[index];
	  }
	  r_call >> iluEndSequence;
 	  return r_call;
 }


#ifdef ADD_VARIANT_SUPPORT
  
  // define the four member functions in typecode class for foo_boundedbarseq
  ILUCPP_DEFINE_ILU_TYPE_CODE_MEMBERFUNCTIONS(foo_boundedbarseq, foo(boundedbarseq))

  // typecode instance for foo_fixedrecord
  const CORBA(TypeCode_ptr) foo(tc_boundedbarseq) = new ILUCPP_TYPE_CODE_CLASS_NAME(foo_boundedbarseq);
  
  // define the Any insertion and extraction operators for foo(boundedbarseq)
  ILUCPP_DEFINE_COPYING_INSERTION_OPERATOR(foo(boundedbarseq), foo(tc_boundedbarseq))
  ILUCPP_DEFINE_NONCOPYING_INSERTION_OPERATOR(foo(boundedbarseq), foo(tc_boundedbarseq))
  ILUCPP_DEFINE_EXTRACTION_OPERATOR(foo(boundedbarseq), foo(tc_boundedbarseq))
  
  
#endif // ADD_VARIANT_SUPPORT
  

  //////////////////////////////////////////////////////////////////////
  // foo(variableuniontype) members
		
  // constructors & desructor
  foo(variableuniontype)::foo_(variableuniontype)() : m_b_beenset(ILUCPP_FALSE) {}
  

  foo(variableuniontype)::foo_(variableuniontype)(const foo(variableuniontype)& r_union_type) : m_b_beenset(ILUCPP_FALSE) {
	  (*this) = r_union_type;
  }
  

  foo(variableuniontype)::~foo_(variableuniontype)() {
	  unset();
  }
  

  // assignment
  foo(variableuniontype)& foo(variableuniontype)::operator= (const foo(variableuniontype)& r_union_type) {
	  if (this == &r_union_type)
		  return (*this);
	  
	  unset();

	  m_b_beenset = r_union_type.m_b_beenset;
	  
	  if (!m_b_beenset)
		  return (*this);
	  
	  m_discriminator = r_union_type.m_discriminator;
	  
	  switch (m_discriminator) {
		  
	  case 0:  // bararm
	  case 1:  
		  // this duplicates per corba spec
		  m_bararm = new foo(bar_var)((*r_union_type.m_bararm));
		  break;
		  
	  default:	// integerarm
		  m_integerarm = r_union_type.m_integerarm;
			  break;
	  };			

	  return (*this);

  }
  

  // accessors
  CORBA(UShort) foo(variableuniontype)::_d () const { 
	  return m_discriminator; 
  }
  

  void foo(variableuniontype)::_d (CORBA(UShort) new_d) { 
	  
	  if (! m_b_beenset) {
		  m_discriminator = new_d;
		  return;
	  }
	  // bararm
	  else if ((m_discriminator == 0 || m_discriminator == 1) &&
		  (new_d == 0 || new_d == 1)) {
		  m_discriminator = new_d;
		  return;
	  }
	  // default arm
	  else if ((m_discriminator != 0 && m_discriminator != 1) &&
		  (new_d != 0 || new_d != 1)) {
		  m_discriminator = new_d;
		  return;
	  }
	  else 			
		  ILUCPP_WARN("Ignoring attempt to set union discriminator outside current membership");			
  }
  

  foo(bar_ptr) foo(variableuniontype)::bararm () const {
	  return (*m_bararm);
  }
  

  void foo(variableuniontype)::bararm (foo(bar_ptr) a_bararm) {
	  unset();			
	  m_discriminator = 0;
	  foo_(bar)::_duplicate(a_bararm);  // duplicate per corba spec
	  m_bararm = new foo(bar_var)(a_bararm);
	  m_b_beenset = ILUCPP_TRUE;
  }
  

  CORBA(Long) foo(variableuniontype)::integerarm () const {
	  return m_integerarm;
  }
  

  void foo(variableuniontype)::integerarm (CORBA(Long) an_integerarm) {
	  unset();			
	  m_discriminator = 2;
	  m_integerarm = an_integerarm;
	  m_b_beenset = ILUCPP_TRUE;
  }		
  

  // for ilustub use only - should be called before the surrogate side stub returns
  void foo(variableuniontype)::iluSurrogateSideCleanup() const {
	  if (m_b_beenset) {
		  switch (m_discriminator) {
		  case 0:  // bararm
		  case 1:  
			  m_bararm->iluDeleteWrapper();
			  break;
		  default:	// integerarm
			  break;
		  };
	  }
  }


  void foo(variableuniontype)::unset() {
	  if (m_b_beenset) {
		  switch (m_discriminator) {
		  case 0:  // bararm
		  case 1:  
			  delete m_bararm;
			  break;
		  default:	// integerarm
			  break;
		  };
		  m_b_beenset = ILUCPP_FALSE;
	  }
  }
  

  // insertion, extraction, and sizing operators for foo()
  
  iluBaseCall& operator+=(iluBaseCall& r_call, const foo(variableuniontype)& r_foo_variableuniontype) {

	  iluUnionWrapper _r_foo_variableuniontype(r_foo_variableuniontype._d(), ilu_shortcardinal_tk);
	  
	  r_call += _r_foo_variableuniontype;
	  
	  switch (r_foo_variableuniontype.m_discriminator) {
	  case 0:  // bararm
	  case 1:  
		  r_call += (*(r_foo_variableuniontype.m_bararm));
		  break;
	  default:	// integerarm
		  r_call += r_foo_variableuniontype.m_integerarm;
	  };
	  
	  r_call += iluEndUnion;
	  return r_call;
  }
  
  
  iluBaseCall& operator<<(iluBaseCall& r_call, const foo(variableuniontype)& r_foo_variableuniontype) {

  	  iluUnionWrapper _r_foo_variableuniontype(r_foo_variableuniontype._d(), ilu_shortcardinal_tk);
	  
	  r_call << _r_foo_variableuniontype;
	  
	  switch (r_foo_variableuniontype.m_discriminator) {
	  case 0:  // bararm
	  case 1:  
		  r_call << (*(r_foo_variableuniontype.m_bararm));
		  break;
	  default:	// integerarm
		  r_call << r_foo_variableuniontype.m_integerarm;
	  };
	  
	  r_call << iluEndUnion;
	  return r_call;
  }
  
  
  iluBaseCall& operator>>(iluBaseCall& r_call, foo(variableuniontype)& r_foo_variableuniontype) {
	  
	  iluUnionWrapper _r_foo_variableuniontype(0, ilu_shortcardinal_tk);
	  
	  r_call >> _r_foo_variableuniontype;
	  foo(bar_var) bararm_temp;
	  CORBA(Long) integerarm_temp;
	  
	  switch (_r_foo_variableuniontype.m_card_discriminator) {
	  case 0:  // bararm
	  case 1:  
		  r_call >> bararm_temp;
		  r_foo_variableuniontype.bararm(bararm_temp);
		  break;
	  default:	// integerarm
		  r_call >> integerarm_temp;
		  r_foo_variableuniontype.integerarm(integerarm_temp);
	  };
	  
	  r_call >> iluEndUnion;
	  r_foo_variableuniontype._d(_r_foo_variableuniontype.m_card_discriminator);
	  return r_call;
  }
  

#ifdef ADD_VARIANT_SUPPORT
  
  // define the four member functions in typecode class for foo_variableuniontype
  ILUCPP_DEFINE_ILU_TYPE_CODE_MEMBERFUNCTIONS(foo_variableuniontype, foo(variableuniontype))

  // typecode instance for foo_fixedrecord
  const CORBA(TypeCode_ptr) foo(tc_variableuniontype) = new ILUCPP_TYPE_CODE_CLASS_NAME(foo_variableuniontype);
  
  // define the Any insertion and extraction operators for foo(variableuniontype)
  ILUCPP_DEFINE_COPYING_INSERTION_OPERATOR(foo(variableuniontype), foo(tc_variableuniontype))
  ILUCPP_DEFINE_NONCOPYING_INSERTION_OPERATOR(foo(variableuniontype), foo(tc_variableuniontype))
  ILUCPP_DEFINE_EXTRACTION_OPERATOR(foo(variableuniontype), foo(tc_variableuniontype))
  
  
#endif // ADD_VARIANT_SUPPORT

  //////////////////////////////////////////////////////////////////////
  //  foo(optionalbarobject) variant support

#ifdef ADD_VARIANT_SUPPORT


  // define the four member functions in typecode class for foo_optionalbarobject
    ILUCPP_DEFINE_ILU_TYPE_CODE_DELETEVALUE(foo_optionalbarobject, foo(optionalbarobject_forany))
	ILUCPP_DEFINE_ILU_TYPE_CODE_DEEPCOPY(foo_optionalbarobject, foo(optionalbarobject_forany))

  void* ILUCPP_TYPE_CODE_CLASS_NAME(foo_optionalbarobject)::iluPickleToValue (iluPickleCall& r_pickle_call) {
		foo(optionalbarobject_forany)* p_thevalue = new foo(optionalbarobject_forany);
		try {
			iluOptionalWrapper _the_value_wrapper;
			r_pickle_call >> _the_value_wrapper;
			if (_the_value_wrapper.m_present) {
				iluObjectWrapper _the_obj_wrapper(ILUCPP_FALSE, foo(bar)::iluGetILUClassRecord());
				r_pickle_call >> _the_obj_wrapper;
				p_thevalue->m_p_value = (foo(bar_ptr)) _the_obj_wrapper.m_pv_iluobject;
			}
		}
		catch (...) { delete p_thevalue; return NULL;}
		return p_thevalue;
	}


  CORBA(Boolean) ILUCPP_TYPE_CODE_CLASS_NAME(foo_optionalbarobject)::iluValueToPickle (void* pv_value, iluPickleCall& r_pickle_call) {
		iluOptionalWrapper opt_wrapper(((foo(optionalbarobject_forany)*)pv_value)->m_p_value);
		foo(bar_ptr) p_thevalue = ((foo(optionalbarobject_forany)*)pv_value)->m_p_value;
		try {			
			r_pickle_call += opt_wrapper;
			if (p_thevalue) {
				iluObjectWrapper obj_wrapper(*p_thevalue, ILUCPP_FALSE);
				r_pickle_call += obj_wrapper;
				r_pickle_call.iluOutputPickle();
				r_pickle_call << opt_wrapper;
				r_pickle_call << obj_wrapper;
			}
			else {
				r_pickle_call.iluOutputPickle();
				r_pickle_call << opt_wrapper;
			}
		}
		catch (...) {return ILUCPP_FALSE;}
		return ILUCPP_TRUE;
	}
	
  // typecode instance for foo_optionalbarobject
  const CORBA(TypeCode_ptr) foo(tc_optionalbarobject) = new ILUCPP_TYPE_CODE_CLASS_NAME(foo_optionalbarobject);

  // define the Any insertion and extraction operators for foo(optionalbarobject)
  ILUCPP_DEFINE_NONCOPYING_INSERTION_OPERATOR(foo(optionalbarobject_forany), foo(tc_optionalbarobject))
  ILUCPP_DEFINE_COPYING_INSERTION_OPERATOR(foo(optionalbarobject_forany), foo(tc_optionalbarobject))
  ILUCPP_DEFINE_EXTRACTION_OPERATOR(foo(optionalbarobject_forany), foo(tc_optionalbarobject))
  
  
#endif // ADD_VARIANT_SUPPORT

  //////////////////////////////////////////////////////////////////////
  //  foo(optionalinteger) variant support

#ifdef ADD_VARIANT_SUPPORT

	// define the four member functions in typecode class for foo_optionalinteger
#ifdef __GNUC__
	// workaround to GNU 2.7.2 preprocessor bug
	// note, this GNU workaround approach should work every where else, so
	// we may just want to do this for the general case.
	ILUCPP_DEFINE_ILU_TYPE_CODE_DELETEVALUE(foo_optionalinteger, foo(optionalinteger_forany))\
	ILUCPP_DEFINE_ILU_TYPE_CODE_DEEPCOPY(foo_optionalinteger, foo(optionalinteger_forany))\
	ILUCPP_DEFINE_ILU_TYPE_CODE_OPTIONAL_VALUETOPICKLE(foo_optionalinteger, foo(optionalinteger_forany))\
	ILUCPP_DEFINE_ILU_TYPE_CODE_OPTIONAL_PICKLETOVALUE(foo_optionalinteger, CORBA(Long), foo(optionalinteger_forany))
#else
	ILUCPP_DEFINE_ILU_TYPE_CODE_SIMPLE_OPTIONAL_MEMBERFUNCTIONS(foo_optionalinteger, foo(optionalinteger), CORBA(Long))
#endif
	
	// typecode instance for foo_optionalinteger
	const CORBA(TypeCode_ptr) foo(tc_optionalinteger) = new ILUCPP_TYPE_CODE_CLASS_NAME(foo_optionalinteger);
	
	// define the Any insertion and extraction operators for foo(optionalinteger)
	ILUCPP_DEFINE_NONCOPYING_INSERTION_OPERATOR(foo(optionalinteger_forany), foo(tc_optionalinteger))
	ILUCPP_DEFINE_COPYING_INSERTION_OPERATOR(foo(optionalinteger_forany), foo(tc_optionalinteger))
	ILUCPP_DEFINE_EXTRACTION_OPERATOR(foo(optionalinteger_forany), foo(tc_optionalinteger))
  
  
#endif // ADD_VARIANT_SUPPORT


  //////////////////////////////////////////////////////////////////////
  // foo(bar) members

  // CORBA object reference operations

  foo(bar_ptr) foo(bar)::_duplicate( foo_(bar_ptr) a_ptr) {
    if (a_ptr) a_ptr->iluIncrementReferenceCount();
    return a_ptr;
  }

  foo(bar_ptr) foo(bar)::_nil() {
    return (foo_(bar_ptr)) NULL;
  }

  // default constructor
  foo(bar)::foo_(bar)() {
     // to be determined
  }

  // destructor
  foo(bar)::~foo_(bar)() {
    // to be determined
  }

  // copy constructor
  foo(bar)::foo_(bar)(const foo_(bar)&) {
    // to be determined
  }

  // assignment operator
  void foo(bar)::operator=(const foo_(bar)&) {
    // to be determined
  }

  // Simple Object Lookup
  foo(bar_ptr) foo(bar)::iluLookup(char* pc_server_id, char* pc_instance_handle) {
    return (foo_(bar_ptr)) iluObject::iluLookup(pc_server_id, pc_instance_handle, m_ILUClassRecord);
  }

  // for use in narrowing
  void *foo(bar)::iluDowncast (iluClass class_to_cast_down_to) {
    if (!class_to_cast_down_to  || class_to_cast_down_to == ilu_rootClass)
      return((void *)((iluObject*) this));
	// if foo(bar) were a CORBA::Object type too, we'd also need
    //if (class_to_cast_down_to == CORBA(Object)::iluGetILUClassRecord())
    // return((void *)((CORBA(Object_ptr)) this));
    if (class_to_cast_down_to == m_ILUClassRecord)
      return ((void*) this);
    return (NULL);
  }

  // initialize to use of this class of objects - called by iluInitialize

  void foo(bar)::iluInitialize() {

	ilu_Method a_method;

    // create and set the class record member to be the iluClass for this object type
    m_ILUClassRecord = 
      iluCppInternal::iluDefineObjectType(
      "foo.bar", // ILU name
      "",	// brand
      "ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ", // type id
      NULL,	 // singleton?
      ILUCPP_FALSE, // optional?
      ILUCPP_TRUE, // collectible?
      NULL,	 // docstring
      16,	// number of methods
      0,	// number of superclasses
      NULL	// no superclass uids (TBD: add them)
    );

    {
		// for method zap
		iluException zap_exception_array[1];
		zap_exception_array[0] = interface_exceptions[g_foo_zapexception_index];
		a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
			0,	// method index
			"zap",	// name
			1,	//method ID
			ILUCPP_FALSE,	// cacheable
			ILUCPP_FALSE,	// asynchronous
			1,	// number of exceptions
			zap_exception_array,
			3,	// number of args
			"ilu:f03Zp82IhHWY1oKhpT4cDlZYWfk"	// return type ID
			);
		iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:nf0EIEuSgtCJuWWvPNt9Fz51i8x");
		iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:m7wUQG3LnPz3B2meTg5Gn6hN4Lw");
		iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:gFAl4D9dw8Bqoq9PtIkS6gyvMux");
    }
    {
      // for method passobj
      iluException* passobj_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        1,	// method index
        "passobj",	// name
        2,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passobj_exception_array,
		3,	// number of args
		"ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:jwrpaAy0+kjOWrm8dLgyXiY5gOQ");

    }
     {
      // for method passenum
      iluException* passenum_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        2,	// method index
        "passenum",	// name
        3,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passenum_exception_array,
		3,	// number of args
		"ilu:mlI8KGJsFBG2ywCR8x0Wql+mOYX"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:mlI8KGJsFBG2ywCR8x0Wql+mOYX");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:mlI8KGJsFBG2ywCR8x0Wql+mOYX");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:mlI8KGJsFBG2ywCR8x0Wql+mOYX");
    }
    {
      // for method passlatinstring
      iluException* passlatinstring_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        3,	// method index
        "passlatinstring",	// name
        4,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passlatinstring_exception_array,
		3,	// number of args
		"ilu:kakRtQhq-+fkRr0MUKKXsAhAwNo"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:kakRtQhq-+fkRr0MUKKXsAhAwNo");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:kakRtQhq-+fkRr0MUKKXsAhAwNo");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:kakRtQhq-+fkRr0MUKKXsAhAwNo");
    }
     {
      // for method passenum
      iluException* passunicodestring_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        4,	// method index
        "passunicodestring",	// name
        5,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passunicodestring_exception_array,
		3,	// number of args
		"ilu:pMGHN1T0dtNq6bo6+8Kn7sKAS97"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:pMGHN1T0dtNq6bo6+8Kn7sKAS97");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:pMGHN1T0dtNq6bo6+8Kn7sKAS97");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:pMGHN1T0dtNq6bo6+8Kn7sKAS97");
    }
     {
      // for method passfixedrecord
      iluException* passfixedrecord_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        5,	// method index
        "passfixedrecord",	// name
        6,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passfixedrecord_exception_array,
		3,	// number of args
		"ilu:fJRvTuuUCyZ+GZX2mytNYfCmECq"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:fJRvTuuUCyZ+GZX2mytNYfCmECq");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:fJRvTuuUCyZ+GZX2mytNYfCmECq");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:fJRvTuuUCyZ+GZX2mytNYfCmECq");
    }
     {
      // for method passvariablerecord
      iluException* passvariablerecord_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        6,	// method index
        "passvariablerecord",	// name
        7,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passvariablerecord_exception_array,
		3,	// number of args
		"ilu:p1p-Xd0SkjKs8cNPeMkSi8G+s-j"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:p1p-Xd0SkjKs8cNPeMkSi8G+s-j");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:p1p-Xd0SkjKs8cNPeMkSi8G+s-j");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:p1p-Xd0SkjKs8cNPeMkSi8G+s-j");
    }
     {
      // for method passfixedarray
      iluException* passfixedarray_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        7,	// method index
        "passfixedarray",	// name
        8,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passfixedarray_exception_array,
		3,	// number of args
		"ilu:f3qA-xRiSkCvrf6KovBV+KsjMh0"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:f3qA-xRiSkCvrf6KovBV+KsjMh0");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:f3qA-xRiSkCvrf6KovBV+KsjMh0");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:f3qA-xRiSkCvrf6KovBV+KsjMh0");
    }
     {
      // for method passvariablearray
      iluException* passvariablearray_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        8,	// method index
        "passvariablearray",	// name
        9,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passvariablearray_exception_array,
		3,	// number of args
		"ilu:dwYXDC7Gf2XOuhGijTt-FPv+OWo"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:dwYXDC7Gf2XOuhGijTt-FPv+OWo");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:dwYXDC7Gf2XOuhGijTt-FPv+OWo");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:dwYXDC7Gf2XOuhGijTt-FPv+OWo");
    }
     {
      // for method passunboundedsequence
      iluException* passunboundedsequence_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        9,	// method index
        "passunboundedsequence",	// name
        10,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passunboundedsequence_exception_array,
		3,	// number of args
		"ilu:gb+4Sy4d-wQwxncKVc0kDH2CHNY"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:gb+4Sy4d-wQwxncKVc0kDH2CHNY");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:gb+4Sy4d-wQwxncKVc0kDH2CHNY");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:gb+4Sy4d-wQwxncKVc0kDH2CHNY");
    }
     {
      // for method passboundedsequence
      iluException* passboundedsequence_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        10,	// method index
        "passboundedsequence",	// name
        11,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passboundedsequence_exception_array,
		3,	// number of args
		"ilu:a-A0iHnQNNRmhhmp3wkeUYwSA84"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:a-A0iHnQNNRmhhmp3wkeUYwSA84");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:a-A0iHnQNNRmhhmp3wkeUYwSA84");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:a-A0iHnQNNRmhhmp3wkeUYwSA84");
    }
     {
      // for method passvariableunion
      iluException* passvariableunion_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        11,	// method index
        "passvariableunion",	// name
        12,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passvariableunion_exception_array,
		3,	// number of args
		"ilu:jYcmgu8Gvx9g1A-c6Q82yVwdEyS"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:jYcmgu8Gvx9g1A-c6Q82yVwdEyS");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:jYcmgu8Gvx9g1A-c6Q82yVwdEyS");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:jYcmgu8Gvx9g1A-c6Q82yVwdEyS");
    }
     {
      // for method passoptionals
      iluException* passoptionals_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        12,	// method index
        "passoptionals",	// name
        13,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passoptionals_exception_array,
		3,	// number of args
		"ilu:f6I-vh57myFWF48brBQvjvvaJI5"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:f6I-vh57myFWF48brBQvjvvaJI5");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:ayhvbuUI6IYTo8anOBtzxYTFKsU");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:ayhvbuUI6IYTo8anOBtzxYTFKsU");
    }
     {
      // for method passsimpleanys
      iluException* passsimpleanys_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        13,	// method index
        "passsimpleanys",	// name
        14,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passsimpleanys_exception_array,
		3,	// number of args
		"ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH"	// return type ID
      );
      iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH");
    }
     {
      // for method passarrayanys
      iluException* passarrayanys_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        14,	// method index
        "passarrayanys",	// name
        15,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passarrayanys_exception_array,
		3,	// number of args
		"ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH");
    }
     {
      // for method passassortedanys
      iluException* passassortedanys_exception_array = NULL;
      a_method = iluCppInternal::iluDefineMethod(m_ILUClassRecord,
        15,	// method index
        "passassortedanys",	// name
        16,	//method ID
        ILUCPP_FALSE,	// cacheable
        ILUCPP_FALSE,	// asynchronous
        0,	// number of exceptions
        passassortedanys_exception_array,
		3,	// number of args
		"ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH"	// return type ID
      );
	  iluCppInternal::iluDefineMethodArg (a_method, 0, "inarg", ILUCPP_FALSE, ilu_In, "ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH");
      iluCppInternal::iluDefineMethodArg (a_method, 1, "inoutarg", ILUCPP_FALSE, ilu_InOut, "ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH");
      iluCppInternal::iluDefineMethodArg (a_method, 2, "outarg", ILUCPP_FALSE, ilu_Out, "ilu:laAHTQbvKAQ8a2Y6fpXzMt46EnH");
    }

    iluCppInternal::iluObjectTypeDefined(m_ILUClassRecord);

};


  //////////////////////////////////////////////////////////////////////
  //  foo(bar) variant support

#ifdef ADD_VARIANT_SUPPORT

	void ILUCPP_TYPE_CODE_CLASS_NAME(foo_bar)::iluDeleteValue (void* pv_value) {
		foo(bar_ptr) p_thevalue = (foo(bar_ptr)) pv_value;
		if (p_thevalue)
			p_thevalue->iluDecrementReferenceCount();
	}

	void* ILUCPP_TYPE_CODE_CLASS_NAME(foo_bar)::iluDeepCopy (void* pv_value) {
		foo(bar_ptr) p_thevalue = (foo(bar_ptr)) pv_value;
		if (p_thevalue)
			p_thevalue->iluIncrementReferenceCount();
		return p_thevalue;
	}

	// objects require wrappers
	CORBA(Boolean) ILUCPP_TYPE_CODE_CLASS_NAME(foo_bar)::iluValueToPickle (void* pv_value, iluPickleCall& r_pickle_call) {
		try {
			foo(bar_ptr) p_thevalue = (foo(bar_ptr)) pv_value;
			iluObjectWrapper _p_thevalue(*p_thevalue, ILUCPP_FALSE);
			r_pickle_call += _p_thevalue;
			r_pickle_call.iluOutputPickle();
			r_pickle_call << _p_thevalue;
		}
		catch (...) {return ILUCPP_FALSE;}
		return ILUCPP_TRUE;
	}
	
	void* ILUCPP_TYPE_CODE_CLASS_NAME(foo_bar)::iluPickleToValue (iluPickleCall& r_pickle_call) {
		iluObjectWrapper _the_value_wrapper(ILUCPP_FALSE, foo(bar)::iluGetILUClassRecord());
		try {
			r_pickle_call >> _the_value_wrapper;
		}
		catch (...) { return NULL;}
		return _the_value_wrapper.m_pv_iluobject;
	}


	void* ILUCPP_TYPE_CODE_CLASS_NAME(foo_bar)::iluUpcast (void* p_an_object_of_your_type, iluClass casttoclass) {
		foo(bar_ptr) p_object = (foo(bar_ptr)) p_an_object_of_your_type;
		if ((!casttoclass) || casttoclass == ilu_rootClass)
			return ((void*)((iluObject*)p_object));
		// if foo(bar) were a CORBA::Object type too, we'd also need
		// if (casttoclass == CORBA(Object)::iluGetILUClassRecord())
		//	return ((CORBA(Object_ptr))p_object);
		if (casttoclass == foo(bar)::iluGetILUClassRecord())
			return ((void*) p_object);
		return NULL;
	}


	CORBA(TypeCode_ptr) ILUCPP_TYPE_CODE_CLASS_NAME(foo_bar)::iluMostSpecificTypeCode (void* p_an_object_of_your_type) {
		foo(bar_ptr) p_object = (foo(bar_ptr)) p_an_object_of_your_type;
		return CORBA(TypeCode)::LookupTypeCode(p_object->iluClassId());
	}


	// typecode instance for foo_bar
	const CORBA(TypeCode_ptr) foo(tc_bar) = new ILUCPP_TYPE_CODE_CLASS_NAME(foo_bar);

	// define the Any insertion and extraction operators for foo(bar)

	void operator<<=(CORBA(Any)& r_any, foo(bar_ptr) p_object){
		// free up anything we had inside
		r_any.iluDeleteContent();
		// assign the appropriate typecode and value
		r_any.replace(foo(tc_bar), p_object, ILUCPP_TRUE);
	}
	
	CORBA(Boolean) operator>>=(const CORBA(Any)& r_any, foo(bar_ptr)& r_p_object) {
		
		CORBA(Any)* p_nc_any = CONST_CAST(NAME_OUTSIDE_SCOPE(CORBA, Any)*, &r_any);
		
		if (p_nc_any->iluGetFromPickle(foo(tc_bar))) { 
			r_p_object = (foo(bar_ptr)) p_nc_any->value();
			return ILUCPP_TRUE;
		}
		return ILUCPP_FALSE;
	}

  
#endif // ADD_VARIANT_SUPPORT

// Exception implementations for this interface
/////////////////////////////////////////////////
// foo_(zapexception) member functions

// constructors and destructor

foo(zapexception)::foo_(zapexception)(const foo(zapexception)& a_zapexception) {
  _m_value = a_zapexception._m_value;
  }

  foo(zapexception)::~foo_(zapexception)() {
  }
  // assignment operator

  foo(zapexception)& foo(zapexception)::operator=(const foo(zapexception)& a_zapexception) {
	_m_value = a_zapexception._m_value;
  return *this;
  }



/////////////////////////////////////////////////
// Force initialization of foo(bar) class upon load

foo(initializer) foo(initializer)::sm_the_foo_initializer;

foo(initializer)::
foo_(initializer) () {
  iluCppRuntime::iluAddInitializationFunction(foo(iluInitialize));
}

int
foo(initializer)::
ensure_instantiation () {
  return REINTERPRET_CAST(int, this);
}

