///////////////////////////////////////////////////////////////////////
// ILU cpp2 implementation of foo server


#include <iostream.h>
#include <winsock.h>

#include "foo2-cpptrue.hpp"



///////////////////////////////////////////////////////////////////////
// implementation class

class foo_bar_impl : public virtual foo::bar {
	
public:
	
	// constructor
	foo_bar_impl(char* pc_instance_handle, iluServer& r_an_ilu_server) : 
	  iluObject(bar::m_ILUClassRecord, pc_instance_handle, r_an_ilu_server) {}
	  
	  virtual ~foo_bar_impl() {
		  iluDeactivate();
	  }
	  
	  // methods
	  virtual CORBA::Boolean zap( CORBA::Long  inarg,
		  CORBA::Octet&  inoutarg,
		  CORBA::Double& outarg ) 
		  throw (CORBA::SystemException, foo::zapexception);
};


///////////////////////////////////////////////////////////////////////
// method implementation

// methods
CORBA::Boolean foo_bar_impl::zap( CORBA::Long  inarg,
		  CORBA::Octet&  inoutarg,
		  CORBA::Double& outarg   ) 
		  throw (CORBA::SystemException, foo::zapexception) {
	
	
	cout << "foo_bar_impl::zap entered" << endl;
	cout << "inarg = " << inarg << ", inoutarg  = 0x" << hex << (unsigned int)inoutarg << dec << endl;
	
	if (inarg > 0) {
		// raise zapexception
		foo::zapexception a_zapexception(inarg);
		throw(a_zapexception);
	}
	
	outarg = 3.14159;
	inoutarg = ~(inoutarg);
	
	return ilu_TRUE;
}



///////////////////////////////////////////////////////////////////////
// main

int main () {
	
	foo::bar_ptr p_true_foo_bar;				// points to true object
	char pc_serverid[512];			// holds server id 
	char pc_hostname[512];			// holds the name of the host the server is on

	foo::iluInitialize();

	/* create server id */
	gethostname(pc_hostname, sizeof(pc_hostname));
	strcpy(pc_serverid, pc_hostname);
	strcat(pc_serverid, ".parc.xerox.com.fooserver");

	// create our server
	iluServer server (pc_serverid);
	
	// create a true foo object
	p_true_foo_bar = new foo_bar_impl("foo_instance_0", server);
	
	if (p_true_foo_bar == NULL) {
		cout << "Error - couldn't create foo_instance_0 object" << endl;
		return 1;
    }
	
	// publish the true foo object
	if (!p_true_foo_bar->iluPublish()) {
		cout << "Error - couldn't publish foo_instance_0 object" << endl;
		return 1;
    }
	else {
		iluCString pc_object_string = p_true_foo_bar->iluObjectToString();
		cout << "Exported " << pc_object_string << endl;
		iluCppRuntime::iluFree(pc_object_string);
	}
	
	// run the server
	server.iluRun();
	
	return 0;
}


