/* foo client side program for corba2 c++ ilu */

#include <stdio.h>
#include <iostream.h>
#include <winsock.h>
#include "foo2-cppsurrogate.hpp"

/* ********************************************************* */
/* Usage string                                              */

char g_c_usage[] = 
"Usage:  fooclient [inarg [ HOSTNAME ]]\n\n\
\tinarg - (defaults to 0) to send to bar method - if 1, bar raises exception.\n\
\tHOSTNAME - used as part of the id for the server - defaults to this host\n";


/* ********************************************************* */
/* MAIN                                                      */


int main(int ac, char **av) {
	
	char pc_hostname[1024];			/* holds the name of the host the server is on */
	char pc_serverid[128];			/* holds server id */
	foo::bar_var mybar_var;
	CORBA::Boolean bool_return_value;
	CORBA::Long  inarg;
	CORBA::Octet inoutarg = 0xaa;
	CORBA::Double outarg;
	
	if ((ac > 3)) {		/* check for proper command line args */
		cout << g_c_usage << endl;
		return 1;
	}
	
	foo::iluInitialize();				/* perform required initialization */
	
	if (ac > 1)				/* get inarg */
		sscanf(av[1], "%lu", &inarg);
	else
		inarg = 0;
	
	if (ac > 2)				/* get hostname */
		strcpy (pc_hostname, av[2]);
	else
		gethostname(pc_hostname, sizeof(pc_hostname));
	
	
	/* create server id */
	strcpy(pc_serverid, pc_hostname);
	strcat(pc_serverid, ".parc.xerox.com.fooserver");
	
	// get an object ptr - note that this object has a refcount of 1
	try {
		mybar_var =  foo::bar::iluLookup ("foo_instance_0", pc_serverid);
	}
	catch(...) {
		cout << "foo::bar::iluLookup Exception" << endl;
		return 0;
	}
	
	try {
		bool_return_value = mybar_var->zap(inarg, inoutarg, outarg);
	}
	catch (const foo::zapexception& the_exception) {
		cout << "Got foo::zapexception, value is " << the_exception.m_l_value << endl;
		return 0;
	}
	catch (const CORBA::SystemException& the_exception) {
		cout << "Got SystemException" << endl <<
			"minor = " << the_exception.minor() << ", completed = ";
		switch (the_exception.completed()) {
		case CORBA::COMPLETED_YES: cout << "YES"; break;
		case CORBA::COMPLETED_NO: cout << "NO"; break;
		case CORBA::COMPLETED_MAYBE: cout << "MAYBE"; break;
		default: cout << "??? unknown exception completion !!!";
		}
		cout << endl;
		return 0;
	}
	
	cout << "zap returned " 
		<< ((bool_return_value == iluTRUE) ? "True" : "False")
		<< ", inoutarg 0x" 
		<< hex
		<< (unsigned int) inoutarg 
		<< ", outarg " 
		<< outarg 
		<< endl ; 
	
	return 0;
}



/* ********************************************************* */
/* End of file                                               */
/* ********************************************************* */
