///////////////////////////////////////////////////////////////////////
// ILU cpp1 implementation of foo server


#include <iostream.h>
#include <winsock.h>

#ifdef AddPort

/* winspool.h (included by windows.h on WIN32) defines AddPort as AddPortA, 
   so we need to undef it here temporarily so it doesn't interfere with
   iluServer.AddPort()
*/
#undef AddPort
#endif

#include "foo1.h"



///////////////////////////////////////////////////////////////////////
// implementation class

class foo_T_bar_impl : public virtual foo_T_bar {
	
public:
	
	// constructor
	foo_T_bar_impl(char *pc_instanceHandle, iluServer* p_server) :
	  m_pc_instance_handle(pc_instanceHandle), m_p_server(p_server) {}
	  
	  // accessors
	  virtual char * ILUGetInstanceHandle() {return m_pc_instance_handle ;}
	  virtual iluServer * ILUGetServer() {return m_p_server;}
	  
	  // methods
	  virtual ilu_Boolean zap (fooStatus *_status, 
		  ilu_Integer inarg, 
		  ilu_Byte * inoutarg, 
		  ilu_Real * outarg);
	  
private:
	
	char* m_pc_instance_handle;
	iluServer* m_p_server;
};


///////////////////////////////////////////////////////////////////////
// method implementation

ilu_Boolean foo_T_bar_impl::zap (fooStatus *_status, 
								 ilu_Integer inarg, 
								 ilu_Byte * inoutarg, 
								 ilu_Real * outarg) {
	
	
	cout << "foo_T_bar_impl::zap entered" << endl;
	cout << "inarg = " << inarg << ", inoutarg  = 0x" << hex << (unsigned int)inoutarg << dec << endl;
	
	if (inarg > 0) {
		// raise zapexception
		_status->returnCode = foo_E_zapexception;
		_status->values.foo_E_zapexception_Value = inarg;
		return ilu_FALSE;
	}
	
	*outarg = 3.14159;
	*inoutarg = ~(*inoutarg);
	
	_status->returnCode = fooReply_Success;
	return ilu_TRUE;
}



///////////////////////////////////////////////////////////////////////
// main

int main () {
	
	foo_T_bar* p_true_foo_bar;			// points to true object
	char pc_serverid[128];			// holds server id 
	char pc_hostname[1024];			// holds the name of the host the server is on

	/* create server id */
	gethostname(pc_hostname, sizeof(pc_hostname));
	strcpy(pc_serverid, pc_hostname);
	strcat(pc_serverid, ".parc.xerox.com.fooserver");

	// set up our server
	iluServer server (pc_serverid, NULL);
	server.AddPort(NULL, NULL, ilu_TRUE);
	ilu::SetDefaultServer(&server);
	
	// create a true foo object
	p_true_foo_bar = new foo_T_bar_impl("foo_instance_0", &server);
	
	if (p_true_foo_bar == NULL) {
		cout << "Error - couldn't create foo_instance_0 object" << endl;
		return 1;
    }
	
	// publish the true foo object
	if (!p_true_foo_bar->ILUPublish()) {
		cout << "Error - couldn't publish foo_instance_0 object" << endl;
		return 1;
    }
	else 
		cout << "Exported " << p_true_foo_bar->ILUStringBindingHandle() << endl;
	
	// run the server
	server.Run();
	
	return 0;
}


