///////////////////////////////////////////////////////////////////////
// ILU cpp1 implementation of foo client

#include <stdio.h>
#include <iostream.h>
#include <winsock.h>
#include "foo1.h"


///////////////////////////////////////////////////////////////////////
// Usage string 

char g_c_usage[] = 
"Usage:  client [inarg [ HOSTNAME ]]\n\n\
\tinarg - (defaults to 0) to send to bar method - if > zero, bar raises exception.\n\
\tHOSTNAME - used as part of the id for the server - defaults to this host\n";

///////////////////////////////////////////////////////////////////////
// show an exception if we have one 

ilu_boolean show_if_exception (fooStatus* p_status, char* pc_situation) {
	
	if (p_status->returnCode == NULL)
		return ilu_FALSE;		// just return false on no exception set 
	
	// show exception if we got one 
	cout << endl << "Exception: " << pc_situation << endl;
	cout << "foo_E_zapexception_Value: " << p_status->values.foo_E_zapexception_Value << endl;
	
	return ilu_TRUE;
}


///////////////////////////////////////////////////////////////////////
// MAIN 

int main(int ac, char **av) {
	
	char pc_hostname[1024];			// holds the name of the host the server is on 
	char pc_serverid[128];			// holds server id 
	foo_T_bar* p_surrogate_foo;		// points to surrogate for true object
	ilu_Boolean b_return_value;
	ilu_Integer inarg = 0; 
	ilu_Byte inoutarg = 0xaa; 
	ilu_Real outarg;
	fooStatus status;
	
	if ((ac > 3)) {		// check for proper command line args
		cout << g_c_usage << endl;
		return 1;
	}
	
	if (ac > 1)				// get inarg 
		sscanf(av[1], "%lu", &inarg);
	
	if (ac > 2)				// get hostname 
		strcpy (pc_hostname, av[2]);
	else
		gethostname(pc_hostname, sizeof(pc_hostname));
	
	// create server id 
	strcpy(pc_serverid, pc_hostname);
	strcat(pc_serverid, ".parc.xerox.com.fooserver");
	
	// lookup the foo instance
	p_surrogate_foo = (foo_T_bar*) iluObject::Lookup(pc_serverid,
		"foo_instance_0", foo_T_bar::ILUClassRecord);
	
	if (p_surrogate_foo == NULL) {
		cout << "Error - couldn't lookup foo_instance_0 object" << endl;
		return 1;
    }
	else 
		cout << "Looked up " << p_surrogate_foo->ILUStringBindingHandle() << endl;
	
	
	b_return_value = p_surrogate_foo->zap(&status, inarg, &inoutarg, &outarg);
	
	if (show_if_exception(&status, "Calling foo::zap"))
		return 1;
	
	cout << "zap returned " 
		<< ((b_return_value == ilu_TRUE) ? "True" : "False")
		<< ", inoutarg 0x"
		<< hex 
		<< (unsigned int) inoutarg
		<< ", outarg " 
		<< outarg 
		<< endl ; 
	
	return 0;
}
